<?php

namespace WPPayFormPro\GateWays;

if (!defined('ABSPATH')) {
    exit;
}


abstract class BasePaymentMethod
{
    protected $key = '';
    protected $title = '';
    protected $route_query = [];
    protected $svg = '';

    protected $settingsKey = '';

    public function __construct($key = '', $title = '', $route_query = [], $svg = '')
    {
        $this->key = $key;
        $this->title = $title;
        $this->route_query = $route_query;
        $this->svg = $svg;
        $this->settingsKey = 'wppayform_payment_settings_'.$key;

        add_filter('wppayform_payment_method_settings', function($settings) use($key) {
             $settings[$key] = array (
                'title' => $this->title,
                'route_name' => $key,
                'route_query' => $this->route_query,
                'svg' => $this->svg,
             );
            return $settings;
        }, 10, 1);

        add_filter('wppayform_payment_method_settings_routes', function($routes) use($key, $title) {
            $routes[] = array (
               'path' => $key,
               'name' => $key,
               'meta' => [
                    'title' => $title
                ]
            );
           return $routes;
       }, 10, 1);

       // Get global payment settings from routes
        add_filter('wppayform_payment_settings_' . $this->key, array($this, 'getPaymentSettings'));
    }


    /**
     * This method will set key value pair for dynamic bindings
     * @return Default values for save Settings
     */
    public function mapper($defaults, $settings = [], $get = true) 
    {
        foreach ($defaults as $key => $value) {
            if ($get) {
                if (isset($settings[$key])) {
                    $defaults[$key]['value'] = $settings[$key];
                }
            } else {
                if (isset($settings[$key])) {
                    $defaults[$key] = $settings[$key]['value'];
                }
            }
        }

        return $defaults;
    }

    abstract public function globalFields();

    abstract static function settingsKeys();

    abstract static function getSettings();
    
    abstract public function getPaymentSettings();
}
