<?php

namespace WPPayFormPro\GateWays\Addons;

if (!defined('ABSPATH')) {
    exit;
}

class AddonHelper
{
    /*
    * Check if the plugin/addon has update
    * @param string $slug addon/plugin slug
    * @param string $org github organization
    * @return array contains available, url, slug
    */
    public static function checkUpdateFromGithub($slug, $org, $update = true)
    {
        $githubApi = "https://api.github.com/repos/{$org}/{$slug}/releases";
        $result = array(
            'available' => 'no',
            'url' => '',
            'slug' => $slug
        );

        // Make the API request to GitHub
        $response = wp_remote_get($githubApi);

        // Check for errors in the response
        if (is_wp_error($response)) {
            return $result;
        }

        // Check the response code
        $responseCode = wp_remote_retrieve_response_code($response);

        if ($responseCode >= 400) {
            return $result;
        }

        // Retrieve the response body
        $body = wp_remote_retrieve_body($response);
        if (empty($body)) {
            return $result;
        }

        // Decode the JSON response
        $releases = json_decode($body);
        if (json_last_error() !== JSON_ERROR_NONE) {
            return $result;
        }

        // Check for documentation URL in the response
        if (isset($releases->documentation_url)) {
            return $result;
        }

        // Get the latest release information
        $latestRelease = $releases[0];
        $latestVersion = $latestRelease->tag_name;
        $zipUrl = $latestRelease->zipball_url;

        // If update is not required, return the result with the URL
        if (!$update) {
            $result['available'] = 'no';
            $result['url'] = $zipUrl;
            return $result;
        }

        // Include the plugin.php file if the get_plugins function does not exist
        if (!function_exists('get_plugins')) {
            require_once ABSPATH . 'wp-admin/includes/plugin.php';
        }

        // Get the list of installed plugins
        $plugins = get_plugins();
        $currentVersion = '';

        // Check if the plugin is present and get the current version
        foreach ($plugins as $plugin_file => $plugin_data) {
            if ($slug === $plugin_data['TextDomain'] || $slug === $plugin_data['Name']) {
                $currentVersion = $plugin_data['Version'];
                break;
            }
        }

        // Compare the latest version with the current version
        if (version_compare($latestVersion, $currentVersion, '>')) {
            $result['available'] = 'yes';
            $result['url'] = $zipUrl;
        }

        return $result;
    }
}