<?php

namespace WPPayFormPro\Classes\DependencyHandler;

class DependencyHandler
{
    public function add()
    {
        $title = __('Paymattic Pro', 'wp-payment-form-pro');

        global $menu;
        add_menu_page(
            $title,
            $title,
            'manage_options',
            'wppayform.php',
            array($this, 'render'),
            $this->getMenuIcon(),
            25
        );
    }

    protected function getMenuIcon()
    {
        $svg = '<?xml version="1.0" encoding="UTF-8"?><svg enable-background="new 0 0 512 512" version="1.1" viewBox="0 0 512 512" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
		<path d="m446 0h-380c-8.284 0-15 6.716-15 15v482c0 8.284 6.716 15 15 15h380c8.284 0 15-6.716 15-15v-482c0-8.284-6.716-15-15-15zm-15 482h-350v-452h350v452z" fill="#fff"/>
		<path d="m313 151h-2v-23c0-30.327-24.673-55-55-55s-55 24.673-55 55v23h-2c-8.284 0-15 6.716-15 15v78c0 8.284 6.716 15 15 15h114c8.284 0 15-6.716 15-15v-78c0-8.284-6.716-15-15-15zm-82-23c0-13.785 11.215-25 25-25s25 11.215 25 25v23h-50v-23zm67 101h-84v-48h84v48z" fill="#fff"/>
		<path d="m166.43 318h-22.857c-4.734 0-8.571 3.838-8.571 8.571v22.857c0 4.734 3.838 8.571 8.571 8.571h22.857c4.734 0 8.571-3.838 8.571-8.571v-22.857c0-4.733-3.838-8.571-8.571-8.571z" fill="#fff"/>
		<path d="m377 323h-142c-8.284 0-15 6.716-15 15s6.716 15 15 15h142c8.284 0 15-6.716 15-15s-6.716-15-15-15z" fill="#fff"/>
		<path d="m166.43 398h-22.857c-4.734 0-8.571 3.838-8.571 8.571v22.857c0 4.734 3.838 8.571 8.571 8.571h22.857c4.734 0 8.571-3.838 8.571-8.571v-22.857c0-4.733-3.838-8.571-8.571-8.571z" fill="#fff"/>
		<path d="m377 403h-142c-8.284 0-15 6.716-15 15s6.716 15 15 15h142c8.284 0 15-6.716 15-15s-6.716-15-15-15z" fill="#fff"/></svg>';
        return 'data:image/svg+xml;base64,' . base64_encode($svg);
    }

    public function injectProDependency()
    {
        add_action('admin_notices', function () {
            $pluginInfo = $this->getWPPayFormProInstallationDetails();
            $class = 'notice notice-error';
            $install_url_text = 'Click Here to Install the Plugin';
            if ($pluginInfo->action == 'activate') {
                $install_url_text = 'Click Here to Activate the Plugin';
            } else if ($pluginInfo->action == 'update') {
                $install_url_text = 'Click Here to Update & Activate the Plugin';
            }
            $message = 'Paymattic PRO Add-On Requires Paymattic Free Plugin, <b><a href="' . $pluginInfo->url
                . '">' . $install_url_text . '</a></b>';
            printf('<div class="%1$s"><p>%2$s</p></div>', esc_attr($class), $message);
        });
    }

    protected function getWPPayFormProInstallationDetails()
    {
        $activation = (object)[
            'action' => 'install',
            'url'    => ''
        ];

        if (!function_exists('get_plugins')) {
            require_once ABSPATH . 'wp-admin/includes/plugin.php';
        }

        $allPlugins = get_plugins();

        if (isset($allPlugins['wp-payment-form/wp-payment-form.php'])) {
            $version = $allPlugins['wp-payment-form/wp-payment-form.php']['Version'];
            if (version_compare($version, '4.3.2', '>')) {
                $activation->action = 'activate';
                $url = wp_nonce_url(
                    self_admin_url('plugins.php?action=activate&plugin=wp-payment-form/wp-payment-form.php'),
                    'activate-plugin_wp-payment-form/wp-payment-form.php'
                );
            } else {
                $activation->action = 'update';
                $url = wp_nonce_url(
                    self_admin_url('update.php?action=upgrade-plugin&plugin=wp-payment-form/wp-payment-form.php'),
                    'upgrade-plugin_wp-payment-form/wp-payment-form.php'
                );
            }
        } else {
            $api = (object)[
                'slug' => 'wp-payment-form'
            ];

            $url = wp_nonce_url(
                self_admin_url('update.php?action=install-plugin&plugin=' . $api->slug),
                'install-plugin_' . $api->slug
            );
        }

        $activation->url = $url;

        return $activation;
    }

    public function render()
    {
        $pluginInfo = $this->getWPPayFormProInstallationDetails();
        $install_url_text = 'Click Here to Install the Plugin';
        if ($pluginInfo->action == 'activate') {
            $install_url_text = 'Click Here to Activate the Plugin';
        } else if ($pluginInfo->action == 'update') {
            $install_url_text = 'Click Here to Update & Activate the Plugin';
        }

        $imagePath = WPPAYFORMPRO_DIR_URL . 'assets/images/migration.png';

        $notice = "<div style='width: 60%;
            height: 100%;
            margin: 0 auto;
            margin-top: 100px;
            background: #ffffff;
            padding: 28px;
            box-shadow: rgb(50 50 93 / 25%) 0px 2px 5px -1px, rgb(0 0 0 / 30%) 0px 1px 3px -1px;
            text-align: center;'>
            <img src='$imagePath' width='270'/>
                <h2>Paymattic Pro version requires the free version!</h2>
                <br>
                <p>After months of hard work and dedication,
                we are proud to introduce to you Paymattic,
                previously known as WPPayForm. Paymattic contains
                all the features and integrations of WPPayForm.
                It has been armed with tonnes more payment and donation
                features to deliver you the ultimate payment experience.
                 Moreover, it will be developed and supported
                 by the same energetic team. So enjoy!</br>
                Paymattic 4.0.0 is restructured with new powerful features. To make the
                plugin more lite and efficient we made the pro version as an add-on of free.
                </p>
                <br>
                <a style='
                    background: #0a4b78;
                    color: white;
                    text-decoration: none;
                    padding: 12px;
                    border-radius: 6px;
                ' href='" . $pluginInfo->url . "'>$install_url_text</a>
            </div>";

        echo $notice;
    }
}
