<?php

namespace WPPayFormPro\Classes\Components;

use WPPayForm\App\Services\GeneralSettings;
use WPPayForm\App\Models\Form;
use WPPayForm\App\Modules\FormComponents\BaseComponent;
use WPPayForm\Framework\Support\Arr;

if (!defined('ABSPATH')) {
    exit;
}

class CurrencySwitcherComponent extends BaseComponent
{
    public function __construct()
    {
        parent::__construct('currency_switcher', 11);
        add_filter('wppayform/validate_component_on_save_currency_switcher', array($this, 'validateOnSave'), 1, 3);
    }

    public function component()
    {
        return array(
            'type' => 'currency_switcher',
            'quick_checkout_form' => true,
            'editor_title' => 'Currency Switcher',
            'group' => 'currency',
            'postion_group' => 'payment',
            'is_pro' => 'yes',
            'single_only' => true,
            'editor_elements' => array(
                'label' => array(
                    'label' => 'Field Label',
                    'type' => 'text',
                    'group' => 'general'
                ),
                'required' => array(
                    'label' => 'Required',
                    'type' => 'switch',
                    'group' => 'general'
                ),
                'switch_options' => array(
                    'label' => 'Currency Choices',
                    'type' => 'currency_pair',
                    'group' => 'general',
                ),
                'admin_label' => array(
                    'label' => 'Admin Label',
                    'type' => 'text',
                    'group' => 'advanced'
                ),
                'wrapper_class' => array(
                    'label' => 'Field Wrapper CSS Class',
                    'type' => 'text',
                    'group' => 'advanced'
                ),
                'element_class' => array(
                    'label' => 'Input Element CSS Class',
                    'type' => 'text',
                    'group' => 'advanced'
                ),
                'conditional_render' => array(
                    'type' => 'conditional_render',
                    'group' => 'advanced',
                    'label' => 'Conditional render',
                    'selection_type' => 'Conditional logic',
                    'conditional_logic' => array(
                        'yes' => 'Yes',
                        'no' => 'No'
                    ),
                    'conditional_type' => array(
                        'any' => 'Any',
                        'all' => 'All'
                    ),
                ),
            ),
            'field_options' => array(
                'label' => 'Currency Switcher Options',
                'required' => 'no',
                'primary_currency' => '',
                'display_type' => 'select',
                'default_value' => '',
                'switch_options' => array(
                    array(
                        'label' =>  'United States Dollar',
                        'value' => 'USD',
                    ),
                ),
                'conditional_logic_option' => array(
                    'conditional_logic' => 'no',
                    'conditional_type'  => 'any',
                    'options' => array(
                        array(
                            'target_field' => '',
                            'condition' => '',
                            'value' => ''
                        )
                    ),
                ),
            )
        );
    }

    public function render($element, $form, $elements)
    {
        $disable = Arr::get($element, 'field_options.disable', false);
        $has_pro = defined('WPPAYFORMHASPRO') && WPPAYFORMHASPRO;

        $switchOptions = Arr::get($element, 'field_options.switch_options', array());
        if (!$switchOptions || $disable) {
            return;
        }

        $element['field_options']['default_value'] = apply_filters('wppayform/input_default_value', Arr::get($element['field_options'], 'default_value'), $element, $form);
        $type = Arr::get($element, 'field_options.display_type', 'radio');

        if (!$type) {
            return;
        }

        $fieldOptions = Arr::get($element, 'field_options', false);
        $conditional_logic = $fieldOptions['conditional_logic_option']['conditional_logic'];
        $hiddenAttr = Arr::get($element, 'field_options.conditional_logic_option.conditional_logic')  === 'yes' ? 'none' : 'block';
       
        $displayValue = $has_pro === true ? $hiddenAttr : '';
        $currenySettings = Form::getCurrencyAndLocale($form->ID);
        $elementId = 'wpf_' . $element['id'];
        $controlAttributes = array(
            'data-element_type' => $this->elementName,
            'data-required_element' => $type,
            'data-required' => Arr::get($fieldOptions, 'required'),
            'data-target_element' => $element['id'],
            'required_id' => $element['id'],
            'class' => $this->elementControlClass($element)
        );

        $defaultValue = Arr::get($fieldOptions, 'default_value'); ?>
            <div style="display : <?php echo esc_attr($displayValue); ?>" <?php $this->printAttributes($controlAttributes); ?>>
                <?php $this->buildLabel($fieldOptions, $form, array('for' => $elementId)); ?>
                <?php if ($type == 'select') : ?>
                    <?php
                    $placeholder = '--Select--';
                    $inputId = 'wpf_input_' . $form->ID . '_' . $this->elementName;
                    $inputAttributes = array(
                        'data-required' => Arr::get($fieldOptions, 'required'),
                        'data-type' => 'select',
                        'name' => $element['id'],
                        'class' => $this->elementInputClass($element) . ' wpf_payment_item',
                        'id' => $inputId,
                    ); ?>
                    <div class="wpf_multi_form_controls wpf_input_content wpf_multi_form_controls_select">
                        <select <?php $this->printAttributes($inputAttributes); ?>>
                            <?php if ($placeholder) : ?>
                                <option data-type="placeholder" value=""><?php echo esc_attr($placeholder); ?></option>
                            <?php endif; ?>
                            <?php foreach ($switchOptions as $index => $currency) : ?>
                                <?php
                                $optionAttributes = array(
                                    'value' => $currency['value'],
                                    'data-currency' => $currency['value'],
                                    'customname' =>  $currency['label']
                                );
                                if ($defaultValue == $currency['value']) {
                                    $optionAttributes['selected'] = 'true';
                                } ?>
                                <option <?php $this->printAttributes($optionAttributes); ?>><?php echo esc_attr($currency['label']); ?>
                                    (<?php echo esc_html($currency['value']); ?>)
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                <?php else : ?>
                    <div class="wpf_multi_form_controls wpf_input_content wpf_multi_form_controls_radio">
                        <?php foreach ($switchOptions as $index => $currency) : ?>
                            <?php
                            $optionId = $element['id'] . '_' . $index . '_' . $form->ID;
                            $attributes = array(
                                'class' => 'form-check-input wpf_payment_item',
                                'type' => 'radio',
                                'data-currency' => $currency['value'],
                                'name' => $element['id'],
                                'id' => $optionId,
                                'value' => $currency['value'],
                                'customname' => $currency['label']
                            );

                            if ($currency['value'] == $defaultValue) {
                                $attributes['checked'] = 'true';
                            }
                            ?>
                            <div class="form-check">
                                <input <?php $this->printAttributes($attributes); ?>>
                                <label class="form-check-label" for="<?php echo esc_attr($optionId); ?>">
                                    <span class="wpf_currency_option_name" itemprop="description"><?php echo esc_html($currency['label']); ?></span>
                                    <span class="wpf_currency_option_sep">&nbsp;–&nbsp;</span>
                                    <span class="wpf_currency_option_currency"><?php echo $currency['value']; ?></span>
                                    <meta itemprop="currency" content="<?php echo esc_attr($currency['value']); ?>">
                                </label>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        <?php
    }

    public function validateOnSave($error, $element, $formId)
    {
        $disable = Arr::get($element, 'field_options.disable', false);
 
        if ($disable) {
            return;
        }
        return; 
    }
}