<?php
global $current_user;
$gallery_configs = get_option('wpmf_gallery_settings');
?>
<div class="gallery_comments_item" data-attachment="<?php echo (int)$item->ID ?>">
    <div class="img_box">
        <div class="img_box_box">
            <div class="wpmf_square_thumbnail">
                <div class="img_centered">
                    <img src="<?php echo esc_url(wp_get_attachment_image_url($item->ID, 'large')) ?>">
                </div>
            </div>
        </div>
    </div>
    <div class="gallery_image_info" data-attachment="<?php echo (int)$item->ID ?>">
        <h4><?php echo esc_html(get_the_title($item->ID)) ?></h4>
        <p><?php echo esc_html(get_the_date('', $item->ID)) ?></p>
        <div class="wpmf_comment_lists">
            <?php
            $comment_lists = wpmfGalleryShowComments($item->ID, 0);
            if ($comment_lists === '') {
                echo '<p style="margin: 0; padding: 0">'. esc_html__('There are no comments in this photo.', 'wp-media-folder-gallery-addon') .'</p>';
            } else {
                // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- This variable is html
                echo $comment_lists;
            }
            ?>
        </div>

        <div class="gallery_comment_form">
            <p><?php echo esc_html__('Add Comment', 'wp-media-folder-gallery-addon') ?></p>
            <div class="gallery_comment_inputs">
                <p>
                    <textarea class="wpmf_gallery_comment_input" data-attachment="<?php echo (int)$item->ID ?>"></textarea>
                </p>
            </div>
            <p class="wpmf_gallery_reply_btn_row"><a href="#" class="wpmf_gallery_reply_btn" data-attachment="<?php echo (int)$item->ID ?>"><?php echo esc_html__('Reply', 'wp-media-folder-gallery-addon') ?></a></p>
        </div>
    </div>
</div>