<?php
$galleries = get_categories(array(
    'hide_empty' => false,
    'taxonomy' => WPMF_GALLERY_ADDON_TAXO,
    'pll_get_terms_not_translated' => 1,
    'parent' => $id
));
foreach ($galleries as $key => $gallery) {
    $gallery_order = get_term_meta($gallery->term_id, 'wpmf_order', true);
    if (empty($gallery_order)) {
        $gallery_order = 0;
    }
    $gallery->order = $gallery_order;
}
usort($galleries, 'wpmfGalleryReorder');
?>
    <div class="wpmf_gallery_lists" style="opacity: 0">
        <?php if (!empty($galleries)) : ?>
            <?php
            $img_alt = get_option('blogname');
            foreach ($galleries as $gallery_item) :
                $feature_image_id = get_term_meta($gallery_item->term_id, 'wpmf_gallery_feature_image', true);
                if (empty($feature_image_id)) {
                    $img_cover_url = WPMF_GALLERY_ADDON_PLUGIN_URL . 'assets/images/images-default.png';
                } else {
                    $attached = get_attached_file($feature_image_id);
                    $drive_type = get_post_meta($feature_image_id, 'wpmf_drive_type', true);
                    if (!empty($drive_type)) {
                        $img_cover_url = wp_get_attachment_image_url($feature_image_id, 'medium');
                        if (empty($img_cover_url)) {
                            $img_cover_url = WPMF_GALLERY_ADDON_PLUGIN_URL . 'assets/images/images-default.png';
                        }
                    } else {
                        if (file_exists($attached)) {
                            $img_cover_url = wp_get_attachment_image_url($feature_image_id, 'medium');
                        } else {
                            $img_cover_url = WPMF_GALLERY_ADDON_PLUGIN_URL . 'assets/images/images-default.png';
                        }
                    }
                }
                ?>
                <div class="wpmf_gallery_list_item" data-id="<?php echo (int)$gallery_item->term_id ?>">
                    <img alt="<?php echo esc_html($img_alt) ?>" src="<?php echo esc_url($img_cover_url) ?>">
                    <p><?php echo esc_html($gallery_item->name) ?></p>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
<?php
