<div id="wpmf_photograper_download_wishlist_lists_<?php echo (int)$id ?>" data-gallery_id="<?php echo (int)$id ?>" class="gallery_download_box gallery_download_wishlist_box mfp-hide">
    <div class="gallery_download_wishlist_wrap">
        <?php
        $photograper_default_dimensions = wpmfGetOption('photograper_default_dimensions');
        $settings         = get_option('wpmf_settings');
        if (isset($settings) && isset($settings['photograper_dimension'])) {
            $photograper_dimension = $settings['photograper_dimension'];
        } else {
            $photograper_dimension = wpmfGetOption('photograper_dimension');
        }
        $other_sizes = get_intermediate_image_sizes();
        $html = '';
        if (is_array($photograper_dimension) && !empty($photograper_dimension)) {
            if (in_array('full', $photograper_dimension)) {
                $key = array_search('full', $photograper_dimension);
                unset($photograper_dimension[$key]);
                $photograper_dimension[] = 'full';
            }
            $html .= '<ul>';
            foreach ($photograper_dimension as $i => $sizes) {
                if ($sizes === 'full') {
                    $lb = '';
                    $size_name = esc_html__('Original size', 'wp-media-folder-gallery-addon');
                } elseif (in_array($sizes, $other_sizes)) {
                    $width = get_option($sizes . '_size_w');
                    $height = get_option($sizes . '_size_h');
                    $size_name = $width . 'x' . $height;
                    $lb = '(' . $width . 'px x ' . $height . 'px)';
                } else {
                    if (!isset($photograper_default_dimensions[$sizes])) {
                        continue;
                    }
                    $size = explode('x', $sizes);
                    $size_name = $photograper_default_dimensions[$sizes]['name'];
                    $lb = '('. $size[0] .'px x '. $size[1] .'px)';
                }

                $html .= '<li>';
                $html .= '<div class="wpmf_size_row"><input '. (((int)$i === 0) ? 'checked' : '') .' class="wpmf_size_input" name="wpmf_photograper_wishlist_size" type="radio" data-size="'. esc_attr($sizes) .'"><label class="wpmf_size_label">'. $size_name .' <span>'. $lb .'</span></label></div>';
                $html .= '</li>';
            }
            $html .= '</ul>';
        }
        // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- This variable is html
        echo $html;
        ?>
    </div>

    <div class="wpmf_gallery_buttons">
        <button type="button" class="wpmf_cancel_gallery_btn"><?php echo esc_html__('Cancel', 'wp-media-folder-gallery-addon') ?></button>
        <button type="button" class="wpmf_download_wishlist_image_btn" data-gallery_id="<?php echo (int)$id ?>"><?php echo esc_html__('Download', 'wp-media-folder-gallery-addon') ?></button>
    </div>
</div>