<?php
/* Prohibit direct script loading */
defined('ABSPATH') || die('No direct script access allowed!');
?>
<div class="block-item ju-settings-option cboption">
    <div class="wpmf_row_full">
        <input type="hidden" name="wpmf_gallery_settings[photographer_feature]" value="0">
        <label data-wpmftippy="<?php esc_html_e('Activate a separate view to display photograph private client galleries', 'wp-media-folder-gallery-addon'); ?>"
               class="ju-setting-label text">
            <?php esc_html_e('Photographer feature', 'wp-media-folder-gallery-addon') ?>
        </label>
        <div class="ju-switch-button">
            <label class="switch">
                <?php
                if (isset($gallery_configs['photographer_feature']) && (int)$gallery_configs['photographer_feature'] === 1) :
                    ?>
                    <input type="checkbox" name="wpmf_gallery_settings[photographer_feature]" checked value="1">
                <?php else : ?>
                    <input type="checkbox" name="wpmf_gallery_settings[photographer_feature]" value="1">
                <?php endif; ?>
                <span class="slider round"></span>
            </label>
        </div>
    </div>
</div>

<div class="block-item ju-settings-option cboption wpmf_right m-r-0">
    <div class="wpmf_row_full">
        <input type="hidden" name="wpmf_gallery_settings[photographer_gallery_share]" value="0">
        <label data-wpmftippy="<?php esc_html_e('Activate the possibility to share protected galleries with clients', 'wp-media-folder-gallery-addon'); ?>"
               class="ju-setting-label text">
            <?php esc_html_e('Photo sharing options', 'wp-media-folder-gallery-addon') ?>
        </label>
        <div class="ju-switch-button">
            <label class="switch">
                <?php
                if (!isset($gallery_configs['photographer_gallery_share']) || (int)$gallery_configs['photographer_gallery_share'] === 1) :
                    ?>
                    <input type="checkbox" name="wpmf_gallery_settings[photographer_gallery_share]" checked value="1">
                <?php else : ?>
                    <input type="checkbox" name="wpmf_gallery_settings[photographer_gallery_share]" value="1">
                <?php endif; ?>
                <span class="slider round"></span>
            </label>
        </div>
    </div>
</div>

<div class="block-item ju-settings-option cboption">
    <div class="wpmf_row_full">
        <input type="hidden" name="wpmf_gallery_settings[photographer_photo_comments]" value="0">
        <label data-wpmftippy="<?php esc_html_e('Activate the possibility to make private comments on photos by customer, from frontend', 'wp-media-folder-gallery-addon'); ?>"
               class="ju-setting-label text">
            <?php esc_html_e('Allow comments on photos', 'wp-media-folder-gallery-addon') ?>
        </label>
        <div class="ju-switch-button">
            <label class="switch">
                <?php
                if (isset($gallery_configs['photographer_photo_comments']) && (int)$gallery_configs['photographer_photo_comments'] === 1) :
                    ?>
                    <input type="checkbox" name="wpmf_gallery_settings[photographer_photo_comments]" checked value="1">
                <?php else : ?>
                    <input type="checkbox" name="wpmf_gallery_settings[photographer_photo_comments]" value="1">
                <?php endif; ?>
                <span class="slider round"></span>
            </label>
        </div>
    </div>
</div>

<div class="wpmf_width_100 wpmf_left">
    <ul class="wpmf_filter_dimension ju-settings-option wpmf-no-margin"
        style="background: transparent !important; box-shadow: none !important;">
        <li class="div_list_child accordion-section control-section control-section-default open">
            <h3 class="accordion-section-title wpmf-section-title dimension_title wpmftippy"
                data-wpmftippy="<?php esc_html_e('Limit the max downloadable size for your images in the download popup', 'wp-media-folder-gallery-addon') ?>"
                data-title="filldimension"
                tabindex="0"
                style="padding: 20px 0;"><?php esc_html_e('Download size limit', 'wp-media-folder-gallery-addon') ?>
                <i class="zmdi zmdi-chevron-up"></i>
                <i class="zmdi zmdi-chevron-down"></i>
            </h3>
            <ul class="content_list_filldimension">
                <?php
                $default_dimensions = wpmfGetOption('photograper_default_dimensions');
                $default_dimensions['full'] = array(
                    'name' => esc_html__('Original size', 'wp-media-folder-gallery-addon'),
                    'width' => 0,
                    'height' => 0
                );

                $settings = get_option('wpmf_settings');
                if (isset($settings) && isset($settings['photograper_dimension'])) {
                    $selected_dimensions = $settings['photograper_dimension'];
                } else {
                    $selected_dimensions = wpmfGetOption('photograper_dimension');
                }

                if (count($default_dimensions) > 0) :
                    foreach ($default_dimensions as $size_name => $default_dimension) :
                        $lb = '';
                        if ($size_name !== 'full') {
                            $lb = '(' . $default_dimension['width'] . 'x' . $default_dimension['height'] . ')';
                        }
                        ?>
                        <li class="wpmf_width_100 ju-settings-option customize-control customize-control-select item_dimension"
                            style="display: list-item;" data-value="<?php echo esc_html($size_name); ?>"
                            data-type="photograper">
                            <div class="wpmf_row_full">
                                <div class="pure-checkbox ju-setting-label wpmf_width_100">
                                    <input title id="photograper_<?php echo esc_attr($size_name) ?>" type="checkbox"
                                           name="photograper_dimension[]"
                                           value="<?php echo esc_attr($size_name) ?>"
                                        <?php
                                        if (in_array($size_name, $selected_dimensions)) {
                                            echo 'checked';
                                        }
                                        ?>
                                    >
                                    <label class="lb"
                                           for="photograper_<?php echo esc_html($size_name) ?>"><?php echo esc_html(ucfirst($default_dimension['name']) . ' ' . $lb) ?></label>
                                    <?php
                                    if ($size_name !== 'full') :
                                        ?>
                                        <label class="ju-switch-button">
                                            <i class="material-icons wpmf-md-edit"
                                               data-label="dimension"
                                               data-name="<?php echo esc_html($default_dimension['name']); ?>"
                                               data-value="<?php echo esc_html($size_name); ?>"
                                               title="<?php esc_html_e('Edit dimension', 'wp-media-folder-gallery-addon'); ?>">
                                                border_color
                                            </i>

                                            <i class="material-icons wpmf-delete" data-label="dimension"
                                               data-value="<?php echo esc_html($size_name); ?>"
                                               data-name="<?php echo esc_html($default_dimension['name']); ?>"
                                               title="<?php esc_html_e('Remove dimension', 'wp-media-folder-gallery-addon'); ?>">delete_outline</i>
                                        </label>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </li>
                    <?php endforeach; ?>
                <?php endif; ?>

                <li class="wpmf_width_100 p-d-20 ju-settings-option customize-control customize-control-select dimension photograper_dimension_row">
                    <div class="photograper_dimension_item">
                        <span class="label_text_bold"><?php esc_html_e('Name', 'wp-media-folder-gallery-addon'); ?></span>
                        <label>
                            <input name="wpmf_size_name"
                                   class="wpmf_size_name"
                                   type="text">
                        </label>
                    </div>

                    <div class="photograper_dimension_item flex_row">
                        <div>
                            <span class="label_text_bold"><?php esc_html_e('Width (px)', 'wp-media-folder-gallery-addon'); ?></span>
                            <label>
                                <input name="wpmf_width_dimension" min="0"
                                       class="small-text wpmf_width_dimension"
                                       type="number">
                            </label>
                        </div>

                        <div>
                            <span class="label_text_bold"><?php esc_html_e('Height (px)', 'wp-media-folder-gallery-addon'); ?></span>
                            <label>
                                <input name="wpmf_height_dimension" min="0"
                                       class="small-text wpmf_height_dimension"
                                       type="number">
                            </label>
                        </div>
                    </div>

                    <div class="wpmf_width_100"
                         style="display: flex; align-items: center; justify-content: space-between; flex-direction: row">
                                    <span
                                            class="wpmf_width_100 m-t-30 ju-button no-background primary-button waves-effect waves-light add_dimension"
                                            data-type="photograper">
                                        <?php esc_html_e('Add new size', 'wp-media-folder-gallery-addon'); ?></span>
                        <span data-label="dimension"
                              class="m-t-10 wpmf_left ju-button primary-button waves-effect waves-light wpmfedit edit_dimension"
                              style="display: none; width: 40%" data-type="photograper">
                                        <?php esc_html_e('Save', 'wp-media-folder-gallery-addon'); ?>
                                    </span>
                        <span
                                class="m-t-10 wpmf_right ju-button no-background primary-button waves-effect waves-light wpmf_can"
                                data-label="dimension"
                                style="display: none;width: 40%"><?php esc_html_e('Cancel', 'wp-media-folder-gallery-addon'); ?></span>
                    </div>
                </li>
            </ul>
        </li>
    </ul>

    <div class="wpmf_row_full">
        <label class="ju-setting-label text"></label>
        <button type="button"
                class="ju-button no-background primary-button waves-effect waves-light wpmf_photograper_regeneration"
                style="display: flex; align-items: center;"
        ><?php esc_html_e('Thumbnail regeneration', 'wp-media-folder-gallery-addon') ?><span class="spinner"
                                                                                             style="margin-top: 0; display: none"></span>
        </button>
    </div>
</div>