<?php
/* Prohibit direct script loading */
defined('ABSPATH') || die('No direct script access allowed!');

$wpmf_ai_keys = array(
    'batch_ai_optimization',
    'new_ai_auto_optimization',
    'force_override_metadata',
    'ai_image_title',
    'ai_image_alt',
    'ai_image_description',
    'ai_image_caption',
    'rename_image_upload',
    'send_image_file_fallback',
    'admin_bar'
);

$wpmf_ai_options = array();

foreach ($wpmf_ai_keys as $key) {
    $default = ($key === 'admin_bar') ? '1' : '0';
    $wpmf_ai_options[$key] = get_option('wpmf_ai_' . $key, $default);
}

$plan_status = get_option('wpmf_ai_plan_status', 'not_paid');
$is_locked = ($plan_status === 'not_paid');
$disabled_class = ($plan_status === 'not_paid') ? 'wpmf_ai_locked' : '';
$disabled_attr = ($plan_status === 'not_paid') ? 'disabled' : '';

$wpmf_ai_feature_list = '
    <li><img src="' . esc_url(WPMF_PLUGIN_URL . 'assets/images/icons/check-icon.svg') . '">'.esc_html('Batch image AI optimization', 'wpmf').'</li>
    <li><img src="' . esc_url(WPMF_PLUGIN_URL . 'assets/images/icons/check-icon.svg') . '">'.esc_html('New image AI auto-optimization', 'wpmf').'</li>
    <li><img src="' . esc_url(WPMF_PLUGIN_URL . 'assets/images/icons/check-icon.svg') . '">'.esc_html('AI image titles', 'wpmf').'</li>
    <li><img src="' . esc_url(WPMF_PLUGIN_URL . 'assets/images/icons/check-icon.svg') . '">'.esc_html('AI image alt text', 'wpmf').'</li>
    <li><img src="' . esc_url(WPMF_PLUGIN_URL . 'assets/images/icons/check-icon.svg') . '">'.esc_html('AI image description', 'wpmf').'</li>
    <li><img src="' . esc_url(WPMF_PLUGIN_URL . 'assets/images/icons/check-icon.svg') . '">'.esc_html('AI image legend', 'wpmf').'</li>
    <li><img src="' . esc_url(WPMF_PLUGIN_URL . 'assets/images/icons/check-icon.svg') . '">'.esc_html('Rename image files on upload', 'wpmf').'</li>
';

$plans = array(
    'start' => array(
        'title' => __('Start', 'wpmf'),
        'price' => __('$10', 'wpmf'),
        'unit' => 400000,
        'badge' => '',
        'button_class' => 'wpmf-outline',
        'featured' => false,
        'link' => 'https://www.joomunited.com/component/payplans/plan/subscribe/81?group_id=0'
    ),
    'pro' => array(
        'title' => __('Pro', 'wpmf'),
        'price' => __('$20', 'wpmf'),
        'unit' => 4000000,
        'badge' => __('Save 80%', 'wpmf'),
        'button_class' => '',
        'featured' => true,
        'link' => 'https://www.joomunited.com/component/payplans/plan/subscribe/82?group_id=0'
    ),
    'max' => array(
        'title' => __('Max', 'wpmf'),
        'price' => __('$30', 'wpmf'),
        'unit' => 8000000,
        'badge' => __('Save 85%', 'wpmf'),
        'button_class' => 'wpmf-outline',
        'featured' => false,
        'link' => 'https://www.joomunited.com/component/payplans/plan/subscribe/83?group_id=0'
    )
);

$current_plan_name = 'pro';
$ai_quota_info = get_option('wpmf_ai_quota_info', array());
if (!empty($ai_quota_info)) {
    $used  = (int) $ai_quota_info['consummate_quota'];
    $limit = (int) $ai_quota_info['quota'];
    $remaining = (int) $ai_quota_info['remaining_quota'];

    if ($limit > 0) {
        $percent_used        = ($used / $limit) * 100;
        $percent_remaining   = 100 - $percent_used;

        if ($percent_remaining <= 10) {
            $bar_color = '#DD2929';
        } elseif ($percent_remaining < 50) {
            $bar_color = '#EC7E00';
        } else {
            $bar_color = '#01AB6A';
        }
    }
}

?>

<div id="ai_settings" class="tab-content">
    <div class="wpmf_width_100 top_bar">
        <h1><?php esc_html_e('AI tools', 'wpmf'); ?></h1>
    </div>
    <div class="content-box content-wpmf-ai-tools wpmf_width_100">
        <div class="ju-setting-content-box wpmf-ai-tools-config">
            <?php if ($is_locked) : ?>
                <div class="wpmf-ai-upgrade-box ju-setting-box">
                    <div class="wpmf-ai-upgrade-box-image">
                        <img src="<?php echo esc_url(WPMF_PLUGIN_URL . 'assets/images/seo-ai-image.svg'); ?>">
                    </div>
                    <div class="wpmf-ai-upgrade-box-description">
                        <h3><?php esc_html_e('SEO-AI Image Optimization', 'wpmf') ?></h3>
                        <p><?php esc_html_e('Take your image SEO to the next level with powerful AI tools designed to save time and boost performance.', 'wpmf') ?></p>
                        <div>
                            <a href="<?php echo esc_url(admin_url('options-general.php?page=option-folder#ai_subscribe')); ?>" class="wpmf-ai-subscribe-link">
                                <?php esc_html_e('Upgrade Now', 'wpmf'); ?>
                            </a>
                        </div>
                    </div>
                </div>

                <div class="wpmf-ai-warning ju-setting-box-warning">
                    <div class="ju-warning-icon">
                        <img src="<?php echo esc_url(WPMF_PLUGIN_URL . 'assets/images/icons/warning-icon.svg'); ?>">
                    </div>
                    <div class="ju-warning-description">
                        <p><?php esc_html_e('This feature is not included in your current plan and requires a separate purchase.', 'wpmf') ?></p>
                        <p><?php esc_html_e('Activate this add-on to unlock all options listed below.', 'wpmf') ?></p>
                    </div>
                </div>
            <?php else : ?>
                <div class="wpmf-ai-plan-box ju-setting-box">
                    <div class="wpmf-ai-plan-title wpmf-ai-settings-section-title">
                        <?php esc_html_e('Your plan', 'wpmf'); ?>
                    </div>
                    <div class="wpmf-ai-plan-content">
                        <div class="wpmf-ai-plan-usage">
                            <span class="wpmf-plan-used"><?php echo esc_html(wpmfCustomNumberFormat($used)) ?></span> / <?php echo esc_html(wpmfCustomNumberFormat($limit)) ?>
                            <?php esc_html_e('credits', 'wpmf'); ?>
                        </div>

                        <div class="wpmf-ai-progress-container">
                            <div class="wpmf-ai-progress-bar" style="width: <?php echo esc_attr($percent_used); ?>%; background-color: <?php echo esc_attr($bar_color); ?>;"></div>
                        </div>

                        <div class="wpmf-ai-plan-remaining">
                            <?php esc_html_e('Credits usage left:', 'wpmf'); ?>
                            <span class="wpmf-ai-plan-remaining-count" style="color: <?php echo esc_attr($bar_color); ?>">
                                <?php echo esc_html(wpmfCustomNumberFormat($remaining)) ?>
                            </span>
                        </div>
                        <?php if ($percent_remaining <= 10) : ?>
                            <div class="wpmf-ai-warning ju-setting-box-danger">
                                <div class="ju-danger-icon">
                                    <img src="<?php echo esc_url(WPMF_PLUGIN_URL . 'assets/images/icons/error-icon.svg'); ?>">
                                </div>
                                <div class="ju-danger-description">
                                    <h6 class="ju-setting-box-danger-title"><?php esc_html_e('You\'re reaching your limit!', 'wpmf') ?></h6>
                                    <p>
                                        <?php
                                            printf(
                                                esc_html__('You’ve used %.0f%% of your available image optimizations.', 'wpmf'),
                                                esc_html(number_format_i18n($percent_used, 0))
                                            );
                                        ?>    
                                    </p>
                                    <p><?php esc_html_e('To continue using SEO-AI features without interruption, consider purchasing an additional image plan.', 'wpmf') ?></p>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>

                    <?php if ($percent_remaining <= 10) : ?>
                        <div class="wpmf-ai-plan-action">
                            <a href="<?php echo esc_url(admin_url('options-general.php?page=option-folder#ai_subscribe')); ?>" class="wpmf-ai-subscribe-link">
                                <?php esc_html_e('Get More Credits', 'wpmf'); ?>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            <div class="wpmf-ai-settings-section ju-setting-box <?php echo $is_locked ? 'locked' : ''; ?>">
                <h4 class="wpmf-ai-settings-section-title"><?php esc_html_e('Auto-optimization', 'wpmf') ?></h4>
                <div class="wpmf-ai-option-box">
                    <input type="hidden" name="wpmf_ai[batch_ai_optimization]" value="0">
                    <label class="wpmf-ai-option-label">
                        <input type="checkbox" name="wpmf_ai[batch_ai_optimization]" value="1" <?php checked($wpmf_ai_options['batch_ai_optimization'], '1'); ?> <?php echo $is_locked ? 'disabled' : ''; ?>>
                        <span><?php esc_html_e('Batch image AI optimization', 'wpmf') ?></span>
                    </label>
                    <span class="wpmf-ai-option-description"><?php esc_html_e('When activated, a new button will be added in the WordPress admin media menu that allows you to launch batch AI image optimization globally or by folder. The settings below will be applied', 'wpmf') ?></span>
                </div>

                <div class="wpmf-ai-option-box">
                    <input type="hidden" name="wpmf_ai[new_ai_auto_optimization]" value="0">
                    <label class="wpmf-ai-option-label">
                        <input type="checkbox" name="wpmf_ai[new_ai_auto_optimization]" value="1" <?php checked($wpmf_ai_options['new_ai_auto_optimization'], '1'); ?> <?php echo $is_locked ? 'disabled' : ''; ?>>
                        <span><?php esc_html_e('New image AI auto-optimization', 'wpmf') ?></span>
                    </label>
                    <span class="wpmf-ai-option-description"><?php esc_html_e('When activated, the image will be AI optimized with the information below', 'wpmf') ?></span>
                </div>
            </div>

            <div class="wpmf-ai-settings-section ju-setting-box <?php echo $is_locked ? 'locked' : ''; ?>">
                <h4 class="wpmf-ai-settings-section-title"><?php esc_html_e('Image SEO information', 'wpmf') ?></h4>

                <div class="wpmf-ai-option-box">
                    <input type="hidden" name="wpmf_ai[force_override_metadata]" value="0">
                    <label class="wpmf-ai-option-label">
                        <input type="checkbox" name="wpmf_ai[force_override_metadata]" value="1"
                               <?php checked($wpmf_ai_options['force_override_metadata'], '1'); ?>
                               <?php echo $is_locked ? 'disabled' : ''; ?>>
                        <span><?php esc_html_e('Image info override', 'wpmf') ?></span>
                    </label>
                    <span class="wpmf-ai-option-description">
                        <?php esc_html_e('Beware, if checked the AI image optimizer will override your existing image information', 'wpmf') ?>
                    </span>
                </div>

                <div class="wpmf-ai-option-box">
                    <input type="hidden" name="wpmf_ai[ai_image_title]" value="0">
                    <label class="wpmf-ai-option-label">
                        <input type="checkbox" name="wpmf_ai[ai_image_title]" value="1"
                               <?php checked($wpmf_ai_options['ai_image_title'], '1'); ?>
                               <?php echo $is_locked ? 'disabled' : ''; ?>>
                        <span><?php esc_html_e('AI image titles', 'wpmf') ?></span>
                    </label>
                    <span class="wpmf-ai-option-description">
                        <?php esc_html_e('When activated, you’ll be able to fill the image titles using AI', 'wpmf') ?>
                    </span>
                </div>

                <div class="wpmf-ai-option-box">
                    <input type="hidden" name="wpmf_ai[ai_image_alt]" value="0">
                    <label class="wpmf-ai-option-label">
                        <input type="checkbox" name="wpmf_ai[ai_image_alt]" value="1"
                               <?php checked($wpmf_ai_options['ai_image_alt'], '1'); ?>
                               <?php echo $is_locked ? 'disabled' : ''; ?>>
                        <span><?php esc_html_e('AI image alt text', 'wpmf') ?></span>
                    </label>
                    <span class="wpmf-ai-option-description">
                        <?php esc_html_e('When activated, you’ll be able to fill the image with alternate titles using AI', 'wpmf') ?>
                    </span>
                </div>

                <div class="wpmf-ai-option-box">
                    <input type="hidden" name="wpmf_ai[ai_image_description]" value="0">
                    <label class="wpmf-ai-option-label">
                        <input type="checkbox" name="wpmf_ai[ai_image_description]" value="1"
                               <?php checked($wpmf_ai_options['ai_image_description'], '1'); ?>
                               <?php echo $is_locked ? 'disabled' : ''; ?>>
                        <span><?php esc_html_e('AI image description', 'wpmf') ?></span>
                    </label>
                    <span class="wpmf-ai-option-description">
                        <?php esc_html_e('When activated, you’ll be able to fill the image description using AI', 'wpmf') ?>
                    </span>
                </div>

                <div class="wpmf-ai-option-box">
                    <input type="hidden" name="wpmf_ai[ai_image_caption]" value="0">
                    <label class="wpmf-ai-option-label">
                        <input type="checkbox" name="wpmf_ai[ai_image_caption]" value="1"
                               <?php checked($wpmf_ai_options['ai_image_caption'], '1'); ?>
                               <?php echo $is_locked ? 'disabled' : ''; ?>>
                        <span><?php esc_html_e('AI image caption', 'wpmf') ?></span>
                    </label>
                    <span class="wpmf-ai-option-description">
                        <?php esc_html_e('When activated, you’ll be able to fill the image caption using AI', 'wpmf') ?>
                    </span>
                </div>
            </div>

            <div class="wpmf-ai-settings-section ju-setting-box <?php echo $is_locked ? 'locked' : ''; ?>">
                <h4 class="wpmf-ai-settings-section-title"><?php esc_html_e('Image names', 'wpmf') ?></h4>
                <div class="wpmf-ai-option-box">
                    <input type="hidden" name="wpmf_ai[rename_image_upload]" value="0">
                    <label class="wpmf-ai-option-label">
                        <input type="checkbox" name="wpmf_ai[rename_image_upload]" value="1"
                               <?php checked($wpmf_ai_options['rename_image_upload'], '1'); ?>
                               <?php echo $is_locked ? 'disabled' : ''; ?>>
                        <span><?php esc_html_e('Rename image files on upload', 'wpmf') ?></span>
                    </label>
                    <span class="wpmf-ai-option-description">
                        <?php esc_html_e('When activated, you’ll be able to fill the image file titles using AI during new image upload', 'wpmf') ?>
                    </span>
                </div>
            </div>

            <div class="wpmf-ai-settings-section ju-setting-box <?php echo $is_locked ? 'locked' : ''; ?>">
                <h4 class="wpmf-ai-settings-section-title"><?php esc_html_e('Fallback upload method', 'wpmf') ?></h4>
                <div class="wpmf-ai-option-box">
                    <input type="hidden" name="wpmf_ai[send_image_file_fallback]" value="0">
                    <label class="wpmf-ai-option-label">
                        <input type="checkbox" name="wpmf_ai[send_image_file_fallback]" value="1"
                               <?php checked($wpmf_ai_options['send_image_file_fallback'], '1'); ?>
                               <?php echo $is_locked ? 'disabled' : ''; ?>>
                        <span><?php esc_html_e('Send image file to AI', 'wpmf') ?></span>
                    </label>
                    <span class="wpmf-ai-option-description">
                        <?php esc_html_e('This is an alternative method to send images to the AI. Upload the image file to the AI service instead of the image URL. This method is slower and should only be used as a fallback when the AI optimizer cannot access or process the image via URL.', 'wpmf') ?>
                    </span>
                </div>
            </div>

            <div class="wpmf-ai-settings-section ju-setting-box <?php echo $is_locked ? 'locked' : ''; ?>">
                <h4 class="wpmf-ai-settings-section-title"><?php esc_html_e('AI Quota', 'wpmf') ?></h4>
                <div class="wpmf-ai-option-box">
                    <input type="hidden" name="wpmf_ai[admin_bar]" value="0">
                    <label class="wpmf-ai-option-label">
                        <input type="checkbox" name="wpmf_ai[admin_bar]" value="1"
                               <?php checked($wpmf_ai_options['admin_bar'], '1'); ?>
                               <?php echo $is_locked ? 'disabled' : ''; ?>>
                        <span><?php esc_html_e('AI Quota in topbar', 'wpmf') ?></span>
                    </label>
                    <span class="wpmf-ai-option-description">
                        <?php esc_html_e('Display the remaining AI token quota in the WordPress topbar', 'wpmf') ?>
                    </span>
                </div>
            </div>
        </div>
    </div>
    <?php if (!$is_locked) : ?>
        <button type="submit" name="btn_wpmf_save" class="btn_wpmf_save ju-button waves-effect waves-light"><?php esc_html_e('Save Changes', 'wpmf'); ?></button>
    <?php endif; ?>
</div>

<div id="ai_subscribe" class="tab-content">
    <div class="content-box content-wpmf-ai-tools wpmf_width_100">
        <div class="wpmf-ai-tool-plan">
            <div class="wpmf-pricing-wrapper">
                <h3 class="wpmf-pricing-title"><?php esc_html_e('Choose a pricing plan', 'wpmf') ?></h3>
                <div class="wpmf-pricing-grid">
                    <?php foreach ($plans as $plan) : ?>
                        <div class="wpmf-pricing-card<?php echo $plan['featured'] ? ' wpmf-pricing-featured' : ''; ?>">
                            <div class="wpmf-pricing-card-top">
                                <div class="wpmf-plan-title-badge">
                                    <h4 class="wpmf-plan-title"><?php echo esc_html($plan['title']); ?></h4>
                                    <?php if (!empty($plan['badge'])) : ?>
                                        <div class="wpmf-badge"><?php echo esc_html($plan['badge']); ?></div>
                                    <?php endif; ?>
                                </div>
                                <?php $images = round($plan['unit'] / 400); ?>
                                <div class="wpmf-plan-price">
                                    <span class="wpmf-price-main"><?php echo esc_html($plan['price']); ?></span>
                                    <div class="wpmf-price-unit-wrapper">
                                        <div class="wpmf-plan-unit">/ <?php echo esc_html(wpmfCustomNumberFormat($plan['unit'])); ?> <?php esc_html_e('credits', 'wpmf') ?></div>
                                        <div class="wpmf-plan-approx">(~<?php echo esc_html(wpmfCustomNumberFormat($images)); ?> <?php esc_html_e('images', 'wpmf') ?>)</div>
                                    </div>
                                </div>
                                <a class="wpmf-upgrade-btn <?php echo esc_attr($plan['button_class']); ?>" href="<?php echo esc_url($plan['link']); ?>" target="_blank">
                                    <?php esc_html_e('Upgrade Now', 'wpmf'); ?>
                                </a>
                            </div>
                            <div class="wpmf-divider"></div>
                            <ul class="wpmf-feature-list">
                                <?php echo wp_kses_post($wpmf_ai_feature_list); ?> 
                            </ul>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</div>
