<?php
$masonry_layout = (isset($layout)) ? $layout : '';
// getting rid of float
$class[] = 'gallery-' . $display;
$class[] = 'gallery-' . $display . '-' . $masonry_layout;
$class[] = 'galleryid-' . $id;
$class[] = 'gallery-columns-' . $columns;
$class[] = 'gallery-size-' . $size;
$class[] = 'wpmf-has-border-radius-' . $img_border_radius;
$class[] = 'wpmf-gutterwidth-' . $gutterwidth;
$class[] = 'wpmf-gallery-clear';
$class = implode(' ', $class);

$masonry_row_height = (isset($row_height)) ? $row_height : 150;
$padding_masonry = get_option('wpmf_padding_masonry');
if (!isset($padding_masonry) && $padding_masonry === '') {
    $padding_masonry = 5;
}

$gutterwidth = isset($gutterwidth) ? $gutterwidth : $padding_masonry;
$lists = array();
$lists_full = array();
$j = 0;
$lightbox_items = $this->getLightboxItems($attachments, $targetsize, $gid);
foreach ($attachments as $index => $attachment) {
    $gallery_item = $this->getAttachmentThemeHtml('masonry', $attachment, $social, $index, $params, $gid);
    if (!$lazy_load) {
        $lists[] = $gallery_item;
    } else {
        if ($j >= 8) {
            $lists[] = $gallery_item;
        }
        $j++;
    }

    $lists_full[] = $gallery_item;
}

$style = '';
if ($img_shadow !== '') {
    $style .= '#' . $selector . ' .wpmf-gallery-item img:not(.glrsocial_image):hover, #' . $selector . ' .wpmf-gallery-item .wpmf_overlay {box-shadow: ' . $img_shadow . ' !important; transition: all 200ms ease;}';
}

if ($border_style !== 'none') {
    $style .= '#' . $selector . ' .wpmf-gallery-item img:not(.glrsocial_image) {border: ' . $border_color . ' ' . $border_width . 'px ' . $border_style . '}';
}

$ids = get_term_meta($gid, 'wpmf_gallery_wishlist', true);
$params = wpmfGalleryAddonGetParams($gid);
$objects = get_objects_in_term($gid, WPMF_GALLERY_ADDON_TAXO);
if (!empty($params) && (int)$params['auto_from_folder'] === 1 && !empty($params['folder'])) {
    $objects2 = get_objects_in_term($params['folder'], WPMF_TAXO);
    $objects = array_merge($objects, $objects2);
}
if (!empty($ids) && is_array($ids)) {
    $wishlist_count = count(array_intersect($ids, $objects));
} else {
    $wishlist_count = 0;
}

wp_add_inline_style('wpmf-gallery-style', $style);
if (isset($is_divi) && (int)$is_divi === 1) {
    // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- This variable is html
    echo '<style>' . $style . '</style>';
}
echo '<div class="wpmf-gallerys wpmf-gallerys-addon" data-theme="'. esc_attr($display) .'" data-layout="'. esc_attr($masonry_layout) .'" data-row_height="'. esc_attr($masonry_row_height) .'" data-id="' . esc_html($id) . '">';
if (!empty($gallery_type) && $gallery_type === 'photographer') {
    echo '<p class="wpmf_gallery_show_request_list_row" data-gallery_id="'. (int)$gid .'" data-wishlist_count="'. (int)$wishlist_count .'">';
    echo '<a href="#" data-wpmftippy="'. esc_html__('Open the selection of image in your wishlist and make comments (if allowed)', 'wp-media-folder-gallery-addon') .'" data-gallery_id="'. (int)$id .'" class="wpmftippy wpmf_gallery_show_request_list"><img src="'. esc_url(WPMF_GALLERY_ADDON_PLUGIN_URL . 'assets/images/add_photo_alternate_white.svg') .'">'. esc_html__('Open wishlist', 'wp-media-folder-gallery-addon') .'</a>';
    echo '<a href="#" data-wpmftippy="'. esc_html__('Filter and display only the images in your wishlist', 'wp-media-folder-gallery-addon') .'" data-gallery_id="'. (int)$id .'" class="wpmftippy wpmf_gallery_filter_wishlist '. ((!empty($is_wishlist) ? 'selected' : '')) .'"><img src="'. esc_url(WPMF_GALLERY_ADDON_PLUGIN_URL . 'assets/images/photo_filter.svg') .'">'. esc_html__('Filter wishlist', 'wp-media-folder-gallery-addon') .'</a>';
    echo '<a href="#" data-wpmftippy="'. esc_html__('Download images from your wishlist', 'wp-media-folder-gallery-addon') .'" data-gallery_id="'. (int)$id .'" class="wpmftippy wpmf_gallery_download_list"><img src="'. esc_url(WPMF_GALLERY_ADDON_PLUGIN_URL . 'assets/images/file_download_white.svg') .'">'. esc_html__('Download wishlist', 'wp-media-folder-gallery-addon') .'</a>';
    echo '</p>';
}
echo '<div id="' . esc_attr($selector) . '" data-count="' . esc_attr($count_attachments) . '" class="' . esc_attr($class) . '" data-gutter-width="' . esc_attr($gutterwidth) . '"
  data-wpmfcolumns="' . esc_attr($columns) . '" data-lightbox-items="'. esc_attr(json_encode($lightbox_items)) .'">';
foreach ($lists_full as $i => $list) {
    if (!$lazy_load) {
        echo $list; // phpcs:ignore WordPress.Security.EscapeOutput -- Content already escaped in the method
    } else {
        if ($i < 8) {
            echo $list; // phpcs:ignore WordPress.Security.EscapeOutput -- Content already escaped in the method
        }
    }
}
echo "</div></div>\n";
