<?php
global $current_user;
$gallery_configs = get_option('wpmf_gallery_settings');
$show_form = false;
if ((!empty($current_user->ID) && in_array('administrator', $current_user->roles)) || !empty($gallery_configs['photographer_photo_comments'])) {
    $show_form = true;
}
?>
<div class="gallery_comments_item" data-attachment="<?php echo (int)$image ?>">
    <div class="img_box">
        <div class="img_box_box">
            <div class="wpmf_square_thumbnail">
                <div class="img_centered">
                    <img src="<?php echo esc_url(wp_get_attachment_image_url($image, 'large')) ?>">
                </div>
            </div>
            <svg class="wpmf_gallery_remove_item" xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 0 24 24"
                 width="24px" fill="#FFFFFF">
                <path d="M0 0h24v24H0V0z" fill="none"/>
                <path d="M14.59 8L12 10.59 9.41 8 8 9.41 10.59 12 8 14.59 9.41 16 12 13.41 14.59 16 16 14.59 13.41 12 16 9.41 14.59 8zM12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z"/>
            </svg>
        </div>
    </div>
    <div class="gallery_image_info" data-attachment="<?php echo (int)$image ?>">
        <h4><?php echo esc_html(get_the_title($image)) ?></h4>
        <p><?php echo esc_html(get_the_date('', $image)) ?></p>
        <?php
        $comment_lists = wpmfGalleryShowComments($image, 0);
        if ($comment_lists === '') {
            if ($show_form) {
                echo '<div class="wpmf_comment_lists">';
                echo '<p style="margin: 0; padding: 0">' . esc_html__('There are no comments in this photo.', 'wp-media-folder-gallery-addon') . '</p>';
                echo '</div>';
            }
        } else {
            echo '<div class="wpmf_comment_lists">';
            // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped -- This variable is html
            echo $comment_lists;
            echo '</div>';
        }
        ?>
        <?php if ($show_form) : ?>
            <div class="gallery_comment_form">
                <p><?php echo esc_html__('Add Comment', 'wp-media-folder-gallery-addon') ?></p>
                <div class="gallery_comment_inputs">
                    <p>
                        <textarea class="wpmf_gallery_comment_input"
                                  data-attachment="<?php echo (int)$image ?>"></textarea>
                    </p>
                </div>
                <p class="wpmf_gallery_reply_btn_row"><a href="#" class="wpmf_gallery_reply_btn"
                                                         data-attachment="<?php echo (int)$image ?>"><?php echo esc_html__('Reply', 'wp-media-folder-gallery-addon') ?></a>
                </p>
            </div>
        <?php endif; ?>
    </div>
</div>