<?php
/* Prohibit direct script loading */
defined('ABSPATH') || die('No direct script access allowed!');

/**
 * Class WpmfGlrAddonFrontEnd
 * This class that holds most of the front-end functionality for WP Media Folder Gallery
 */
class WpmfGlrAddonFrontEnd
{
    /**
     * WpmfGlrAddonFrontEnd constructor.
     */
    public function __construct()
    {
        if (is_plugin_active('wp-media-folder/wp-media-folder.php')) {
            add_action('wp_enqueue_scripts', array($this, 'galleryScripts'));
            add_shortcode('wpmfgallery', array($this, 'galleryShortcode'));
            add_action('wp_ajax_nopriv_wpmf_load_gallery', array($this, 'loadGallery'));
            add_action('wp_ajax_wpmf_load_gallery', array($this, 'loadGallery'));
            add_action('wp_ajax_get_galleries', array($this, 'getGalleries'));
            add_action('wp_ajax_nopriv_get_galleries', array($this, 'getGalleries'));
            add_action('wp_ajax_nopriv_getParentsCats', array($this, 'getParentsCats'));
            add_action('wp_ajax_getParentsCats', array($this, 'getParentsCats'));
            add_action('wp_ajax_nopriv_wpmf_get_gallery_item', array($this, 'getGalleryItem'));
            add_action('wp_ajax_wpmf_get_gallery_item', array($this, 'getGalleryItem'));
            add_action('wp_ajax_wpmf_divi_load_gallery_addon_html', array($this, 'loadGalleryHtml'));
            add_action('wp_ajax_nopriv_wpmf_gallery_insert_comment', array($this, 'galleryInsertComment'));
            add_action('wp_ajax_wpmf_gallery_insert_comment', array($this, 'galleryInsertComment'));
            add_action('wp_ajax_nopriv_wpmf_gallery_submit_comments', array($this, 'gallerySubmitComments'));
            add_action('wp_ajax_wpmf_gallery_submit_comments', array($this, 'gallerySubmitComments'));
            add_action('wp_ajax_nopriv_wpmf_gallery_photograper_load_requests', array($this, 'galleryPhotograperLoadRequests'));
            add_action('wp_ajax_wpmf_gallery_photograper_load_requests', array($this, 'galleryPhotograperLoadRequests'));
            add_action('wp_ajax_nopriv_wpmf_gallery_add_to_wishlist', array($this, 'galleryAddToWishlist'));
            add_action('wp_ajax_wpmf_gallery_add_to_wishlist', array($this, 'galleryAddToWishlist'));
            add_action('wp_ajax_nopriv_wpmf_gallery_download_wishlist', array($this, 'galleryDownloadWishlist'));
            add_action('wp_ajax_wpmf_gallery_download_wishlist', array($this, 'galleryDownloadWishlist'));
            add_action('wp_ajax_nopriv_wpmf_gallery_load_download_sizes', array($this, 'galleryLoadDownloadSizes'));
            add_action('wp_ajax_wpmf_gallery_load_download_sizes', array($this, 'galleryLoadDownloadSizes'));
            add_action('wp_ajax_nopriv_wpmf_gallery_download_image', array($this, 'galleryDownloadImage'));
            add_action('wp_ajax_wpmf_gallery_download_image', array($this, 'galleryDownloadImage'));
            add_action('wp_ajax_wpmf_gallery_download_image_all', array($this, 'galleryDownloadImageAll'));
            add_filter('post_password_required', array($this, 'postPasswordRequired'), 10, 2);
        }
    }

    /**
     * Filters whether a post requires the user to supply a password.
     *
     * @param boolean $required Whether the user needs to supply a password. True if password has not been
     *                          provided or is incorrect, false if password has been supplied or is not required.
     * @param object  $post     Post object.
     *
     * @return boolean
     */
    public function postPasswordRequired($required, $post)
    {
        global $current_user;
        if (!empty($current_user->ID)) {
            if (in_array('administrator', $current_user->roles)) {
                return false;
            }
        }
        return $required;
    }

    /**
     * Load gallery html
     *
     * @return void
     */
    public function loadGalleryHtml()
    {
        if (empty($_REQUEST['et_admin_load_nonce'])
            || !wp_verify_nonce($_REQUEST['et_admin_load_nonce'], 'et_admin_load_nonce')) {
            wp_send_json(array('status' => false, 'html' => '<p>'. esc_html__('Load failed!', 'wp-media-folder-gallery-addon') .'</p>'));
        }
        $request_body = file_get_contents('php://input');
        $data = json_decode($request_body, true);
        $gallery_navigation = (!empty($data['display_tree']) && $data['display_tree'] === 'on') ? 1 : 0;
        $sub_galleries_listing = (!empty($data['sub_galleries_listing']) && $data['sub_galleries_listing'] === 'on') ? 1 : 0;
        $gallery_image_tags = (!empty($data['display_tag']) && $data['display_tag'] === 'on') ? 1 : 0;
        $disable_overlay = (!empty($data['disable_overlay']) && $data['disable_overlay'] === 'on') ? 1 : 0;
        $download_all = (!empty($data['download_all']) && $data['download_all'] === 'on') ? 1 : 0;
        if (empty($data['gallery_id'])) {
            $html = '<div class="wpmf-divi-container">
            <div id="divi-gallery-placeholder" class="divi-gallery-placeholder">
                        <span class="wpmf-divi-message">
                            ' . esc_html__('Please add some images to the gallery to activate the preview', 'wp-media-folder-gallery-addon') . '
                        </span>
            </div>
          </div>';
            wp_send_json(array('status' => false, 'html' => $html));
        }

        $html = do_shortcode('[wpmfgallery is_divi="1" is_lazy_load="0" display_tree="'. esc_attr($gallery_navigation) .'" sub_galleries_listing="'. esc_attr($sub_galleries_listing) .'" display_tag="'. esc_attr($gallery_image_tags) .'" disable_overlay="'. esc_attr($disable_overlay) .'" download_all="'. esc_attr($download_all) .'" gallery_id="'. esc_attr($data['gallery_id']) .'" display="' . esc_attr($data['display']) . '" layout="' . esc_attr($data['layout']) . '" row_height="' . esc_attr($data['row_height']) . '" aspect_ratio="'. esc_attr($data['aspect_ratio']) .'" columns="' . esc_attr($data['columns']) . '" size="' . esc_attr($data['size']) . '" targetsize="' . esc_attr($data['targetsize']) . '" link="' . esc_attr($data['link']) . '" wpmf_orderby="' . esc_attr($data['orderby']) . '" wpmf_order="' . esc_attr($data['order']) . '" gutterwidth="' . esc_attr($data['gutterwidth']) . '" border_width="' . esc_attr($data['border_width']) . '" border_style="' . esc_attr($data['border_style']) . '" border_color="' . esc_attr($data['border_color']) . '" img_shadow="' . esc_attr($data['img_shadow']) . '" img_border_radius="' . esc_attr($data['border_radius']) . '" number_lines="' . esc_attr($data['number_lines']) . '" hover_color="'. $data['hover_color'] .'" hover_opacity="'. $data['hover_opacity'] .'" hover_title_position="'. $data['hover_title_position'] .'" hover_title_size="'. $data['hover_title_size'] .'" hover_title_color="'. $data['hover_title_color'] .'" hover_desc_position="'. $data['hover_desc_position'] .'" hover_desc_size="'. $data['hover_desc_size'] .'" hover_desc_color="'. $data['hover_desc_color'] .'"]');
        wp_send_json(array('status' => true, 'html' => $html));
    }

    /**
     * Get term to display folder tree
     *
     * @return void
     */
    public function getGalleries()
    {
        $dirs = array();
        $id   = 0;
        // phpcs:ignore WordPress.Security.NonceVerification.Missing -- get gallery on frontend
        if (!empty($_POST['id'])) {
            // phpcs:ignore WordPress.Security.NonceVerification.Missing -- get gallery on frontend
            $id = (int) $_POST['id'];
        }

        // Retrieve the terms in a given taxonomy or list of taxonomies.
        $categorys = get_categories(
            array(
                'taxonomy'   => WPMF_GALLERY_ADDON_TAXO,
                'orderby'    => 'name',
                'order'      => 'ASC',
                'parent'     => $id,
                'hide_empty' => false
            )
        );

        foreach ($categorys as $category) {
            $child      = get_term_children((int) $category->term_id, WPMF_GALLERY_ADDON_TAXO);
            $countchild = count($child);
            $dirs[]     = array(
                'type'        => 'dir',
                'file'        => $category->name,
                'id'          => $category->term_id,
                'parent_id'   => $category->parent,
                'count_child' => $countchild,
                'term_group'  => $category->term_group
            );
        }

        if (count($dirs) === 0) {
            wp_send_json(array('status' => false));
        } else {
            wp_send_json(array('status' => true, 'dirs' => $dirs));
        }
    }

    /**
     * Loop get parent list gallery
     *
     * @param integer $id     Id of current gallery
     * @param array   $result Result
     *
     * @return array
     */
    public function loopGetParentsCats($id, $result)
    {
        $term = get_term($id, WPMF_GALLERY_ADDON_TAXO);
        if ((int) $term->parent !== 0) {
            $result = $this->loopGetParentsCats($term->parent, $result);
        }
        $result[] = $term->term_id;
        return $result;
    }

    /**
     * Get parents categories
     *
     * @return void
     */
    public function getParentsCats()
    {
        if (empty($_POST['wpmf_gallery_nonce'])
            || !wp_verify_nonce($_POST['wpmf_gallery_nonce'], 'wpmf_gallery_nonce')) {
            die();
        }

        $result = array();
        if (isset($_POST['id'])) {
            $id       = (int) $_POST['id'];
            $term     = get_term($id, WPMF_GALLERY_ADDON_TAXO);
            $result   = $this->loopGetParentsCats($term->parent, $result);
            $result[] = $id;
        }
        wp_send_json($result);
    }

    /**
     * Get social html
     *
     * @return string
     */
    public function getSocialHtml()
    {
        $social_sharing      = wpmfGetOption('social_sharing');
        $social_sharing_link = wpmfGetOption('social_sharing_link');

        foreach ($social_sharing_link as $attr_key => $attr_value) {
            ${$attr_key} = $attr_value;
        }

        $social       = '';
        if ((int) $social_sharing === 1) {
            if (!empty($facebook) || !empty($twitter) || !empty($instagram) || !empty($pinterest)) {
                $social .= '<div class="wpmfglr_social">';
                if (!empty($facebook)) {
                    $social .= '<a href="' . $facebook . '"  target="_blank">
<span class="dashicons dashicons-facebook-alt"></span></a>';
                }

                if (!empty($twitter)) {
                    $social .= '<a href="' . $twitter . '"  target="_blank">
<span class="dashicons dashicons-twitter"></span></a>';
                }

                if (!empty($instagram)) {
                    $social .= '<a href="' . $instagram . '"  target="_blank">
<span class="dashicons dashicons-instagram"></span></a>';
                }

                if (!empty($pinterest)) {
                    $social .= '<a href="' . $pinterest . '"  target="_blank">
<img class="glrsocial_image" src="' . WPMF_GALLERY_ADDON_PLUGIN_URL . 'assets/images/pinterest.png" /></a>';
                }

                $social .= '</div>';
            }
        }

        return $social;
    }

    /**
     * Run shortcode gallery
     *
     * @param array $attr Params of gallery
     *
     * @return string
     */
    public function galleryShortcode($attr)
    {
        if (empty($attr['gallery_id'])) {
            return esc_html__('Please choose a gallery!', 'wp-media-folder-gallery-addon');
        }

        wp_enqueue_style('wpmf-material-icon');
        wp_enqueue_style(
            'wpmf-material-design-iconic-font.min',
            WPMF_PLUGIN_URL . 'assets/css/material-design-iconic-font.min.css',
            array(),
            WPMF_VERSION
        );
        /* Get all params */
        $post = get_post();
        static $instance = 0;
        $instance++;
        $selector = 'wpmf-gallery-' . $instance;
        $gallery_configs = get_option('wpmf_gallery_settings');
        // verify orderby option
        $galleries = get_option('wpmf_galleries');
        $gallery_type = get_term_meta((int)$attr['gallery_id'], 'gallery_type', true);
        $default_params = array(
            'display' => '',
            'layout' => 'vertical',
            'row_height' => 200,
            'aspect_ratio' => 'default',
            'columns' => 3,
            'gutterwidth' => 5,
            'link' => 'file',
            'size' => (!empty($gallery_type) && $gallery_type === 'photographer') ? 'large' : 'medium',
            'targetsize' => 'large',
            'wpmf_orderby' => 'post__in',
            'wpmf_order' => 'ASC',
            'customlink' => 0,
            'class' => '',
            'display_tree' => 0,
            'sub_galleries_listing' => 0,
            'display_tag' => 0,
            'disable_overlay' => 0,
            'download_all' => 0,
            'tree_width' => 250,
            'img_border_radius' => 0,
            'border_width' => 0,
            'border_color' => 'transparent',
            'border_style' => 'solid',
            'img_shadow' => '',
            'auto_from_folder' => 1,
            'folder' => 0,
            'google_photos_album' => 0,
            'show_buttons' => $gallery_configs['theme']['flowslide_theme']['show_buttons'],
            'animation' => $gallery_configs['theme']['slider_theme']['animation'],
            'duration' => $gallery_configs['theme']['slider_theme']['duration'],
            'auto_animation' => $gallery_configs['theme']['slider_theme']['auto_animation'],
            'number_lines' => 1,
            'is_divi' => 0,
            'include_children' => 0,
            'crop_image' => 1,
            'hover_color' => '#000',
            'hover_opacity' => '0.4',
            'hover_title_position' => 'center_center',
            'hover_title_size' => 16,
            'hover_title_color' => '#fff',
            'hover_desc_position' => 'none',
            'hover_desc_size' => 14,
            'hover_desc_color' => '#fff',
            'is_lazy_load' => 1,
            'is_wishlist' => 0,
            'align' => 'none'
        );

        if (empty($gallery_type) || $gallery_type !== 'photographer') {
            foreach ($default_params as $param_key => $default_param) {
                if (!isset($attr[$param_key])) {
                    $attr[$param_key] = $default_params[$param_key];
                }
            }
        }

        if (isset($galleries[$attr['gallery_id']])) {
            $params = array_merge(
                $default_params,
                $galleries[$attr['gallery_id']],
                $attr
            );
        } else {
            $params = array_merge(
                $default_params,
                $attr
            );
        }

        $gid = $attr['gallery_id'];
        $params = $this->modifyOrderOptions($params);
        foreach ($params as $attr_key => $attr_value) {
            ${$attr_key} = $attr_value;
        }

        if (!empty($galleries[$attr['gallery_id']]) && !empty($galleries[$attr['gallery_id']]['tree_width'])) {
            $tree_width = $galleries[$attr['gallery_id']]['tree_width'];
        }

        if (!empty($galleries[$attr['gallery_id']]) && !empty($galleries[$attr['gallery_id']]['google_photos_album'])) {
            $google_photos_album = $galleries[$attr['gallery_id']]['google_photos_album'];
        }

        $id = intval($gallery_id);
        $lazy_load = ((isset($gallery_configs['progressive_loading']) && (int)$gallery_configs['progressive_loading'] === 0) || is_admin()) ? false : true;
        if (isset($is_lazy_load) && (int)$is_lazy_load === 0) {
            $lazy_load = false;
        }

        $gallery_exist = get_term($id, WPMF_GALLERY_ADDON_TAXO);
        if (is_wp_error($gallery_exist)) {
            return esc_html__('Gallery not exists!', 'wp-media-folder-gallery-addon');
        }

        $relationships = get_option('wpmfgrl_relationships');
        $social = $this->getSocialHtml();

        if ($display === '') {
            $display = 'default';
            if (!empty($galleries[$id]['theme'])) {
                $display = $galleries[$id]['theme'];
            }
        }

        // get params from options
        $allow_themes = array(
            'default',
            'masonry',
            'portfolio',
            'slider',
            'flowslide',
            'square_grid',
            'material',
            'custom_grid'
        );
        if (!in_array($display, $allow_themes)) {
            $display = 'default';
        }

        $caption_lightbox = wpmfGetOption('caption_lightbox_gallery');
        $hover_class = (isset($gallery_configs['hover_image']) && (int)$gallery_configs['hover_image'] === 0) ? ' hover_false' : ' hover_true';
        if (!empty($disable_overlay)) {
            $hover_class = 'hover_false';
        }
        $grid_styles = get_term_meta($gallery_id, 'wpmf_grid_styles', true);

        /* Query images */
        $tax_query = wpmfGalleryAddonGetTaxQuery($id, $params);
        $args = array(
            'posts_per_page' => -1,
            'post_status' => 'any',
            'post_type' => 'attachment',
            'post_mime_type' => wpmfGalleryAddonGetImageType(),
            'tax_query' => $tax_query,
            'wpmf_gallery' => 1
        );

        if ($display === 'custom_grid') {
            $wpmf_orderby = 'post__in';
            $args['orderby'] = 'post__in';
            $args['order'] = 'DESC';
        } else {
            if ($wpmf_orderby !== 'post__in') {
                $args['orderby'] = $wpmf_orderby;
                $args['order'] = $wpmf_order;
            }
        }

        /**
         * Filter to change query arguments to get images in the gallery
         *
         * @param array $args Default value
         * @param integer $id Gallery ID
         */
        $args = apply_filters('wpmf_gallery_query_args', $args, $id);
        $query = new WP_Query($args);
        $_attachments = $query->get_posts();
        if ($wpmf_orderby === 'post__in') {
            $attachments = array();
        } else {
            $attachments = $_attachments;
        }
        $tags = array();
        foreach ($_attachments as &$val) {
            if ($wpmf_orderby === 'post__in') {
                $order = get_post_meta((int)$val->ID, 'wpmf_gallery_' . $gallery_id . '_order', true);
                $val->order = (int)$order;
                $attachments[] = $val;
            }
            //get tags filter
            $tags_query = wp_get_post_terms($val->ID, 'wpmf_tag', array('fields' => 'names'));
            if (!empty($tags_query)) {
                foreach ($tags_query as $tag_name) {
                    $tag_name = strtolower(trim($tag_name));
                    if (!empty($tag_name)) {
                        $tags[] = $tag_name;
                    }
                }
            }
        }
        if ($wpmf_orderby === 'post__in') {
            usort($attachments, 'wpmfSortByOrder');
        }
        $tags = array_unique($tags);
        
        $count_attachments = count($attachments);
        // get google photos
        $attachment_photos = $this->getGooglePhotos($google_photos_album);
        if (!empty($attachment_photos)) {
            $count_attachments += count($attachment_photos);
            $attachments = array_merge($attachments, $attachment_photos);
        }

        if (empty($attachments) && (int)$display_tree === 0) {
            return '<div class="wpmf_gallery_wrap"><p style="margin: 0; text-align: center; padding: 5px; color: #f00">' . esc_html__('No media items found.', 'wp-media-folder-gallery-addon') . '</p></div>';
        }

        $class = array();
        $class[] = 'wpmf-gallery-addon-wrap';
        $class[] = 'gallery-link-' . $link;

        /* Create output html */
        if (!is_admin()) {
            $this->enqueue($display, $params);
        }

        $list_img_gallery_ids = array();
        foreach ($attachments as $value) {
            $list_img_gallery_ids[] = $value->ID;
        }

        natcasesort($tags);
        if ((int)$display_tag === 1 && count(array_unique($tags)) > 0) {
            $classtag = 'wpmf-tags';
        } else {
            $classtag = '';
        }
        $output = '';
        if (is_plugin_active('wp-media-folder-addon/wp-media-folder-addon.php')) {
            if (file_exists(WP_PLUGIN_DIR . '/wp-media-folder/class/class-wp-folder-option.php')) {
                require_once(WP_PLUGIN_DIR . '/wp-media-folder/class/class-wp-folder-option.php');

                $file = WP_PLUGIN_DIR . '/wp-media-folder-gallery-addon/assets/css/download_gallery.css';

                // get custom setting single download file
                $media_download = wpmfGetOption('media_download');
                // custom css by settings
                $custom_css = '
                .wrap-download-all {
                    position: relative;
                    display: flex;
                    justify-content: right;
                }

                .wrap-download-all a{
                    background: ' . $media_download['bgdownloadlink'] . ' !important;
                    color: ' . $media_download['fontdownloadlink'] . ' !important;
                    border: '. $media_download['border_width'] .'px '. $media_download['border_type'] .' '. $media_download['border_color'] .' !important;
                    border-radius: '. $media_download['border_radius'] .'px !important;
                    box-shadow: none !important;
                    text-shadow: none !important;
                    transition: all 0.2s ease 0s !important;
                    display: inline-block !important;
                    margin: '. $media_download['margin_top'] .'px '. $media_download['margin_right'] .'px '. $media_download['margin_bottom'] .'px '. $media_download['margin_left'] .'px !important;
                    padding: 6px 12px;
                    text-decoration: none !important;
                    position: relative;
                    font-size: 14px !important;
                    cursor: pointer;
                }
                
                .wrap-download-all a:hover{
                    background: ' . $media_download['hvdownloadlink'] . ' !important;
                    box-shadow: 1px 1px 12px #ccc !important;
                    color: ' . $media_download['hoverfontcolor'] . ' !important;
                }
                ';
                file_put_contents($file, $custom_css);
            }
        }
        //download all images
        if (isset($attr['download_all']) && !empty($attr['download_all']) && $list_img_gallery_ids) {
            $output .= '<div class="wrap-download-all"><a data-gallery-id="' . $gid . '" data-image-ids="' . esc_attr(json_encode($list_img_gallery_ids)) . '">Download all</a></div>';
        }

        $output .= '<div class="wpmf_gallery_wrap wpmf_gallery_addon '. $align .' ' . $classtag . $hover_class . '" data-count-childs="' . count($attachments) . '" data-selector="' . $selector . '" data-top-gallery-settings="' . esc_attr(json_encode($params)) . '" data-id="' . $id . '" style="visibility: hidden">';
        if (isset($display_tree) && (int)$display_tree === 1) {
            // render tree html in divi builder
            $tree_html = $this->renderTree($id);
            $tree_width = (int)$tree_width;
            if ((int)$tree_width === 0) {
                $tree_width = 250;
            }
            $right_width = 'calc(100% - ' . $tree_width . 'px)';

            $icon_search = '<svg class="search_gallery_btn" xmlns="http://www.w3.org/2000/svg" height="24px" viewBox="0 0 24 24" width="24px" fill="#656565"><path d="M0 0h24v24H0V0z" fill="none"/><path d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z"/></svg>';
            $search_html = '<form action="#" class="wpmf_search_galleries_form"> ' . $icon_search . ' <input type="text" class="wpmf_search_galleries" placeholder="' . esc_html__('Filter galleries...', 'wp-media-folder-gallery-addon') . '" size="1"> </form>';
            $search_html .= '<div class="search_no_result_wrap">
<svg width="70" height="70" viewBox="0 0 70 70" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M25.1037 14.5194C22.2246 17.3996 20.3095 21.1018 19.6223 25.116C18.9351 29.1301 19.5097 33.2585 21.2669 36.9325C22.5392 39.5839 24.3918 41.915 26.6875 43.7531C26.383 45.1912 26.2363 46.6582 26.25 48.1281V48.8719C25.55 48.3906 24.85 47.9094 24.1938 47.3844L7.65625 63.4406L4.375 60.5531L21 44.4094C18.4207 41.4927 16.5876 37.9938 15.6582 34.2128C14.7287 30.4318 14.7307 26.4818 15.6638 22.7017C16.597 18.9216 18.4335 15.4245 21.0157 12.5104C23.5979 9.59633 26.8487 7.35238 30.489 5.97118C34.1294 4.58998 38.0505 4.11277 41.9158 4.58053C45.7812 5.04829 49.4753 6.44704 52.681 8.65671C55.8868 10.8664 58.5085 13.821 60.3211 17.2669C62.1336 20.7128 63.0829 24.5471 63.0875 28.4406C63.0875 29.6131 63 30.7812 62.825 31.9406C61.5687 30.7995 60.1894 29.8017 58.7125 28.9656V28.4406C58.7125 24.5468 57.5579 20.7404 55.3946 17.5027C53.2313 14.2651 50.1565 11.7417 46.5591 10.2516C42.9617 8.76145 39.0031 8.37157 35.1841 9.13123C31.3651 9.89089 27.8571 11.766 25.1037 14.5194V14.5194ZM38.4037 33.5769C40.3144 32.2859 42.4612 31.3853 44.721 30.9267C46.9808 30.4681 49.309 30.4607 51.5717 30.9047C53.8344 31.3488 55.987 32.2357 57.9058 33.5144C59.8246 34.7931 61.4718 36.4384 62.7528 38.3557C64.0337 40.2731 64.9231 42.4247 65.3698 44.6868C65.8165 46.949 65.8117 49.2772 65.3558 51.5375C64.8998 53.7978 64.0017 55.9458 62.7129 57.8579C61.4242 59.77 59.7703 61.4085 57.8463 62.6794C53.9868 65.2286 49.275 66.1462 44.7409 65.2316C40.2069 64.317 36.2193 61.6446 33.6499 57.7985C31.0804 53.9524 30.1381 49.2456 31.0289 44.7068C31.9197 40.168 34.5712 36.1664 38.4037 33.5769V33.5769ZM38.8413 57.4075C40.0603 58.6269 41.5076 59.5941 43.1005 60.254C44.6935 60.9138 46.4008 61.2533 48.125 61.2531C50.8508 61.261 53.5114 60.42 55.7375 58.8469L37.4063 40.5156C35.8331 42.7417 34.9921 45.4023 35 48.1281C35.0007 51.6088 36.384 54.9466 38.8456 57.4075H38.8413ZM40.5125 37.4137L58.8437 55.7406C60.4169 53.5145 61.2579 50.8539 61.25 48.1281C61.25 44.6471 59.8672 41.3087 57.4058 38.8473C54.9444 36.3859 51.606 35.0031 48.125 35.0031C45.3992 34.9952 42.7386 35.8362 40.5125 37.4094V37.4137Z" fill="black"/>
</svg>
<p>' . esc_html__('Sorry, no gallery found', 'wp-media-folder-gallery-addon') . '</p>
</div>';
            $tree_html = $search_html . $tree_html;
            $output .= '<div class="wpmf_gallery_tree '. (!empty($gallery_configs['navigation_covers']) ? 'wpmf_navigation_' . $gallery_configs['navigation_covers'] : 'wpmf_navigation_small') .'" data-id="' . $id . '" style="width: ' . esc_attr($tree_width) . 'px">' . $tree_html . '</div>';
            $output .= '<div class="wpmf_gallery_box" data-id="' . $id . '" data-theme="' . $display . '" style="width: ' . esc_attr($right_width) . '">';
        } else {
            $output .= '<div class="wpmf_gallery_box fullbox" data-id="' . $id . '" data-theme="' . $display . '">';
        }

        if ($display !== 'default' && $display !== 'material' && $display !== 'square_grid') {
            if (!empty($attachments)) {
                $output .= "<img class='loading_gallery' src='" . WPMF_GALLERY_ADDON_PLUGIN_URL . "/assets/images/Loading_icon.gif' />";
            }
        }

        if ((int)$display_tag === 1 && count(array_unique($tags)) > 0) {
            $output .= '<div class="wpmf-gridblock-filters">';
            $output .= '<ul class="tabs gridblock-filter-categories">';
            $output .= '<li class="tab filter-all-control selected">';
            $output .= '<a data-filter="*">' . esc_html__('All', 'wp-media-folder-gallery-addon') . '</a>';
            $output .= '</li>';
            foreach (array_unique($tags) as $tag) {
                $output .= '<li class="tab filter-all-control">';
                $output .= '<a data-filter="' . $tag . '">' . strtoupper($tag) . '</a>';
                $output .= '</li>';
            }
            $output .= '</ul></div>';
        }

        $output .= '<div id="videoPreviewModal" style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.8); z-index:9999; justify-content:center; align-items:center;">
                        <div style="position:relative; max-width:80%; max-height:80%;">
                            <video id="previewVideoPlayer" controls style="width:100%; height:auto;">
                            <source src="" type="video/mp4">
                            </video>
                            <button id="closeModal" style="position:absolute; top:-20px; right:-20px; background:#fff; border:none; font-size:20px;">✖</button>
                        </div>
                    </div>';

        ob_start();

        if (empty($attachments) && (int)$sub_galleries_listing === 1 && (int)$display_tree === 1) {
            require(WPMF_GALLERY_ADDON_PLUGIN_DIR . 'frontend/themes-gallery/gallery-lists.php');
        }

        if (isset($display)) {
            if (file_exists(WPMF_GALLERY_ADDON_PLUGIN_DIR . 'frontend/themes-gallery/' . $display . '.php')) {
                require(WPMF_GALLERY_ADDON_PLUGIN_DIR . 'frontend/themes-gallery/' . $display . '.php');
            } else {
                require(WPMF_GALLERY_ADDON_PLUGIN_DIR . 'frontend/themes-gallery/default.php');
            }
        } else {
            require(WPMF_GALLERY_ADDON_PLUGIN_DIR . 'frontend/themes-gallery/default.php');
        }

        if (!empty($gallery_type) && $gallery_type === 'photographer') {
            wp_enqueue_style('wpmf-style-tippy');
            wp_enqueue_script('wpmf-tippy-core');
            wp_enqueue_script('wpmf-tippy');
            require(WPMF_GALLERY_ADDON_PLUGIN_DIR . 'frontend/themes-gallery/gallery_comments.php');
            require(WPMF_GALLERY_ADDON_PLUGIN_DIR . 'frontend/themes-gallery/download_popup.php');
            require(WPMF_GALLERY_ADDON_PLUGIN_DIR . 'frontend/themes-gallery/download_wishlist_popup.php');
        }
        $output .= ob_get_contents();
        ob_end_clean();
        $output .= '</div>';
        $output .= '</div>';

        if (!empty($gallery_type) && $gallery_type === 'photographer') {
            wp_enqueue_style(
                'wpmf-magnific-popup',
                WPMF_PLUGIN_URL . 'assets/css/display-gallery/magnific-popup.css',
                array(),
                '0.9.9'
            );

            wp_enqueue_script(
                'wpmf-magnific-popup',
                WPMF_PLUGIN_URL . 'assets/js/display-gallery/jquery.magnific-popup.min.js',
                array('jquery'),
                '0.9.9',
                true
            );
        }

        return $output;
    }

    /**
     * Register script, style
     *
     * @return void
     */
    public function galleryScripts()
    {
        $is_builder = (function_exists('fusion_is_preview_frame') && fusion_is_preview_frame()) || (function_exists('fusion_is_builder_frame') && fusion_is_builder_frame());
        if (!$is_builder) {
            wp_enqueue_script('jquery');
            wp_register_style(
                'wpmf-material-icon',
                WPMF_PLUGIN_URL . 'assets/css/google-material-icon.css',
                array(),
                WPMF_VERSION
            );

            $lightbox = get_option('wpmf_usegellery_lightbox');
            if (!empty($lightbox)) {
                wp_dequeue_style('media_boxes-fancybox');
                wp_dequeue_script('media_boxes-fancybox-js');
                wp_register_script(
                    'wpmf-google-photo-fancybox-script',
                    WPMF_GALLERY_ADDON_PLUGIN_URL . 'assets/js/fancybox/jquery.fancybox.min.js',
                    array('jquery'),
                    WPMF_VERSION
                );

                wp_register_style(
                    'wpmf-google-photo-fancybox-style',
                    WPMF_GALLERY_ADDON_PLUGIN_URL . 'assets/js/fancybox/jquery.fancybox.min.css',
                    array(),
                    WPMF_VERSION
                );
            }

            wp_register_script(
                'wpmf-autobrower',
                WPMF_GALLERY_ADDON_PLUGIN_URL . 'assets/js/jquery.esn.autobrowse.js',
                array('jquery'),
                WPMF_GALLERY_ADDON_VERSION,
                true
            );

            wp_register_script(
                'wordpresscanvas-imagesloaded',
                WPMF_PLUGIN_URL . 'assets/js/display-gallery/imagesloaded.pkgd.min.js',
                array(),
                '3.1.5',
                true
            );

            wp_register_style(
                'wpmf-justified-style',
                WPMF_GALLERY_ADDON_PLUGIN_URL . 'assets/js/justified-gallery/justifiedGallery.min.css',
                array(),
                WPMF_GALLERY_ADDON_VERSION
            );

            wp_register_script(
                'wpmf-justified-script',
                WPMF_GALLERY_ADDON_PLUGIN_URL . 'assets/js/justified-gallery/jquery.justifiedGallery.min.js',
                array('jquery'),
                WPMF_GALLERY_ADDON_VERSION,
                true
            );

            wp_register_script('wpmfisotope', WPMF_GALLERY_ADDON_PLUGIN_URL . 'assets/js/isotope.pkgd.js', array('jquery'), WPMF_GALLERY_ADDON_VERSION, true);
            wp_register_script('wpmfpackery', WPMF_GALLERY_ADDON_PLUGIN_URL . 'assets/packery/packery.pkgd.min.js', array('jquery'), WPMF_GALLERY_ADDON_VERSION, true);
            wp_register_style(
                'wpmf-slick-style',
                WPMF_PLUGIN_URL . 'assets/js/slick/slick.css',
                array(),
                WPMF_VERSION
            );

            wp_register_style(
                'wpmf-slick-theme-style',
                WPMF_PLUGIN_URL . 'assets/js/slick/slick-theme.css',
                array(),
                WPMF_VERSION
            );

            wp_register_script(
                'wpmf-slick-script',
                WPMF_PLUGIN_URL . 'assets/js/slick/slick.min.js',
                array('jquery'),
                WPMF_VERSION,
                true
            );

            wp_register_style(
                'wpmf-gallery-style',
                WPMF_PLUGIN_URL . 'assets/css/display-gallery/style-display-gallery.css',
                array(),
                WPMF_VERSION
            );

            wp_register_script(
                'wpmf-flipster-js',
                WPMF_GALLERY_ADDON_PLUGIN_URL . 'assets/js/jquery.flipster.js',
                array('jquery'),
                WPMF_GALLERY_ADDON_VERSION,
                true
            );

            wp_register_style(
                'wpmf-flipster-css',
                WPMF_GALLERY_ADDON_PLUGIN_URL . 'assets/css/jquery.flipster.css',
                array(),
                WPMF_GALLERY_ADDON_VERSION
            );

            wp_register_style(
                'wpmf-style-tippy',
                WPMF_PLUGIN_URL . 'assets/js/tippy/tippy.css',
                array(),
                WPMF_VERSION
            );

            wp_register_script(
                'wpmf-tippy-core',
                WPMF_PLUGIN_URL . 'assets/js/tippy/tippy-core.js',
                array('jquery'),
                WPMF_VERSION
            );

            wp_register_script(
                'wpmf-tippy',
                WPMF_PLUGIN_URL . 'assets/js/tippy/tippy.js',
                array('jquery'),
                WPMF_VERSION
            );

            wp_register_script(
                'wpmf-gallery-js',
                WPMF_GALLERY_ADDON_PLUGIN_URL . 'assets/js/gallery.js',
                array('jquery'),
                WPMF_GALLERY_ADDON_VERSION,
                true
            );

            wp_register_script(
                'wpmf-gallery-tree-js',
                WPMF_GALLERY_ADDON_PLUGIN_URL . 'assets/js/gallery_navigation_front.js',
                array('jquery'),
                WPMF_GALLERY_ADDON_VERSION
            );

            wp_register_style(
                'wpmf-gallery-css',
                WPMF_GALLERY_ADDON_PLUGIN_URL . 'assets/css/gallery.css',
                array(),
                WPMF_GALLERY_ADDON_VERSION
            );

            wp_register_style(
                'wpmf-gallery-download-css',
                WPMF_GALLERY_ADDON_PLUGIN_URL . 'assets/css/download_gallery.css',
                array(),
                WPMF_GALLERY_ADDON_VERSION
            );

            wp_localize_script('wpmf-gallery-js', 'wpmfgallery', $this->localizeScript());
        }
    }

    /**
     * Enqueue script styles by editor
     *
     * @param string $editor Editor name
     *
     * @return void
     */
    public function enqueueScript($editor = '')
    {
        if ($editor === 'divi') {
            wp_enqueue_style('wpmf-material-icon');
            wp_enqueue_style('wpmf-slick-style');
            wp_enqueue_style('wpmf-slick-theme-style');
            wp_enqueue_style('wpmf-justified-style');
            wp_enqueue_style('wpmf-gallery-style');
            wp_enqueue_style('wpmf-flipster-css');
            wp_enqueue_style('wpmf-gallery-css');
            wp_enqueue_style('wpmf-gallery-download-css');
            wp_enqueue_script('wordpresscanvas-imagesloaded');
            wp_enqueue_script('wpmf-slick-script');
            wp_enqueue_script('wpmf-justified-script');
            wp_enqueue_script('wpmf-flipster-js');
            wp_enqueue_script('wpmfisotope');
            wp_enqueue_script('wpmfpackery');
        }
    }

    /**
     * Load scripts and styles
     *
     * @param string $display Theme name
     * @param string $params  Gallery params
     *
     * @return void
     */
    public function enqueue($display, $params)
    {
        $settings = get_option('wpmf_gallery_settings');
        wp_enqueue_script('wpmf-google-photo-fancybox-script');
        wp_enqueue_style('wpmf-google-photo-fancybox-style');
        wp_enqueue_script('wordpresscanvas-imagesloaded');
        if (in_array($display, array('masonry', 'portfolio', 'square_grid')) || (int)$params['display_tree'] === 1) {
            if ($params['layout'] === 'vertical') {
                wp_enqueue_script('jquery-masonry');
            } else {
                if ($display === 'masonry' || $display === 'square_grid') {
                    wp_enqueue_style('wpmf-justified-style');
                    wp_enqueue_script('wpmf-justified-script');
                }
            }
        }

        if ($display === 'custom_grid') {
            wp_enqueue_script('wpmfisotope');
            wp_enqueue_script('wpmfpackery');
        }

        if (!isset($settings['progressive_loading']) || (int) $settings['progressive_loading'] === 1) {
            wp_enqueue_script('wpmf-autobrower');
        }

        if ($display === 'slider' || (int) $params['display_tree'] === 1) {
            wp_enqueue_style('wpmf-slick-style');
            wp_enqueue_style('wpmf-slick-theme-style');
            wp_enqueue_script('wpmf-slick-script');
        }

        wp_enqueue_style('wpmf-gallery-style');

        if ($display === 'flowslide' || (int) $params['display_tree'] === 1) {
            wp_enqueue_script('wpmf-flipster-js');
            wp_enqueue_style('wpmf-flipster-css');
        }

        wp_enqueue_script('wpmf-gallery-js');
        wp_enqueue_script('wpmf-gallery-tree-js');
        wp_enqueue_style('wpmf-gallery-css');
        wp_enqueue_style('wpmf-gallery-download-css');
    }

    /**
     * Render folders tree
     *
     * @param string $folder_id Folder ID
     *
     * @return string
     */
    public function renderTree($folder_id)
    {
        $gallery = get_term((int)$folder_id, WPMF_GALLERY_ADDON_TAXO);
        $feature_image_id = get_term_meta($folder_id, 'wpmf_gallery_feature_image', true);
        $feature_image = '';
        if (!empty($feature_image_id)) {
            $feature_image = wp_get_attachment_image_url($feature_image_id, 'thumbnail');
        }
        $feature_image = ($feature_image) ? $feature_image : WPMF_GALLERY_ADDON_PLUGIN_URL .'assets/images/image-gallery-icon.png';
        $sub_html = $this->renderFoldersTree($gallery->term_id, 28);
        $html = '<ul>';
        $html .= '<li class="open selected" data-id="'. esc_attr($folder_id) .'">';
        $html .= '<div class="wpmf-gallery-tree-item" data-id="'. esc_attr($folder_id) .'">';
        $html .= '<div class="wpmf-gallery-item-inside">';
        if ($sub_html !== '') {
            $html .= '<a data-id="'. esc_attr($folder_id) .'" class="wpmf-gallery-toggle-icon"><i class="tree_arrow_right_icon wpmf-gallery-arrow"></i></a>';
        } else {
            $html .= '<a data-id="'. esc_attr($folder_id) .'" class="wpmf-gallery-toggle-icon" style="visibility: hidden"><i class="tree_arrow_right_icon wpmf-gallery-arrow"></i></a>';
        }

        $html .= '<a class="wpmf-gallery-text-item" data-id="'. esc_attr($folder_id) .'">';
        $html .= '<img class="wpmf-gallery-thumbnail-icon" src="'. esc_url($feature_image) .'">';
        $html .= '<span class="wpmf-gallery-item-title">'. esc_html($gallery->name) .'</span>';
        $html .= '</a>';
        $html .= '</div>';
        $html .= '</div>';
        $html .= $sub_html;
        $html .= '</li>';
        $html .= '</ul>';
        return $html;
    }

    /**
     * Render folders tree
     *
     * @param integer $parent  Parent
     * @param integer $padding Padding
     *
     * @return string
     */
    public function renderFoldersTree($parent = 0, $padding = 26)
    {
        $args = array(
            'hide_empty'                   => false,
            'taxonomy'                     => WPMF_GALLERY_ADDON_TAXO,
            'pll_get_terms_not_translated' => 1,
            'parent' => $parent
        );

        $galleries            = get_categories($args);
        foreach ($galleries as $key => $object) {
            $order = get_term_meta($object->term_id, 'wpmf_order', true);
            if (empty($order)) {
                $order = 0;
            }
            $object->order = $order;
        }
        usort($galleries, 'wpmfGalleryReorder');
        $html = '';
        if (!empty($galleries)) {
            $html .= '<ul>';
            foreach ($galleries as $gallery) {
                $feature_image_id = get_term_meta($gallery->term_id, 'wpmf_gallery_feature_image', true);
                $feature_image = '';
                if (!empty($feature_image_id)) {
                    $feature_image = wp_get_attachment_image_url($feature_image_id, 'thumbnail');
                }
                $feature_image = ($feature_image) ? $feature_image : WPMF_GALLERY_ADDON_PLUGIN_URL .'assets/images/image-gallery-icon.png';

                $html .= '<li class="closed" data-id="'. esc_attr($gallery->term_id) .'">';
                $sub_html = $this->renderFoldersTree($gallery->term_id, (int)$padding + 26);
                $html .= '<div class="wpmf-gallery-tree-item" data-id="'. esc_attr($gallery->term_id) .'">';
                $html .= '<div class="wpmf-gallery-item-inside" style="padding-left: '. $padding .'px">';
                if ($sub_html !== '') {
                    $html .= '<a data-id="'. esc_attr($gallery->term_id) .'" class="wpmf-gallery-toggle-icon"><i class="tree_arrow_right_icon wpmf-gallery-arrow"></i></a>';
                } else {
                    $html .= '<a data-id="'. esc_attr($gallery->term_id) .'" class="wpmf-gallery-toggle-icon" style="visibility: hidden"><i class="tree_arrow_right_icon wpmf-gallery-arrow"></i></a>';
                }
                $html .= '<a class="wpmf-gallery-text-item" data-id="'. esc_attr($gallery->term_id) .'">';
                $html .= '<img class="wpmf-gallery-thumbnail-icon" src="'. esc_url($feature_image) .'">';
                $html .= '<span class="wpmf-gallery-item-title">'. esc_html($gallery->name) .'</span>';
                $html .= '</a>';
                $html .= '</div>';
                $html .= '</div>';
                $html .= $sub_html;
                $html .= '</li>';
            }
            $html .= '</ul>';
        }

        return $html;
    }

    /**
     * Localize a script.
     * Works only if the script has already been added.
     *
     * @return array
     */
    public function localizeScript()
    {
        $option_current_theme = get_option('current_theme');
        $gallery_configs      = get_option('wpmf_gallery_settings');

        if (isset($gallery_configs['progressive_loading']) && (int) $gallery_configs['progressive_loading'] === 0) {
            $progressive_loading = 0;
        } else {
            $progressive_loading = 1;
        }

        return array(
            'wpmf_current_theme'  => $option_current_theme,
            'gallery_configs'     => $gallery_configs,
            'progressive_loading' => (int) $progressive_loading,
            'wpmf_gallery_nonce'  => wp_create_nonce('wpmf_gallery_nonce'),
            'ajaxurl'             => admin_url('admin-ajax.php'),
            'plugin_url_image' => WPMF_GALLERY_ADDON_PLUGIN_URL . 'assets/images/',
            'wishlist_msg_error' => esc_html__('Sorry, but you need to add images to wishlist first', 'wp-media-folder-gallery-addon')
        );
    }

    /**
     * Generate html attachment link
     *
     * @param integer $id        Id of image
     * @param string  $size      Size of image
     * @param boolean $permalink Permalink of image
     *
     * @return mixed|string|boolean
     */
    public function galleryGetAttachmentLink(
        $id = 0,
        $size = 'thumbnail',
        $permalink = false
    ) {
        $id    = intval($id);
        $_post = get_post($id);
        $url   = wp_get_attachment_url($_post->ID);
        if (empty($_post) || ('attachment' !== $_post->post_type) || !$url) {
            return false;
        }

        if ($size && 'none' !== $size) {
            $thumb_id = wpmfGalleryGetVideoThumbID($id);
            $alt = trim(strip_tags(get_post_meta($id, '_wp_attachment_image_alt', true)));
            if ($alt === '') {
                $alt = $_post->post_title;
            }
            $link_text = wp_get_attachment_image($thumb_id, $size, false, array('data-type' => 'wpmfgalleryimg', 'id' => 'wpmfgalleryimg', 'alt' => $alt));
        } else {
            $link_text = '';
        }

        if (trim($link_text) === '') {
            $link_text = $_post->post_title;
        }

        return apply_filters(
            'wp_get_attachment_link',
            $link_text,
            $thumb_id,
            $size,
            $permalink,
            false,
            false
        );
    }

    /**
     * Modify order options
     *
     * @param array $settings Gallery settings
     *
     * @return mixed
     */
    public function modifyOrderOptions($settings)
    {
        if (isset($settings['orderby'])) {
            $settings['wpmf_orderby'] = $settings['orderby'];
        }
        if (isset($settings['order'])) {
            $settings['wpmf_order'] = $settings['order'];
        }

        return $settings;
    }

    /**
     * Get gallery items
     *
     * @return void
     */
    public function getGalleryItem()
    {
        // phpcs:disable WordPress.Security.NonceVerification.Recommended -- No action, nonce is not required
        $settings = json_decode(stripcslashes($_REQUEST['settings']), true);
        // verify orderby option
        $settings = $this->modifyOrderOptions($settings);
        $gallery_configs     = get_option('wpmf_gallery_settings');
        $lazy_load = (isset($gallery_configs['progressive_loading']) && (int) $gallery_configs['progressive_loading'] === 0) ? false : true;
        $tags = isset($_REQUEST['tags']) ? $_REQUEST['tags'] : '*';
        $id = $_REQUEST['gallery_id'];
        $social = $this->getSocialHtml();
        foreach ($settings as $key => $setting) {
            ${$key} = $setting;
        }

        // get google photo album id
        $galleries = get_option('wpmf_galleries');
        if (!empty($galleries[$id]) && !empty($galleries[$id]['google_photos_album'])) {
            $google_photos_album = $galleries[$id]['google_photos_album'];
        }

        $theme = $_REQUEST['theme'];
        $offset = isset($_REQUEST['offset']) ? (int)$_REQUEST['offset'] : 0;

        // get google photos
        $attachment_photos = $this->getGooglePhotos($google_photos_album);
        // phpcs:enable
        $tax_query = wpmfGalleryAddonGetTaxQuery($id, $settings);
        $args = array(
            'posts_per_page' => (!empty($attachment_photos)) ? -1 : 8,
            'post_status'    => 'any',
            'post_type' => 'attachment',
            'post_mime_type' => wpmfGalleryAddonGetImageType(),
            'tax_query'      => $tax_query
        );
        if ($tags !== '*') {
            // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- No action, nonce is not required
            $list_loaded_ids = isset($_REQUEST['loaded_ids']) ? $_REQUEST['loaded_ids'] : '';
            $args_tag = array_merge($args, array('posts_per_page' => -1));
            $query_tag = new WP_Query($args_tag);
            $attachments_tags = $query_tag->get_posts();
            $_attachment_tags = array();

            if ($attachments_tags) {
                $attachment_ids = wp_list_pluck($attachments_tags, 'ID');
                $terms = wp_get_object_terms($attachment_ids, 'wpmf_tag', array('fields' => 'all_with_object_id'));

                $attachment_terms = array();
                foreach ($terms as $term) {
                    $attachment_terms[$term->object_id][] = strtolower(trim($term->name));
                }

                foreach ($attachments_tags as $val) {
                    if (isset($attachment_terms[$val->ID]) && in_array(esc_html($tags), $attachment_terms[$val->ID])) {
                        $_attachment_tags[] = $val->ID;
                    }
                }
            }
            $list_ids_loaded = $list_loaded_ids ? explode(',', $list_loaded_ids) : array();
            $gallery_ids = array_diff($_attachment_tags, $list_ids_loaded);
            $gallery_ids = implode(',', $gallery_ids);
        } else {
            // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- No action, nonce is not required
            $gallery_ids = $_REQUEST['gallery_ids'] ?? false;
        }

        if ($gallery_ids  && empty($attachment_photos)) {
            $post_ids = array_slice(explode(',', $gallery_ids) ?? [], 0, $args['posts_per_page']);
            $args['post__in'] = $post_ids;
            $args['orderby'] = 'post__in';
        } else {
            // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- No action, nonce is not required
            if (isset($_REQUEST['loaded_ids']) && empty($attachment_photos)) {
                // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- No action, nonce is not required
                $args['post__not_in'] = explode(',', $_REQUEST['loaded_ids']);
            }
        }

        if ($wpmf_orderby !== 'post__in') {
            $args['orderby'] = $wpmf_orderby;
            $args['order']   = $wpmf_order;
        }

        $query        = new WP_Query($args);
        $_attachments = $query->get_posts();
        $attachments  = array();
        foreach ($_attachments as &$val) {
            $order = get_post_meta((int)$val->ID, 'wpmf_gallery_order', true);
            $val->order = (int) $order;
            if ($tags !== '*') {
                $i_trim_tags = array();
                $i_tags = wp_get_post_terms($val->ID, 'wpmf_tag');
                if ($i_tags) {
                    $i_tags = array_column($i_tags, 'name');
                    foreach ($i_tags as $i_tag) {
                        $i_trim_tags[] = strtolower(trim($i_tag));
                    }
                }
                if (in_array(esc_html($tags), $i_trim_tags)) {
                    $attachments[] = $val;
                }
            } else {
                $attachments[] = $val;
            }
        }

        if ($wpmf_orderby === 'post__in') {
            usort($attachments, 'wpmfSortByOrder');
        }

        if (!empty($attachment_photos)) {
            $attachments = array_merge($attachments, $attachment_photos);
        }

        if (empty($attachments)) {
            wp_send_json(array('status' => false));
        }

        $items = array();
        foreach ($attachments as $i => $attachment) {
            if (!empty($attachment_photos)) {
                if ($i < $offset || $i >= ($offset + 8)) {
                    continue;
                }
                $index = $i;
            } else {
                // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- No action, nonce is not required
                $index = $i + count(explode(',', $_REQUEST['loaded_ids']));
            }

            $items[] = $this->getAttachmentThemeHtml($theme, $attachment, $social, $index, $settings, $id);
        }

        if (!empty($items)) {
            wp_send_json(array('status' => true, 'items' => $items));
        } else {
            wp_send_json(array('status' => false));
        }
    }

    /**
     * Get vimeo video ID from URL
     *
     * @param string $url URl of video
     *
     * @return mixed|string
     */
    public function getVimeoVideoIdFromUrl($url = '')
    {
        $regs = array();
        $id   = '';
        $vimeo_pattern = '%^https?:\/\/(?:www\.|player\.)?vimeo.com\/(?:channels\/(?:\w+\/)?|groups\/([^\/]*)\/videos\/|album\/(\d+)\/video\/|video\/|)(\d+)(?:$|\/|\?)(?:[?]?.*)$%im';
        if (preg_match($vimeo_pattern, $url, $regs)) {
            $id = $regs[3];
        }

        return $id;
    }

    /**
     * Get lightbox items
     *
     * @param array   $attachments All Attachments
     * @param string  $targetsize  Lightbox size
     * @param integer $gallery_id  Gallery ID
     *
     * @return array
     */
    public function getLightboxItems($attachments, $targetsize, $gallery_id = 0)
    {
        $lightbox_items = array();
        $caption_lightbox = wpmfGetOption('caption_lightbox_gallery');
        $uploadpath = wp_upload_dir();
        foreach ($attachments as $attachment) {
            $post_title = (!empty($caption_lightbox) && $attachment->post_excerpt !== '') ? $attachment->post_excerpt : $attachment->post_title;

            $custom_link = get_post_meta($attachment->ID, _WPMF_GALLERY_PREFIX . 'custom_image_link', true);
            if ($custom_link &&
                strpos($custom_link, '.jpg') !== false || strpos($custom_link, '.jpeg') !== false || strpos($custom_link, '.png') !== false || strpos($custom_link, '.webp') !== false) {
                $url   = $custom_link;
                $type = 'image';
            } else {
                $lightboxUrls = $this->getLightboxUrl($attachment, $targetsize);
                $url = $lightboxUrls['url'];
                $type = $lightboxUrls['type'];
            }

            // get lightbox URL for photograper
            if (!empty($gallery_id)) {
                $meta = get_post_meta($attachment->ID, 'wpmf_photograper_sizes', true);
                $gallery_type = get_term_meta((int)$gallery_id, 'gallery_type', true);
                if (!empty($gallery_type) && $gallery_type === 'photographer') {
                    if (isset($meta[$targetsize])) {
                        $url = $uploadpath['baseurl'] . $meta[$targetsize];
                    } else {
                        $url = wp_get_attachment_url($attachment->ID);
                    }
                    $type = 'image';
                }
            }

            $lightbox_items[] = array(
                'id' => $attachment->ID,
                'src' => $url,
                'type' => $type,
                'caption' => htmlentities($post_title, ENT_COMPAT, 'UTF-8')
            );
        }

        return $lightbox_items;
    }

    /**
     * Get lightbox URL and type
     *
     * @param object $attachment Attachment
     * @param string $targetsize Lightbox size
     *
     * @return array
     */
    public function getLightboxUrl($attachment, $targetsize)
    {
        $type = 'image';
        if (!empty($attachment->type) && $attachment->type === 'google_photo') {
            $item_urls = $attachment->url . '=w' . $attachment->width . '-h' . $attachment->height;
        } else {
            $item_urls = wp_get_attachment_image_url($attachment->ID, $targetsize);
        }

        $remote_video = get_post_meta($attachment->ID, 'wpmf_remote_video_link', true);
        $url = (!empty($remote_video)) ? $remote_video : $item_urls;
        if ((!empty($remote_video)) && strpos($url, 'vimeo') !== false) {
            $vimeo_id = $this->getVimeoVideoIdFromUrl($url);
            $url = 'https://player.vimeo.com/video/' . $vimeo_id;
            $type = 'iframe';
        }

        if ((!empty($remote_video)) && (strpos($url, 'youtube') !== false || strpos($url, 'youtu.be') !== false)) {
            $parts = parse_url($url);
            if ($parts['host'] === 'youtu.be') {
                $youtube_id = trim($parts['path'], '/');
            } else {
                parse_str($parts['query'], $query);
                $youtube_id = $query['v'];
            }
            $type = 'iframe';
            $url = 'https://www.youtube.com/embed/' . $youtube_id;
        }

        if ((!empty($remote_video)) && (strpos($url, 'dailymotion') !== false)) {
            $type = 'iframe';
            $id = strtok(basename($url), '_');
            $url = 'https://dailymotion.com/embed/video/' . $id;
        }

        if (!empty($remote_video)) {
            if (strpos($url, '.mp4') !== false || strpos($url, '.mov') !== false || strpos($url, '.flv') !== false) {
                $type = 'video';
            }
        }

        if ((!empty($remote_video)) && (strpos($url, 'wistia') !== false)) {
            $type = 'iframe';
        }

        if ((!empty($remote_video)) && (strpos($url, 'facebook') !== false)) {
            $type = 'iframe';
            $url = 'https://www.facebook.com/plugins/video.php?height=314&href='. urlencode($url) .'&show_text=false&width=560';
        }

        if ((!empty($remote_video)) && (strpos($url, 'twitch') !== false)) {
            $type = 'iframe';
            $parts = parse_url($url);
            if (strpos($parts['path'], '/video') !== false) {
                $twitch_id = str_replace('/videos/', '', $parts['path']);
                $url = 'https://player.twitch.tv/?video='. $twitch_id .'&parent=' . $_SERVER['SERVER_NAME'];
            } else {
                $twitch_id = trim($parts['path'], '/');
                $url = 'https://player.twitch.tv/?channel='. $twitch_id .'&parent=' . $_SERVER['SERVER_NAME'];
            }
        }

        return array('type' => $type, 'url' => $url);
    }

    /**
     * Get attachment html by theme
     *
     * @param string  $theme      Theme
     * @param object  $attachment Attachment details
     * @param string  $social     Social html
     * @param integer $index      Index
     * @param integer $params     Gallery settings
     * @param integer $gid        Gallery ID
     *
     * @return string
     */
    public function getAttachmentThemeHtml($theme, $attachment, $social, $index = 0, $params = array(), $gid = 0)
    {
        $link = $params['link'];
        $size = $params['size'];
        $targetsize = $params['targetsize'];
        $item = '';
        $caption_lightbox = wpmfGetOption('caption_lightbox_gallery');
        $gallery_configs = get_option('wpmf_gallery_settings');
        $post_title = (!empty($caption_lightbox) && $attachment->post_excerpt !== '') ? $attachment->post_excerpt : $attachment->post_title;
        $img_tags = wp_get_post_terms($attachment->ID, 'wpmf_tag');
        if ($img_tags) {
            $img_tags = array_column($img_tags, 'name');
            $img_tags = implode(',', $img_tags);
        } else {
            $img_tags = '';
        }
        $custom_link = get_post_meta($attachment->ID, _WPMF_GALLERY_PREFIX . 'custom_image_link', true);
        $link_target = get_post_meta($attachment->ID, '_gallery_link_target', true);
        $gallery_type = get_term_meta((int)$gid, 'gallery_type', true);
        $uploadpath = wp_upload_dir();
        if (!empty($attachment->type) && $attachment->type === 'google_photo') {
            if ($link === 'post') {
                $link = 'none';
            }
            $image_output = '<img alt="'. esc_attr($attachment->post_title) .'" src="'. esc_url($attachment->url) .'">';
        } else {
            if (!empty($gallery_type) && $gallery_type === 'photographer') {
                $image_alt = get_post_meta($attachment->ID, '_wp_attachment_image_alt', true);
                $meta = get_post_meta($attachment->ID, 'wpmf_photograper_sizes', true);
                if (isset($meta[$size])) {
                    $image_url = $uploadpath['baseurl'] . $meta[$size];
                } else {
                    $image_url = wp_get_attachment_url($attachment->ID);
                }
                $image_output = '<img alt="'. esc_attr($image_alt) .'" src="'. esc_url($image_url) .'">';
            } else {
                $image_output = $this->galleryGetAttachmentLink($attachment->ID, $size, false);
            }
        }

        if (!$image_output) {
            return '';
        }
        $remote_video = get_post_meta($attachment->ID, 'wpmf_remote_video_link', true);
        if (strpos($attachment->post_mime_type, 'video/') !== false) {
            $video = true;
        } else {
            $video = false;
        }

        $video_class = (!empty($remote_video) || $video) ? 'isvideo' : '';
        $downloads = wpmfGalleryGetDownloadLink($attachment);
        $hovers = $this->renderHoverStyle($attachment, $params);
        $hover_color_style = $hovers['hover_color_style'];
        $hover_box = $hovers['hover_box'];
        $gallery_type = get_term_meta((int)$params['gallery_id'], 'gallery_type', true);
        switch ($theme) {
            case 'material':
                if ($custom_link && $custom_link !== '') {
                    if (strpos($custom_link, '.jpg') !== false || strpos($custom_link, '.jpeg') !== false || strpos($custom_link, '.png') !== false || strpos($custom_link, '.webp') !== false) {
                        $icon = '<a '. $hover_color_style .' data-type="'. ((!empty($remote_video) || $video) ? 'iframe' : 'image') .'"  class="wpmf_overlay '. $video_class .'">'. $hover_box .'</a>';
                    } else {
                        $icon = '<a '. $hover_color_style .' href="' . $custom_link . '" class="wpmf_overlay '. $video_class .'" target="' . $link_target . '">'. $hover_box .'</a>';
                    }

                    $icon .= $social;
                } else {
                    switch ($link) {
                        case 'none':
                            $icon = '<div '. $hover_color_style .' class="wpmf_overlay '. $video_class .'">'. $hover_box .'</div>';
                            $icon .= $social;
                            break;

                        case 'post':
                            $url = get_attachment_link($attachment->ID);
                            $icon = '<a '. $hover_color_style .' href="' . esc_url($url) . '" title="' . esc_attr($post_title) . '" class="wpmf_overlay '. $video_class .'" target="' . $link_target . '">'. $hover_box .'</a>';
                            $icon .= $social;
                            break;

                        default:
                            $lightboxUrls = $this->getLightboxUrl($attachment, $targetsize);
                            $url = $lightboxUrls['url'];
                            $icon = '<a '. $hover_color_style .' data-type="'. ((!empty($remote_video) || $video) ? 'iframe' : 'image') .'"  data-href="' . esc_url($url) . '" data-caption="' . esc_attr($post_title) . '"
class="wpmfgalleryaddonswipe wpmf_overlay '. $video_class .'">'. $hover_box .'</a>';
                            $icon .= $social;
                    }
                }

                $icon .= '<div class="gallery_icons_wrap">';
                if (isset($gallery_configs['download_item']) && (int)$gallery_configs['download_item'] === 1) {
                    $icon .= '<a href="'.esc_url($downloads['download_link']).'" '. (($downloads['type'] === 'local') ? 'download' : '') .' target="'. (($downloads['type'] === 'google_photo') ? '_blank' : '_self') .'" class="wpmf_gallery_download_icon"><span class="material-icons-outlined"> file_download </span></a>';
                }

                if (!empty($gallery_type) && $gallery_type === 'photographer') {
                    $icon .= '<a href="#" data-gallery_id="'. (int)$gid .'" data-attachment="'. (int)$attachment->ID .'" class="wpmf_gallery_add_to_list"><span class="material-icons-outlined"> add_photo_alternate </span></a>';
                }
                $icon .= '</div>';
                $icon .= '<a href="#" class="wpmf_gallery_show_comments"><span class="material-icons-outlined"> add_photo_alternate </span></a>';

                $noLightbox = $this->getLightboxClass($custom_link);
                $item = '<figure class="wpmf-gallery-item gallery-item '.$noLightbox.'" data-id="'. (int)$attachment->ID .'" data-index="'. esc_html($index) .'">';
                $item .= '<div class="wpmf-card image-over-card m-t-30">';

                $item .= '<div class="wpmf-card-image wpmf-gallery-icon">';
                $item .= wpmfRenderVideoIcon($attachment->ID);
                $item .= $icon;
                $item .= '<div class="square_thumbnail">';
                $item .= '<div class="img_centered">';
                $item .= $image_output;
                $item .= '</div>';
                $item .= '</div>';
                $item .= '</div>';


                $item .= '<div class="wpmf-card-body">';
                if (esc_html($attachment->post_excerpt) === '') {
                    $item .= '<figcaption class="wpmf-card-title text-center wpmf-gallery-caption">' . wptexturize($attachment->post_title) . '</figcaption>';
                } else {
                    $item .= '<figcaption class="wpmf-card-title text-center wpmf-gallery-caption">' . wptexturize($attachment->post_excerpt) . '</figcaption>';
                }
                $item .= '</div>';
                $item .= '</div>';
                $item .= '</figure>';
                break;

            case 'square_grid':
                if ($custom_link && $custom_link !== '') {
                    if (strpos($custom_link, '.jpg') !== false || strpos($custom_link, '.jpeg') !== false || strpos($custom_link, '.png') !== false || strpos($custom_link, '.webp') !== false) {
                        $icon = '<a '. $hover_color_style .' data-type="'. ((!empty($remote_video) || $video) ? 'iframe' : 'image') .'"  class="wpmf_overlay '. $video_class .'">'. $hover_box .'</a>';
                    } else {
                        $icon = '<a '. $hover_color_style .' href="' . $custom_link . '" class="wpmf_overlay '. $video_class .'" target="' . $link_target . '">'. $hover_box .'</a>';
                    }
                    $icon .= $social;
                } else {
                    switch ($link) {
                        case 'none':
                            $icon = '<div '. $hover_color_style .' class="wpmf_overlay '. $video_class .'">'. $hover_box .'</div>';
                            $icon .= $social;
                            break;

                        case 'post':
                            $url = get_attachment_link($attachment->ID);
                            $icon = '<a '. $hover_color_style .' href="' . esc_url($url) . '" title="' . esc_attr($post_title) . '" class="wpmf_overlay '. $video_class .'" target="' . $link_target . '">'. $hover_box .'</a>';
                            $icon .= $social;
                            break;

                        default:
                            $lightboxUrls = $this->getLightboxUrl($attachment, $targetsize);
                            $url = $lightboxUrls['url'];

                            $icon = '<a '. $hover_color_style .' data-type="'. ((!empty($remote_video) || $video) ? 'iframe' : 'image') .'"  data-href="' . esc_url($url) . '" data-caption="' . esc_attr($post_title) . '"
class="wpmfgalleryaddonswipe wpmf_gallery_lightbox wpmf_overlay '. $video_class .'">'. $hover_box .'</a>';
                            $icon .= $social;
                    }
                }

                $icon .= '<div class="gallery_icons_wrap">';
                if (isset($gallery_configs['download_item']) && (int)$gallery_configs['download_item'] === 1) {
                    $icon .= '<a href="'.esc_url($downloads['download_link']).'" '. (($downloads['type'] === 'local') ? 'download' : '') .' target="'. (($downloads['type'] === 'google_photo') ? '_blank' : '_self') .'" class="wpmf_gallery_download_icon"><span class="material-icons-outlined"> file_download </span></a>';
                }

                if (!empty($gallery_type) && $gallery_type === 'photographer') {
                    $icon .= '<a href="#" data-gallery_id="'. (int)$gid .'" data-attachment="'. (int)$attachment->ID .'" class="wpmf_gallery_add_to_list"><span class="material-icons-outlined"> add_photo_alternate </span></a>';
                }
                $icon .= '</div>';

                $noLightbox = $this->getLightboxClass($custom_link);
                $item = '<figure class="wpmf-gallery-item gallery-item '.$noLightbox.'" data-id="'. (int)$attachment->ID .'" data-index="'. esc_html($index) .'">';
                $item .= '<div class="wpmf-gallery-icon">';
                $item .= wpmfRenderVideoIcon($attachment->ID);
                $item .= $icon;
                $item .= '<div class="square_thumbnail">';
                $item .= '<div class="img_centered">';
                $item .= $image_output;
                $item .= '</div>';
                $item .= '</div>';
                $item .= '</div>';
                $item .= '</figure>';
                break;
            case 'masonry':
                $requests = get_term_meta($gid, 'wpmf_gallery_wishlist', true);
                if (empty($requests)) {
                    $requests = array();
                }

                if ($custom_link && $custom_link !== '') {
                    if (strpos($custom_link, '.jpg') !== false || strpos($custom_link, '.jpeg') !== false || strpos($custom_link, '.png') !== false || strpos($custom_link, '.webp') !== false) {
                        $icon = '<a '. $hover_color_style .' data-type="'. ((!empty($remote_video) || $video) ? 'iframe' : 'image') .'"  data-href="' . esc_url($custom_link) . '" data-caption="' . esc_attr($post_title) . '"
 class="wpmfgalleryaddonswipe wpmf_gallery_lightbox wpmf_overlay '. $video_class .'">'. $hover_box .'</a>';
                    } else {
                        $icon = '<a '. $hover_color_style .' href="' . $custom_link . '" class="wpmf_overlay '. $video_class .'" target="' . $link_target . '">'. $hover_box .'</a>';
                    }

                    $icon .= $social;
                } else {
                    switch ($link) {
                        case 'none':
                            $icon = '<div '. $hover_color_style .' class="wpmf_overlay '. $video_class .'">'. $hover_box .'</div>';
                            $icon .= $social;
                            break;

                        case 'post':
                            $url = get_attachment_link($attachment->ID);
                            $icon = '<a '. $hover_color_style .' href="' . esc_url($url) . '" title="' . esc_attr($post_title) . '" class="wpmf_overlay '. $video_class .'" target="' . $link_target . '">'. $hover_box .'</a>';
                            $icon .= $social;
                            break;

                        default:
                            if (!empty($gallery_type) && $gallery_type === 'photographer') {
                                if (isset($meta[$targetsize])) {
                                    $url = $uploadpath['baseurl'] . $meta[$targetsize];
                                } else {
                                    $url = wp_get_attachment_url($attachment->ID);
                                }
                            } else {
                                $lightboxUrls = $this->getLightboxUrl($attachment, $targetsize);
                                $url = $lightboxUrls['url'];
                            }

                            $icon = '<a '. $hover_color_style .' data-type="'. ((!empty($remote_video) || $video) ? 'iframe' : 'image') .'"  data-href="' . esc_url($url) . '" data-caption="' . esc_attr($post_title) . '"

class="wpmfgalleryaddonswipe wpmf_gallery_lightbox wpmf_overlay '. $video_class .'">'. $hover_box .'</a>';
                            $icon .= $social;
                    }
                }

                $icon .= '<div class="gallery_icons_wrap">';
                if (!empty($gallery_type) && $gallery_type === 'photographer') {
                    $icon .= '<a href="#" data-gallery_id="'. (int)$gid .'" data-attachment="'. (int)$attachment->ID .'" class="wpmf_gallery_download_icon wpmf_photograper_open_download_lists"><span class="material-icons-outlined"> file_download </span></a>';
                } else {
                    if (isset($gallery_configs['download_item']) && (int)$gallery_configs['download_item'] === 1) {
                        $icon .= '<a href="'.esc_url($downloads['download_link']).'" '. (($downloads['type'] === 'local') ? 'download' : '') .' target="'. (($downloads['type'] === 'google_photo') ? '_blank' : '_self') .'" class="wpmf_gallery_download_icon"><span class="material-icons-outlined"> file_download </span></a>';
                    }
                }

                if (!empty($gallery_type) && $gallery_type === 'photographer') {
                    $icon .= '<a href="#" data-gallery_id="'. (int)$gid .'" data-attachment="'. (int)$attachment->ID .'" class="wpmf_gallery_add_to_list '. ((in_array($attachment->ID, $requests)) ? 'selected' : '') .'"><span class="material-icons-outlined"> add_photo_alternate </span></a>';
                }
                $icon .= '</div>';

                $noLightbox = $this->getLightboxClass($custom_link);
                $item = '<div class="wpmf-gallery-item '.$noLightbox.'" data-id="'. (int)$attachment->ID .'" data-tags="' . $img_tags . '" data-index="'. esc_html($index) .'">';
                $item .= '<div class="wpmf-gallery-icon">';
                $item .= wpmfRenderVideoIcon($attachment->ID);
                $item .= $icon . ' ' . $image_output;
                $item .= '</div>';
                $item .= '</div>';
                break;

            case 'custom_grid':
                if ($custom_link && $custom_link !== '') {
                    if (strpos($custom_link, '.jpg') !== false || strpos($custom_link, '.jpeg') !== false || strpos($custom_link, '.png') !== false || strpos($custom_link, '.webp') !== false) {
                        $icon = '<a '. $hover_color_style .' data-type="'. ((!empty($remote_video) || $video) ? 'iframe' : 'image') .'"  class="wpmf_overlay '. $video_class .'" target="' . $link_target . '">'. $hover_box .'</a>';
                    } else {
                        $icon = '<a '. $hover_color_style .' href="' . $custom_link . '" class="wpmf_overlay '. $video_class .'" target="' . $link_target . '">'. $hover_box .'</a>';
                    }
                    $icon .= $social;
                } else {
                    switch ($link) {
                        case 'none':
                            $icon = '<div '. $hover_color_style .' class="wpmf_overlay '. $video_class .'">'. $hover_box .'</div>';
                            $icon .= $social;
                            break;

                        case 'post':
                            $url = get_attachment_link($attachment->ID);
                            $icon = '<a '. $hover_color_style .' href="' . esc_url($url) . '" title="' . esc_attr($post_title) . '" class="wpmf_overlay '. $video_class .'" target="' . $link_target . '">'. $hover_box .'</a>';
                            $icon .= $social;
                            break;

                        default:
                            $lightboxUrls = $this->getLightboxUrl($attachment, $targetsize);
                            $url = $lightboxUrls['url'];
                            $icon = '<a '. $hover_color_style .' data-type="'. ((!empty($remote_video) || $video) ? 'iframe' : 'image') .'"  data-href="' . esc_url($url) . '" data-caption="' . esc_attr($post_title) . '"
class="wpmfgalleryaddonswipe wpmf_gallery_lightbox wpmf_overlay '. $video_class .'">'. $hover_box .'</a>';
                            $icon .= $social;
                    }
                }

                $icon .= '<div class="gallery_icons_wrap">';
                if (isset($gallery_configs['download_item']) && (int)$gallery_configs['download_item'] === 1) {
                    $icon .= '<a href="'.esc_url($downloads['download_link']).'" '. (($downloads['type'] === 'local') ? 'download' : '') .' target="'. (($downloads['type'] === 'google_photo') ? '_blank' : '_self') .'" class="wpmf_gallery_download_icon"><span class="material-icons-outlined"> file_download </span></a>';
                }

                if (!empty($gallery_type) && $gallery_type === 'photographer') {
                    $icon .= '<a href="#" data-gallery_id="'. (int)$gid .'" data-attachment="'. (int)$attachment->ID .'" class="wpmf_gallery_add_to_list"><span class="material-icons-outlined"> add_photo_alternate </span></a>';
                }
                $icon .= '</div>';

                $noLightbox = $this->getLightboxClass($custom_link);
                $item = '<div class="wpmf-gallery-item grid-item '.$noLightbox.'" data-id="'. (int)$attachment->ID .'" data-tags="' . $img_tags . '" data-index="'. esc_html($index) .'">';
                $item .= '<div class="wpmf-gallery-icon">';
                $item .= wpmfRenderVideoIcon($attachment->ID);
                $item .= $icon . ' ' . $image_output;
                $item .= '</div>';
                $item .= '</div>';
                break;
            case 'default':
                if ($custom_link && $custom_link !== '') {
                    if (strpos($custom_link, '.jpg') !== false || strpos($custom_link, '.jpeg') !== false || strpos($custom_link, '.png') !== false || strpos($custom_link, '.webp') !== false) {
                        $icon = '<a '. $hover_color_style .' data-type="'. ((!empty($remote_video) || $video) ? 'iframe' : 'image') .'" class="wpmf_overlay '. $video_class .'" data-href="' . esc_url($custom_link) .'" target="' . $link_target . '">'. $hover_box .'</a>';
                    } else {
                        $icon = '<a '. $hover_color_style .' href="' . $custom_link . '" class="wpmf_overlay '. $video_class .'" target="' . $link_target . '">'. $hover_box .'</a>';
                    }
                    $icon .= $social;
                } else {
                    switch ($link) {
                        case 'none':
                            $icon = '<div '. $hover_color_style .' class="wpmf_overlay '. $video_class .'">'. $hover_box .'</div>';
                            $icon .= $social;
                            break;

                        case 'post':
                            $url = get_attachment_link($attachment->ID);
                            $icon = '<a '. $hover_color_style .' href="' . esc_url($url) . '" title="' . esc_attr($post_title) . '" class="wpmf_overlay '. $video_class .'" target="' . $link_target . '">'. $hover_box .'</a>';
                            $icon .= $social;
                            break;

                        default:
                            $lightboxUrls = $this->getLightboxUrl($attachment, $targetsize);
                            $url = $lightboxUrls['url'];


                            $icon = '<a '. $hover_color_style .' data-type="'. ((!empty($remote_video) || $video) ? 'iframe' : 'image') .'"  data-href="' . esc_url($url) . '" data-caption="' . esc_attr($post_title) . '"

class="wpmfgalleryaddonswipe wpmf_gallery_lightbox wpmf_overlay '. $video_class .'">'. $hover_box .'</a>';
                            $icon .= $social;
                    }
                }

                $icon .= '<div class="gallery_icons_wrap">';
                if (isset($gallery_configs['download_item']) && (int)$gallery_configs['download_item'] === 1) {
                    $icon .= '<a href="'.esc_url($downloads['download_link']).'" '. (($downloads['type'] === 'local') ? 'download' : '') .' target="'. (($downloads['type'] === 'google_photo') ? '_blank' : '_self') .'" class="wpmf_gallery_download_icon"><span class="material-icons-outlined"> file_download </span></a>';
                }

                if (!empty($gallery_type) && $gallery_type === 'photographer') {
                    $icon .= '<a href="#" data-gallery_id="'. (int)$gid .'" data-attachment="'. (int)$attachment->ID .'" class="wpmf_gallery_add_to_list"><span class="material-icons-outlined"> add_photo_alternate </span></a>';
                }
                $icon .= '</div>';

                $noLightbox = $this->getLightboxClass($custom_link);
                $item = '<figure class="wpmf-gallery-item gallery-item '.$noLightbox.'" data-id="'. (int)$attachment->ID .'" data-index="'. esc_html($index) .'">';
                $item .= '<div class="wpmf-gallery-icon">';
                $item .= wpmfRenderVideoIcon($attachment->ID);
                $item .= $icon;
                $item .= '<div class="square_thumbnail">';
                $item .= '<div class="img_centered">';
                $item .= $image_output;
                $item .= '</div>';
                $item .= '</div>';
                $item .= '</div>';
                if (trim($attachment->post_excerpt) !== '') {
                    $item .= '<figcaption class="wpmf-card-title text-center wpmf-gallery-caption">' . wptexturize($attachment->post_excerpt) . '</figcaption>';
                } else {
                    $item .= '<figcaption class="wpmf-card-title text-center wpmf-gallery-caption">' . wptexturize($attachment->post_title) . '</figcaption>';
                }
                $item .= '</figure>';
                break;
            case 'portfolio':
                if ($custom_link && $custom_link !== '') {
                    if (strpos($custom_link, '.jpg') !== false || strpos($custom_link, '.jpeg') !== false || strpos($custom_link, '.png') !== false || strpos($custom_link, '.webp') !== false) {
                        $icon = '<a '. $hover_color_style .' data-type="'. ((!empty($remote_video) || $video) ? 'iframe' : 'image') .'" class="wpmf_overlay '. $video_class .'" target="' . $link_target . '">'. $hover_box .'</a>';
                        $icon .= '<a class="portfolio_lightbox" data-type="'. ((!empty($remote_video) || $video) ? 'iframe' : 'image') .'"  title="' . esc_attr($post_title) . '" target="' . $link_target . '">+</a>';
                    } else {
                        $icon = '<a '. $hover_color_style .' href="' . $custom_link . '" class="wpmf_overlay '. $video_class .'" target="' . $link_target . '">'. $hover_box .'</a>';
                        $icon .= '<a class="portfolio_lightbox" href="' . $custom_link . '" title="' . esc_attr($post_title) . '" target="' . $link_target . '">+</a>';
                    }

                    $icon .= $social;
                } else {
                    switch ($link) {
                        case 'none':
                            $icon = '<div '. $hover_color_style .' class="wpmf_overlay '. $video_class .'">'. $hover_box .'</div><span class="hide_icon portfolio_lightbox" title="' . esc_attr($post_title) . '">+</span>';
                            $icon .= $social;
                            break;

                        case 'post':
                            $url = get_attachment_link($attachment->ID);
                            $icon = '<a '. $hover_color_style .' href="' . esc_url($url) . '" title="' . esc_attr($post_title) . '" class="wpmf_overlay '. $video_class .'" target="' . $link_target . '">'. $hover_box .'</a>';
                            $icon .= '<a class="portfolio_lightbox" href="' . esc_url($url) . '" title="' . esc_attr($post_title) . '"">+</a>';
                            $icon .= $social;
                            break;

                        default:
                            $lightboxUrls = $this->getLightboxUrl($attachment, $targetsize);
                            $url = $lightboxUrls['url'];

                            $icon = '<a '. $hover_color_style .' data-type="'. ((!empty($remote_video) || $video) ? 'iframe' : 'image') .'"  data-href="' . esc_url($url) . '" data-caption="' . esc_attr($post_title) . '"
class="wpmfgalleryaddonswipe wpmf_overlay '. $video_class .'">'. $hover_box .'</a>';
                            $icon .= '<a  class="wpmfgalleryaddonswipe portfolio_lightbox '. ((!empty($remote_video) || $video) ? 'isvideo' : '') .'"
 data-caption="' . esc_attr($post_title) . '">+</a>';
                            $icon .= $social;
                    }
                }

                $icon .= '<div class="gallery_icons_wrap">';
                if (isset($gallery_configs['download_item']) && (int)$gallery_configs['download_item'] === 1) {
                    $icon .= '<a href="'.esc_url($downloads['download_link']).'" '. (($downloads['type'] === 'local') ? 'download' : '') .' target="'. (($downloads['type'] === 'google_photo') ? '_blank' : '_self') .'" class="wpmf_gallery_download_icon"><span class="material-icons-outlined"> file_download </span></a>';
                }

                if (!empty($gallery_type) && $gallery_type === 'photographer') {
                    $icon .= '<a href="#" data-gallery_id="'. (int)$gid .'" data-attachment="'. (int)$attachment->ID .'" class="wpmf_gallery_add_to_list"><span class="material-icons-outlined"> add_photo_alternate </span></a>';
                }
                $icon .= '</div>';

                $noLightbox = $this->getLightboxClass($custom_link);
                $item = '<figure class="wpmf-gallery-item '.$noLightbox.'" data-id="'. (int)$attachment->ID .'" data-tags="' . $img_tags . '" data-index="'. esc_html($index) .'">';
                $item .= '<div class="wpmf-gallery-icon">';
                $item .= wpmfRenderVideoIcon($attachment->ID);
                $item .= $icon;
                $item .= '<div class="square_thumbnail">';
                $item .= '<div class="img_centered">';
                $item .= $image_output;
                $item .= '</div>';
                $item .= '</div>';
                $item .= '</div>';
                if (trim($attachment->post_excerpt) || trim($attachment->post_title)) {
                    $item .= "<div class='wpmf-caption-text wpmf-gallery-caption'>";
                    if (trim($attachment->post_title)) {
                        $item .= "<span class='title'>" . wptexturize($attachment->post_title) . ' </span><br>';
                    }

                    if (trim($attachment->post_excerpt)) {
                        $item .= "<span class='excerpt'>" . wptexturize($attachment->post_excerpt) . '</span>';
                    }
                    $item .= '</div>';
                }
                $item .= '</figure>';
                break;
        }

        return $item;
    }

    /**
     * Check if the provided custom link should disable the lightbox.
     *
     * This function checks the file extension of the provided custom link.
     * If the extension is not one of the allowed image types (jpg, jpeg, png, webp),
     * it sets the `noLightbox` flag.
     *
     * @param string $custom_link The custom link to check.
     *
     * @return string Returns 'noLightbox' if the link should disable the lightbox, otherwise an empty string.
     */
    private function getLightboxClass($custom_link)
    {
        $noLightbox = '';
        if (!empty($custom_link)) {
            $extension = strtolower(strrchr($custom_link, '.'));
            if (!in_array($extension, array('.jpg', '.jpeg', '.png', '.webp'))) {
                $noLightbox = 'noLightbox';
            }
        }
        return $noLightbox;
    }

    /**
     * Render hover box for image
     *
     * @param object $attachment Attachment info
     * @param array  $params     Gallery settings
     *
     * @return array
     */
    public function renderHoverStyle($attachment, $params = array())
    {
        $hover_color_style = 'style="background: ' . wpmfConvertHex2rgba($params['hover_color'], $params['hover_opacity']) . '"';
        $title_style = 'style="color: '. $params['hover_title_color'] .'; font-size:'. $params['hover_title_size'] .'px"';
        $desc_style = 'style="color: '. $params['hover_desc_color'] .'; font-size:'. $params['hover_desc_size'] .'px"';
        $title_position_class = (isset($params['hover_title_position'])) ? $params['hover_title_position'] : 'center_center';
        $desc_position_class = (isset($params['hover_desc_position'])) ? $params['hover_desc_position'] : 'none';
        $box_hover_class = '';
        if ($title_position_class === $desc_position_class) {
            $box_hover_class = 'wpmf_box_same_position wpmf_box_' . $title_position_class;
        }

        $hover_box = '';
        if ($params['hover_title_position'] !== 'none' || $params['hover_desc_position'] !== 'none') {
            $hover_box .= '<div class="wpmf_hover_box '. $box_hover_class .'">';
            if ($params['hover_title_position'] !== 'none' && $attachment->post_title !== '') {
                $hover_box .= '<figcaption class="wpmf_text wpmf_text_'. $title_position_class .'" '. $title_style .'>' . wptexturize($attachment->post_title) . '</figcaption>';
            }

            if ($params['hover_desc_position'] !== 'none' && $attachment->post_excerpt !== '') {
                $hover_box .= '<p class="wpmf_text wpmf_text_'. $desc_position_class .'" '. $desc_style .'>' . wptexturize($attachment->post_excerpt) . '</p>';
            }
            $hover_box .= '</div>';
        }

        return array(
            'hover_color_style' => $hover_color_style,
            'hover_box' => $hover_box,
        );
    }

    /**
     * Load gallery
     *
     * @return void
     */
    public function loadGallery()
    {
        // phpcs:disable WordPress.Security.NonceVerification.Missing -- load image gallery on frontend
        if (empty($_POST['gallery_id'])) {
            wp_send_json(array('status' => false));
        }

        $gallery_id = $_POST['gallery_id'];
        $gid = $_POST['gallery_id'];
        if (isset($_POST['selector'])) {
            $selector = $_POST['selector'];
        } else {
            $selector = 'wpmf-gallery-0';
        }
        /* get all params */
        $galleries = get_option('wpmf_galleries');
        $gallery_configs = get_option('wpmf_gallery_settings');
        $social = $this->getSocialHtml();
        // get params
        $id = intval($gallery_id);
        if (empty($galleries[$id]['theme'])) {
            $display = 'default';
        } else {
            $display = $galleries[$id]['theme'];
        }

        $params = $this->getSettingsFront($id, $_POST['settings'], $gallery_configs, $galleries, $display);
        // verify orderby option
        $params = $this->modifyOrderOptions($params);
        foreach ($params as $attr_key => $setting) {
            ${$attr_key} = $setting;
        }

        $lazy_load = (isset($gallery_configs['progressive_loading']) && (int)$gallery_configs['progressive_loading'] === 0) ? false : true;
        $is_wishlist = (isset($_POST['wishlist'])) ? (int)$_POST['wishlist'] : 0;

        // get google photo album id
        if (!empty($galleries[$id]) && !empty($galleries[$id]['google_photos_album'])) {
            $google_photos_album = $galleries[$id]['google_photos_album'];
        }

        $caption_lightbox = wpmfGetOption('caption_lightbox_gallery');
        /* Query images */
        $tax_query = wpmfGalleryAddonGetTaxQuery($id, $params);
        $args = array(
            'posts_per_page' => -1,
            'post_status' => 'any',
            'post_type' => 'attachment',
            'post_mime_type' => wpmfGalleryAddonGetImageType(),
            'tax_query' => $tax_query
        );

        if (($wpmf_orderby !== 'post__in' && $wpmf_orderby !== 'rand') || ($wpmf_orderby === 'rand' && !$lazy_load)) {
            $args['orderby'] = $wpmf_orderby;
            $args['order'] = $wpmf_order;
        }

        if (!empty($is_wishlist)) {
            $requests = get_term_meta($gid, 'wpmf_gallery_wishlist', true);
            if (!empty($requests) && is_array($requests)) {
                $args['post__in'] = $requests;
            } else {
                wp_send_json(array('status' => false));
            }
        }

        $query = new WP_Query($args);
        $_attachments = $query->get_posts();
        $attachments = array();
        foreach ($_attachments as &$val) {
            $order = get_post_meta((int)$val->ID, 'wpmf_gallery_'.$id.'_order', true);
            $val->order = (int)$order;
            if (isset($_POST['tags']) && $_POST['tags'] !== '*') {
                $i_trim_tags = array();
                $i_tags = wp_get_post_terms($val->ID, 'wpmf_tag');
                if ($i_tags) {
                    $i_tags = array_column($i_tags, 'name');
                    foreach ($i_tags as $i_tag) {
                        $i_trim_tags[] = strtolower(trim($i_tag));
                    }
                }
                if (in_array(esc_html($_POST['tags']), $i_trim_tags)) {
                    $attachments[] = $val;
                }
            } else {
                $attachments[] = $val;
            }
        }

        if ($wpmf_orderby === 'post__in') {
            usort($attachments, 'wpmfSortByOrder');
        }
        
        // get google photos
        $attachment_photos = $this->getGooglePhotos($google_photos_album);
        if (!empty($attachment_photos)) {
            $attachments = array_merge($attachments, $attachment_photos);
        }

        $count_attachments = count($attachments);

        //get list image id for download all
        $list_img_gallery_ids = array();
        if ($attachments) {
            foreach ($attachments as $item) {
                $list_img_gallery_ids[] = $item->ID;
            }
        }

        $class = array();
        $class[] = 'wpmf-gallery-addon-wrap';
        $class[] = 'gallery-link-' . $link;

        /* Create output html */
        $output = '';
        $output .= "<img class='loading_gallery' src='" . WPMF_GALLERY_ADDON_PLUGIN_URL . "/assets/images/Loading_icon.gif' />";

        // render Tabs
        $tag_value = (isset($_POST['tags'])) ? $_POST['tags'] : '*';
        $output .= $this->renderTabsFilter($display_tag, $_attachments, $tag_value);
        $gallery_type = get_term_meta((int)$gallery_id, 'gallery_type', true);
        // phpcs:enable
        ob_start();
        if (empty($attachments) && (int)$sub_galleries_listing === 1 && (int)$display_tree === 1) {
            require(WPMF_GALLERY_ADDON_PLUGIN_DIR . 'frontend/themes-gallery/gallery-lists.php');
        }

        if (file_exists(WPMF_GALLERY_ADDON_PLUGIN_DIR . 'frontend/themes-gallery/' . $display . '.php')) {
            require(WPMF_GALLERY_ADDON_PLUGIN_DIR . 'frontend/themes-gallery/' . $display . '.php');
        } else {
            require(WPMF_GALLERY_ADDON_PLUGIN_DIR . 'frontend/themes-gallery/default.php');
        }

        if (!empty($gallery_type) && $gallery_type === 'photographer') {
            require(WPMF_GALLERY_ADDON_PLUGIN_DIR . 'frontend/themes-gallery/gallery_comments.php');
            require(WPMF_GALLERY_ADDON_PLUGIN_DIR . 'frontend/themes-gallery/download_popup.php');
            require(WPMF_GALLERY_ADDON_PLUGIN_DIR . 'frontend/themes-gallery/download_wishlist_popup.php');
        }
        $output .= ob_get_contents();
        ob_end_clean();
        wp_send_json(array('status' => true, 'html' => $output, 'download_all' => esc_attr(json_encode($list_img_gallery_ids))));
    }

    /**
     * Get Google Photos
     *
     * @param string $google_photos_album Google photos album ID
     *
     * @return array
     */
    public function getGooglePhotos($google_photos_album)
    {
        $attachment_photos = array();
        $google_photo_config = get_option('_wpmfAddon_google_photo_config', true);
        if (is_plugin_active('wp-media-folder-addon/wp-media-folder-addon.php') && (!empty($google_photo_config['connected']))) {
            if (!empty($google_photos_album)) {
                require_once(WPMFAD_PLUGIN_DIR . '/class/wpmfGooglePhoto.php');
                $google_photo = new WpmfAddonGooglePhoto;
                if (method_exists($google_photo, 'getAllMediaItemsByAlbumId')) {
                    if ($google_photos_album === 'photos') {
                        $return = $google_photo->getAllMediaItemsByAlbumId('');
                    } else {
                        $return = $google_photo->getAllMediaItemsByAlbumId($google_photos_album);
                    }
                    $photos = $return['photos'];
                }

                if (!empty($photos)) {
                    foreach ($photos as $photo) {
                        if (strpos($photo->mimeType, 'image') === false) {
                            continue;
                        }
                        $object = new stdClass();
                        $object->ID = $photo->id;
                        $object->post_title = $photo->filename;
                        $object->post_excerpt = (isset($photo->description)) ? $photo->description : $photo->filename;
                        $object->post_mime_type = $photo->mimeType;
                        $object->url = $photo->baseUrl;
                        $object->width = $photo->mediaMetadata->width;
                        $object->height = $photo->mediaMetadata->height;
                        $object->type = 'google_photo';
                        $attachment_photos[] = $object;
                    }
                }
            }
        }

        return $attachment_photos;
    }

    /**
     * Get settings front
     *
     * @param integer $id                      Gallery ID
     * @param array   $request_settings        Request settings
     * @param array   $gallery_default_configs Gallery default configs
     * @param array   $galleries               Gallery configs
     * @param string  $theme                   Gallery theme
     *
     * @return array
     */
    public function getSettingsFront($id, $request_settings, $gallery_default_configs, $galleries, $theme)
    {
        $default = array(
            'columns'      => 3,
            'gutterwidth'  => 5,
            'link'         => 'post',
            'size'         => 'thumbnail',
            'targetsize'   => 'large',
            'wpmf_orderby'      => 'post__in',
            'wpmf_order'        => 'ASC',
            'customlink'   => 0,
            'class'        => '',
            'include'      => '',
            'exclude'      => '',
            'display_tree' => 0,
            'sub_galleries_listing' => 0,
            'display_tag'  => 0,
            'disable_overlay' => 0,
            'img_border_radius' => 0,
            'border_width' => 0,
            'border_color' => 'transparent',
            'border_style' => 'solid',
            'img_shadow' => '',
            'show_buttons' => 1,
            'animation' => 'slide',
            'duration' => 4000,
            'auto_animation' => 1,
            'number_lines' => 1
        );

        if (isset($request_settings)) {
            $settings = $request_settings;
            if (empty($settings['display'])) {
                $settings['display'] = $theme;
            }
        } else {
            $settings = array_merge($gallery_default_configs['theme'][$theme . '_theme'], $galleries[$id]);
        }

        $settings = array_merge($default, $settings);
        return $settings;
    }

    /**
     * Render tabs filter
     *
     * @param integer $enable       Enable or disable
     * @param array   $_attachments Attachments
     * @param string  $tag_value    Current tag value
     *
     * @return string
     */
    public function renderTabsFilter($enable, $_attachments, $tag_value)
    {
        ob_start();
        $html = '';
        if ((int) $enable === 1) {
            $tags   = array();
            foreach ($_attachments as $value) {
                $img_tags = wp_get_post_terms($value->ID, 'wpmf_tag');
                if ($img_tags) {
                    $img_tags = array_column($img_tags, 'name');
                    foreach ($img_tags as $img_tag) {
                        if (trim($img_tag) !== '') {
                            $tags[] = strtolower(trim($img_tag));
                        }
                    }
                }
            }

            natcasesort($tags);
            if (count(array_unique($tags)) > 0) {
                echo '<div class="wpmf-gridblock-filters">';
                echo '<ul class="tabs gridblock-filter-categories">';
                if (empty($tag_value) || (!empty($tag_value) && $tag_value === '*')) {
                    echo '<li class="tab filter-all-control selected">';
                } else {
                    echo '<li class="tab filter-all-control">';
                }

                echo '<a data-filter="*">' . esc_html__('All', 'wp-media-folder-gallery-addon') . '</a>';
                echo '</li>';
                foreach (array_unique($tags) as $tag) {
                    if ($tag !== '') {
                        if ($tag === esc_html($tag_value)) {
                            echo '<li class="tab filter-all-control selected">';
                        } else {
                            echo '<li class="tab filter-all-control">';
                        }
                        // phpcs:ignore WordPress.Security.EscapeOutput -- Content already escaped in the method
                        echo '<a data-filter="' . esc_attr($tag) . '" class="">' . strtoupper($tag) . '</a>';
                        echo '</li>';
                    }
                }
                echo '</ul></div>';
            }
        }

        $html .= ob_get_contents();
        ob_end_clean();

        return $html;
    }

    /**
     * Submit comments and send email to admin
     *
     * @return void
     */
    public function gallerySubmitComments()
    {
        // phpcs:disable WordPress.Security.NonceVerification.Missing -- load image gallery on frontend
        $gallery_id = isset($_POST['gallery_id']) ? (int)$_POST['gallery_id'] : 0;
        if (!empty($gallery_id)) {
            $ids = get_term_meta($gallery_id, 'wpmf_gallery_wishlist', true);
            if (empty($ids)) {
                $ids = array();
            }

            if (empty($ids)) {
                wp_send_json(array('status' => false));
            }

            global $current_user;
            $comments = (isset($_POST['comments'])) ? json_decode(stripslashes($_POST['comments']), true) : array();
            if (!empty($comments)) {
                $author_name = isset($_POST['author_name']) ? sanitize_text_field($_POST['author_name']) : '';
                if (!empty($current_user->ID)) {
                    $author_name = $current_user->data->display_name;
                }
            // phpcs:enable
                foreach ($comments as $comment) {
                    $data = array(
                        'comment_post_ID' => (int)$comment['attachment_id'],
                        'comment_author' => $author_name,
                        'comment_content' => sanitize_textarea_field($comment['comment']),
                        'comment_parent' => (int)$comment['parent']
                    );

                    if (!empty($current_user->ID)) {
                        $data['comment_author_email'] = $current_user->data->user_email;
                    }

                    $comment_id = wp_insert_comment($data);
                    if ($comment_id) {
                        update_term_meta((int)$gallery_id, 'wpmf_is_new_comment', 1);
                    }
                }
            }
            $admin_email = get_option('admin_email');
            $to = $admin_email;
            if (!empty($current_user->ID)) {
                $roles = $current_user->roles;
                if (in_array('administrator', $roles)) {
                    $gallery_emails = get_term_meta($gallery_id, 'wpmf_gallery_emails', true);
                    if (!empty($gallery_emails)) {
                        $to = implode(',', $gallery_emails);
                    }
                }
            }

            $blogname = get_option('blogname');
            $subject = esc_html__('New gallery comments', 'wp-media-folder-gallery-addon');
            if (!empty($blogname)) {
                $subject = $blogname . ' - ' . $subject;
            }

            $titles = array();
            foreach ($ids as $id) {
                $titles[] = get_the_title($id);
            }
            $gallery = get_term($gallery_id, WPMF_GALLERY_ADDON_TAXO);
            $gallery_page = get_term_meta($gallery_id, 'wpmf_gallery_page', true);
            $page = get_post($gallery_page);
            $html = '';
            $html .= '<b>' . esc_html__('Gallery Title:', 'wp-media-folder-gallery-addon') . '</b> ' . $gallery->name . '<br>';
            $html .= '<b>' . esc_html__('Gallery URL:', 'wp-media-folder-gallery-addon') . '</b> ' . get_the_permalink((int)$gallery_page) . '<br>';
            $html .= '<b>' . esc_html__('Gallery Password:', 'wp-media-folder-gallery-addon') . '</b> ' . $page->post_password . '<br>';
            $html .= '<b>' . esc_html__('Pictures:', 'wp-media-folder-gallery-addon') . '</b> ' . implode(', ', $titles) . '</span>';

            foreach ($ids as $id) {
                $comments = get_comments(array('post_id' => $id, 'number' => 3));
                $html .= '<p><b>'. get_the_title($id) .'</b></p>';
                if (!empty($comments)) {
                    $html .= '<ul>';
                    foreach ($comments as $comment) {
                        $sup = '';
                        $author = ($comment->comment_author === '') ? esc_html__('Guest', 'wp-media-folder-gallery-addon') : $comment->comment_author;
                        $html .= '<li><span>'. $author . '</span>'. $sup . ': ' . esc_html($comment->comment_content) . '</li>';
                    }
                    $html .= '</ul>';
                }
                $html .= '------------------------------';
            }

            $headers = array('Content-Type: text/html; charset=UTF-8');
            wp_mail($to, $subject, $html, $headers);
            wp_send_json(array('status' => true));
        }
        wp_send_json(array('status' => false));
    }

    /**
     * Insert comment to image
     *
     * @return void
     */
    public function galleryInsertComment()
    {
        // phpcs:disable WordPress.Security.NonceVerification.Missing -- load image gallery on frontend
        global $current_user;
        $attachment_id = isset($_POST['attachment_id']) ? (int)$_POST['attachment_id'] : 0;
        $gallery_id = isset($_POST['gallery_id']) ? (int)$_POST['gallery_id'] : 0;
        $author_name = isset($_POST['author_name']) ? sanitize_text_field($_POST['author_name']) : '';
        if (!empty($current_user->ID)) {
            $author_name = $current_user->data->display_name;
        }
        $comment = isset($_POST['comment']) ? sanitize_textarea_field($_POST['comment']) : '';
        $parent =  isset($_POST['parent']) ? (int)$_POST['parent'] : 0;
        if ((int)$attachment_id === 0 || $comment === '' || $author_name === '') {
            wp_send_json(array('status' => false));
        }
        // phpcs:enable
        $data = array(
            'comment_post_ID' => $attachment_id,
            'comment_author' => $author_name,
            'comment_content' => $comment,
            'comment_parent' => $parent
        );

        if (!empty($current_user->ID)) {
            $data['comment_author_email'] = $current_user->data->user_email;
        }

        $comment_id = wp_insert_comment($data);
        if ($comment_id) {
            if (!empty($gallery_id)) {
                update_term_meta((int)$gallery_id, 'wpmf_is_new_comment', 1);
            }
            $comments = wpmfGalleryShowComments($attachment_id, 0);
            wp_send_json(array('status' => true, 'comments' => $comments));
        }
    }

    /**
     * Add to wishlist
     *
     * @return void
     */
    public function galleryAddToWishlist()
    {
        // phpcs:disable WordPress.Security.NonceVerification.Missing -- load image gallery on frontend
        $gallery_id = !empty($_POST['gallery_id']) ? (int)$_POST['gallery_id'] : 0;
        $image_id = !empty($_POST['attachment_id']) ? (int)$_POST['attachment_id'] : 0;
        $is_add = !empty($_POST['is_add']) ? (int)$_POST['is_add'] : 0;
        // phpcs:enable
        $params = wpmfGalleryAddonGetParams($gallery_id);
        $gallery_wishlist = get_term_meta($gallery_id, 'wpmf_gallery_wishlist', true);
        if (empty($gallery_wishlist)) {
            $gallery_wishlist = array();
        }

        if (!empty($is_add)) {
            if (!in_array($image_id, $gallery_wishlist)) {
                $gallery_wishlist[] = $image_id;
            }
        } else {
            if (!empty($gallery_wishlist) && in_array($image_id, $gallery_wishlist)) {
                $key = array_search($image_id, $gallery_wishlist);
                unset($gallery_wishlist[$key]);
            }
        }

        $objects = get_objects_in_term($gallery_id, WPMF_GALLERY_ADDON_TAXO);
        if (!empty($params) && (int)$params['auto_from_folder'] === 1 && !empty($params['folder'])) {
            $objects2 = get_objects_in_term($params['folder'], WPMF_TAXO);
            $objects = array_merge($objects, $objects2);
        }

        if (!empty($gallery_wishlist) && is_array($gallery_wishlist)) {
            $wishlist = array_intersect($gallery_wishlist, $objects);
        } else {
            $wishlist = array();
        }
        update_term_meta($gallery_id, 'wpmf_gallery_wishlist', $wishlist);
        wp_send_json(array('status' => true, 'wishlist_count' => count($wishlist)));
    }

    /**
     * Load gallery wishlist
     *
     * @return void
     */
    public function galleryPhotograperLoadRequests()
    {
        // phpcs:ignore WordPress.Security.NonceVerification.Missing -- load image gallery on frontend
        $gallery_id = !empty($_POST['gallery_id']) ? (int)$_POST['gallery_id'] : 0;
        $ids = get_term_meta($gallery_id, 'wpmf_gallery_wishlist', true);
        $params = wpmfGalleryAddonGetParams($gallery_id);
        $objects = get_objects_in_term($gallery_id, WPMF_GALLERY_ADDON_TAXO);
        if (!empty($params) && (int)$params['auto_from_folder'] === 1 && !empty($params['folder'])) {
            $objects2 = get_objects_in_term($params['folder'], WPMF_TAXO);
            $objects = array_merge($objects, $objects2);
        }
        if (!empty($ids) && is_array($ids)) {
            $images = array_intersect($ids, $objects);
        } else {
            $images = array();
        }

        if (empty($images)) {
            $images = array();
        }
        $html = '';
        if (!empty($images) && !empty($gallery_id)) {
            ob_start();
            foreach ($images as $image) {
                require WPMF_GALLERY_ADDON_PLUGIN_DIR . 'frontend/themes-gallery/gallery_comments_item.php';
            }
            $html .= ob_get_contents();
            ob_end_clean();
            wp_send_json(array('status' => true, 'html' => $html));
        }
        wp_send_json(array('status' => false));
    }

    /**
     * Load download image size lists
     *
     * @return void
     */
    public function galleryLoadDownloadSizes()
    {
        // phpcs:ignore WordPress.Security.NonceVerification.Missing -- load image gallery on frontend
        $attachment_id = !empty($_POST['attachment_id']) ? (int)$_POST['attachment_id'] : 0;
        $html = '';
        if (!empty($attachment_id)) {
            $photograper_default_dimensions = wpmfGetOption('photograper_default_dimensions');
            $settings         = get_option('wpmf_settings');
            if (isset($settings) && isset($settings['photograper_dimension'])) {
                $photograper_dimension = $settings['photograper_dimension'];
            } else {
                $photograper_dimension = wpmfGetOption('photograper_dimension');
            }

            $other_sizes = get_intermediate_image_sizes();
            if (is_array($photograper_dimension) && !empty($photograper_dimension)) {
                $html .= '<ul>';
                $sub = '';
                //check for goole drive only download original size
                $driveType = get_post_meta($attachment_id, 'wpmf_drive_type', true);
                $drive_id = get_post_meta($attachment_id, 'wpmf_drive_id', true);
                if (!empty($drive_id) && $driveType === 'google_drive') {
                    $size_name = esc_html__('Original size', 'wp-media-folder-gallery-addon');
                    $sub .= '<li>';
                    $sub .= '<div class="wpmf_size_row"><input checked class="wpmf_size_input" name="wpmf_photograper_size" type="radio" data-attachment="'. (int)$attachment_id .'"><label class="wpmf_size_label">'. $size_name .' <span></span></label></div>';
                    $sub .= '</li>';
                } else {
                    foreach ($photograper_dimension as $i => $sizes) {
                        if ($sizes === 'full') {
                            $image_attributes = wp_get_attachment_image_src($attachment_id, 'full');
                            $size_name = esc_html__('Original size', 'wp-media-folder-gallery-addon');
                            $lb = '(' . $image_attributes[1] . 'px x ' . $image_attributes[2] . 'px)';
                        } elseif (in_array($sizes, $other_sizes)) {
                            $width = get_option($sizes . '_size_w');
                            $height = get_option($sizes . '_size_h');
                            $size_name = $width . 'x' . $height;
                            $lb = '(' . $width . 'px x ' . $height . 'px)';
                        } else {
                            $image_attributes = wp_get_attachment_image_src($attachment_id, 'full');
                            if ($photograper_default_dimensions[$sizes]['width'] > $image_attributes[1] || $photograper_default_dimensions[$sizes]['height'] > $image_attributes[2]) {
                                continue;
                            }
    
                            if (!isset($photograper_default_dimensions[$sizes])) {
                                continue;
                            }
    
                            $size_name = $photograper_default_dimensions[$sizes]['name'];
                            $lb = '('. $photograper_default_dimensions[$sizes]['width'] .'px x '. floor($photograper_default_dimensions[$sizes]['width']*$image_attributes[2]/$image_attributes[1]) .'px)';
                        }
    
                        $sub .= '<li>';
                        $sub .= '<div class="wpmf_size_row"><input '. (((int)$i === 0) ? 'checked' : '') .' class="wpmf_size_input" name="wpmf_photograper_size" type="radio" data-attachment="'. (int)$attachment_id .'" data-size="'. esc_attr($sizes) .'"><label class="wpmf_size_label">'. $size_name .' <span>'. $lb .'</span></label></div>';
                        $sub .= '</li>';
                    }
                }

                if ($sub !== '') {
                    $html .= $sub;
                } else {
                    $html .= '<li style="text-align: center; display: block !important; color: #f00;">'. esc_html__('The download size for this image is not available.', 'wp-media-folder-gallery-addon') .'</li>';
                }
                $html .= '</ul>';
            }
            wp_send_json(array('status' => true, 'html' => $html));
        }
        wp_send_json(array('status' => false));
    }

    /**
     * Download image size from gallery
     *
     * @return void
     */
    public function galleryDownloadImage()
    {
        // phpcs:disable WordPress.Security.NonceVerification.Missing -- load image gallery on frontend
        $attachment_id = !empty($_POST['attachment_id']) ? (int)$_POST['attachment_id'] : 0;
        $size = !empty($_POST['size']) ? $_POST['size'] : '';
        $driveType = get_post_meta($attachment_id, 'wpmf_drive_type', true);
        $drive_id = get_post_meta($attachment_id, 'wpmf_drive_id', true);
        if (!empty($drive_id)) {
            switch ($driveType) {
                case 'google_drive':
                    wp_send_json(array('status' => true, 'download_url' => 'https://drive.google.com/uc?export=download&id='.$drive_id, 'name' => ''));
                    break;
            }
        } else {
            // phpcs:enable
            if (!empty($attachment_id) && !empty($size)) {
                $upload_dir =  wp_upload_dir();
                if (!file_exists($upload_dir['basedir'] . '/wpmf-gallery/wishlist')) {
                    mkdir($upload_dir['basedir'] . '/wpmf-gallery/wishlist', 0777, true);
                }

                if ($size === 'full') {
                    $intermediate_file = get_attached_file($attachment_id);
                    $download_url = wp_get_attachment_image_url($attachment_id, 'full');
                } else {
                    $returns = wpmfGalleryCreateThumbnail((int)$attachment_id, $size);
                    if (!$returns) {
                        wp_send_json(array('status' => false));
                    }
                    $intermediate_file = $returns['intermediate_file'];
                    $download_url = $returns['download_url'];
                }

                $info_url = pathinfo($download_url);
                $filename = $info_url['basename'];

                // render watermark
                wpmfGalleryrenderWatermark($intermediate_file, $size);
                if (file_exists($intermediate_file)) {
                    wp_send_json(array('status' => true, 'download_url' => $download_url . '?v=' . time(), 'name' => $filename));
                }
            }
        }

        wp_send_json(array('status' => false));
    }

    /**
     * Download gallery wishlist
     *
     * @return void
     */
    public function galleryDownloadWishlist()
    {
        // phpcs:disable WordPress.Security.NonceVerification.Missing -- load image gallery on frontend
        $upload_dir =  wp_upload_dir();
        if (!file_exists($upload_dir['basedir'] . '/wpmf-gallery/wishlist')) {
            mkdir($upload_dir['basedir'] . '/wpmf-gallery/wishlist', 0777, true);
        }
        $gallery_id = isset($_POST['gallery_id']) ? (int)$_POST['gallery_id'] : 0;
        $size = isset($_POST['size']) ? $_POST['size'] : 'full';
        $ids = get_term_meta($gallery_id, 'wpmf_gallery_wishlist', true);
        $params = wpmfGalleryAddonGetParams($gallery_id);
        $objects = get_objects_in_term($gallery_id, WPMF_GALLERY_ADDON_TAXO);
        if (!empty($params) && (int)$params['auto_from_folder'] === 1 && !empty($params['folder'])) {
            $objects2 = get_objects_in_term($params['folder'], WPMF_TAXO);
            $objects = array_merge($objects, $objects2);
        }

        if (!empty($ids) && is_array($ids)) {
            $images = array_intersect($ids, $objects);
        } else {
            $images = array();
        }
        // phpcs:enable
        if (empty($images)) {
            $images = array();
        }
        $zipname = $upload_dir['basedir'] . '/wpmf-gallery/wishlist/gallery_' . $gallery_id . '.zip';
        $urlzip = $upload_dir['baseurl'] . '/wpmf-gallery/wishlist/gallery_' . $gallery_id . '.zip';
        if (file_exists($zipname)) {
            // phpcs:ignore Generic.PHP.NoSilencedErrors.Discouraged -- fix warning when not have permission unlink
            @unlink($zipname);
        }
        if (!empty($ids)) {
            $zip = new ZipArchive();
            $zip->open($zipname, ZipArchive::CREATE);
            foreach ($images as $id) {
                if ($size === 'full') {
                    $file = get_attached_file($id);
                } else {
                    $returns = wpmfGalleryCreateThumbnail((int)$id, $size);
                    if (!$returns) {
                        continue;
                    }
                    $file = $returns['intermediate_file'];
                }

                // render watermark
                wpmfGalleryrenderWatermark($file, $size);
                $pathInfo = pathInfo($file);
                $parentPath = $pathInfo['dirname'];
                $exclusiveLength = strlen($parentPath . '/');
                $localPath = substr($file, $exclusiveLength);
                $zip->addFile($file, $localPath);
            }
            $zip->close();
            wp_send_json(array('status' => true, 'download_url' => $urlzip . '?v=' . time(), 'name' => 'gallery_wishlist_' . $gallery_id . '.zip'));
        }
        wp_send_json(array('status' => false));
    }

    /**
     * Download all images in gallery
     *
     * @return void
     */
    public function galleryDownloadImageAll()
    {
        // phpcs:disable WordPress.Security.NonceVerification.Missing -- load image gallery on frontend
        if (isset($_POST['image_ids']) && !empty($_POST['image_ids']) && isset($_POST['gallery_id']) && !empty($_POST['gallery_id'])) {
            $upload_dir =  wp_upload_dir();
            if (!file_exists($upload_dir['basedir'] . '/wpmf-gallery/gallery')) {
                mkdir($upload_dir['basedir'] . '/wpmf-gallery/gallery', 0777, true);
            }
            $zip_name = $upload_dir['basedir'] . '/wpmf-gallery/gallery/gallery_' . $_POST['gallery_id'] . '.zip';
            $url_zip = $upload_dir['baseurl'] . '/wpmf-gallery/gallery/gallery_' . $_POST['gallery_id'] . '.zip';
            if (file_exists($zip_name)) {
                // phpcs:ignore Generic.PHP.NoSilencedErrors.Discouraged -- fix warning when not have permission unlink
                @unlink($zip_name);
            }
            $zip = new ZipArchive();
            $zip->open($zip_name, ZipArchive::CREATE);
            $list_images = json_decode($_POST['image_ids'], true);
            // phpcs:enable
            if ($list_images) {
                foreach ($list_images as $id) {
                    $file = get_attached_file($id);
                    $pathInfo = pathInfo($file);
                    $parentPath = $pathInfo['dirname'];
                    $exclusiveLength = strlen($parentPath . '/');
                    $localPath = substr($file, $exclusiveLength);
                    $zip->addFile($file, $localPath);
                }
                $zip->close();
                wp_send_json(array('status' => true, 'download_url' => $url_zip . '?v=' . time()));
            }
        }
        wp_send_json(array('status' => false));
    }
}
