'use strict';

/**
 * Folder tree for WP Media Folder
 */
var wpmfGalleryTree = void 0;
(function ($) {
    wpmfGalleryTree = {
        ajax_loading: false,
        galleries_tree: {},
        /**
         * Initialize module related things
         */
        initModule: function initModule($current) {
            // Render the tree view
            var top_gallery_id = $current.data('id'); // get gallery ID inserted content
            //$current.html(wpmfGalleryTree.getRendering($current));
            $current.find('.wpmf-gallery-toggle-icon').on('click', function () {
                // single click
                if ($(this).closest('li').hasClass('closed')) {
                    $(this).closest('li').removeClass('closed');
                } else {
                    $(this).closest('li').addClass('closed');
                }
            });

            // Initialize double click to folder title on tree view
            $current.find('.wpmf-gallery-tree-item').on('click', function (e) {
                if ($(e.target).hasClass('wpmf-gallery-arrow')) {
                    return;
                }

                if (!wpmfGallery.ajax_loading) {
                    // single click
                    var id = $(this).data('id');
                    $current.find('ul li').removeClass('open selected');
                    $(this).closest('li').addClass('open selected');
                    wpmfGalleryTree.changeFolder($current, id, $('.wpmf_gallery_tree[data-id="' + top_gallery_id + '"]'));
                    wpmfGalleryTree.loadGallery($current, id, top_gallery_id);
                }
            });

            // search with enter key
            $current.find('.wpmf_search_galleries').on('keypress', function (e) {
                if (e.which === 13) {
                    wpmfGalleryTree.doSearch();
                    return false;
                }
            });

            $current.find(".wpmf_search_galleries").wpmfGalleryHandleKeyboardChange(1000).change(function () {
                wpmfGalleryTree.doSearch();
            });

            var galleryIdStart = wpmfGalleryTree.getGalleryIDStart($current);
            var tree_hash = window.location.hash;
            tree_hash = tree_hash.replace('#', '');
            if (tree_hash !== '') {
                var hasha = tree_hash.split('-');
                if (hasha[1].indexOf('wpmfgallery') !== -1) {
                    var args = hasha[1].split('+');
                    if (galleryIdStart !== args[1]) {
                        wpmfGalleryTree.changeFolder($current, galleryIdStart, $('.wpmf_gallery_tree[data-id="' + args[1] + '"]'));
                        wpmfGalleryTree.loadGallery($current, galleryIdStart, top_gallery_id);
                    }
                }
            }
        },

        /**
         *  Do search folder
         */
        doSearch: function doSearch() {
            // search on folder tree
            var keyword = $('.wpmf_search_galleries').val().trim().toLowerCase();
            if (keyword !== '') {
                $('.wpmf_gallery_tree li').addClass('folderhide').removeClass('foldershow');
                $('.wpmf-gallery-item-title').each(function (i, v) {
                    var folder_name = $(v).html().trim().toLowerCase();
                    if (folder_name.indexOf(keyword) !== -1) {
                        $(v).closest('li').addClass('foldershow').removeClass('folderhide closed');
                        $(v).closest('li').parents('.wpmf_gallery_tree li').addClass('foldershow').removeClass('folderhide closed');
                    }
                });

                if ($('.foldershow').length) {
                    $('.search_no_result_wrap').hide();
                } else {
                    $('.search_no_result_wrap').show();
                }
            } else {
                $('.wpmf_gallery_tree li').removeClass('foldershow folderhide');
                $('.search_no_result_wrap').hide();
            }
        },

        loadGallery: function loadGallery($current, galleryId, top_gallery_id) {
            var $container = $('.wpmf_gallery_tree[data-id="' + top_gallery_id + '"]').closest('.wpmf_gallery_wrap');
            var settings = $container.data('top-gallery-settings');
            var selector = $container.data('selector');
            var data = {
                action: "wpmf_load_gallery",
                gallery_id: galleryId,
                settings: settings,
                selector: selector
            };

            if (parseInt(galleryId) === parseInt(top_gallery_id)) {
                data.settings = $('.wpmf_gallery_wrap[data-id="' + galleryId + '"]').data('top-gallery-settings');
            }
            $.ajax({
                url: wpmfgallery.ajaxurl,
                method: "POST",
                dataType: 'json',
                data: data,
                beforeSend: function beforeSend() {
                    $container.find('.wpmf_gallery_box *').hide();
                    $container.find('.wpmf_gallery_box .loading_gallery').show();
                    wpmfGallery.ajax_loading = true;
                },
                success: function success(res) {
                    if (res.status) {
                        window.location.hash = '#' + galleryId + '-wpmfgallery+' + top_gallery_id;
                        $container.find('.wpmf_gallery_box').html('').append(res.html);
                        wpmfGallery.initGallery();
                        wpmfGallery.photograperHandle();
                        //set data to button download all
                        $('.wrap-download-all a').attr('data-gallery-id', galleryId);
                        $('.wrap-download-all a').attr('data-image-ids', res.download_all);
                    }
                    wpmfGallery.ajax_loading = false;
                }
            });
        },

        /**
         * Change the selected folder in tree view
         */
        changeFolder: function changeFolder($current, folder_id, $gallery) {
            // Remove previous selection
            $gallery.find('li').removeClass('selected');

            // Select the folder
            $gallery.find('li[data-id="' + folder_id + '"]').addClass('selected'). // Open parent folders
            parents('.wpmf_gallery_tree li.closed').removeClass('closed');
        },

        getGalleryIDStart: function getGalleryIDStart($current) {
            var gallery_id = $current.data('id'); // get gallery ID inserted content
            var tree_hash = window.location.hash;
            tree_hash = tree_hash.replace('#', '');
            if (tree_hash !== '') {
                var hasha = tree_hash.split('-');
                if (hasha[1].indexOf('wpmfgallery') !== -1) {
                    gallery_id = parseInt(hasha[0]);
                }
            }

            return gallery_id;
        }
    };

    // Let's initialize WPMF folder tree features
    $(document).ready(function () {
        $('.wpmf_gallery_tree').each(function () {
            wpmfGalleryTree.initModule($(this));
        });

        $('.menu-item a').on('click', function () {
            setTimeout(function () {
                var hash = window.location.hash;
                if (hash.indexOf('wpmfgallery') !== -1) {
                    hash = hash.replace('#', '');
                    var ids = hash.split('-wpmfgallery+');
                    var galleryId = ids[0];
                    var top_gallery_id = ids[1];
                    wpmfGalleryTree.loadGallery(galleryId, top_gallery_id);
                    $('.wpmf_gallery_tree li').removeClass('open selected');
                    $('.wpmf_gallery_tree li[data-id="' + galleryId + '"]').addClass('open selected');
                }
            }, 200);
        });
    });
})(jQuery);

jQuery.fn.wpmfGalleryHandleKeyboardChange = function (nDelay) {
    // Utility function to test if a keyboard event should be ignored
    function shouldIgnore(event) {
        var mapIgnoredKeys = {
            9: true, // Tab
            16: true, 17: true, 18: true, // Shift, Alt, Ctrl
            37: true, 38: true, 39: true, 40: true, // Arrows
            91: true, 92: true, 93: true // Windows keys
        };
        return mapIgnoredKeys[event.which];
    }

    // Utility function to fire OUR change event if the value was actually changed
    function fireChange($element) {
        if ($element.val() != jQuery.data($element[0], "valueLast")) {
            jQuery.data($element[0], "valueLast", $element.val());
            $element.trigger("change");
        }
    }

    // The currently running timeout,
    // will be accessed with closures
    var timeout = 0;

    // Utility function to cancel a previously set timeout
    function clearPreviousTimeout() {
        if (timeout) {
            clearTimeout(timeout);
        }
    }

    return this.keydown(function (event) {
        if (shouldIgnore(event)) return;
        // User pressed a key, stop the timeout for now
        clearPreviousTimeout();
        return null;
    }).keyup(function (event) {
        if (shouldIgnore(event)) return;
        // Start a timeout to fire our event after some time of inactivity
        // Eventually cancel a previously running timeout
        clearPreviousTimeout();
        var $self = jQuery(this);
        timeout = setTimeout(function () {
            fireChange($self);
        }, nDelay);
    }).change(function () {
        // Fire a change
        // Use our function instead of just firing the event
        // Because we want to check if value really changed since
        // our previous event.
        // This is for when the browser fires the change event
        // though we already fired the event because of the timeout
        fireChange(jQuery(this));
    });
};
