<?php
/* Prohibit direct script loading */
defined('ABSPATH') || die('No direct script access allowed!');

/**
 * Class WpmfGenerateWebpFile
 * This class that automatically generate webp file functionality for Media Folder.
 */
class WpmfGenerateWebpFile
{

    /**
     * Wpmf_Duplicate_File constructor.
     */
    public function __construct()
    {
        $settings         = get_option('wpmf_settings');
        if (isset($settings) && isset($settings['auto_generate_webp']) && $settings['auto_generate_webp']) {
            add_filter('wp_handle_upload', array($this, 'generateWebpFileOnUpload'), 12, 1);
        }
    }

    /**
     * Generate a WebP version of an uploaded image and replace the original file.
     *
     * @param array $upload An array of upload data, typically from `wp_handle_upload`.
     *                      Keys include 'file' (full path), 'url' (file URL), and 'type' (MIME type).
     *
     * @return array The modified upload array with the WebP file as the main file.
     */
    public function generateWebpFileOnUpload($upload)
    {
        $file_path = $upload['file'];

        // Only process JPEG and PNG images
        $ext = strtolower(pathinfo($file_path, PATHINFO_EXTENSION));
        if (!in_array($ext, ['jpg', 'jpeg', 'png'])) {
            return $upload;
        }

        // Generate WebP file path
        $upload_dir = dirname($file_path);
        $file_name  = pathinfo($file_path, PATHINFO_FILENAME);
        $unique_webp_name = wp_unique_filename($upload_dir, $file_name . '.webp');
        $webp_path = trailingslashit($upload_dir) . $unique_webp_name;

        $image = wp_get_image_editor($file_path);
        if (!is_wp_error($image)) {
            $image->set_quality(85);
            $saved = $image->save($webp_path, 'image/webp');

            if (!is_wp_error($saved) && file_exists($webp_path)) {
                // Delete the original JPG/PNG file
                unlink($file_path);

                // Override upload info so WP treats WebP as the main file
                $upload['file'] = $webp_path;
                $upload['url']  = preg_replace('/\.(jpe?g|png)$/i', '.webp', $upload['url']);
                $upload['type'] = 'image/webp';
            }
        }
        return $upload;
    }
}
