<?php
/*
Plugin Name: Elfsight Google Maps CC
Description: Start creating Google Maps on your website with the incredible Elfsight map builder.
Plugin URI: https://elfsight.com/google-maps-widget/wordpress/?utm_source=markets&utm_medium=codecanyon&utm_campaign=google-maps&utm_content=plugin-site
Version: 1.1.0
Author: پرشین اسکریپت
Author URI: http://www.persianscript.ir
*/

if (!defined('ABSPATH')) exit;


require_once('core/elfsight-plugin.php');

new ElfsightPlugin(array(
        'name' => 'Google Maps',
        'description' => 'Start creating Google Maps on your website with the incredible Elfsight map builder.',
        'slug' => 'elfsight-google-maps',
        'version' => '1.1.0',
        'text_domain' => 'elfsight-google-maps',
        'editor_settings' => array(
            'tabs' => array(
                array(
                    'id' => 'markers',
                    'name' => 'Markers',
                    'active' => true,
                ),
                array(
                    'id' => 'layout',
                    'name' => 'Layout',
                ),
                array(
                    'id' => 'map',
                    'name' => 'Map',
                ),
                array(
                    'id' => 'style',
                    'name' => 'Style',
                ),
            ),
            'properties' => array(
                array(
                    'id' => 'markers',
                    'name' => 'Markers',
                    'tab' => 'markers',
                    'type' => 'complex',
                    'complex' => array(
                        'properties' => array(
                            array(
                                'id' => 'position',
                                'name' => 'Position (address, coordinates)',
                                'type' => 'text',
                                'defaultValue' => '',
                                'description' => 'Set the marker\'s position. You can set its name or address in text format or set the specific coordinates (latitude, longitude separated by a comma).',
                            ),
                            array(
                                'id' => 'icon',
                                'name' => 'Icon',
                                'type' => 'select',
                                'select' => array(
                                    'options' => array(
                                        array(
                                            'value' => 'default',
                                            'name' => 'Default',
                                        ),
                                        array(
                                            'value' => 'custom',
                                            'name' => 'Custom',
                                        ),
                                        array(
                                            'value' => 'airport',
                                            'name' => 'Airport',
                                        ),
                                        array(
                                            'value' => 'atm',
                                            'name' => 'ATM',
                                        ),
                                        array(
                                            'value' => 'bus',
                                            'name' => 'Bus',
                                        ),
                                        array(
                                            'value' => 'bar',
                                            'name' => 'Bar',
                                        ),
                                        array(
                                            'value' => 'businessCenter',
                                            'name' => 'Business Center',
                                        ),
                                        array(
                                            'value' => 'cafe',
                                            'name' => 'Cafe',
                                        ),
                                        array(
                                            'value' => 'camping',
                                            'name' => 'Camping',
                                        ),
                                        array(
                                            'value' => 'cinema',
                                            'name' => 'Cinema',
                                        ),
                                        array(
                                            'value' => 'flag',
                                            'name' => 'Flag',
                                        ),
                                        array(
                                            'value' => 'gasStation',
                                            'name' => 'Gas Station',
                                        ),
                                        array(
                                            'value' => 'home',
                                            'name' => 'Home',
                                        ),
                                        array(
                                            'value' => 'hospital',
                                            'name' => 'Hospital',
                                        ),
                                        array(
                                            'value' => 'info',
                                            'name' => 'Info',
                                        ),
                                        array(
                                            'value' => 'library',
                                            'name' => 'Library',
                                        ),
                                        array(
                                            'value' => 'museum',
                                            'name' => 'Museum',
                                        ),
                                        array(
                                            'value' => 'parking',
                                            'name' => 'Parking',
                                        ),
                                        array(
                                            'value' => 'pin',
                                            'name' => 'Pin',
                                        ),
                                        array(
                                            'value' => 'port',
                                            'name' => 'Port',
                                        ),
                                        array(
                                            'value' => 'railway',
                                            'name' => 'Railway',
                                        ),
                                        array(
                                            'value' => 'restaurant',
                                            'name' => 'Restaurant',
                                        ),
                                        array(
                                            'value' => 'school',
                                            'name' => 'School',
                                        ),
                                        array(
                                            'value' => 'shopping',
                                            'name' => 'Shopping',
                                        ),
                                        array(
                                            'value' => 'sight',
                                            'name' => 'Sight',
                                        ),
                                        array(
                                            'value' => 'star',
                                            'name' => 'Star',
                                        ),
                                        array(
                                            'value' => 'subway',
                                            'name' => 'Subway',
                                        ),
                                        array(
                                            'value' => 'walk',
                                            'name' => 'Walk',
                                        ),
                                        array(
                                            'value' => 'wc',
                                            'name' => 'WC',
                                        ),
                                        array(
                                            'value' => 'wifi',
                                            'name' => 'Wi-Fi',
                                        ),
                                        array(
                                            'value' => 'zoo',
                                            'name' => 'Zoo',
                                        ),
                                        array(
                                            'value' => 'number1',
                                            'name' => '1',
                                        ),
                                        array(
                                            'value' => 'number2',
                                            'name' => '2',
                                        ),
                                        array(
                                            'value' => 'number3',
                                            'name' => '3',
                                        ),
                                        array(
                                            'value' => 'number4',
                                            'name' => '4',
                                        ),
                                        array(
                                            'value' => 'number5',
                                            'name' => '5',
                                        ),
                                        array(
                                            'value' => 'number6',
                                            'name' => '6',
                                        ),
                                        array(
                                            'value' => 'number7',
                                            'name' => '7',
                                        ),
                                        array(
                                            'value' => 'number8',
                                            'name' => '8',
                                        ),
                                        array(
                                            'value' => 'number9',
                                            'name' => '9',
                                        ),
                                    ),
                                ),
                                'defaultValue' => 'default',
                                'description' => 'Set the marker\'s icon. You can select a default Google Map icon, or one of the icons from our library. If you can\'t find the icon you\'re looking for, select "custom" and set your icon url in the Custom icon URL field.',
                            ),
                            array(
                                'id' => 'iconUrl',
                                'name' => 'Custom icon URL (40x40, png)',
                                'type' => 'text',
                                'defaultValue' => '',
                                'visible' => false,
                                'description' => 'Set your custom marker icon URL. Size: 40x40, Format: PNG. You can upload it to any server or file manager to make it publicly available.',
                            ),
                            array(
                                'id' => 'infoWindow',
                                'name' => 'Show info window',
                                'type' => 'toggle',
                                'defaultValue' => true,
                                'description' => 'The option allows you to open an information window by clicking on the marker.',
                            ),
                            array(
                                'id' => 'infoTitle',
                                'name' => 'Title',
                                'type' => 'text',
                                'defaultValue' => '',
                                'description' => 'Set the marker\'s title for the info window. Usually, it\'s the name of the place marker indicates.',
                            ),
                            array(
                                'id' => 'infoDescription',
                                'name' => 'Description',
                                'type' => 'textarea',
                                'defaultValue' => '',
                                'description' => 'The marker\'s description on the info window.',
                            ),
                            array(
                                'id' => 'infoImage',
                                'name' => 'Info window image URL',
                                'type' => 'text',
                                'defaultValue' => '',
                                'description' => 'Set the URL of the image to be displayed on the info window. Usually, it\'s a photo of the indicated place.',
                            ),
                            array(
                                'id' => 'infoAddress',
                                'name' => 'Info address',
                                'type' => 'text',
                                'defaultValue' => '',
                                'description' => 'Set the address to be displayed on the info window.',
                            ),
                            array(
                                'id' => 'infoSite',
                                'name' => 'Info site',
                                'type' => 'text',
                                'defaultValue' => '',
                                'description' => 'Set the website URL to be displayed on the info window.',
                            ),
                            array(
                                'id' => 'infoPhone',
                                'name' => 'Info phone',
                                'type' => 'text',
                                'defaultValue' => '',
                                'description' => 'Set the phone number to be displayed on the info window.',
                            ),
                            array(
                                'id' => 'infoEmail',
                                'name' => 'Info email',
                                'type' => 'text',
                                'defaultValue' => '',
                                'description' => 'Set the email to be displayed on the info window.',
                            ),
                            array(
                                'id' => 'infoWorkingHours',
                                'name' => 'Info working hours',
                                'type' => 'text',
                                'defaultValue' => '',
                                'description' => 'Set the working hours to be displayed on the info window.',
                            ),
                            array(
                                'id' => 'infoDirections',
                                'name' => 'Show directions button',
                                'type' => 'toggle',
                                'defaultValue' => true,
                                'description' => 'Display directions button in the info window. This button allows to set the directions from your current position to the marker. Works only with https.',
                            ),
                            array(
                                'id' => 'animation',
                                'name' => 'Animation',
                                'type' => 'select-inline',
                                'selectInline' => array(
                                    'options' => array(
                                        array(
                                            'value' => 'none',
                                            'name' => 'None',
                                        ),
                                        array(
                                            'value' => 'drop',
                                            'name' => 'Drop',
                                        ),
                                        array(
                                            'value' => 'bounce',
                                            'name' => 'Bounce',
                                        ),
                                    ),
                                ),
                                'defaultValue' => 'none',
                                'description' => 'Set marker animation.',
                            ),
                            array(
                                'id' => 'linkUrl',
                                'name' => 'Link URL',
                                'type' => 'text',
                                'defaultValue' => '',
                                'description' => 'Set the link URL and this link will be opened in a new browser tab by clicking on the marker.',
                            ),
                        ),
                    ),
                    'allowEmpty' => true,
                    'defaultValue' => array(
                        array(
                            'position' => '1600 Amphitheatre Pkwy, USA',
                            'icon' => 'businessCenter',
                            'infoTitle' => 'Googleplex',
                            'infoDescription' => 'The Googleplex is the corporate headquarters complex of Google, Inc. and its parent company Alphabet Inc.',
                            'infoImage' => 'https://elfsight.com/assets/google-maps-marker-image.jpg',
                            'infoAddress' => '1600 Amphitheatre Pkwy, Mountain View, CA 94043, USA',
                            'infoSite' => 'google.com',
                            'infoPhone' => '+1 650-253-0000',
                            'infoEmail' => 'info@google.com',
                            'infoWorkingHours' => 'from 9am to 6pm CET Monday-Friday',
                        ),
                    ),
                    'description' => 'Add markers to display them on the map.',
                ),
                array(
                    'id' => 'width',
                    'name' => 'Width (px, %, auto)',
                    'tab' => 'layout',
                    'type' => 'text',
                    'defaultValue' => 'auto',
                    'description' => 'Set the map width in pixels or %, or select "auto" and it will fit the container width.',
                ),
                array(
                    'id' => 'height',
                    'name' => 'Height (px)',
                    'tab' => 'layout',
                    'type' => 'text',
                    'defaultValue' => '700',
                    'description' => 'Set the map height in pixels.',
                ),
                array(
                    'id' => 'center',
                    'name' => 'Center (address, coordinates, auto)',
                    'tab' => 'map',
                    'type' => 'text',
                    'defaultValue' => 'auto',
                    'description' => 'Set the default map center. You can set its name or address in text format or set the specific coordinates (latitude, longitude separated by a comma). Set "auto" to automatically calculate the center depending on the markers\' position.',
                ),
                array(
                    'id' => 'zoom',
                    'name' => 'Zoom (0-20, auto)',
                    'tab' => 'map',
                    'type' => 'text',
                    'defaultValue' => '16',
                    'description' => 'Set the default map zoom. It supports numeric values 0-20. You can also set "auto" and zoom will be calculated automatically to display all the set markers.',
                ),
                array(
                    'id' => 'mapType',
                    'name' => 'Map type',
                    'tab' => 'map',
                    'type' => 'select',
                    'select' => array(
                        'options' => array(
                            array(
                                'value' => 'roadmap',
                                'name' => 'Roadmap',
                            ),
                            array(
                                'value' => 'satellite',
                                'name' => 'Satellite',
                            ),
                            array(
                                'value' => 'hybrid',
                                'name' => 'Hybrid',
                            ),
                            array(
                                'value' => 'terrain',
                                'name' => 'Terrain',
                            ),
                        ),
                    ),
                    'defaultValue' => 'roadmap',
                    'description' => 'Select your map type from the list.',
                ),
                array(
                    'id' => 'controls',
                    'name' => 'Controls',
                    'tab' => 'map',
                    'type' => 'checklist',
                    'checklist' => array(
                        'options' => array(
                            array(
                                'value' => 'zoom',
                                'name' => 'Zoom',
                            ),
                            array(
                                'value' => 'mapType',
                                'name' => 'Map Type',
                            ),
                            array(
                                'value' => 'scale',
                                'name' => 'Scale',
                            ),
                            array(
                                'value' => 'streetView',
                                'name' => 'Street View',
                            ),
                            array(
                                'value' => 'rotate',
                                'name' => 'Rotate',
                            ),
                            array(
                                'value' => 'fullscreen',
                                'name' => 'Fullscreen',
                            ),
                        ),
                    ),
                    'defaultValue' => array('zoom','mapType','scale','streetView','rotate','fullscreen'),
                    'description' => 'Select the map controls to be displayed on the map.',
                ),
                array(
                    'id' => 'scrollwheel',
                    'name' => 'Scroll wheel scaling',
                    'tab' => 'map',
                    'type' => 'toggle',
                    'defaultValue' => false,
                    'description' => 'This option lets you scale the map with the mouse scrolling wheel.',
                ),
                array(
                    'id' => 'layers',
                    'name' => 'Layers',
                    'tab' => 'map',
                    'type' => 'checklist',
                    'checklist' => array(
                        'options' => array(
                            array(
                                'value' => 'poi',
                                'name' => 'POI',
                            ),
                            array(
                                'value' => 'traffic',
                                'name' => 'Traffic',
                            ),
                            array(
                                'value' => 'transit',
                                'name' => 'Transit',
                            ),
                            array(
                                'value' => 'bike',
                                'name' => 'Bike',
                            ),
                            array(
                                'value' => 'streetView',
                                'name' => 'Street View',
                            ),
                        ),
                    ),
                    'defaultValue' => array('poi'),
                    'description' => 'Set the layers to be displayed on the map.',
                ),
                array(
                    'id' => 'lang',
                    'name' => 'Language',
                    'tab' => 'map',
                    'type' => 'select',
                    'select' => array(
                        'options' => array(
                            array(
                                'value' => 'en',
                                'name' => 'English',
                            ),
                            array(
                                'value' => 'es',
                                'name' => 'Español',
                            ),
                            array(
                                'value' => 'ru',
                                'name' => 'Русский',
                            ),
                            array(
                                'value' => 'ja',
                                'name' => '日本語'
                            )
                        ),
                    ),
                    'defaultValue' => 'en',
                    'description' => 'Choose one of available languages of the info window UI.',
                ),
                array(
                    'id' => 'style',
                    'name' => 'Color scheme',
                    'tab' => 'style',
                    'type' => 'select',
                    'select' => array(
                        'options' => array(
                            array(
                                'value' => 'default',
                                'name' => 'Default',
                            ),
                            array(
                                'value' => 'silver',
                                'name' => 'Silver',
                            ),
                            array(
                                'value' => 'night',
                                'name' => 'Night',
                            ),
                            array(
                                'value' => 'retro',
                                'name' => 'Retro',
                            ),
                            array(
                                'value' => 'custom',
                                'name' => 'Custom',
                            ),
                        ),
                    ),
                    'defaultValue' => 'default',
                    'description' => 'Select one of the four predefined color schemes. Set custom colors to create your own scheme.',
                ),
                array(
                    'id' => 'customColors',
                    'name' => 'Custom Colors',
                    'tab' => 'style',
                    'type' => 'subgroup',
                    'subgroup' => array(
                        'properties' => array(
                            array(
                                'id' => 'colorGeometry',
                                'name' => 'Geometry',
                                'type' => 'color',
                                'defaultValue' => '',
                            ),
                            array(
                                'id' => 'colorLabelsTextFill',
                                'name' => 'Labels Text Fill',
                                'type' => 'color',
                                'defaultValue' => '',
                            ),
                            array(
                                'id' => 'colorLabelsTextStroke',
                                'name' => 'Labels Text Stroke',
                                'type' => 'color',
                                'defaultValue' => '',
                            ),
                            array(
                                'id' => 'colorAdministrativeGeometryStroke',
                                'name' => 'Administrative Geometry Stroke',
                                'type' => 'color',
                                'defaultValue' => '',
                            ),
                            array(
                                'id' => 'colorAdministrativeLandParcel',
                                'name' => 'Administrative Land Parcel',
                                'type' => 'color',
                                'defaultValue' => '',
                            ),
                            array(
                                'id' => 'colorLandscapeNaturalGeometry',
                                'name' => 'Landscape Natural Geometry',
                                'type' => 'color',
                                'defaultValue' => '',
                            ),
                            array(
                                'id' => 'colorPoiGeometry',
                                'name' => 'Poi',
                                'type' => 'color',
                                'defaultValue' => '',
                            ),
                            array(
                                'id' => 'colorPoiLabelsTextFill',
                                'name' => 'Poi Text Fill',
                                'type' => 'color',
                                'defaultValue' => '',
                            ),
                            array(
                                'id' => 'colorPoiParkGeometryFill',
                                'name' => 'Park Geometry Fill',
                                'type' => 'color',
                                'defaultValue' => '',
                            ),
                            array(
                                'id' => 'colorPoiParkLabelsTextFill',
                                'name' => 'Park Labels Text Fill',
                                'type' => 'color',
                                'defaultValue' => '',
                            ),
                            array(
                                'id' => 'colorRoadGeometry',
                                'name' => 'Road',
                                'type' => 'color',
                                'defaultValue' => '',
                            ),
                            array(
                                'id' => 'colorRoadArterial',
                                'name' => 'Road Arterial',
                                'type' => 'color',
                                'defaultValue' => '',
                            ),
                            array(
                                'id' => 'colorRoadHighway',
                                'name' => 'Road Highway',
                                'type' => 'color',
                                'defaultValue' => '',
                            ),
                            array(
                                'id' => 'colorRoadHighwayGeometryStroke',
                                'name' => 'Road Highway Geometry Stroke',
                                'type' => 'color',
                                'defaultValue' => '',
                            ),
                            array(
                                'id' => 'colorRoadHighwayControlledAccessGeometry',
                                'name' => 'Road Highway Controlled Access Geometry',
                                'type' => 'color',
                                'defaultValue' => '',
                            ),
                            array(
                                'id' => 'colorRoadHighwayControlledAccessGeometryStroke',
                                'name' => 'Road Highway Controlled Access Geometry Stroke',
                                'type' => 'color',
                                'defaultValue' => '',
                            ),
                            array(
                                'id' => 'colorRoadLocalLabelsTextFill',
                                'name' => 'Road Local Labels Text Fill',
                                'type' => 'color',
                                'defaultValue' => '',
                            ),
                            array(
                                'id' => 'colorTransitLineGeometry',
                                'name' => 'Transit Line',
                                'type' => 'color',
                                'defaultValue' => '',
                            ),
                            array(
                                'id' => 'colorTransitLineLabelsTextFill',
                                'name' => 'Transit Line Labels Text Fill',
                                'type' => 'color',
                                'defaultValue' => '',
                            ),
                            array(
                                'id' => 'colorTransitLineLabelsTextStroke',
                                'name' => 'Transit Line Labels Text Stroke',
                                'type' => 'color',
                                'defaultValue' => '',
                            ),
                            array(
                                'id' => 'colorTransitStationGeometry',
                                'name' => 'Transit Station Geometry',
                                'type' => 'color',
                                'defaultValue' => '',
                            ),
                            array(
                                'id' => 'colorWaterGeometryFill',
                                'name' => 'Water',
                                'type' => 'color',
                                'defaultValue' => '',
                            ),
                            array(
                                'id' => 'colorWaterLabelTextFill',
                                'name' => 'Water Labels',
                                'type' => 'color',
                                'defaultValue' => '',
                            ),
                        ),
                    ),
                ),
            ),
        ),
        'editor_preferences' => array(
            'previewUpdateTimeout' => 0
        ),
        'script_url' => plugins_url('assets/elfsight-google-maps.js', __FILE__),

        'plugin_name' => 'Elfsight Google Maps',
        'plugin_file' => __FILE__,
        'plugin_slug' => plugin_basename(__FILE__),

        'vc_icon' => plugins_url('assets/img/vc-icon.png', __FILE__),

        'menu_icon' => plugins_url('assets/img/menu-icon.png', __FILE__),
        'update_url' => 'https://a.elfsight.com/updates/',

        'preview_url' => plugins_url('preview/', __FILE__),
        'observer_url' => plugins_url('preview/google-maps-observer.js', __FILE__),

        'product_url' => 'https://codecanyon.net/item/elfsight-google-maps-wordpress-plugin/20574814?ref=Elfsight',
        'support_url' => 'https://elfsight.ticksy.com/submit/#100010647'
    )
);

?>