<?php
/**
 * WP Courseware Database Table Order Items.
 *
 * @package WPCW
 * @subpackage Database\Tables
 * @since 4.3.0
 */
namespace WPCW\Database\Tables;

// Exit if accessed directly
defined( 'ABSPATH' ) || exit;

/**
 * Class DB_Table_Order_Items.
 *
 * @since 4.3.0
 */
final class DB_Table_Order_Items extends DB_Table {

	/**
	 * @var string Table name
	 * @since 4.3.0
	 */
	protected $name = 'wpcw_order_items';

	/**
	 * @var int Database Table version
	 * @since 4.3.0
	 */
	protected $version = 430;

	/**
	 * Setup the database schema.
	 *
	 * @since 4.3.0
	 */
	protected function set_schema() {
		$this->schema = "order_item_id bigint(20) unsigned NOT NULL AUTO_INCREMENT,
						 order_id bigint(20) unsigned NOT NULL DEFAULT '0',
						 course_id bigint(20) NOT NULL DEFAULT '0',
						 order_item_title text NOT NULL DEFAULT '',
						 order_item_index bigint(20) unsigned NOT NULL DEFAULT '0',
						 type varchar(20) NOT NULL DEFAULT 'course',
						 qty bigint(20) unsigned NOT NULL DEFAULT '0',
						 amount varchar(100) NOT NULL DEFAULT '0',
						 subtotal varchar(100) NOT NULL DEFAULT '0',
						 discount varchar(100) NOT NULL DEFAULT '0',
						 tax varchar(100) NOT NULL DEFAULT '0',
						 total varchar(100) NOT NULL DEFAULT '0',
						 is_recurring tinyint(1) NOT NULL DEFAULT '0',
						 PRIMARY KEY (order_item_id),
						 KEY order_id (order_id),
						 KEY course_id (course_id),
						 KEY type (type),
						 KEY order_course_id (order_id, course_id)";
	}
}