<?php
/**
 * WP Courseware Database Table Question Random Lock.
 *
 * @package WPCW
 * @subpackage Database\Tables
 * @since 4.3.0
 */
namespace WPCW\Database\Tables;

// Exit if accessed directly
defined( 'ABSPATH' ) || exit;

/**
 * Class DB_Table_Question_Random_Lock.
 *
 * @since 4.3.0
 */
final class DB_Table_Question_Random_Lock extends DB_Table {

	/**
	 * @var string Table name
	 * @since 4.3.0
	 */
	protected $name = 'wpcw_question_random_lock';

	/**
	 * @var int Database Table version
	 * @since 4.3.0
	 */
	protected $version = 430;

	/**
	 * Setup the database schema.
	 *
	 * @since 4.3.0
	 */
	protected function set_schema() {
		$this->schema = "question_user_id int(11) unsigned NOT NULL,
						 rand_question_id int(11) unsigned NOT NULL,
						 parent_unit_id int(11) unsigned NOT NULL,
						 question_selection_list text NOT NULL,
						 UNIQUE KEY wpcw_question_rand_lock (question_user_id,rand_question_id)";
	}
}