<?php
/**
 * WP Courseware Database Table Modules.
 *
 * @package WPCW
 * @subpackage Database\Tables
 * @since 4.3.0
 */
namespace WPCW\Database\Tables;

// Exit if accessed directly
defined( 'ABSPATH' ) || exit;

/**
 * Class DB_Table_Modules.
 *
 * @since 4.3.0
 */
final class DB_Table_Modules extends DB_Table {

	/**
	 * @var string Table name
	 * @since 4.3.0
	 */
	protected $name = 'wpcw_modules';

	/**
	 * @var int Database Table version
	 * @since 4.3.0
	 */
	protected $version = 440;

	/**
	 * Setup the database schema.
	 *
	 * @since 4.3.0
	 */
	protected function set_schema() {
		$this->schema = "module_id int(11) unsigned NOT NULL AUTO_INCREMENT,
			             parent_course_id int(11) unsigned NOT NULL DEFAULT '0',
			             module_author bigint(20) unsigned NOT NULL default '0',
			             module_title varchar(150) NOT NULL,
			             module_desc longtext NOT NULL,
			             module_order int(11) unsigned NOT NULL DEFAULT '10000',
			             module_number int(11) unsigned NOT NULL DEFAULT '0',
			             PRIMARY KEY  (module_id)";
	}

	/**
	 * Get Upgrades.
	 *
	 * @since 4.4.0
	 */
	protected function get_upgrades() {
		return array(
			'440' => 'upgrade_to_440',
		);
	}

	/**
	 * Upgrade to version 4.4.0
	 *
	 * @since 4.4.0
	 */
	protected function upgrade_to_440() {
		global $wpdb;

		$module_desc = $wpdb->query( "SHOW COLUMNS FROM $this->table_name LIKE 'module_desc'" );

		if ( $module_desc ) {
			$wpdb->query( "ALTER TABLE $this->table_name MODIFY COLUMN `module_desc` longtext NOT NULL" );
		}
	}
}