<?php
global $post;
if ( isset( $wpbm_option[ 'post_type' ] ) && $wpbm_option[ 'post_type' ] == 'post' ) {
    $tags = get_the_tags();
} else {
    $tags = get_the_terms( $product_post_id, 'product_tag' );
}
$output = '';
if ( ! empty( $tags ) ) {
    foreach ( $tags as $tag ) {
        $output .= '<a href="' . esc_url( get_tag_link( $tag -> term_id ) ) . '" alt="' . esc_attr( sprintf( __( 'View all posts in %s', WPBM_TD ), $tag -> name ) ) . '">' . esc_html( $tag -> name ) . '</a>' . $separator;
    }
    ?>
    <div class="wpbm-tag-list">
        <i class="<?php echo $pular_tag; ?>" aria-hidden="true"></i>
        <?php
        echo trim( $output, $separator );
        ?>
    </div>
    <?php
}
