<?php
global $post;
if ( isset( $wpbm_option[ 'post_type' ] ) && $wpbm_option[ 'post_type' ] == 'post' ) {
    $tags = get_the_tags();
} else {
    $tags = get_the_terms( $product_post_id, 'product_tag' );
}
$output = '';
if ( ! empty( $tags ) ) {
    foreach ( $tags as $tag ) {
        $output .= '<a href="' . esc_url( get_tag_link( $tag -> term_id ) ) . '" alt="' . esc_attr( sprintf( __( 'View all posts in %s', WPBM_TD ), $tag -> name ) ) . '" target="' . $link_target . '">' . $pre_text . esc_html( $tag -> name ) . '</a>' . $separator;
    }
    ?>
    <div class="wpbm-tag-list">
        <?php
        echo trim( $output, $separator );
        ?>
    </div>
    <?php
}

