<div class="wpbm-category-wrap">
    <?php
    if ( isset( $wpbm_option[ 'post_type' ] ) && $wpbm_option[ 'post_type' ] == 'post' ) {
        $categories = get_the_category();
    } else {
        $categories = get_the_terms( $product_post_id, $wpbm_option[ 'select_post_taxonomy' ] );
    }
    $output = '';
    if ( ! empty( $categories ) ) {
        foreach ( $categories as $category ) {
            $output .= '<a href="' . esc_url( get_category_link( $category -> term_id ) ) . '" alt="' . esc_attr( sprintf( __( 'View all posts in %s', WPBM_TD ), $category -> name ) ) . '" target="' . $link_target . '">' . esc_html( $category -> name ) . '</a>' . $separator;
        }
        ?>
        <div class="wpbm-category-list">
            <?php
            echo trim( $output, $separator );
            ?>
        </div>
        <?php
    }
    ?>
</div>