<?php

class WPBM_VC_Elements extends WPBakeryShortCode{

    // Element Init
    function __construct(){
        add_action( 'init', array( $this, 'wpbm_vc_widgets' ) );
        add_shortcode( 'wpbm', array( $this, 'wpbm_vc_shortcode' ) );
    }

    function wpbm_vc_widgets(){
        // Stop all if VC is not enabled
        if ( ! defined( 'WPB_VC_VERSION' ) ) {
            return;
        }
        //Require new custom Element
        $args = array(
            'post_type' => 'wpblogmanager',
            'post_status' => 'publish',
            'posts_per_page' => -1,
            'order' => 'ASC',
            'orderby' => 'id'
        );
        $posts = get_posts( $args );
        if ( ! empty( $posts ) ) {
            foreach ( $posts as $post ) {
                $wpbm_post_types[ $post -> post_title ] = $post -> ID;
            }
        } else {
            $wpbm_post_types[ __( 'No Blog Manager Data found.', WPBM_TD ) ] = '';
        }

        vc_map( array(
            'name' => 'WP Blog Manager Widget',
            'base' => 'wpbm',
            'description' => esc_html__( 'Blog For WordPress', WPBM_TD ),
            'category' => 'WP Blog Manager',
            'icon' => '',
            'params' => array(
                array(
                    'type' => 'dropdown',
                    'heading' => esc_html__( 'WP Blog Manager', WPBM_TD ),
                    'param_name' => 'id',
                    'class' => 'wpbm-lists',
                    'save_always' => true,
                    'value' => $wpbm_post_types,
                    'description' => esc_html__( 'Select any blog manager post title and add it to your post or page.', WPBM_TD ),
                )
            )
        ) );
    }

    // Element HTML
    public function wpbm_vc_shortcode( $atts, $content = null ){

        ob_start();
        include(WPBM_PATH . 'inc/frontend/wpbm-frontend.php');
        $blog = ob_get_contents();
        ob_end_clean();
        return $blog;
    }

}

new WPBM_VC_Elements();
