<div class="wpbm-import-wrapper">
    <h3><?php _e( 'Import Settings', WPBM_TD ); ?></h3>
    <form method="post" action="<?php echo admin_url( 'admin-post.php' ); ?>" enctype="multipart/form-data">
        <input type="hidden" name="action" value="wpbm_import_form_action"/>
        <?php wp_nonce_field( 'wpbm-import-nonce', 'wpbm_import_nonce_field' ); ?>
        <div class="wpbm-field-wrapper wpbm-import-wrapper">
            <div class="wpbm-column-full-width">
                <div class="wpbm-post-option-wrap wpbm-clearfix">
                    <label>
                        <?php _e( "Choose Import File Type", WPBM_TD ); ?>
                    </label>
                    <div class="wpbm-post-field-wrap">
                        <select name="wpbm_import_file_type" class="wpbm-impfiletype">
                            <option value=""><?php _e( 'Choose File', WPBM_TD ); ?></option>
                            <option value="demo_json"><?php _e( "Upload Our Demo File", WPBM_TD ); ?></option>
                            <option value="custom_json"><?php _e( "Upload Custom File", WPBM_TD ); ?></option>
                        </select>
                        <p class="description"><?php _e( 'Choose import file type using json file.', WPBM_TD ); ?></p>
                    </div>
                </div>
            </div>
            <div class="wpbm-column-full-width wpbm-demo-upload-wrapper" style="display:none;">
                <div class="wpbm-post-option-wrap wpbm-clearfix">

                    <label class="wpbm-label-inline">
                        <?php _e( "Select Demo File", WPBM_TD ); ?>
                    </label>

                    <div class="wpbm-post-field-wrap">
                        <?php
                        $template_details = $this -> wpbm_get_template_list();
                        ?>
                        <select name="demo_import_file"  id="wpbm-demo-choice"><?php
                            foreach ( $template_details as $key ) {
                                $slug = $key -> template_slug;
                                $template_name = $key -> template_name;
                                ?>
                                <option value="<?php echo $slug; ?>">
                                    <?php echo $template_name; ?>
                                </option>
                            <?php }
                            ?>
                        </select>
                        <p class="description"><?php _e( 'Choose wp blog manager template builder demo file.', WPBM_TD ); ?></p>

                    </div>
                </div>
            </div>
            <div class="wpbm-column-full-width wpbm-custom-upload-wrapper" style="display:none;">
                <div class="wpbm-post-option-wrap wpbm-clearfix">

                    <label class="wpbm-label-inline">
                        <?php _e( "Upload Custom File", WPBM_TD ); ?>
                    </label>

                    <div class="wpbm-post-field-wrap">

                        <div class="fileUpload">
                            <input id="wpbm_uploadimport_btn" type="file" class="upload" name="import_wpbm_file" />
                        </div>
                        <p class="description"><?php _e( 'Import Custom Blog of our plugin using json file.', WPBM_TD ); ?></p>
                    </div>
                </div>
            </div>
            <div class="wpbm-post-option-wrap wpbm-clearfix">
                <div class="wpbm-post-field-wrap">
                    <input type="submit" name="import_wpbm_submit" value="<?php _e( 'Import', WPBM_TD ); ?>" class="button button-secondary wpbm-default-button"/>
                </div>
            </div>
        </div>
    </form>
</div>