<?php

global $wpdb;
if ( isset( $_POST[ 'action' ] ) && $_POST[ 'action' ] == 'wpbm_export_form_action' && wp_verify_nonce( $_POST[ 'wpbm_export_nonce_field' ], 'wpbm-export-nonce' ) ) {
    $post_id = (isset( $_POST[ 'wpbm_export_id' ] ) && $_POST[ 'wpbm_export_id' ] != '') ? intval( $_POST[ 'wpbm_export_id' ] ) : '';
    if ( $post_id != '' ) {
        $post_arr = get_post( $post_id );
        $current_user = wp_get_current_user();
        $new_post_author = $current_user -> ID;
        if ( isset( $post_arr ) && $post_arr != null ) {
            $filename = sanitize_title( $post_arr -> post_name );
            $args = array(
                'comment_status' => $post_arr -> comment_status,
                'ping_status' => $post_arr -> ping_status,
                'post_author' => $new_post_author,
                'post_content' => $post_arr -> post_content,
                'post_excerpt' => $post_arr -> post_excerpt,
                'post_name' => $post_arr -> post_name,
                'post_parent' => $post_arr -> post_parent,
                'post_password' => $post_arr -> post_password,
                'post_status' => 'draft',
                'post_title' => $post_arr -> post_title,
                'post_type' => $post_arr -> post_type,
                'to_ping' => $post_arr -> to_ping,
                'menu_order' => $post_arr -> menu_order
            );
            $post_meta_infos = $wpdb -> get_results( "SELECT meta_key, meta_value FROM {$wpdb -> postmeta} WHERE post_id=$post_id" );
            if ( count( $post_meta_infos ) != 0 ) {
                foreach ( $post_meta_infos as $meta_info ) {
                    $meta_key = $meta_info -> meta_key;
                    if ( $meta_key == '_wp_old_slug' )
                        continue;
                    $meta_value = addslashes( $meta_info -> meta_value );
                    $args[ 'key' ][ $meta_key ] = $meta_value;
                }
            }
            $json = json_encode( $args );
            header( 'Content-disposition: attachment; filename=' . $filename . '.json' );
            header( 'Content-type: application/json' );
            echo( $json );
        }else {
            wp_redirect( admin_url( 'edit.php?post_type=wpblogmanager&page=wpbm-common-settings-page&message=2' ) );
            exit;
        }
    }
} else {
    die( 'No script kiddies please!!' );
}