<?php
function wt_custom_admin_css() {
	$we_layout_purpose = get_option('wt_slayout_purpose');
	$wt_main_purpose = get_option('wt_main_purpose');
	if(($we_layout_purpose != 'tour' && $wt_main_purpose !='tour' ) || $wt_main_purpose =='custom'){
		if($wt_main_purpose ==''){ return;}
		echo '<style>
		.post-type-product .postbox-container #time-settings.postbox,
		.post-type-product .postbox-container #tour-info.postbox,
		.post-type-product .postbox-container #additional-information.postbox,
		.post-type-product .postbox-container #layout-settings.postbox,
		.post-type-product .postbox-container #custom-field.postbox{display: none;}
		</style>';
	}
	echo '<style>.edit_form_line input.cat.textfield[name=cat]{display: inline-block !important;}</style>';
}
add_action( 'admin_head', 'wt_custom_admin_css' );
function wt_add_admin_ct_class( $classes ) {
	$purpose = get_option('wt_main_purpose');
	$we_layout_purpose = get_option('wt_slayout_purpose');
	if( $purpose != 'meta' && $purpose != 'custom'){
		$classes .= $wt_dbclss = 'wt-hidden-st';
	}else if( $purpose == 'meta' && $we_layout_purpose=='tour'){
		$classes .= $wt_dbclss = 'wt-hidden-st';
	}
	return $classes;
}
add_filter( 'admin_body_class', 'wt_add_admin_ct_class');

if(!function_exists('wt_convent_weekday_to_export')){
	add_action('admin_init','wt_convent_weekday_to_export',999);
	function wt_convent_weekday_to_export() {
		if(current_user_can( 'manage_options' ) && isset($_GET['action']) && $_GET['action'] =='convert-wd'){
			$args = array(
				'post_type' => 'product',
				'post_status' => 'publish',
				'posts_per_page' => -1,
				'meta_query' => array(
					array(
						'key'     => 'wt_weekday',
						'compare' => 'EXISTS',
					),
				),
			);
			$ex_posts = get_posts( $args );
			foreach($ex_posts as $item){
				$wt_weekday = get_post_meta($item->ID,'wt_weekday',true);
				if(is_array($wt_weekday)){
					$wt_weekday = implode(",",$wt_weekday);
					update_post_meta( $item->ID, 'wt_wdays',  $wt_weekday);
				}
			}
			wp_redirect( admin_url() );
			exit;
			
		}
		return;
	}
}


/***** add filter order by tour date *****/
if(!function_exists('exwt_admin_filter_order_tour_date')){
	function exwt_admin_filter_order_tour_date( $post_type, $which ) {
		if ( $post_type == 'shop_order' ) {	
			wp_enqueue_script('jquery-ui-core');
			wp_enqueue_script('jquery-ui-datepicker');
			wp_enqueue_script('jquery-ui-datetimepicker');
			// Display filter HTML
			echo '<input type="text" class="date-picker" name="_tour_date" placeholder="'.esc_html__( 'Select tour date', 'woo-tour' ).'" value="'.(isset( $_GET['_tour_date'] ) ? $_GET['_tour_date'] : '' ).'">';
		}
	
	}
	add_action( 'restrict_manage_posts', 'exwt_admin_filter_order_tour_date' , 10, 2);
}
add_action( 'pre_get_posts','exwt_admin_filter_tour_date_qr',101 );
if (!function_exists('exwt_admin_filter_tour_date_qr')) {
	function exwt_admin_filter_tour_date_qr($query) {
		if ( isset($_GET['post_type']) && $_GET['post_type']=='shop_order' && is_admin()) {
			if( isset($_GET['_tour_date']) && $_GET['_tour_date']!='' ){
				$tdate = str_replace('-', '_', $_GET['_tour_date']);
				$ids = exwt_admin_search_ordeby_date($tdate);
				if($ids=='' || empty($ids)){
					$query->set('post__in', array(0));
				}else{
					$query->set('post__in', $ids);
				}
			}
		}
	}
}
function exwt_admin_search_ordeby_date($date){
	global $wpdb;
	$result = $wpdb->get_col( $wpdb->prepare( "
	    SELECT oi.order_id
	    FROM {$wpdb->prefix}woocommerce_order_items as oi
	    LEFT JOIN {$wpdb->prefix}woocommerce_order_itemmeta as oim
	        ON oi.order_item_id = oim.order_item_id
	    LEFT JOIN {$wpdb->posts} AS p
	        ON oi.order_id = p.ID
	    WHERE p.post_type = 'shop_order'
	    AND oi.order_item_type = 'line_item'
	    AND oim.meta_key = '_metadate'
	    AND oim.meta_value = '%s'
	    ORDER BY oi.order_id DESC
	", $date ) );
	return $result;
}