<?php
/**
 * Plugin Name: WooCommerce Orders Progress bar
 * Plugin URI: http://www.appknitters.com/
 * Description: Displays visual progress bar on orders and single order pages in customer's My Account.
 * Version: 1.5.0
 * Author: پرشین اسکریپت
 * Author URI: http://www.persianscript.ir
 * Tested up to: 5.0.2
 *
 * Text Domain: woocommerce_order_progressbar
 * Domain Path: /lang/
 * 
 */
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly


include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
if (!is_plugin_active('woocommerce/woocommerce.php')) {
    return;
}
if (!defined('WCOPB_VER')) {
    define('WCOPB_VER', 1.5);
}
if (!class_exists('ANWC_Order_Progress_Bar')) {

    class ANWC_Order_Progress_Bar {

        private $options;

        public function __construct() {
            // Get defualt options
            $defaults = $this->get_default_options();
            // loading saved options.
            $options = get_option('anwc_order_progressbar');
            $this->options = wp_parse_args($options, $defaults);

            // adding settings page menu.
            add_action('admin_menu', array($this, 'admin_menu'));

            // rendering settings feilds 
            add_action('admin_init', array($this, 'admin_init'));
            // add css file for progress bar.
            add_action('wp_enqueue_scripts', array($this, 'scripts'));

            add_action('admin_enqueue_scripts', array($this, 'admin_scripts'));

            // Emails
            add_action('woocommerce_email_header', array($this, 'woocommerce_email_header'), 100, 2);

            //Adding markup in my-account
            add_action('woocommerce_my_account_my_orders_column_order-status', array($this, 'my_orders_column'));
            add_action('woocommerce_view_order', array($this, 'my_orders_column'));
            add_action('woocommerce_thankyou', array($this, 'my_orders_column'));
            add_action('manage_shop_order_posts_custom_column', array($this, 'shop_orders_column'), 10, 2);
        }

        public function scripts() {

            if (is_admin()) {
                
            } else {

                $selected_statuses = $this->options['wc_statuses'];
                $my_account_id = get_option('woocommerce_myaccount_page_id');
                $my_account = get_post_field('post_name', get_option('woocommerce_myaccount_page_id'));
                $checkout_page_id = woocommerce_get_page_id( 'checkout' );
                $checkout_page = get_post_field('post_name',$checkout_page_id);
                $is_orders_page = isset($this->options['is_orders_page']);
                $orders_page_slug = get_option('woocommerce_myaccount_orders_endpoint');
                $is_view_order_page = isset($this->options['is_view_order_page']);
                $view_order_page_slug = get_option('woocommerce_myaccount_view_order_endpoint');
                $is_order_received_page = isset($this->options['is_order_received_page']);
                $order_received_page_slug = get_option('woocommerce_checkout_order_received_endpoint');
                $is_order_tracking_page = isset($this->options['is_order_tracking_page']);
                $style_options['theme'] = isset($this->options['theme']) ? $this->options['theme'] : '';
                $style_options['color'] = isset($this->options['color']) ? $this->options['color'] : '';
                $style_options['bgcolor'] = isset($this->options['bgcolor']) ? $this->options['bgcolor'] : '';
                $style_options['border'] = isset($this->options['border']) ? $this->options['border'] : '';
                $border_style = array('corners' => 0, 'rounded' => 10, 'circle' => 20);
                $style = ".meter:after {border-color:" . $this->darken_color($style_options['color']) . " !important;-moz-border-radius: {$border_style[$this->options['border']]}px;-webkit-border-radius: {$border_style[$this->options['border']]}px;border-radius: {$border_style[$this->options['border']]}px; } .meter span:after{background:" . $this->darken_color($style_options['color']) . " !important;-moz-border-radius: {$border_style[$this->options['border']]}px;-webkit-border-radius: {$border_style[$this->options['border']]}px;border-radius: {$border_style[$this->options['border']]}px; }.meter {-moz-border-radius: {$border_style[$this->options['border']]}px;-webkit-border-radius: {$border_style[$this->options['border']]}px;border-radius: {$border_style[$this->options['border']]}px; } .meter span{-moz-border-radius: {$border_style[$this->options['border']]}px;-webkit-border-radius: {$border_style[$this->options['border']]}px;border-radius: {$border_style[$this->options['border']]}px; }";
                
               
                $display_view_orders = false;
                if ($is_view_order_page && (strstr($_SERVER['REQUEST_URI'], $my_account . "/{$view_order_page_slug}/") || (isset($_REQUEST['page_id']) && $_REQUEST['page_id'] == $my_account_id && isset($_REQUEST['view-order'])))) {
                    $display_view_orders = true;
                } elseif ($is_order_received_page && (strstr($_SERVER['REQUEST_URI'], $checkout_page . "/{$order_received_page_slug}/") || (isset($_REQUEST['page_id']) && $_REQUEST['page_id'] == $checkout_page_id && isset($_REQUEST['order-received'])))) {
                    $display_view_orders = true;
                } elseif ($is_order_tracking_page && $_POST['track']=='Track') {
                    $display_view_orders = true;
                }
                if ($is_orders_page && (strstr($_SERVER['REQUEST_URI'], $my_account . "/{$orders_page_slug}/") || (isset($_REQUEST['page_id']) && $_REQUEST['page_id'] == $my_account_id && isset($_REQUEST['orders'])))) {
                    //Progress bar theme 
                    wp_enqueue_style ('anwc_progress_bar', plugin_dir_url (__FILE__) . 'css/progress-bar.css');
                    wp_add_inline_style ('anwc_progress_bar', $style);
                    // Script to trigger bar
                    wp_enqueue_script ('anwc_progress_bar_functions', plugin_dir_url (__FILE__) . 'js/functions.js', array ('jquery'));
                    wp_register_script ('anwc_progress_bar', plugin_dir_url (__FILE__) . 'js/progress_bar_orders.js', array ('jquery'));
                    wp_localize_script ('anwc_progress_bar', 'anwc_stages', $selected_statuses);
                    wp_localize_script ('anwc_progress_bar', 'anwc_style', $style_options);
                    wp_enqueue_script ('anwc_progress_bar');
                    } elseif ($display_view_orders) {
                    // Theme
                    wp_enqueue_style('anwc_progress_bar', plugin_dir_url(__FILE__) . 'css/progress-bar.css');
                    wp_add_inline_style('anwc_progress_bar', $style);
                    // Script to trigger bar
                    wp_enqueue_script('anwc_progress_bar_functions', plugin_dir_url(__FILE__) . 'js/functions.js', array('jquery'));
                    wp_register_script('anwc_progress_bar', plugin_dir_url(__FILE__) . 'js/progress_bar_view_order.js', array('jquery'));
                    wp_localize_script('anwc_progress_bar', 'anwc_stages', $selected_statuses);
                    wp_localize_script('anwc_progress_bar', 'anwc_style', $style_options);
                    wp_enqueue_script('anwc_progress_bar');
                }
            }
        }

        public function admin_scripts($page) {
            if (isset($_GET['page']) && $_GET['page'] == 'anwc_order_progressbar') {
                $wp_scripts = wp_scripts();
                wp_enqueue_style('anwc_progress_bar', plugin_dir_url(__FILE__) . 'css/progress-bar.css');
                wp_enqueue_style('spectrum', plugin_dir_url(__FILE__) . 'css/spectrum.css');
                wp_enqueue_style('jquery-ui', 'http://ajax.googleapis.com/ajax/libs/jqueryui/' . $wp_scripts->registered['jquery-ui-core']->ver . '/themes/smoothness/jquery-ui.css');
                wp_enqueue_style('anwc_progress_bar_options', plugin_dir_url(__FILE__) . 'css/admin_options.css');
                wp_enqueue_script('jquery-ui-core');
                wp_enqueue_script('jquery-ui-sortable');
                wp_enqueue_script('jquery-ui-tabs');
                wp_enqueue_script('spectrum', plugin_dir_url(__FILE__) . 'js/spectrum.js', array('jquery'));
                wp_enqueue_script('anwc_progress_bar_functions', plugin_dir_url(__FILE__) . 'js/functions.js', array('jquery'));
                wp_enqueue_script('anwc_progress_bar_options', plugin_dir_url(__FILE__) . 'js/admin_options.js', array('jquery', 'jquery-ui-sortable', 'jquery-ui-tabs'));
            }

            $selected_statuses = $this->options['wc_statuses'];


            $is_admin_orders_page = isset($this->options['is_admin_orders_page']);
            $style_options['theme'] = isset($this->options['theme']) ? $this->options['theme'] : '';
            $style_options['color'] = isset($this->options['color']) ? $this->options['color'] : '';
            $style_options['bgcolor'] = isset($this->options['bgcolor']) ? $this->options['bgcolor'] : '';
            $style_options['border'] = isset($this->options['border']) ? $this->options['border'] : '';
            $border_style = array('corners' => 0, 'rounded' => 10, 'circle' => 20);
            $style = ".meter:after {border-color:" . $this->darken_color($style_options['color']) . " !important;-moz-border-radius: {$border_style[$this->options['border']]}px;-webkit-border-radius: {$border_style[$this->options['border']]}px;border-radius: {$border_style[$this->options['border']]}px; } .meter span:after{background:" . $this->darken_color($style_options['color']) . " !important;-moz-border-radius: {$border_style[$this->options['border']]}px;-webkit-border-radius: {$border_style[$this->options['border']]}px;border-radius: {$border_style[$this->options['border']]}px; }.meter {-moz-border-radius: {$border_style[$this->options['border']]}px;-webkit-border-radius: {$border_style[$this->options['border']]}px;border-radius: {$border_style[$this->options['border']]}px; } .meter span{-moz-border-radius: {$border_style[$this->options['border']]}px;-webkit-border-radius: {$border_style[$this->options['border']]}px;border-radius: {$border_style[$this->options['border']]}px; }";

            if ($is_admin_orders_page && $page == 'edit.php' && $_GET['post_type'] == 'shop_order') {
                //Progress bar theme 
                wp_enqueue_style('anwc_progress_bar', plugin_dir_url(__FILE__) . 'css/progress-bar.css');
                wp_add_inline_style('anwc_progress_bar', $style);
                // Script to trigger bar
                wp_enqueue_script('anwc_progress_bar_functions', plugin_dir_url(__FILE__) . 'js/functions.js', array('jquery'));
                wp_register_script('anwc_progress_bar', plugin_dir_url(__FILE__) . 'js/admin-progress_bar_orders.js', array('jquery'));
                wp_localize_script('anwc_progress_bar', 'anwc_stages', $selected_statuses);
                wp_localize_script('anwc_progress_bar', 'anwc_style', $style_options);
                wp_enqueue_script('anwc_progress_bar');
            }
        }

        // adds custom menu to admin menu. we are adding our Order deadlines menu here 
        public function admin_menu() {

            add_submenu_page('woocommerce', 'Progress Bar', 'Orders Progress Bar', 'manage_woocommerce', 'anwc_order_progressbar', array($this, 'admin_menu_settings'));
        }

        public function admin_menu_settings() {
            $wc_statuses = wc_get_order_statuses();
            // Set class property
            ?>
            <div class="wrap">
                <h1>Progress bar settings</h1>
                <form method="post" action="options.php">
                    <?php
                    // This prints out all hidden setting fields
                    settings_fields('anwc_order_progressbar_options');
                    do_settings_sections('anwc_order_progressbar');
                    //do_settings_fields( 'anwc_order_progressbar',false );
                    submit_button();
                    ?>
                </form>
            </div>
            <?php
        }

        public function admin_init() {
            register_setting(
                    'anwc_order_progressbar_options', // Option group
                    'anwc_order_progressbar', // Option name
                    array($this, 'sanitize') // Sanitize
            );
            add_settings_section(
                    'anwc_order_progressbar_basic', // ID
                    'Basic', // Title
                    array($this, 'print_basic_info'), // Callback
                    'anwc_order_progressbar' // Page
            );
            add_settings_field(
                    'wc_statuses', // ID
                    'Statuses to use', // Title 
                    array($this, 'wc_statuses_callback'), // Callback
                    'anwc_order_progressbar', // Page
                    'anwc_order_progressbar_basic' // Section           
            );

            add_settings_section(
                    'anwc_order_progressbar_pages', // ID
                    'Pages', // Title
                    array($this, 'print_pages_info'), // Callback
                    'anwc_order_progressbar' // Page
            );

            add_settings_field(
                    'is_orders_page', // ID
                    '', // Title 
                    array($this, 'wc_is_orders_page_callback'), // Callback
                    'anwc_order_progressbar', // Page
                    'anwc_order_progressbar_pages' // Section           
            );

            add_settings_field(
                    'is_view_order_page', // ID
                    '', // Title 
                    array($this, 'wc_is_view_order_page_callback'), // Callback
                    'anwc_order_progressbar', // Page
                    'anwc_order_progressbar_pages' // Section           
            );
            add_settings_field(
                    'is_order_tracking_page', // ID
                    '', // Title 
                    array($this, 'wc_is_order_tracking_page_callback'), // Callback
                    'anwc_order_progressbar', // Page
                    'anwc_order_progressbar_pages' // Section           
            );
            add_settings_field(
                    'is_order_received_page', // ID
                    '', // Title 
                    array($this, 'wc_is_order_reveived_page_callback'), // Callback
                    'anwc_order_progressbar', // Page
                    'anwc_order_progressbar_pages' // Section           
            );

            add_settings_field(
                    'is_admin_orders_page', // ID
                    '', // Title 
                    array($this, 'wc_is_admin_orders_page_callback'), // Callback
                    'anwc_order_progressbar', // Page
                    'anwc_order_progressbar_pages' // Section           
            );

            add_settings_field(
                    'is_emails', // ID
                    '', // Title 
                    array($this, 'wc_is_emails_page_callback'), // Callback
                    'anwc_order_progressbar', // Page
                    'anwc_order_progressbar_pages' // Section           
            );

            add_settings_section(
                    'anwc_order_progressbar_style', // ID
                    'Style', // Title
                    array($this, 'print_style_info'), // Callback
                    'anwc_order_progressbar' // Page
            );
            add_settings_field(
                    'theme', // ID
                    'Theme', // Title 
                    array($this, 'wc_theme_callback'), // Callback
                    'anwc_order_progressbar', // Page
                    'anwc_order_progressbar_style' // Section           
            );

            add_settings_field(
                    'border', // ID
                    'Border', // Title 
                    array($this, 'wc_border_callback'), // Callback
                    'anwc_order_progressbar', // Page
                    'anwc_order_progressbar_style' // Section           
            );

            add_settings_field(
                    'preview', // ID
                    '', // Title 
                    array($this, 'wc_preview_callback'), // Callback
                    'anwc_order_progressbar', // Page
                    'anwc_order_progressbar_style' // Section           
            );
        }

        public function wc_statuses_callback() {
            $statuses = wc_get_order_statuses();
            $selected_arr = $this->options['wc_statuses'];
            if (!is_array($selected_arr)) {
                $selected_arr = array();
            }
            ?>

            <div id="wc_statuses" style="display:none">

                <?php foreach ($selected_arr as $key => $title): ?>
                    <input type="hidden" value="<?php echo $title; ?>" name="anwc_order_progressbar[wc_statuses][<?php echo $key; ?>]">
                <?php endforeach; ?>

            </div>
            <div id="statuses_selection_container">

                <div id="left">
                    <p>All Statuses</p>
                    <ul id="all_statuses" class="connected">
                        <?php foreach ($statuses as $slug => $title): ?>
                            <?php if (!in_array($title, $selected_arr)): ?>
                                <li data-id="<?php echo $slug; ?>" ><?php echo $title; ?></li>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <div id="right">
                    <p>Selected</p>
                    <ul id="selected_statuses" class="connected">
                        <?php foreach ($selected_arr as $slug => $title): ?>

                            <li data-id="<?php echo $slug; ?>"><?php echo $title; ?></li>

                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
            <span> Please drop status of your choice from left panel into right panel. you can re-arrange status position on progress bar by dragging up and down in right(Selected) panel.</span>

            <?php
        }

        public function wc_is_orders_page_callback() {
            $checked = isset($this->options['is_orders_page']) ? $this->options['is_orders_page'] : '';
            ?>
            <label for="is_orders_page" ><input type="checkbox" id="is_orders_page" name="anwc_order_progressbar[is_orders_page]" <?php checked($checked, 'on'); ?>/> Orders Page</label>

            <?php
        }

        public function wc_is_view_order_page_callback() {
            $checked = isset($this->options['is_view_order_page']) ? $this->options['is_view_order_page'] : '';
            ?>
            <label for="is_view_order_page" ><input type="checkbox" id="is_view_order_page" name="anwc_order_progressbar[is_view_order_page]" <?php checked($checked, 'on'); ?>/> View order page</label>

            <?php
        }

        public function wc_is_order_reveived_page_callback() {
            $checked = isset($this->options['is_order_received_page']) ? $this->options['is_order_received_page'] : '';
            ?>
            <label for="is_order_received_page" ><input type="checkbox" id="is_order_received_page" name="anwc_order_progressbar[is_order_received_page]" <?php checked($checked, 'on'); ?>/> Order received page</label>

            <?php
        }

        public function wc_is_order_tracking_page_callback() {
            $checked = isset($this->options['is_order_tracking_page']) ? $this->options['is_order_tracking_page'] : '';
            ?>
            <label for="is_order_tracking_page" ><input type="checkbox" id="is_order_tracking_page" name="anwc_order_progressbar[is_order_tracking_page]" <?php checked($checked, 'on'); ?>/> Order tracking page</label>

            <?php
        }

        public function wc_is_admin_orders_page_callback() {
            $checked = isset($this->options['is_admin_orders_page']) ? $this->options['is_admin_orders_page'] : '';
            ?>
            <label for="is_admin_orders_page" ><input type="checkbox" id="is_admin_orders_page" name="anwc_order_progressbar[is_admin_orders_page]" <?php checked($checked, 'on'); ?>/> Admin orders listing page</label>

            <?php
        }

        public function wc_is_emails_page_callback() {
            $checked = isset($this->options['is_emails']) ? $this->options['is_emails'] : '';
            ?>
            <label for="is_emails" ><input type="checkbox" id="is_emails" name="anwc_order_progressbar[is_emails]" <?php checked($checked, 'on'); ?>/> Order Emails</label>

            <?php
        }

        public function wc_theme_callback() {

            $selected = isset($this->options['theme']) ? $this->options['theme'] : '';
            $color = isset($this->options['color']) ? $this->options['color'] : '';
            $bgcolor = isset($this->options['bgcolor']) ? $this->options['bgcolor'] : 'lightgray';

            $themes = ['stripes' => 'Stripes', 'glow' => 'Glow', 'shine' => 'Shine'];

            $themes = apply_filters('an_orders_progress_bar_themes', $themes);
            ?>

            <select id="theme" name="anwc_order_progressbar[theme]"  >
                <option value="" <?php selected($selected, ''); ?>>Default</option>
                <?php foreach ($themes as $key => $title): ?>
                    <option value="<?php echo $key; ?>" <?php selected($selected, $key); ?>><?php echo $title ?></option>
                <?php endforeach; ?>
            </select>
            <p>
                <label for="color">
                    <input type="text" id="color" name="anwc_order_progressbar[color]" value="<?php echo $color; ?>"/>
                    <span>Progress color</span>
                </label>
            </p>
            <p>
                <label for="bgcolor">
                    <input type="text" id="bgcolor" name="anwc_order_progressbar[bgcolor]" value="<?php echo $bgcolor; ?>"/>
                    <span>Background color</span>
                </label>
            </p>


            <?php
        }

        public function wc_border_callback() {

            $selected = isset($this->options['border']) ? $this->options['border'] : '';
            ?>
            <select id="border" name="anwc_order_progressbar[border]"  >
                <option value="corners" <?php selected($selected, 'corners'); ?>>Corners</option>
                <option value="rounded" <?php selected($selected, 'rounded'); ?>>Rounded</option>
                <option value="circle" <?php selected($selected, 'circle'); ?>>Circle</option>

            </select>

            <?php
        }

        public function wc_preview_callback() {
            ?>
            <div id="anwcpb_preview"></div>
            <?php
        }

        public function sanitize($input) {
            $new_input = array();
            // if (isset($input['wc_statuses']))
            //$input['wc_statuses'] = serialize($input['wc_statuses']);
            return $input;
        }

        public function print_basic_info() {
            print 'Please select woocommerce statuses to display in progress bar.';
        }

        public function print_pages_info() {
            print 'Please select pages on which you want to display progress bar.';
        }

        public function print_style_info() {
            print 'Please select style related options for your bar.';
        }

        public function woocommerce_email_header($heading, $email = false) {

            $is_emails = isset($this->options['is_emails']);
            $order = $email->object;

            if ($is_emails && is_object($order) && is_a($order, 'WC_Order')) {
                $stages = $this->options['wc_statuses'];
                $wc_statuses = wc_get_order_statuses();

                $stage_slug = $order->get_status();
                $stage = $wc_statuses['wc-' . $stage_slug];


                $style_options['theme'] = isset($this->options['theme']) ? $this->options['theme'] : '';
                $style_options['color'] = isset($this->options['color']) ? $this->options['color'] : '';
                $style_options['bgcolor'] = isset($this->options['bgcolor']) ? $this->options['bgcolor'] : 'lightgray';
                $style_options['border'] = isset($this->options['border']) ? $this->options['border'] : '';
                $border_style = array('corners' => 0, 'rounded' => 10, 'circle' => 20);

                $style = array();
                $style['meter'] = "-moz-border-radius: {$border_style[$this->options['border']]}px;-webkit-border-radius: {$border_style[$this->options['border']]}px;border-radius: {$border_style[$this->options['border']]}px;height: 30px;position: relative;background:" . $style_options['bgcolor'] . ";box-shadow: inset 0 -1px 1px rgba(255,255,255,0.3);";
                $style['meter:after'] = "border-color:" . $this->darken_color($style_options['color']) . " !important;-moz-border-radius: {$border_style[$this->options['border']]}px;-webkit-border-radius: {$border_style[$this->options['border']]}px;border-radius: {$border_style[$this->options['border']]}px; }";
                $style['meter span'] = "border-radius: {$border_style[$this->options['border']]}px;background:" . $style_options['color'] . ";display: block;height: 100%;position: relative;overflow: hidden;";
                $style['meter span:after'] = "background:" . $this->darken_color($style_options['color']) . " !important;-moz-border-radius: {$border_style[$this->options['border']]}px;-webkit-border-radius: {$border_style[$this->options['border']]}px;border-radius: {$border_style[$this->options['border']]}px;float:right;display:block;height:30px;width:30px;overflow:hidden;";
                /* 	
                  if($style_options['theme']=='stripes'){
                  $style['meter']='';
                  $style['meter:after']='';
                  $style['meter span'] = '';
                  $style['meter span:after'] ='';
                  }elseif($style_options['theme']=='glow'){
                  $style['meter']='';
                  $style['meter:after']='';
                  $style['meter span'] = '';
                  $style['meter span:after'] ='';
                  }elseif($style_options['theme']=='shine'){
                  $style['meter']='';
                  $style['meter:after']='';
                  $style['meter span'] = '';
                  $style['meter span:after'] ='';
                  }else{
                  $style['meter']='';
                  $style['meter:after']='';
                  $style['meter span'] = '';
                  $style['meter span:after'] ='';
                  }
                 */

                $stage_scores = array();
                $stage_name_html = '';
                $unit = 100 / (count($stages) - 1);
                $stage_unit = 100 / count($stages);
                $i = 0;
                foreach ($stages as $slug => $_stage) {
                    $stage_scores[$_stage] = ($unit * $i) ? $unit * $i : 7;
                    $display = 'inline-block';
                    if ($i == (count($stages) - 1)) {
                        $display = 'inline';
                    }
                    $last = $i == (count($stages) - 1) ? 'text-align:right;' : 'text-align:left;';
                    $current = $stage == $_stage ? 'font-weight:900;text-decoration:underline;' : 'font-weight:normal;';
                    $stage_name_html .= '<span style="' . $current . $last . ' width:' . ($unit - 5) . '%;font-size:10px;white-space:nowrap;display:' . $display . ';">' . $_stage . '</span>';
                    $i++;
                }

                $order_number = trim(str_replace('#', '', $order->get_order_number()));
                $html = '<div id="progress_bar" style="width:80%;margin:0 auto;">'
                        . '<div class="meter" style="' . $style['meter'] . '">'
                        . '<div style="width: ' . ($stage_scores[$stage] == 100 ? '100' : $stage_scores[$stage]) . '%;' . $style['meter span'] . '">'
                        . '<span class="after" style="' . $style['meter span:after'] . '"></span>'
                        . '</div>'
                        //. '<span class="meter_after" style="display:block;height:26px;width:26px;background:transparent;-moz-border-radius:20px;-webkit-border-radius:20px;border-radius:20px;border:2px solid darkgreen;overflow:hidden;"></span>'
                        . '</div>'
                        . '<div class="stage_names" style="width:100%;">' . $stage_name_html . '</div>'
                        . '</div><br><br>';
                echo $html;
            }
        }

        public function my_orders_column($order) {
            if (is_object($order)) {
                $order_number = $order->get_id();
                $order_status = $order->get_status();
                echo wc_get_order_status_name($order_status);
            } else {
                $order_number = $order;
                $order = wc_get_order($order);
                $order_status = $order->get_status();
            }
            ?>

            <input type="hidden" id="opb_order_number" value="<?php echo $order_number; ?>" />
            <input type="hidden" id="opb_order_status" value="wc-<?php echo $order_status; ?>" />

            <?php
        }

        public function shop_orders_column($column, $order) {
            if ($column == 'order_status') {
                if (is_object($order)) {
                    $order_number = $order->get_id();
                    $order_status = $order->get_status();
                    echo wc_get_order_status_name($order_status);
                } else {
                    $order_number = $order;
                    $order = wc_get_order($order);
                    $order_status = $order->get_status();
                }
                ?>

                <input type="hidden" id="opb_order_number" value="<?php echo $order_number; ?>" />
                <input type="hidden" id="opb_order_status" value="wc-<?php echo $order_status; ?>" />

                <?php
            }
        }

        private function darken_color($rgb, $darker = 2) {

            $hash = (strpos($rgb, '#') !== false) ? '#' : '';
            $rgb = (strlen($rgb) == 7) ? str_replace('#', '', $rgb) : ((strlen($rgb) == 6) ? $rgb : false);
            if (strlen($rgb) != 6)
                return $hash . '000000';
            $darker = ($darker > 1) ? $darker : 1;

            list($R16, $G16, $B16) = str_split($rgb, 2);

            $R = sprintf("%02X", floor(hexdec($R16) / $darker));
            $G = sprintf("%02X", floor(hexdec($G16) / $darker));
            $B = sprintf("%02X", floor(hexdec($B16) / $darker));

            return $hash . $R . $G . $B;
        }

        private function get_default_options() {

            $defaults['wc_statuses'] = array(
                'wc-pending' => 'Pending payment',
                'wc-on-hold' => 'On hold',
                'wc-processing' => 'Processing',
                'wc-completed' => 'Completed'
            );
            $defaults['theme'] = 'stripes';
            $defaults['color'] = '#4db91b';
            $defaults['bgcolor'] = 'lightgray';
            $defaults['border'] = 'circle';

            return $defaults;
        }

    }

    new ANWC_Order_Progress_Bar();
}