<?php
$meta_basics = get_post_meta($post->ID, 'basics', true);
//var_dump($meta_basics);
?>

<?php
    /**
     * To Get Category List of WooCommerce
     * @since 1.0.0 -10
     */
    $args = array(
        'hide_empty' => false, //False from 3.4 
        'orderby' => 'count',
        'order' => 'DESC',
    );

    //WooCommerce Product Category Object as Array
    $wpt_product_cat_object = get_terms('product_cat', $args);
    //var_dump($wpt_product_cat_object);
?>


<div class="wpt_column">
    <label class="wpt_label" for="wpt_product_slugs">Category Includes <small>(Click to choose Categories)</small></label>
    <select name="basics[product_cat_ids][]" data-name="product_cat_ids" id="wpt_product_ids" class="wpt_fullwidth wpt_data_filed_atts" multiple>
        <?php
        foreach ($wpt_product_cat_object as $category) {
            echo "<option value='{$category->term_id}' " . ( is_array($meta_basics['product_cat_ids']) && in_array($category->term_id, $meta_basics['product_cat_ids']) ? 'selected' : false ) . ">{$category->name} - {$category->slug} ({$category->count})</option>";
        }
        ?>
    </select>
</div>


<div class="wpt_column">
    <label class="wpt_label">Product ID Exclude (Separate with comma)</label>
    <input name="basics[post_exclude]" data-name="post_exclude" value="<?php echo isset( $meta_basics['post_exclude'] ) ? $meta_basics['post_exclude'] : ''; ?>" class="wpt_data_filed_atts" type="text" placeholder="Example: 1,2,3,4">
</div>
<div class="wpt_column">
    <label class="wpt_label" for="wpt_product_slugs">Category Exclude <small>(Click to choose Categories)</small></label>
    <select name="basics[cat_explude][]" data-name="cat_explude" id="wpt_product_ids" class="wpt_fullwidth wpt_data_filed_atts" multiple>
        <?php
        foreach ($wpt_product_cat_object as $category) {
            echo "<option value='{$category->term_id}' " . ( is_array($meta_basics['cat_explude']) && in_array($category->term_id, $meta_basics['cat_explude']) ? 'selected' : false ) . ">{$category->name} - {$category->slug} ({$category->count})</option>";
        }
        ?>
    </select>
</div>


<?php
    $wpt_product_ids_tag = false;
    /**
     * To Get Category List of WooCommerce
     * @since 1.0.0 -10
     */
    $args = array(
        'hide_empty' => true,
        'orderby' => 'count',
        'order' => 'DESC',
    );

    //WooCommerce Product Category Object as Array
    $wpt_product_tag_object = get_terms('product_tag', $args);
    //var_dump($wpt_product_tag_object);
?>


<div class="wpt_column">
    <label class="wpt_label" for="product_tag_ids">Tag Includes <small>(Click to choose Tags)</small></label>
    <select name="basics[product_tag_ids][]" data-name="product_tag_ids" id="product_tag_ids" class="wpt_fullwidth wpt_data_filed_atts" multiple>
        <?php
        foreach ($wpt_product_tag_object as $tags) {
            echo "<option value='{$tags->term_id}' " . ( is_array($meta_basics['product_tag_ids']) && in_array($tags->term_id, $meta_basics['product_tag_ids']) ? 'selected' : false ) . ">{$tags->name} - {$tags->slug} ({$tags->count})</option>";
        }
        ?>
    </select>
</div>

<div class="wpt_column">
    <label class="wpt_label wpt_table_ajax_action" for='wpt_table_minicart_position'>Ajax Action (Enable/Disable)</label>
    <select name="basics[ajax_action]" data-name='ajax_action' id="wpt_table_ajax_action" class="wpt_fullwidth wpt_data_filed_atts" >
        <option value="ajax_active" <?php echo isset( $meta_basics['ajax_action'] ) && $meta_basics['ajax_action'] == 'ajax_active' ? 'selected' : false; ?>>Active Ajax (Default)</option>
        <option value="no_ajax_action" <?php echo isset( $meta_basics['ajax_action'] ) && $meta_basics['ajax_action'] == 'no_ajax_action' ? 'selected' : false; ?>>Disable Ajax Action</option>
    </select>
</div>


<div class="wpt_column">
    <label class="wpt_label" for='wpt_table_minicart_position'>Mini Cart Position</label>
    <select name="basics[minicart_position]" data-name='minicart_position' id="wpt_table_minicart_position" class="wpt_fullwidth wpt_data_filed_atts" >
        <option value="top" <?php echo isset( $meta_basics['minicart_position'] ) && $meta_basics['minicart_position'] == 'top' ? 'selected' : false; ?>>Top (Default)</option>
        <option value="bottom" <?php echo isset( $meta_basics['minicart_position'] ) && $meta_basics['minicart_position'] == 'bottom' ? 'selected' : false; ?>>Bottom</option>
        <option value="none" <?php echo isset( $meta_basics['minicart_position'] ) && $meta_basics['minicart_position'] == 'none' ? 'selected' : false; ?>>None</option>
    </select>
</div>



<div class="wpt_column">
    <label class="wpt_label" for='wpt_table_table_class'>Set a Class name for Table</label>
    <input name="basics[table_class]" value="<?php echo isset( $meta_basics['table_class'] ) ? $meta_basics['table_class'] : ''; ?>" class="wpt_data_filed_atts" data-name="table_class" type="text" placeholder="Product's Table Class Name (Optional)" id='wpt_table_table_class'>
</div>

<div class="wpt_column">
    <label class="wpt_label" for='wpt_table_temp_number'>Temporary Number for Table</label>
    <input name="basics[temp_number]" class="wpt_data_filed_atts readonly" data-name="temp_number" type="text" placeholder="123" id='wpt_table_temp_number' value="<?php echo isset( $meta_basics['temp_number'] ) ? $meta_basics['temp_number'] : random_int(10, 300); ?>" readonly="readonly">
    <p>This is not very important, But should different number for different shortcode of your table. Mainly to identify each table.</p>
</div>


<div class="wpt_column">
    <label class="wpt_label" for="wpt_table_add_to_cart_text">(Add to cart) Text</label>
    <input name="basics[add_to_cart_text]" class="wpt_data_filed_atts" data-name="add_to_cart_text" type="text" value="<?php echo isset( $meta_basics['add_to_cart_text'] ) ? $meta_basics['add_to_cart_text'] : __( 'Add to cart', 'wpt_pro' ); ?>" placeholder="Example: Buy" id="wpt_table_add_to_cart_text">
    <p style="color: #006799;padding: 0;margin: 0;">Put a Space (" ") for getting default <b>Add to Cart Text</b></p>
</div>
<div class="wpt_column">
    <label class="wpt_label" for="wpt_table_added_to_cart_text">Added_to_cart (Added) Text</label>
    <input name="basics[added_to_cart_text]" class="wpt_data_filed_atts" data-name="added_to_cart_text" type="text" value="<?php echo isset( $meta_basics['added_to_cart_text'] ) ? $meta_basics['added_to_cart_text'] : __( 'Added', 'wpt_pro' ); ?>" placeholder="Example: Added" id="wpt_table_added_to_cart_text">
</div>
<div class="wpt_column">
    <label class="wpt_label" for="wpt_table_adding_to_cart_text">Added_to_cart (Adding..) Text</label>
    <input name="basics[adding_to_cart_text]"  class="wpt_data_filed_atts" data-name="adding_to_cart_text" type="text" value="<?php echo isset( $meta_basics['adding_to_cart_text'] ) ? $meta_basics['adding_to_cart_text'] : __( 'Adding..', 'wpt_pro' ); ?>" placeholder="Example: Adding.." id="wpt_table_added_to_cart_text">
</div>

<div class="wpt_column">
    <label class="wpt_label" for="wpt_table_add_to_cart_selected_text">(Add to cart(Selected]) Text</label>
    <input name="basics[add_to_cart_selected_text]"  class="wpt_data_filed_atts" data-name="add_to_cart_selected_text" type="text" value="<?php echo isset( $meta_basics['add_to_cart_selected_text'] ) ? $meta_basics['add_to_cart_selected_text'] : __( 'Add to Cart (Selected)', 'wpt_pro' ); ?>" placeholder="Example: Add to cart Selected" id="wpt_table_add_to_cart_selected_text">
</div>

<div class="wpt_column">
    <label class="wpt_label" for="wpt_table_check_uncheck_text">(All Check/Uncheck) Text</label>
    <input name="basics[check_uncheck_text]"  class="wpt_data_filed_atts" data-name="check_uncheck_text" type="text" value="<?php echo isset( $meta_basics['check_uncheck_text'] ) ? $meta_basics['check_uncheck_text'] : __( 'All Check/Uncheck','wpt_pro' ); ?>" placeholder="Example: All Check/Uncheck" id="wpt_table_check_uncheck_text">
</div>
<hr> 
<div class="wpt_column">
    <label class="wpt_label" for="wpt_table_author">AuthorID/UserID/VendorID<strong>(Optional)</strong></label>
    <input name="basics[author]"  class="wpt_data_filed_atts" data-name="author" type="number" value="<?php echo isset( $meta_basics['author'] ) ? $meta_basics['author'] : ''; ?>" placeholder="Author ID/Vendor ID" id="wpt_table_author">
    <p style="color: #006394;">Only AuthorID or AuthorName field for both [AuthorID/UserID/VendorID] or [author_name/username/VendorUserName]. Don't use both.</p>
</div>
<div class="wpt_column">
    <label class="wpt_label" for="wpt_table_author_name">author_name/username/VendorUserName<strong>(Optional)</strong></label>
    <input name="basics[author_name]"  class="wpt_data_filed_atts" data-name="author_name" type="text" value="<?php echo isset( $meta_basics['author_name'] ) ? $meta_basics['author_name'] : ''; ?>" placeholder="Author username/ Vendor username" id="wpt_table_author_name">
    <p style="color: #006394;">Only AuthorID or AuthorName field for both [AuthorID/UserID/VendorID] or [author_name/username/VendorUserName]. Don't use both.</p>
</div>
