<?php
/**
 * Order details Summary
 *
 * This template displays a summary of original order details
 *
 * @package woocommerce-deposits/Templates
 * @version 2.5.0
 */

if (!defined('ABSPATH')) {
    exit;
}

if (!$order = wc_get_order($order_id)) {
    return;
}


$order_items = $order->get_items(apply_filters('woocommerce_purchase_order_item_types', 'line_item'));
$show_purchase_note = $order->has_status(apply_filters('woocommerce_purchase_note_order_statuses', array('completed', 'processing')));

?> <p> <?php _e('Below is a summary of original order','woocommerce-deposits') ?> <strong><?php  echo $order->get_order_number(); ?> </strong>  </p>
<table class="woocommerce-table woocommerce-table--order-details shop_table order_details woocommerce_deposits_parent_order_summary">

    <thead>
    <tr>
        <th class="woocommerce-table__product-name product-name"><?php _e('Product', 'woocommerce-deposits'); ?></th>
        <th class="woocommerce-table__product-table product-total"><?php _e('Total', 'woocommerce-deposits'); ?></th>
    </tr>
    </thead>

    <tbody>
    <?php

    foreach ($order_items as $item_id => $item) {
        $product = $item->get_product();

        wc_get_template('order/order-details-item.php', array(
            'order' => $order,
            'item_id' => $item_id,
            'item' => $item,
            'show_purchase_note' => $show_purchase_note,
            'purchase_note' => $product ? $product->get_purchase_note() : '',
            'product' => $product,
        ));
    }

    ?>
    </tbody>

    <tfoot>
    <?php
    foreach ($order->get_order_item_totals() as $key => $total) {
        ?>
        <tr>
            <th scope="row"><?php echo $total['label']; ?></th>
            <td><?php echo ('payment_method' === $key) ? esc_html($total['value']) : $total['value']; ?></td>
        </tr>
        <?php
    }
    ?>
    <?php if ($order->get_customer_note()) : ?>
        <tr>
            <th><?php _e('Note:', 'woocommerce'); ?></th>
            <td><?php echo wptexturize($order->get_customer_note()); ?></td>
        </tr>
    <?php endif; ?>
    </tfoot>
</table>
