<?php


if (!defined('ABSPATH')) {
    exit;
}


if (!class_exists('Wc_Deposits_Pdf_Invoices_compatibility')) {
    class Wc_Deposits_Pdf_Invoices_compatibility
    {

        function __construct()
        {

            add_filter('wc_deposits_admin_partial_payment_actions', array($this, 'partial_payment_invoices'), 10, 2);
            add_filter('wpo_wcpdf_document_classes', array($this, 'document_classes'));
            add_filter('wpo_wcpdf_template_file', array($this, 'template_file'), 10, 2);

        }


        function partial_payment_invoices($actions, $partial_payment)
        {

            $actions['pdf_invoice'] = '<a class="button btn" href="';
            $actions['pdf_invoice'] .= wp_nonce_url(admin_url("admin-ajax.php?action=generate_wpo_wcpdf&document_type=partial_payment_invoice&order_ids=" . $partial_payment->get_id()), 'generate_wpo_wcpdf') . '">';
            $actions['pdf_invoice'] .= __('PDF Invoice', 'woocommerce-deposits') . '</a>';

            return $actions;
        }

        function document_classes($documents)
        {
  if (!class_exists('WPO\WC\PDF_Invoices\Documents\WCDP_Partial_Payment_Invoice') && file_exists(WC_DEPOSITS_PLUGIN_PATH . 'includes/compatibility/pdf-invoices/class-wcdp-partial-payment-invoice.php')) {
                ;
                $documents['WPO\WC\PDF_Invoices\Documents\WCDP_Partial_Payment_Invoice'] = include WC_DEPOSITS_PLUGIN_PATH . 'includes/compatibility/pdf-invoices/class-wcdp-partial-payment-invoice.php';

            }

            return $documents;
        }


        function template_file($path, $type)
        {


            if (strpos($path, 'partial_payment_invoice.php') !== false && $type === 'partial_payment_invoice') {

                $path = plugin_dir_path(__FILE__) . 'partial_payment_invoice.php';
            }
            return $path;
        }


    }
}

return new Wc_Deposits_Pdf_Invoices_compatibility();
