<?php

class geoip_rulesWcu extends moduleWcu {

	public $currencyModule;
	public $optionsPro;

	public function init() {
		parent::init();
		dispatcherWcu::addAction('geoIpRules', array($this->getView(), 'getGeoIpRulesTab'), 10, 1);
		$this->optionsPro =  frameWcu::_()->getModule('options_pro')->getModel()->getOptionsPro();

		if ( !isset($_COOKIE[frameWcu::_()->getModule('currency')->currencyCookieName] ) && ! empty( $this->optionsPro['geoip_rules']['enable'] ) ) {
			add_action( 'init', array( $this, 'initAutomaticByIp' ) );
		}
	}

	public function initAutomaticByIp() {
		if ( ! empty( $this->optionsPro['geoip_rules']['automatic_by_ip'] ) ) {
			$this->setCurrentCurrencyAutoByIp();
		}
		if ( empty( $this->optionsPro['geoip_rules']['automatic_by_ip'] ) ) {
			$this->setCurrentCurrencyByList();
		}
	}

	public function setCurrentCurrencyByList() {
		$countryCode = $this->getUserCountryCode();
		$currencyCountryListArr = $this->getCurrencyCountryList();
		$currencyCode = '';
		$currencyList = !empty($this->optionsPro['geoip_rules']['currency_list']) ? $this->optionsPro['geoip_rules']['currency_list'] : array();
		foreach ($currencyList as $key => $countryListArr) {
			if (in_array($countryCode, $countryListArr)) {
				$currencyCode = $key;
			}
		}
		$currencyCode = !empty($currencyCode) ? $currencyCode : frameWcu::_()->getModule('currency')->getDefaultCurrency();
		frameWcu::_()->getModule('currency')->setCurrentCurrency($currencyCode);
	}
	public function setCurrentCurrencyAutoByIp() {
		$countryCode = $this->getUserCountryCode();
		$currencyCode = $this->getCurrencyCodeByCountry($countryCode);
		$currencyCode = !empty($currencyCode) ? $currencyCode : frameWcu::_()->getModule('currency')->getDefaultCurrency();
		frameWcu::_()->getModule('currency')->setCurrentCurrency($currencyCode);
	}

	public function getUserCountryCode() {
		$ip = '';
		$ip = $this->getModel()->getRealIpAddr();
		//$ip = '77.111.246.20'; // US
		//$ip = '185.31.162.152'; // RU
		$countryCode = $this->getModel()->getCountryCodeByIp( $ip );

		if ( '' === $countryCode && class_exists( 'WC_Geolocation' ) ) {
			$wcGeolocation = new WC_Geolocation();
			$geolocate     = $wcGeolocation->geolocate_ip( $ip );
			$countryCode   = $geolocate['country'];
		}

		return $countryCode;
	}

	public function getCurrencyCodeByCountry( $countryCode ) {
		$currencyCode = '';
		$currencyCountryListArr = $this->getCurrencyCountryList();
		foreach ($currencyCountryListArr as $key => $countryListArr) {
			if (in_array($countryCode, $countryListArr)) {
				$currencyCode = $key;
			}
		}
		return $currencyCode;
	}
	public function getDefaultOptions() {
        return array(
                'enable' => '0',
                'automatic_by_ip' => '1',
				'automatic_by_settings' => '0',
        );
    }
    public function getOptionsParams() {
        // to find params description and hooks @see currencyWcu::getOptionsParams
        return array(
                'enable' => array(
                    'html' => 'checkboxHiddenVal',
					'row_classes' => '',
                    'row_parent' => '',
                    'row_show' => '',
                    'row_hide' => '',
					'tooltip' => __('Allows you to automatically set the currency for visitors when they first visit the site.', WCU_LANG_CODE),
					'content_after' => '<i class="fa fa-question supsystic-tooltip" title="'.__('Toggle GeoIp Rules functional', WCU_LANG_CODE).'"></i>',
                    'label' => __('Enable', WCU_LANG_CODE),
                    'params' => array(
                        'value'=>'1',
                    ),
                ),
				'automatic_by_ip' => array(
                    'html' => 'checkboxHiddenVal',
					'row_classes' => '',
                    'row_parent' => '',
                    'row_show' => '',
                    'row_hide' => '',
					'tooltip' => __('If this option is enabled, currencies for your visitors will be set by default by country code.', WCU_LANG_CODE),
                    'label' => __('Set currencies automatic by default with GeoIP', WCU_LANG_CODE),
                    'params' => array(
                        'value'=>'1',
                    ),
                ),
                'default_for_robots' => array(
                    'html' => 'checkboxHiddenVal',
					'row_classes' => '',
                    'row_parent' => '',
                    'row_show' => '',
                    'row_hide' => '',
					'tooltip' => __('If this option is enabled, search robots such as Googlebot will always get the page in main currency.', WCU_LANG_CODE),
                    'label' => __('Use the Main currency for robots.', WCU_LANG_CODE),
                    'params' => array(
                        'value'=>'1',
                    ),
                ),
				'automatic_by_settings' => array(
                    'html' => 'hidden',
					'row_classes' => '',
                    'row_parent' => '',
                    'row_show' => '',
                    'row_hide' => '',
					'tooltip' => __('If you want to specify the definition of the currency yourself, please select your list of countries for each currency. The option "Set currencies automatic by default with GeoIP" must be disabled.', WCU_LANG_CODE),
                    'label' => __('Use custom settings', WCU_LANG_CODE),
                    'params' => array(
                        'value'=>'1',
                    ),
                ),
        );
    }
	public function getCurrencyCountryList() {
		return array(
			'AFN' => array( 'AF' ),
			'ALL' => array( 'AL' ),
			'DZD' => array( 'DZ' ),
			'USD' => array( 'AS', 'IO', 'GU', 'MH', 'FM', 'MP', 'PW', 'PR', 'TC', 'US', 'UM', 'VI' ),
			'EUR' => array( 'AD', 'AT', 'BE', 'CY', 'EE', 'FI', 'FR', 'GF', 'TF', 'DE', 'GR', 'GP', 'IE', 'IT', 'LV', 'LT', 'LU', 'MT', 'MQ', 'YT', 'MC', 'ME', 'NL', 'PT', 'RE', 'PM', 'SM', 'SK', 'SI', 'ES' ),
			'AOA' => array( 'AO' ),
			'XCD' => array( 'AI', 'AQ', 'AG', 'DM', 'GD', 'MS', 'KN', 'LC', 'VC' ),
			'ARS' => array( 'AR' ),
			'AMD' => array( 'AM' ),
			'AWG' => array( 'AW' ),
			'AUD' => array( 'AU', 'CX', 'CC', 'HM', 'KI', 'NR', 'NF', 'TV' ),
			'AZN' => array( 'AZ' ),
			'BSD' => array( 'BS' ),
			'BHD' => array( 'BH' ),
			'BDT' => array( 'BD' ),
			'BBD' => array( 'BB' ),
			'BYR' => array( 'BY' ),
			'BZD' => array( 'BZ' ),
			'XOF' => array( 'BJ', 'BF', 'ML', 'NE', 'SN', 'TG' ),
			'BMD' => array( 'BM' ),
			'BTN' => array( 'BT' ),
			'BOB' => array( 'BO' ),
			'BAM' => array( 'BA' ),
			'BWP' => array( 'BW' ),
			'NOK' => array( 'BV', 'NO', 'SJ' ),
			'BRL' => array( 'BR' ),
			'BND' => array( 'BN' ),
			'BGN' => array( 'BG' ),
			'BIF' => array( 'BI' ),
			'KHR' => array( 'KH' ),
			'XAF' => array( 'CM', 'CF', 'TD', 'CG', 'GQ', 'GA' ),
			'CAD' => array( 'CA' ),
			'CVE' => array( 'CV' ),
			'KYD' => array( 'KY' ),
			'CLP' => array( 'CL' ),
			'CNY' => array( 'CN' ),
			'HKD' => array( 'HK' ),
			'COP' => array( 'CO' ),
			'KMF' => array( 'KM' ),
			'CDF' => array( 'CD' ),
			'NZD' => array( 'CK', 'NZ', 'NU', 'PN', 'TK' ),
			'CRC' => array( 'CR' ),
			'HRK' => array( 'HR' ),
			'CUP' => array( 'CU' ),
			'CZK' => array( 'CZ' ),
			'DKK' => array( 'DK', 'FO', 'GL' ),
			'DJF' => array( 'DJ' ),
			'DOP' => array( 'DO' ),
			'ECS' => array( 'EC' ),
			'EGP' => array( 'EG' ),
			'SVC' => array( 'SV' ),
			'ERN' => array( 'ER' ),
			'ETB' => array( 'ET' ),
			'FKP' => array( 'FK' ),
			'FJD' => array( 'FJ' ),
			'GMD' => array( 'GM' ),
			'GEL' => array( 'GE' ),
			'GHS' => array( 'GH' ),
			'GIP' => array( 'GI' ),
			'QTQ' => array( 'GT' ),
			'GGP' => array( 'GG' ),
			'GNF' => array( 'GN' ),
			'GWP' => array( 'GW' ),
			'GYD' => array( 'GY' ),
			'HTG' => array( 'HT' ),
			'HNL' => array( 'HN' ),
			'HUF' => array( 'HU' ),
			'ISK' => array( 'IS' ),
			'INR' => array( 'IN' ),
			'IDR' => array( 'ID' ),
			'IRR' => array( 'IR' ),
			'IQD' => array( 'IQ' ),
			'GBP' => array( 'IM', 'JE', 'GS', 'GB' ),
			'ILS' => array( 'IL' ),
			'JMD' => array( 'JM' ),
			'JPY' => array( 'JP' ),
			'JOD' => array( 'JO' ),
			'KZT' => array( 'KZ' ),
			'KES' => array( 'KE' ),
			'KPW' => array( 'KP' ),
			'KRW' => array( 'KR' ),
			'KWD' => array( 'KW' ),
			'KGS' => array( 'KG' ),
			'LAK' => array( 'LA' ),
			'LBP' => array( 'LB' ),
			'LSL' => array( 'LS' ),
			'LRD' => array( 'LR' ),
			'LYD' => array( 'LY' ),
			'CHF' => array( 'LI', 'CH' ),
			'MKD' => array( 'MK' ),
			'MGF' => array( 'MG' ),
			'MWK' => array( 'MW' ),
			'MYR' => array( 'MY' ),
			'MVR' => array( 'MV' ),
			'MRO' => array( 'MR' ),
			'MUR' => array( 'MU' ),
			'MXN' => array( 'MX' ),
			'MDL' => array( 'MD' ),
			'MNT' => array( 'MN' ),
			'MAD' => array( 'MA', 'EH' ),
			'MZN' => array( 'MZ' ),
			'MMK' => array( 'MM' ),
			'NAD' => array( 'NA' ),
			'NPR' => array( 'NP' ),
			'ANG' => array( 'AN' ),
			'XPF' => array( 'NC', 'WF' ),
			'NIO' => array( 'NI' ),
			'NGN' => array( 'NG' ),
			'OMR' => array( 'OM' ),
			'PKR' => array( 'PK' ),
			'PAB' => array( 'PA' ),
			'PGK' => array( 'PG' ),
			'PYG' => array( 'PY' ),
			'PEN' => array( 'PE' ),
			'PHP' => array( 'PH' ),
			'PLN' => array( 'PL' ),
			'QAR' => array( 'QA' ),
			'RON' => array( 'RO' ),
			'RUB' => array( 'RU' ),
			'RWF' => array( 'RW' ),
			'SHP' => array( 'SH' ),
			'WST' => array( 'WS' ),
			'STD' => array( 'ST' ),
			'SAR' => array( 'SA' ),
			'RSD' => array( 'RS' ),
			'SCR' => array( 'SC' ),
			'SLL' => array( 'SL' ),
			'SGD' => array( 'SG' ),
			'SBD' => array( 'SB' ),
			'SOS' => array( 'SO' ),
			'ZAR' => array( 'ZA' ),
			'SSP' => array( 'SS' ),
			'LKR' => array( 'LK' ),
			'SDG' => array( 'SD' ),
			'SRD' => array( 'SR' ),
			'SZL' => array( 'SZ' ),
			'SEK' => array( 'SE' ),
			'SYP' => array( 'SY' ),
			'TWD' => array( 'TW' ),
			'TJS' => array( 'TJ' ),
			'TZS' => array( 'TZ' ),
			'THB' => array( 'TH' ),
			'TOP' => array( 'TO' ),
			'TTD' => array( 'TT' ),
			'TND' => array( 'TN' ),
			'TRY' => array( 'TR' ),
			'TMT' => array( 'TM' ),
			'UGX' => array( 'UG' ),
			'UAH' => array( 'UA' ),
			'AED' => array( 'AE' ),
			'UYU' => array( 'UY' ),
			'UZS' => array( 'UZ' ),
			'VUV' => array( 'VU' ),
			'VEF' => array( 'VE' ),
			'VND' => array( 'VN' ),
			'YER' => array( 'YE' ),
			'ZMW' => array( 'ZM' ),
			'ZWD' => array( 'ZW' ),
			'ETH' => array ( 'CRYPTO' ),
			'ETC' => array ( 'CRYPTO' ),
			'BTC' => array ( 'CRYPTO' ),
			'BCH' => array ( 'CRYPTO' ),
			'LTC' => array ( 'CRYPTO' ),
			'ZEC' => array ( 'CRYPTO' ),
			'DASH' => array ( 'CRYPTO' ),
			'XRP' => array ( 'CRYPTO' ),
			'XMR' => array ( 'CRYPTO' ),
			'BCH' => array ( 'CRYPTO' ),
			'NEO' => array ( 'CRYPTO' ),
			'ADA' => array ( 'CRYPTO' ),
			'EOS' => array ( 'CRYPTO' ),
		);
	}
	public function getCountryNameList() {
		return array(
		    'AF' => 'Afghanistan',
		    'AX' => 'Aland Islands',
		    'AL' => 'Albania',
		    'DZ' => 'Algeria',
		    'AS' => 'American Samoa',
		    'AD' => 'Andorra',
		    'AO' => 'Angola',
		    'AI' => 'Anguilla',
		    'AQ' => 'Antarctica',
		    'AG' => 'Antigua and Barbuda',
		    'AR' => 'Argentina',
		    'AM' => 'Armenia',
		    'AW' => 'Aruba',
		    'AU' => 'Australia',
		    'AT' => 'Austria',
		    'AZ' => 'Azerbaijan',
		    'BS' => 'Bahamas',
		    'BH' => 'Bahrain',
		    'BD' => 'Bangladesh',
		    'BB' => 'Barbados',
		    'BY' => 'Belarus',
		    'BE' => 'Belgium',
		    'BZ' => 'Belize',
		    'BJ' => 'Benin',
		    'BM' => 'Bermuda',
		    'BT' => 'Bhutan',
		    'BO' => 'Bolivia',
		    'BQ' => 'Bonaire, Saint Eustatius and Saba',
		    'BA' => 'Bosnia and Herzegovina',
		    'BW' => 'Botswana',
		    'BV' => 'Bouvet Island',
		    'BR' => 'Brazil',
		    'IO' => 'British Indian Ocean Territory',
		    'VG' => 'British Virgin Islands',
		    'BN' => 'Brunei',
		    'BG' => 'Bulgaria',
		    'BF' => 'Burkina Faso',
		    'BI' => 'Burundi',
		    'KH' => 'Cambodia',
		    'CM' => 'Cameroon',
		    'CA' => 'Canada',
		    'CV' => 'Cape Verde',
		    'KY' => 'Cayman Islands',
		    'CF' => 'Central African Republic',
		    'TD' => 'Chad',
		    'CL' => 'Chile',
		    'CN' => 'China',
		    'CX' => 'Christmas Island',
		    'CC' => 'Cocos Islands',
		    'CO' => 'Colombia',
		    'KM' => 'Comoros',
		    'CK' => 'Cook Islands',
		    'CR' => 'Costa Rica',
		    'HR' => 'Croatia',
		    'CU' => 'Cuba',
		    'CW' => 'Curacao',
		    'CY' => 'Cyprus',
		    'CZ' => 'Czech Republic',
		    'CD' => 'Democratic Republic of the Congo',
		    'DK' => 'Denmark',
		    'DJ' => 'Djibouti',
		    'DM' => 'Dominica',
		    'DO' => 'Dominican Republic',
		    'TL' => 'East Timor',
		    'EC' => 'Ecuador',
		    'EG' => 'Egypt',
		    'SV' => 'El Salvador',
		    'GQ' => 'Equatorial Guinea',
		    'ER' => 'Eritrea',
		    'EE' => 'Estonia',
		    'ET' => 'Ethiopia',
		    'FK' => 'Falkland Islands',
		    'FO' => 'Faroe Islands',
		    'FJ' => 'Fiji',
		    'FI' => 'Finland',
		    'FR' => 'France',
		    'GF' => 'French Guiana',
		    'PF' => 'French Polynesia',
		    'TF' => 'French Southern Territories',
		    'GA' => 'Gabon',
		    'GM' => 'Gambia',
		    'GE' => 'Georgia',
		    'DE' => 'Germany',
		    'GH' => 'Ghana',
		    'GI' => 'Gibraltar',
		    'GR' => 'Greece',
		    'GL' => 'Greenland',
		    'GD' => 'Grenada',
		    'GP' => 'Guadeloupe',
		    'GU' => 'Guam',
		    'GT' => 'Guatemala',
		    'GG' => 'Guernsey',
		    'GN' => 'Guinea',
		    'GW' => 'Guinea-Bissau',
		    'GY' => 'Guyana',
		    'HT' => 'Haiti',
		    'HM' => 'Heard Island and McDonald Islands',
		    'HN' => 'Honduras',
		    'HK' => 'Hong Kong',
		    'HU' => 'Hungary',
		    'IS' => 'Iceland',
		    'IN' => 'India',
		    'ID' => 'Indonesia',
		    'IR' => 'Iran',
		    'IQ' => 'Iraq',
		    'IE' => 'Ireland',
		    'IM' => 'Isle of Man',
		    'IL' => 'Israel',
		    'IT' => 'Italy',
		    'CI' => 'Ivory Coast',
		    'JM' => 'Jamaica',
		    'JP' => 'Japan',
		    'JE' => 'Jersey',
		    'JO' => 'Jordan',
		    'KZ' => 'Kazakhstan',
		    'KE' => 'Kenya',
		    'KI' => 'Kiribati',
		    'XK' => 'Kosovo',
		    'KW' => 'Kuwait',
		    'KG' => 'Kyrgyzstan',
		    'LA' => 'Laos',
		    'LV' => 'Latvia',
		    'LB' => 'Lebanon',
		    'LS' => 'Lesotho',
		    'LR' => 'Liberia',
		    'LY' => 'Libya',
		    'LI' => 'Liechtenstein',
		    'LT' => 'Lithuania',
		    'LU' => 'Luxembourg',
		    'MO' => 'Macao',
		    'MK' => 'Macedonia',
		    'MG' => 'Madagascar',
		    'MW' => 'Malawi',
		    'MY' => 'Malaysia',
		    'MV' => 'Maldives',
		    'ML' => 'Mali',
		    'MT' => 'Malta',
		    'MH' => 'Marshall Islands',
		    'MQ' => 'Martinique',
		    'MR' => 'Mauritania',
		    'MU' => 'Mauritius',
		    'YT' => 'Mayotte',
		    'MX' => 'Mexico',
		    'FM' => 'Micronesia',
		    'MD' => 'Moldova',
		    'MC' => 'Monaco',
		    'MN' => 'Mongolia',
		    'ME' => 'Montenegro',
		    'MS' => 'Montserrat',
		    'MA' => 'Morocco',
		    'MZ' => 'Mozambique',
		    'MM' => 'Myanmar',
		    'NA' => 'Namibia',
		    'NR' => 'Nauru',
		    'NP' => 'Nepal',
		    'NL' => 'Netherlands',
		    'NC' => 'New Caledonia',
		    'NZ' => 'New Zealand',
		    'NI' => 'Nicaragua',
		    'NE' => 'Niger',
		    'NG' => 'Nigeria',
		    'NU' => 'Niue',
		    'NF' => 'Norfolk Island',
		    'KP' => 'North Korea',
		    'MP' => 'Northern Mariana Islands',
		    'NO' => 'Norway',
		    'OM' => 'Oman',
		    'PK' => 'Pakistan',
		    'PW' => 'Palau',
		    'PS' => 'Palestinian Territory',
		    'PA' => 'Panama',
		    'PG' => 'Papua New Guinea',
		    'PY' => 'Paraguay',
		    'PE' => 'Peru',
		    'PH' => 'Philippines',
		    'PN' => 'Pitcairn',
		    'PL' => 'Poland',
		    'PT' => 'Portugal',
		    'PR' => 'Puerto Rico',
		    'QA' => 'Qatar',
		    'CG' => 'Republic of the Congo',
		    'RE' => 'Reunion',
		    'RO' => 'Romania',
		    'RU' => 'Russia',
		    'RW' => 'Rwanda',
		    'BL' => 'Saint Barthelemy',
		    'SH' => 'Saint Helena',
		    'KN' => 'Saint Kitts and Nevis',
		    'LC' => 'Saint Lucia',
		    'MF' => 'Saint Martin',
		    'PM' => 'Saint Pierre and Miquelon',
		    'VC' => 'Saint Vincent and the Grenadines',
		    'WS' => 'Samoa',
		    'SM' => 'San Marino',
		    'ST' => 'Sao Tome and Principe',
		    'SA' => 'Saudi Arabia',
		    'SN' => 'Senegal',
		    'RS' => 'Serbia',
		    'SC' => 'Seychelles',
		    'SL' => 'Sierra Leone',
		    'SG' => 'Singapore',
		    'SX' => 'Sint Maarten',
		    'SK' => 'Slovakia',
		    'SI' => 'Slovenia',
		    'SB' => 'Solomon Islands',
		    'SO' => 'Somalia',
		    'ZA' => 'South Africa',
		    'GS' => 'South Georgia and the South Sandwich Islands',
		    'KR' => 'South Korea',
		    'SS' => 'South Sudan',
		    'ES' => 'Spain',
		    'LK' => 'Sri Lanka',
		    'SD' => 'Sudan',
		    'SR' => 'Suriname',
		    'SJ' => 'Svalbard and Jan Mayen',
		    'SZ' => 'Swaziland',
		    'SE' => 'Sweden',
		    'CH' => 'Switzerland',
		    'SY' => 'Syria',
		    'TW' => 'Taiwan',
		    'TJ' => 'Tajikistan',
		    'TZ' => 'Tanzania',
		    'TH' => 'Thailand',
		    'TG' => 'Togo',
		    'TK' => 'Tokelau',
		    'TO' => 'Tonga',
		    'TT' => 'Trinidad and Tobago',
		    'TN' => 'Tunisia',
		    'TR' => 'Turkey',
		    'TM' => 'Turkmenistan',
		    'TC' => 'Turks and Caicos Islands',
		    'TV' => 'Tuvalu',
		    'VI' => 'U.S. Virgin Islands',
		    'UG' => 'Uganda',
		    'UA' => 'Ukraine',
		    'AE' => 'United Arab Emirates',
		    'GB' => 'United Kingdom',
		    'US' => 'United States',
		    'UM' => 'United States Minor Outlying Islands',
		    'UY' => 'Uruguay',
		    'UZ' => 'Uzbekistan',
		    'VU' => 'Vanuatu',
		    'VA' => 'Vatican',
		    'VE' => 'Venezuela',
		    'VN' => 'Vietnam',
		    'WF' => 'Wallis and Futuna',
		    'EH' => 'Western Sahara',
		    'YE' => 'Yemen',
		    'ZM' => 'Zambia',
		    'ZW' => 'Zimbabwe',
			'CRYPTO' => 'Cryptocurrencies'
		);
	}

}
