<?php

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class NINJA_Page_WooComposer_Shortcode {

	protected $shortcodes;

	public function __construct() {

	  // define list shortcode with function of me

	  $this->shortcodes = array(

		// PRODUCT

			'ninja_woo_single_product_images'=>'ninja_woo_single_product_images_shortcode',

			'ninja_woo_single_product_title'=>'ninja_woo_single_product_title_shortcode',

			'ninja_woo_single_product_rating'=>'ninja_woo_single_product_rating_shortcode',

			'ninja_woo_single_product_price'=>'ninja_woo_single_product_price_shortcode',

			'ninja_woo_single_product_excert'=>'ninja_woo_single_product_excert_shortcode',

			'ninja_woo_single_product_add_to_cart'=>'ninja_woo_single_product_add_to_cart_shortcode',

			'ninja_woo_single_product_cat_product_single'=>'ninja_woo_single_product_cat_product_single_shortcode',

			'ninja_woo_single_product_description'=>'ninja_woo_single_product_description_shortcode',

                        'ninja_woo_single_product_share'=>'ninja_woo_single_product_share_shortcode',

			'ninja_woo_single_product_additional_information'=>'ninja_woo_single_product_additional_information_shortcode',

			'ninja_woo_single_product_show_tab'=>'ninja_woo_single_product_show_tab_shortcode',

			

			'ninja_woo_single_product_relate'=>'ninja_woo_single_product_relate_shortcode',

			'ninja_woo_single_product_review'=>'ninja_woo_single_product_review_shortcode',

            'ninja_woo_single_product_upsell'=>'ninja_woo_single_product_upsell_shortcode',

            'ninja_dtwpb_yith_ywraq_add_to_quote'=>'ninja_dtwpb_yith_ywraq_add_to_quote_shortcode',

            'ninja_woo_product_page_product_category' => 'product_category_shortcode',

        // CART

            'ninja_page_cart_table'=>'ninja_page_cart_table_shortcode',	

			'ninja_page_cart_total'=>'ninja_page_cart_total_shortcode',

			'ninja_page_cart_cross_sell'=>'ninja_page_cart_cross_sell_shortcode',

			'ninja_page_cart_empty'=>'ninja_page_cart_empty_shortcode',

		// CHECKOUT

			

			'ninja_page_checkout_billing_information'=>'ninja_page_checkout_billing_information_shortcode',

			'ninja_page_checkout_shipping_information_form'=>'ninja_page_checkout_shipping_information_form_shortcode',

			'ninja_page_checkout_order_review'=>'ninja_page_checkout_order_review_shortcode',

			'ninja_page_order_review'=>'ninja_page_order_review_shortcode',

			'ninja_page_order_payment'=>'ninja_page_order_payment_shortcode',

			////===============MINICART======================

			//'ninja_page_minicart' => 'ninja_page_minicart_shortcode',

		// MYACCOUNT

			'ninja_page_my_account_login_form'=>'ninja_page_my_account_login_form_shortcode',

			'ninja_page_my_account_register_form'=>'ninja_page_my_account_register_form_shortcode',

			'ninja_page_my_account_dashboard'=>'ninja_page_my_account_dashboard_shortcode',

			'ninja_page_my_account_order'=>'ninja_page_my_account_order_shortcode',

			'ninja_page_my_account_download'=>'ninja_page_my_account_download_shortcode',

			'ninja_page_my_account_address'=>'ninja_page_my_account_address_shortcode',

			'ninja_page_my_account_edit'=>'ninja_page_my_account_edit_shortcode',

			'ninja_page_my_account_logout'=>'ninja_page_my_account_logout_shortcode',

		// ORDER RECEIVED

			'ninja_page_order_received_thankyou'=>'ninja_page_order_received_thankyou_shortcode',

			'ninja_page_order_received_order_detail'=>'ninja_page_order_received_order_detail_shortcode',

			'ninja_page_order_received_customer_detail'=>'ninja_page_order_received_customer_detail_shortcode',

			'ninja_page_order_received_billing_address'=>'ninja_page_order_received_billing_address_shortcode'

	  );

		

	}



    public function add_shortcodes(){	

		add_action( 'template_redirect', array( &$this, 'add_shortcode' ));

	}



	public function add_shortcode(){

		global $post;

		foreach ( $this->shortcodes as $shortcode => $shorecode_name_function) {

				add_shortcode($shortcode , array(&$this,$shorecode_name_function));

		}

		



	   if(defined( 'YITH_YWZM_DIR' )){ 

			remove_shortcode('ninja_woo_single_product_images');

			add_shortcode ( 'ninja_woo_single_product_images',array(&$this,'ninja_woo_single_product_images_shortcode_custom') );

		}



		

	}



	public function shortcode_error($atts='',$content='',$tag=''){

		return '<em style="display: block; color: rgb(51, 51, 51); font-weight: bold; white-space: pre-wrap;">Shortcode "'.ucwords(str_replace(array('ninja_woo','_'), array('Single ',' '), $tag)).'". <i style="font-size: inherit; color: rgb(255, 0, 0); font-weight: normal;">Please view Product after assigning Custom Template</i></em>';

	}



   // DEFINE SHORTCODE_ATTRS 

    protected function _shortcode_atts($defaults=array(),$atts){

		if(isset($atts['class']))

			$atts['defined_class'] = $atts['class'];

		return shortcode_atts ( $defaults, $atts );

	}



   // PRODUCT SHORTCODE



    //===============SHORTCODE IMAGE================

	public function ninja_woo_single_product_images_shortcode($atts, $content = null) {

		global $product;

		extract ( $this->_shortcode_atts ( array (

				'el_class' => '',

				'animation' => ''

		), $atts ) );

		ob_start ();

		// Build the animation classes

		if($el_class=="") $el_class="njt_product_image";



		$animation_classes = $this->getCSSAnimation( $animation );



		if (! empty ( $el_class ))

			echo '<div class="' . $el_class .' '.$animation_classes.'">';

	

		if(class_exists('JCKWooThumbs')){

			$JCKWooThumbs = new JCKWooThumbs;

			$JCKWooThumbs->show_product_images();

		}else if(class_exists('WC_Product_Gallery_slider')){   // when install plguin gallery woo

			$enabled = get_option( 'woocommerce_product_gallery_slider_enabled' );

			$enabled_for_post   = get_post_meta( $post->ID, '_woocommerce_product_gallery_slider_enabled', true );

		

			if ( ( $enabled == 'yes' && $enabled_for_post !== 'no' ) || ( $enabled == 'no' && $enabled_for_post == 'yes' ) ) {

					WC_Product_Gallery_slider::setup_scripts_styles();

					WC_Product_Gallery_slider::show_product_gallery();

			}

		}else{

			woocommerce_show_product_sale_flash();

			woocommerce_show_product_images ();

		}

		if (! empty ( $el_class ))

			echo '</div>';

		return ob_get_clean ();

	}

	//  IF YOU INSTALL PLUGIN SUPPORT IMAGES WOO ---> SHORTCODE USED

    public function ninja_woo_single_product_images_shortcode_custom($atts, $content = null){

		   

		global $product;

		extract ( $this->_shortcode_atts ( array (

			'el_class' => '',

			'animation' => ''

		), $atts ) );

		ob_start ();

		// Build the animation classes

		if($el_class=="") $el_class="njt_product_image";



		$animation_classes = $this->getCSSAnimation( $animation );



		if (! empty ( $el_class ))

			echo '<div class="' . $el_class .' '.$animation_classes.'">';

		

		

		$wc_get_template = function_exists( 'wc_get_template' ) ? 'wc_get_template' : 'woocommerce_get_template';

		$wc_get_template( 'single-product/product-image-magnifier.php', array(), '', YITH_YWZM_DIR . 'templates/' );

	

		if (! empty ( $el_class ))

			echo '</div>';

		return ob_get_clean ();

	}



	//===========SHORTCODE TITLE=================

	public function ninja_woo_single_product_title_shortcode($atts, $content = null) {

		extract ( $this->_shortcode_atts ( array (

				

				'tag'=>'h2',

				'el_class'=>'' ,

				'text_align'=>'left',

				'font_size'=>'',

				'line_height'=>'',

				'color'=>'',

				'use_fonts'=>'yes',

				'google_fonts'=>'font_family:Abril Fatface|font_style:400 regular',

				'animation' => ''

		), $atts ) );

		ob_start ();

		

		  

			//woocommerce_template_single_title ();



			  $class=($el_class!="") ? $el_class : "njt_product_title";

			  ?>

			  <style type="text/css">

			  	   <?php 

			  	      if($el_class!="") $class_style=$tag.".".$el_class;

			  	      else $class_style=$tag.".njt_product_title";

			  	   		echo $class_style;?>{

			  	   		<?php if($font_size!=""):?>

			  	   		  font-size: <?php echo $font_size; ?>px !important;

			  	   		<?php endif;?>

			  	   		<?php if($line_height!=""):?>

			  	   		  line-height: <?php echo $line_height; ?>px !important;

			  	   		<?php endif;?>

			  	   		<?php if($color!=""):?>

			  	   		  color: <?php echo $color; ?> !important;

			  	   		<?php endif;?>



			  	   		  text-align: <?php echo $text_align; ?>;





			  	   }

			  </style>

			<?php



			//***********************// MANAGE ANIMATION DATA ***********************//

     

		    // Build the animation classes

		    $animation_classes = $this->getCSSAnimation( $animation );





			//****************** MANAGE FONT DATA ******************//

         	

         	if($atts['use_fonts']=='no') :   // not use font-family default

		        // Build the data array

		        $text_font_data = $this->getFontsData( $google_fonts );

         

		        // Build the inline style

		        $text_font_inline_style = $this->googleFontsStyles( $text_font_data );   

                 

		        // Enqueue the right font   

		        $this->enqueueGoogleFonts( $text_font_data );



			  echo "<".$tag." class='".$class." ".$animation_classes."' style='".$text_font_inline_style."'>".get_the_title()."</".$tag.">";

			else :



			  echo "<".$tag." class='".$class." ".$animation_classes."'>".get_the_title()."</".$tag.">";



			endif; 

			  //woocommerce_template_single_title ();

		

		return ob_get_clean ();

	}

	//===========SHORTCODE RATING=================

	public function ninja_woo_single_product_rating_shortcode($atts, $content = null) {

		global $post,$product;

		extract ( $this->_shortcode_atts ( array (

				'el_class' => '',

				'animation' => '' 

		), $atts ) );

		ob_start ();

		

		// Build the animation classes

		if($el_class=="") $el_class="njt_product_rating";



		$animation_classes = $this->getCSSAnimation( $animation );



		if (! empty ( $el_class ))

			echo '<div class="' . $el_class .' '.$animation_classes.'">';



		// Call function rating single product  inside  single-product/rating.php and of woocommrce

			woocommerce_template_single_rating();

		

		if (! empty ( $el_class ))

			echo '</div>';

		return ob_get_clean ();



	}

	//================SHORTCODE PRICE

	public function ninja_woo_single_product_price_shortcode($atts, $content = null){



		global $post,$product;

		extract ( $this->_shortcode_atts ( array (

				'el_class' => '',

				'text_align'=>'left',

				'font_size'=>'',

				'line_height'=>'',

				'color'=>'',

				'use_fonts'=>'yes',

				'google_fonts'=>'font_family:Abril Fatface|font_style:400 regular',

				'animation' => '' 

		), $atts ) );

		ob_start ();



		$class=($el_class!="") ? $el_class : "njt_product_price";

		

		if($el_class!="") $class_style="p.".$el_class;

		

		else $class_style="p.njt_product_price";

		?>



		<style type="text/css">

			<?php 

			 

			  	echo $class_style;?>{

			  	   		<?php if($font_size!=""):?>

			  	   		  font-size: <?php echo $font_size; ?>px !important;

			  	   		<?php endif;?>

			  	   		<?php if($line_height!=""):?>

			  	   		  line-height: <?php echo $line_height; ?>px !important;

			  	   		<?php endif;?>

			  	   		<?php if($color!=""):?>

			  	   		  color: <?php echo $color; ?> !important;

			  	   		<?php endif;?>



			  	   		  text-align: <?php echo $text_align; ?>;

			   }

			<?php

			   echo $class_style;?> del,<?php echo $class_style;?> ins{

			   		background: none;

			   }

			<?php

			   echo $class_style;?> del .amount,<?php echo $class_style;?> ins .amount{

			   		<?php if($line_height!=""):?>

			  	   		  line-height: <?php echo $line_height; ?>px !important;

			  	   		<?php endif;?>

			  	   		<?php if($color!=""):?>

			  	   		  color: <?php echo $color; ?> !important;

			  	   		<?php endif;?>

			   }

			   

		</style>



		<?php

		

			//***********************// MANAGE ANIMATION DATA ***********************//

     

		    // Build the animation classes

		    $animation_classes = $this->getCSSAnimation( $animation );





			//****************** MANAGE FONT DATA ******************//

         	

         	if($atts['use_fonts']=='no') :   // not use font-family default

		        // Build the data array

		        $text_font_data = $this->getFontsData( $google_fonts );

         

		        // Build the inline style

		        $text_font_inline_style = $this->googleFontsStyles( $text_font_data );   

                 

		        // Enqueue the right font   

		        $this->enqueueGoogleFonts( $text_font_data );





			  echo "<p class='".$class." ".$animation_classes."' style='".$text_font_inline_style."'>".$product->get_price_html()."</p>";

			else :



			  echo "<p class='".$class." ".$animation_classes."'>".$product->get_price_html()."</p>";



			endif; 

	

		

		return ob_get_clean ();



	}

	//=============== SHORTCODE EXCERPT

	public function ninja_woo_single_product_excert_shortcode($atts, $content = null){

        

        global $post,$product;

		extract ( $this->_shortcode_atts ( array (

				'el_class' => 'njt_product_excerpt' ,

				'text_align'=>'left',

				'font_size'=>'',

				'line_height'=>'',

				'color'=>'',

				'use_fonts'=>'yes',

				'google_fonts'=>'font_family:Abril Fatface|font_style:400 regular',

				'animation' => ''

		), $atts ) );

		ob_start ();

			

			$class=($el_class!="") ? $el_class : "njt_product_excerpt";

			if($el_class!="") $class_style="p.".$el_class;

			else $class_style="p.njt_product_excerpt";

			

			  ?>

			  <style type="text/css">

			  	   <?php 

			  	      

			  	      

			  	   		echo $class_style;?>{

			  	   		<?php if($font_size!=""):?>

			  	   		  font-size: <?php echo $font_size; ?>px !important;

			  	   		<?php endif;?>

			  	   		<?php if($line_height!=""):?>

			  	   		  line-height: <?php echo $line_height; ?>px !important;

			  	   		<?php endif;?>

			  	   		<?php if($color!=""):?>

			  	   		  color: <?php echo $color; ?> !important;

			  	   		<?php endif;?>



			  	   		  text-align: <?php echo $text_align; ?>;





			  	   }

			  </style>

			<?php



			//***********************// MANAGE ANIMATION DATA ***********************//

     

		    // Build the animation classes

		    $animation_classes = $this->getCSSAnimation( $animation );





			//****************** MANAGE FONT DATA ******************//

         	

         	if($atts['use_fonts']=='no') :   // not use font-family default

		        // Build the data array

		        $text_font_data = $this->getFontsData( $google_fonts );

         

		        // Build the inline style

		        $text_font_inline_style = $this->googleFontsStyles( $text_font_data );   

                 

		        // Enqueue the right font   

		        $this->enqueueGoogleFonts( $text_font_data );



		        //get_the_excerpt()

			  echo "<p class='".$class." ".$animation_classes."' style='".$text_font_inline_style."'>".apply_filters( 'woocommerce_short_description', $post->post_excerpt )."</p>";

			else :



			  echo "<p class='".$class." ".$animation_classes."'>".apply_filters( 'woocommerce_short_description', $post->post_excerpt )."</p>";



			endif; 



		return ob_get_clean ();

	}

	//================ SHORTCODE ADD TO CART

	public function ninja_woo_single_product_add_to_cart_shortcode($atts, $content = null)

	{

		extract ( $this->_shortcode_atts ( array (

				'el_class' => '',

				'animation' => ''

		), $atts ) );

		ob_start ();

		// Build the animation classes

		if($el_class=="") $el_class="njt_product_add_to_cart";



		$animation_classes = $this->getCSSAnimation( $animation );



		if (! empty ( $el_class ))

			echo '<div class="' . $el_class .' '.$animation_classes.'">';

		

				//woocommerce_template_single_add_to_cart ();

				woocommerce_template_single_add_to_cart();



		if (! empty ( $el_class ))

			echo '</div>';

		return ob_get_clean ();

	}

	//===================SHORTCODE SHOW CATEGORY PRODUCT SINGLE

	public function ninja_woo_single_product_cat_product_single_shortcode($atts, $content = null){



		global $post,$product;

		extract ( $this->_shortcode_atts ( array (

				'el_class' => '',

				'animation' => ''

		), $atts ) );

		ob_start ();

		// Build the animation classes

		if($el_class=="") $el_class="njt_product_product_meta";



		$animation_classes = $this->getCSSAnimation( $animation );



		if (! empty ( $el_class ))

			echo '<div class="' . $el_class .' '.$animation_classes.'">';

		// Call  function show category single product belong to  inside  single-product/meta.php

			woocommerce_template_single_meta ();  

	

		if (! empty ( $el_class ))

			echo '</div>';

		return ob_get_clean ();

	}

	//==========================SHORTCODE DESCRIPTION

	public function ninja_woo_single_product_description_shortcode($atts, $content = null){

        

        global $post,$product;

		extract ( $this->_shortcode_atts ( array (

				'el_class' => 'njt_product_content' ,

				'text_align'=>'left',

				'font_size'=>'',

				'line_height'=>'',

				'color'=>'',

				'use_fonts'=>'yes',

				'google_fonts'=>'font_family:Abril Fatface|font_style:400 regular',

				'animation' => ''

		), $atts ) );

		ob_start ();

			

			$class=($el_class!="") ? $el_class : "njt_product_content";

			if($el_class!="") $class_style="p.".$el_class;

			else $class_style="p.njt_product_content";

			

			  ?>

			  <style type="text/css">

			  	   <?php 

			  	      

			  	      

			  	   		echo $class_style;?>{

			  	   		<?php if($font_size!=""):?>

			  	   		  font-size: <?php echo $font_size; ?>px !important;

			  	   		<?php endif;?>

			  	   		<?php if($line_height!=""):?>

			  	   		  line-height: <?php echo $line_height; ?>px !important;

			  	   		<?php endif;?>

			  	   		<?php if($color!=""):?>

			  	   		  color: <?php echo $color; ?> !important;

			  	   		<?php endif;?>



			  	   		  text-align: <?php echo $text_align; ?>;





			  	   }

			  </style>

			<?php



			//***********************// MANAGE ANIMATION DATA ***********************//

     

		    // Build the animation classes

		    $animation_classes = $this->getCSSAnimation( $animation );





			//****************** MANAGE FONT DATA ******************//

         	

         	if($atts['use_fonts']=='no') :   // not use font-family default

		        // Build the data array

		        $text_font_data = $this->getFontsData( $google_fonts );

         

		        // Build the inline style

		        $text_font_inline_style = $this->googleFontsStyles( $text_font_data );   

                 

		        // Enqueue the right font   

		        $this->enqueueGoogleFonts( $text_font_data );





			  echo "<p class='".$class." ".$animation_classes."' style='".$text_font_inline_style."'>".apply_filters( 'woocommerce_short_description', $post->post_content )."</p>";

			else :

				
				//echo apply_filters( 'woocommerce_short_description', $post->post_content );
				//do_shortcode(get_the_content())
			  echo "<p class='".$class." ".$animation_classes."'>".apply_filters( 'woocommerce_short_description', $post->post_content )."</p>";



			endif; 



		return ob_get_clean ();



	}

        // SHORTCODE SHARE

	public function ninja_woo_single_product_share_shortcode($atts,$content=null){

		extract ( $this->_shortcode_atts ( array (

				'btn_share'=>'',

				'el_class' => '',

				'animation' => ''

		), $atts ) );

		ob_start();



		// Build the animation classes

		if($el_class=="") $el_class="njt_product_share";



		$animation_classes = $this->getCSSAnimation( $animation );



		if (! empty ( $el_class ))

			echo '<div class="' . $el_class .' '.$animation_classes.'">';



		    if($btn_share!=''):

		    	$array=explode(',', $btn_share);

				foreach ($array as $key => $value):

					if($value=='1'):

					?>

				<div id="fb-root"></div>

				<script>(function(d, s, id) {

				  var js, fjs = d.getElementsByTagName(s)[0];

				  if (d.getElementById(id)) return;

				  js = d.createElement(s); js.id = id;

				  js.src = "//connect.facebook.net/en/sdk.js#xfbml=1&version=v2.8";

				  fjs.parentNode.insertBefore(js, fjs);

				}(document, 'script', 'facebook-jssdk'));</script>

				<div style="float: left;" class="fb-share-button" data-href="<?php echo get_the_permalink(); ?>" data-layout="button_count" data-mobile-iframe="true"><a class="fb-xfbml-parse-ignore" target="_blank" href="<?php echo get_the_permalink(); ?>">Share</a></div><?php	

				    endif;

					if($value=='2'):

				    ?>

						<div style="float: left;padding: 3px 0px 0px 5px;">

							 <?php echo do_shortcode('[vc_tweetmeme]'); ?>

						</div>

					<?php

					endif;

					if($value=='3'):?>

					

					<div style="padding: 3px 0px 0px 5px; display:inline-block; float: left;">

					  <script type="text/javascript" src="https://apis.google.com/js/plusone.js" ></script>

						<g:plusone size="medium" ></g:plusone>

					</div>

						

					<?php

					endif;

				endforeach;

		    endif;

		if (! empty ( $el_class ))

			echo '</div>';	

		return ob_get_clean();

	}

	//=================SHORTCODE ADDTION INFOMATION  : shortcode show attribute,...when you customize Infomation product

	public function ninja_woo_single_product_additional_information_shortcode($atts, $content = null){

		global $product, $post;

		extract ( $this->_shortcode_atts ( array (

			'el_class' => '',

			'animation' => ''

		), $atts ) );

		ob_start ();

		

		// Build the animation classes

		if($el_class=="") $el_class="njt_product_product_additional_information";



		$animation_classes = $this->getCSSAnimation( $animation );



		if (! empty ( $el_class ))

			echo '<div class="' . $el_class .' '.$animation_classes.'">';





		if ( $product && ( $product->has_attributes() || ( $product->enable_dimensions_display() && ( $product->has_dimensions() || $product->has_weight() ) ) ) ) {

			wc_get_template( 'single-product/tabs/additional-information.php' );   // call function and show adtinal-information single product belongs to

		}



		if (! empty ( $el_class ))

			echo '</div>';

		return ob_get_clean ();

	}

	//=======================SHORTCODE SHOW DATA TABLE PRODUCT SINGLE (DESCTION : RATING ...)

	public function ninja_woo_single_product_show_tab_shortcode($atts, $content = null){

		extract ( $this->_shortcode_atts ( array (

				'el_class' => '',

				'animation' => ''

		), $atts ) );

		ob_start ();

		// Build the animation classes

		if($el_class=="") $el_class="njt_product_tab";



		$animation_classes = $this->getCSSAnimation( $animation );



		if (! empty ( $el_class ))

			echo '<div class="' . $el_class .' '.$animation_classes.'">';



		woocommerce_output_product_data_tabs ();   // show tab (descrip, add infomation, review,addtion infomation...) of woo inside single-product/data-tab.php

		if (! empty ( $el_class ))

			echo '</div>';

		return ob_get_clean ();

	}

	// SHORTCODE RELATE 

	public function ninja_woo_single_product_relate_shortcode($atts,$content=null){



		extract ( $this->_shortcode_atts ( array (

				'posts_per_page'=>3,

				'columns'=>3,

				'orderby'=>'rand',

				'el_class' => '',

				'animation' => ''

		), $atts ) );

		ob_start ();



		?>

		<?php

			

				if($columns==1) {$width=100/1;}

				if($columns==2) {$width=100/2;}

				if($columns==3) {$width=100/3;}

				if($columns==4) {$width=100/4;}

				if($columns==5) {$width=100/5;}

			

				if($columns==6) {$width=100/6;}

			



		?>	

		<style type="text/css">

                .site-main .product_relate ul.products,.product_relate ul.products{margin: 0 -10px !important;}

				.site-main .product_relate ul.products li.product,.product_relate ul.products li.product{

					width: <?php echo $width;?>% !important;

                                        margin:0px !important;

                                        padding: 0 !important;

                                        

					float: left;

				}

				.site-main .product_relate ul.products li.product a,.product_relate ul.products li.product a{display: block; padding: 0 10px;}



                .site-main .product_relate ul.products li.product:nth-child(<?php echo $columns; ?>n),.product_relate ul.products li.product:nth-child(<?php echo $columns; ?>n){ padding: 0px !important;}



				.product_relate ul.products li.product img{width: 100% !important;}

                .product_relate ul.products li{margin:0px !important;}

                             

		</style>

		<?php

		// Build the animation classes

		if($el_class=="") $el_class="njt_product_relate";



		$animation_classes = $this->getCSSAnimation( $animation );



		if (! empty ( $el_class ))

			echo '<div class="' . $el_class .' '.$animation_classes.'">';



                        echo '<div class="product_relate">';

		              echo woocommerce_related_products($atts);

                        echo '</div>';

		if (! empty ( $el_class ))

			echo '</div>';

		return ob_get_clean ();

	}

	// SHORTCODE REVIEWS

	public function ninja_woo_single_product_review_shortcode($atts,$content=null){

		extract ( $this->_shortcode_atts ( array (

			'el_class' => '',

			'animation' => ''

		), $atts ) );

		ob_start ();

		// Build the animation classes

		if($el_class=="") $el_class="njt_product_product_review";



		$animation_classes = $this->getCSSAnimation( $animation );



		if (! empty ( $el_class ))

			echo '<div class="' . $el_class .' '.$animation_classes.'">';

		if(comments_open() ){

			comments_template();   // simple only template comments of woo

		}

		if (! empty ( $el_class ))

			echo '</div>';

		return ob_get_clean ();

	}

	// SHORTCODE UP SELL

	public function ninja_woo_single_product_upsell_shortcode($atts,$content=null){

		extract ( $this->_shortcode_atts ( array (

				'posts_per_page'=>4,

				'columns'=>4,

				'orderby'=>'date',

				'el_class' => '',

				'animation' => '' 

		), $atts ) );

		ob_start ();

		if($columns==1) {$width=100/1;}

		if($columns==2) {$width=100/2;}

		if($columns==3) {$width=100/3;}

		if($columns==4) {$width=100/4;}

		if($columns==5) {$width=100/5;}

		if($columns==6) {$width=100/6;}?>

<style type="text/css">

                .site-main ul.products,ul.products{margin: 0 -10px !important;}

				.site-main ul.products li.product,ul.products li.product{

					width: <?php echo $width;?>% !important;

                                        margin:0px !important;

                                        padding: 0 !important;

                                        

					float: left;

				}

				.site-main ul.products li.product a,ul.products li.product a{display: block; padding: 0 10px;}



                .site-main ul.products li.product:nth-child(<?php echo $columns; ?>n),ul.products li.product:nth-child(<?php echo $columns; ?>n){ padding: 0px !important;}



				ul.products li.product img{width: 100% !important;}

                ul.products li{margin:0px !important;}

                             

		</style>

		<?php

		// Build the animation classes

		if($el_class=="") $el_class="njt_product_upsell";



		$animation_classes = $this->getCSSAnimation( $animation );



		if (! empty ( $el_class ))

			echo '<div class="' . $el_class .' '.$animation_classes.'">';



		woocommerce_upsell_display ( $posts_per_page, $columns, $orderby);

		if (! empty ( $el_class ))

			echo '</div>';

		return ob_get_clean ();

	}



	// REQUEST A QUOTE

	public function ninja_dtwpb_yith_ywraq_add_to_quote_shortcode($atts,$content=null){

		extract( shortcode_atts(array(

			'defined_class' => ''

		), $atts) );

		ob_start();

		if(	! empty($defined_class) )

			echo '<div class="'.esc_attr($defined_class).'">';

		

			if ( defined( 'YITH_YWRAQ_VERSION' ) )



				YITH_YWRAQ_Frontend()->add_button_single_page();

			

		if(	! empty($defined_class) )

			echo '</div>';

		

		return ob_get_clean();

		

	}



	// PRODUCT CATEGORY SHORTCODE

	public function product_category_shortcode($atts, $content = null) {

		extract ( $this->_shortcode_atts ( array (

			'per_page' => '12',

		    'columns'  => '4',

		    'orderby'  => 'menu_order title',

		    'order'    => 'asc',

		   

		    'operator' => 'IN', //// Possible values are 'IN', 'NOT IN', 'AND'.

			'define_class' => ''

		), $atts ) );

		ob_start ();

	    if($columns==1) {$width=100/1;}

		if($columns==2) {$width=100/2;}

		if($columns==3) {$width=100/3;}

		if($columns==4) {$width=100/4;}

		if($columns==5) {$width=100/5;}

		if($columns==6) {$width=100/6;}?>

		

		<style type="text/css">

                .site-main .product_category_ninja ul.products,.product_category_ninja ul.products{margin: 0 -10px !important;}

				.site-main .product_category_ninja ul.products li.product,.product_category_ninja ul.products li.product{

					width: <?php echo $width;?>% !important;

                                        margin:0px !important;

                                        padding: 0 !important;

                                        

					float: left;

				}

				.site-main .product_category_ninja ul.products li.product a,.product_category_ninja ul.products li.product a{display: block; padding: 0 10px;}



                .site-main .product_category_ninja ul.products li.product:nth-child(<?php echo $columns; ?>n),.product_category_ninja ul.products li.product:nth-child(<?php echo $columns; ?>n){ padding: 0px !important;}



				.product_category_ninja ul.products li.product img{width: 100% !important;}

                .product_category_ninja ul.products li{margin:0px !important;}

                             

		</style>



		<?php

		if (! empty ( $defined_class ))

			echo '<div class="' . $defined_class . '">';

			echo '<div class="product_category_ninja">';

		    if(is_product_category()):

		    global $wp_query;

			$term_id= $wp_query->get_queried_object_id();  // id of category selected



			

			$cat_name= get_cat_slug($term_id);

            

			echo	do_shortcode("[product_category category=".$cat_name." per_page=".$per_page." columns=".$columns." orderby=".$orderby." order=".$order." operator=".$operator."]");

			endif;



		if (! empty ( $defined_class ))

			echo '</div>';

			echo '</div>';

		

		return ob_get_clean ();

	}









   // CART SHORTCODE



	//================ SHORTCODE TABLE

	public function ninja_page_cart_table_shortcode($atts, $content = null) {

        extract( shortcode_atts(array(

			'el_class' => '',

			'animation' => ''

		), $atts) );

		ob_start();

		// Build the animation classes

		if($el_class=="") $el_class="njt_cart_table";



		$animation_classes = $this->getCSSAnimation( $animation );



		if (! empty ( $el_class ))

			echo '<div class="' . $el_class .' '.$animation_classes.'">';

		

			echo Ninja_Woo_Shortcode_Cart::output();

			

		if(	! empty($el_class) )

			echo '</div>';

		

		return ob_get_clean();

	}

	//================ SHORTCODE TOTAL

	public function ninja_page_cart_total_shortcode($atts, $content = null){

 		if(WC()->cart->is_empty())

			return '';

		

		extract( shortcode_atts(array(

			'el_class' => '',

			'animation' => ''

		), $atts) );

		ob_start();
		?>
		<style type="text/css">
			.wc-proceed-to-checkout a.checkout-button{
				display: block;
				    text-align: center;
				    margin-bottom: 1em;
				    font-size: 1.25em;
				    padding: 1em;
				background-color: #a46497;
				    color: #fff;
				    -webkit-font-smoothing: antialiased;
			}
			table.shop_table.shop_table_responsive{
    border: 1px solid rgba(0,0,0,.1);
    margin: 0 -1px 24px 0;
    text-align: left;
    width: 100%;
    border-collapse: separate;
    border-radius: 5px;
}
		.cart_totals table th, .cart_totals table td{
			border-top: 1px solid rgba(0,0,0,.1) !important;
			padding: 9px 12px;
		}
		</style>
		<?php
		// Build the animation classes

		if($el_class=="") $el_class="njt_cart_total";



		$animation_classes = $this->getCSSAnimation( $animation );



		if (! empty ( $el_class ))

			echo '<div class="woocommerce' . $el_class .' '.$animation_classes.'">';

		

		

			woocommerce_cart_totals();

		

		if(!empty($el_class))

		echo '</div>';



		return ob_get_clean(); 

    }

    //================ SHORTCODE CROSS SELL

    public function ninja_page_cart_cross_sell_shortcode($atts, $content = null) {

    	

		extract ( $this->_shortcode_atts ( array (

				'posts_per_page'=>3,

				'columns'=>3,

				'orderby'=>'rand',

				'el_class' => '',

				'animation' => '' 

		), $atts ) );

		

		ob_start ();

			

				if($columns==1) {$width=100/1;}

				if($columns==2) {$width=100/2;}

				if($columns==3) {$width=100/3;}

				if($columns==4) {$width=100/4;}

				if($columns==5) {$width=100/5;}

				if($columns==6) {$width=100/6;}

			

		?>

	

		<style type="text/css">

            /*    .site-main ul.products,ul.products{margin: 0 -10px !important;} 

				.site-main ul.products li.product,ul.products li.product{

					width: <?php echo $width;?>% !important;

                                        margin:0px !important;

                                        padding: 0 !important;

                                        

					float: left;

					list-style-type: none;

				}

				.site-main ul.products li.product a,ul.products li.product a{display: block; padding: 0 10px;}



                .site-main ul.products li.product:nth-child(<?php echo $columns; ?>n),ul.products li.product:nth-child(<?php echo $columns; ?>n){ padding: 0px !important;}



				ul.products li.product img{width: 100% !important;}

                ul.products li{margin:0px !important;}

               */   



               .site-main ul.products li.product,ul.products li.product{

					

					list-style-type: none;

				}           

				ul.products li .desc{

					text-align: center;

				}

				ul.products li .desc h4{

					font-weight: 600;

				}

				a.button.product_type_simple.add_to_cart_button.ajax_add_to_cart{

					    margin-top: 1em;

    

    					margin-left: 23%;

				}

		</style>

	

		

		<?php

		// Build the animation classes

		if($el_class=="") $el_class="njt_cart_cross_sell";



		$animation_classes = $this->getCSSAnimation( $animation );



		if (! empty ( $el_class ))

			echo '<div class="' . $el_class .' '.$animation_classes.'">';

		//woocommerce_cross_sell_display ( $posts_per_page, $columns, $orderby);

		woocommerce_cross_sell_display ( $posts_per_page, 4, $orderby);

		if (! empty ( $el_class ))

			echo '</div>';

		return ob_get_clean ();

	}

	//================ SHORTCODE CART EMPTY

	public function ninja_page_cart_empty_shortcode($atts, $content = null){



		extract( shortcode_atts(array(

			'defined_class' => '',

			'text_empty'=>'Your cart is currently empty'

		), $atts) );

		ob_start();

		if(	! empty($defined_class) )

			echo '<div class="'.esc_attr($defined_class).'">';?>

		

			<p class="cart-empty">

			

				<?php _e($text_empty, 'woocommerce' ) ?>

			</p>



			<?php do_action( 'woocommerce_cart_is_empty' ); ?>



			<?php if ( wc_get_page_id( 'shop' ) > 0 ) : ?>

				<p class="return-to-shop">

					<a class="button wc-backward" href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>">

						<?php _e( 'Return To Shop', 'woocommerce' ) ?>

					</a>

				</p>

			<?php endif; ?>



		<?php	

		if(	! empty($defined_class) )

			echo '</div>';

		return ob_get_clean(); 

	}

   // CHECKOUT SHORTCODE	

	

	//================ SHORTCODE BILLING INFOMARTION

	public function ninja_page_checkout_billing_information_shortcode($atts, $content = null){

			

		$checkout = WC()->checkout();

		extract( shortcode_atts(array(

			'el_class' => '',

			'animation' => ''

		), $atts) );

		ob_start();

		// Build the animation classes

		if($el_class=="") $el_class="njt_product_checkout_billing";



		$animation_classes = $this->getCSSAnimation( $animation );



		if (! empty ( $el_class ))

			echo '<div class="' . $el_class .' '.$animation_classes.'">';

			if ( sizeof( $checkout->checkout_fields ) > 0 ) :

				do_action( 'woocommerce_checkout_billing' );

			endif;

		if(	! empty($el_class) )

			echo '</div>';

		

		return ob_get_clean();

	}

	//================ SHORTCODE SHIPPING INFORMATION FORM

	public function ninja_page_checkout_shipping_information_form_shortcode($atts, $content = null){



		$checkout = WC()->checkout();

		extract( shortcode_atts(array(

			'el_class' => '',

			'animation' => ''

		), $atts) );

		ob_start();

		// Build the animation classes

		if($el_class=="") $el_class="njt_product_checkout_shipping";



		$animation_classes = $this->getCSSAnimation( $animation );



		if (! empty ( $el_class ))

			echo '<div class="' . $el_class .' '.$animation_classes.'">';



			if ( sizeof( $checkout->checkout_fields ) > 0 ) :

				do_action( 'woocommerce_checkout_shipping' );

			    

			endif;

		if(	! empty($el_class) )

			echo '</div>';

		

		return ob_get_clean();



	}

	//================ SHORTCODE ORDER REVIEW

	public function ninja_page_checkout_order_review_shortcode($atts, $content = null){



		$checkout = WC()->checkout();

		extract( shortcode_atts(array(

			'el_class' => '',

			'animation' => ''

		), $atts) );

		ob_start();

		// Build the animation classes

		if($el_class=="") $el_class="njt_checkout_order_review";



		$animation_classes = $this->getCSSAnimation( $animation );



		if (! empty ( $el_class ))

			echo '<div class="' . $el_class .' '.$animation_classes.'">'; ?>

			

			<h3 id="order_review_heading"><?php _e( 'Your order', 'woocommerce' ); ?></h3>

		

			<?php do_action( 'woocommerce_checkout_before_order_review' ); ?>

		

			<div id="order_review" class="woocommerce-checkout-review-order">

				<?php do_action( 'woocommerce_checkout_order_review' ); ?>

			</div>

		

			<?php do_action( 'woocommerce_checkout_after_order_review' ); ?>

		<?php

		if(	! empty($el_class) )

			echo '</div>';

		

		return ob_get_clean(); 

	}



	// =============

	public function ninja_page_order_review_shortcode($atts, $content = null){



		extract( shortcode_atts(array(

			'el_class' => '',

			'animation'=>''

		), $atts) );

		ob_start();

		// Build the animation classes

		if($el_class=="") $el_class="njt_checkout_order";



		$animation_classes = $this->getCSSAnimation( $animation );



		if (! empty ( $el_class ))

			echo '<div class="' . $el_class .' '.$animation_classes.'">';?>

			<?php woocommerce_order_review();?>

		<?php

		if(	! empty($el_class) )

			echo '</div>';

		

		return ob_get_clean(); 

	}

	// =============

	public function ninja_page_order_payment_shortcode($atts, $content = null){

		extract( shortcode_atts(array(

			'el_class' => '',

			'animation'=>''

		), $atts) );

		ob_start();

		// Build the animation classes

		if($el_class=="") $el_class="njt_checkout_order_payment";



		$animation_classes = $this->getCSSAnimation( $animation );



		if (! empty ( $el_class ))

			echo '<div class="' . $el_class .' '.$animation_classes.'">';?>
			
		     <?php if ( ! is_ajax() ):

						do_action( 'woocommerce_review_order_before_payment' );

				   endif;

			?>

			<?php woocommerce_checkout_payment();?>





			<?php	

				if ( ! is_ajax() ):

					do_action( 'woocommerce_review_order_after_payment' );

				endif;

			?>

		<?php

		if(	! empty($el_class) )

			echo '</div>';

		

		return ob_get_clean(); 

	}

	

	// MYACOUNT SHORTCODE



	// SHORTCODE MY ACCOUNT LOGIN FORM

    public function ninja_page_my_account_login_form_shortcode($atts, $content = null){

		ob_start();

		

		wc_get_template( 'myaccount/form-login.php', array( 'woo-composer-page-template' => 1 ), NINJA_WOO_PAGE_DIR . 'woo-composer-page-template/', NINJA_WOO_PAGE_DIR . 'woo-composer-page-template/' );

		

		return ob_get_clean();



    }

	// SHORTCODE MY ACCOUNT REGISTER FORM

	public function ninja_page_my_account_register_form_shortcode($atts, $content = null){



		ob_start();

		

		wc_get_template( 'myaccount/form-register.php', array( 'woo-composer-page-template' => 1 ), NINJA_WOO_PAGE_DIR . 'woo-composer-page-template/', NINJA_WOO_PAGE_DIR . 'woo-composer-page-template/' );

		

		

		return ob_get_clean();

    

	}

	// SHORTCODE My Account Dashboard

	public function ninja_page_my_account_dashboard_shortcode($atts, $content = null){

	

		extract( shortcode_atts(array(

		'defined_class' => ''

		), $atts) );

		ob_start();

		if(	! empty($defined_class) )

			echo '<div class="'.esc_attr($defined_class).'">';

		

		if( !empty($content) ){

			global $current_user;

			?>

			<p><?php

	/* translators: 1: user display name 2: logout url */

	printf(

		__( 'Hello %1$s (not %1$s? <a href="%2$s">Log out</a>)', 'woocommerce' ),

		'<strong>' . esc_html( $current_user->display_name ) . '</strong>',

		esc_url( wc_logout_url( wc_get_page_permalink( 'myaccount' ) ) )

	);

?></p>

			<p>

				<?php echo $content;?>

			</p>

			<?php

		}else{

			wc_get_template( 'myaccount/dashboard.php', array(

			'current_user' => get_user_by( 'id', get_current_user_id() ),

			) );

		}

		

		if(	! empty($defined_class) )

			echo '</div>';

		

		return ob_get_clean();



	}

	// SHORTCODE MY ACCOUNT ORDER

	public function ninja_page_my_account_order_shortcode($atts, $content = null){



	   extract( shortcode_atts(array(

		'defined_class' => ''

			), $atts) );

			ob_start();

			if(	! empty($defined_class) )

				echo '<div class="'.esc_attr($defined_class).'">';

		

		global $wp,$dtwbp_my_account_current_order_id,$dtwpb_wc_get_endpoint_url_tab_id;

		

		VcShortcodeAutoloader::getInstance()->includeClass( 'WPBakeryShortCode_VC_Tta_Section' );

		$tab_id = end(WPBakeryShortCode_VC_Tta_Section::$section_info);

		if($tab_id){

			do_action('ninja_woocomposer_account_orders_in_tab',$tab_id);

			do_action('ninja_woocomposer_wc_get_endpoint_url',$tab_id);

		}

		

		if( isset($wp->query_vars['orders']) ){

			$value = $wp->query_vars['orders'];

			do_action( 'woocommerce_account_orders_endpoint', $value );

			

		}elseif( isset($wp->query_vars['view-order']) ){

			$value = $wp->query_vars['view-order'];

			if($tab_id){

				$myaccount_url = get_permalink().'#'.$tab_id['tab_id'];

				do_action('ninja_woocomposer_woocommerce_account_view_order_backorder',$myaccount_url);

			}

			do_action( 'woocommerce_account_view-order_endpoint', $value );

			

		}elseif( isset($wp->query_vars['payment-methods']) ){

			$value = $wp->query_vars['payment-methods'];

			do_action( 'woocommerce_account_view-order_endpoint', $value );

			

		}elseif( isset($wp->query_vars['add-payment-method']) ){

			$value = $wp->query_vars['add-payment-method'];

			do_action( 'woocommerce_account_view-order_endpoint', $value );

			

		}else{

			$value = '';

			do_action( 'woocommerce_account_orders_endpoint', $value );

		}



		if(	! empty($defined_class) )

			echo '</div>';

		$dtwbp_my_account_current_order_id = null;

		$dtwpb_wc_get_endpoint_url_tab_id = null;

		return ob_get_clean();

	}



	// SHORTCODE My Account Downloads

	public function ninja_page_my_account_download_shortcode($atts, $content = null){

      

      extract( shortcode_atts(array(

		'defined_class' => ''

			), $atts) );

			ob_start();

			if(	! empty($defined_class) )

				echo '<div class="'.esc_attr($defined_class).'">';

		

		do_action('woocommerce_account_downloads_endpoint');

		

		if(	! empty($defined_class) )

			echo '</div>';

		

		return ob_get_clean();



	}



	// SHORTCODE My Account Address

	public function ninja_page_my_account_address_shortcode($atts, $content = null){



		extract( shortcode_atts(array(

		'defined_class' => ''

			), $atts) );

			ob_start();

		global $wp, $ninja_woocomposer_wc_get_endpoint_url_tab_id;

		

		$type = '';

		

		if( isset($wp->query_vars['edit-address']) ){

			$type = $wp->query_vars['edit-address'];



		}else{

			$type = wc_edit_address_i18n( sanitize_title( $type ), true );

		}





		

		VcShortcodeAutoloader::getInstance()->includeClass( 'WPBakeryShortCode_VC_Tta_Section' );

		$tab_id = end(WPBakeryShortCode_VC_Tta_Section::$section_info);



		//if($tab_id){

		//	do_action('ninja_woocomposer_wc_get_endpoint_url',$tab_id);

		//}

			if(	! empty($defined_class) )

				echo '<div class="'.esc_attr($defined_class).'">';

		

		//WC_Shortcode_My_Account::edit_address( $type );

				njt_my_account_edit_address($type);



		if(	! empty($defined_class) )

			echo '</div>';

		$ninja_woocomposer_wc_get_endpoint_url_tab_id = null;

		return ob_get_clean();



	}



   // SHORTCODE MY ACCOUNT DETAILS

	public function ninja_page_my_account_edit_shortcode($atts, $content = null){



		extract( shortcode_atts(array(

		'defined_class' => ''

			), $atts) );

			ob_start();

			if(	! empty($defined_class) )

				echo '<div class="'.esc_attr($defined_class).'">';

		

		do_action('woocommerce_account_edit-account_endpoint');

		

		if(	! empty($defined_class) )

			echo '</div>';

		

		return ob_get_clean();



	}



    // SHORTCODE MY ACCOUNT LOGOUT

	public function ninja_page_my_account_logout_shortcode($atts, $content = null){



		extract( shortcode_atts(array(

		'defined_class' => ''

			), $atts) );

			ob_start();

			if(	! empty($defined_class) )

				echo '<div class="'.esc_attr($defined_class).'">';

		

		foreach ( wc_get_account_menu_items() as $endpoint => $label ) :

			if( $endpoint == 'customer-logout' ):

			?>

			<a href="<?php echo esc_url( wc_get_account_endpoint_url( $endpoint ) ); ?>"><?php echo esc_html( $label ); ?></a>

			<?php 

			endif;

		endforeach;

		

		if(	! empty($defined_class) )

			echo '</div>';

		

		return ob_get_clean();



	}



// ORDER RECEIVED



	// SHORTCODE THANK YOU

	public function ninja_page_order_received_thankyou_shortcode($atts, $content = null){



		global $wp;

		extract( shortcode_atts(array(

		'defined_class' => ''

			), $atts) );



		$order = wc_get_order($wp->query_vars['order-received']);

			ob_start();

			if(	! empty($defined_class) )

			echo '<div class="'.esc_attr($defined_class).'">';

				

			  if ( $order ) :

			    do_action( 'ninja_woocomposer_thankyou_order', $order );

			  endif;

		

		if(	! empty($defined_class) )

			echo '</div>';

		

		return ob_get_clean();



	}



	// SHORTCODE ORDER DETAILS

	public function ninja_page_order_received_order_detail_shortcode($atts, $content = null){

		global $wp;

		extract( shortcode_atts(array(

		'defined_class' => ''

			), $atts) );



		$order = wc_get_order($wp->query_vars['order-received']);



		ob_start();

			if(	! empty($defined_class) )

			echo '<div class="'.esc_attr($defined_class).'">';



			  if ( $order )

			    do_action( 'ninja_woocomposer_order_detail', $order );

		

			if(	! empty($defined_class) )

			echo '</div>';

		

		return ob_get_clean();

	}



	// SHORTCODE CUSTOMER DETAIL

	public function ninja_page_order_received_customer_detail_shortcode($atts, $content = null){

		global $wp;

		extract( shortcode_atts(array(

		'defined_class' => ''

			), $atts) );



		$order = wc_get_order($wp->query_vars['order-received']);

			ob_start();

			if(	! empty($defined_class) )

			echo '<div class="'.esc_attr($defined_class).'">';

			  if ( $order )

			    do_action( 'ninja_woocomposer_customer_detail', $order );

		

		if(	! empty($defined_class) )

			echo '</div>';

		

		return ob_get_clean();

	}



	//SHORTCODE BILLING ADDRESS

	public function ninja_page_order_received_billing_address_shortcode($atts, $content = null){



	    global $wp;

		extract( shortcode_atts(array(

		'defined_class' => ''

			), $atts) );



		$order = wc_get_order($wp->query_vars['order-received']);

			ob_start();

			if(	! empty($defined_class) )

			echo '<div class="'.esc_attr($defined_class).'">';

		

			  if ( $order )

			    do_action( 'ninja_woocomposer_billing_address', $order );

	

		

		if(	! empty($defined_class) )

			echo '</div>';

		

		return ob_get_clean();

	}





//  DEFINE FUNCTION USE GOOGLE FONT AND ANIMATION WITH VISUAL COMPOSER



	// GOOGLE FONT

	// Build the string of values in an Array

	protected function getFontsData( $fontsString ) {   

 

    // Font data Extraction

    $googleFontsParam = new Vc_Google_Fonts();      

    $fieldSettings = array();

    $fontsData = strlen( $fontsString ) > 0 ? $googleFontsParam->_vc_google_fonts_parse_attributes( $fieldSettings, $fontsString ) : '';

    return $fontsData;

     

	}



	// Build the inline style starting from the data

    protected function googleFontsStyles( $fontsData ) {

         

        // Inline styles

        $fontFamily = explode( ':', $fontsData['values']['font_family'] );

        $styles[] = 'font-family:' . $fontFamily[0];

        $fontStyles = explode( ':', $fontsData['values']['font_style'] );

        $styles[] = 'font-weight:' . $fontStyles[1];

        $styles[] = 'font-style:' . $fontStyles[2];

         

        $inline_style = '';     

        foreach( $styles as $attribute ){           

            $inline_style .= $attribute.'; ';       

        }   

         

        return $inline_style;

         

    }

     

    // Enqueue right google font from Googleapis

    protected function enqueueGoogleFonts( $fontsData ) {

         

        // Get extra subsets for settings (latin/cyrillic/etc)

        $settings = get_option( 'wpb_js_google_fonts_subsets' );

        if ( is_array( $settings ) && ! empty( $settings ) ) {

            $subsets = '&subset=' . implode( ',', $settings );

        } else {

            $subsets = '';

        }

         

        // We also need to enqueue font from googleapis

        if ( isset( $fontsData['values']['font_family'] ) ) {

            wp_enqueue_style( 

                'vc_google_fonts_' . vc_build_safe_css_class( $fontsData['values']['font_family'] ), 

                '//fonts.googleapis.com/css?family=' . $fontsData['values']['font_family'] . $subsets

            );

        }

         

    }

    //

    protected function getCSSAnimation( $css_animation ) {

			$output = '';

			if ( '' !== $css_animation && 'none' !== $css_animation ) {

				wp_enqueue_script( 'waypoints' );

				wp_enqueue_style( 'animate-css' );

				$output = ' wpb_animate_when_almost_visible wpb_' . $css_animation . ' ' . $css_animation;

			}



			return $output;

		}

}



new NINJA_Page_WooComposer_Shortcode();



/**

 * Cart Shortcode

 * NINJA_WC_Shortcode_Cart 

 */

if(defined('WOOCOMMERCE_VERSION')){

class Ninja_Woo_Shortcode_Cart extends WC_Shortcode_Cart{

	/**

	 * Output the cart shortcode.

	 */

	public static function output($atts=null) {

		// Constants

		if ( ! defined( 'WOOCOMMERCE_CART' ) ) {

			define( 'WOOCOMMERCE_CART', true );

		}



		// Update Shipping

		if ( ! empty( $_POST['calc_shipping'] ) && wp_verify_nonce( $_POST['_wpnonce'], 'woocommerce-cart' ) ) {

			self::calculate_shipping();

		}



		// Check cart items are valid

		do_action( 'woocommerce_check_cart_items' );



		// Calc totals

		WC()->cart->calculate_totals();



		if ( WC()->cart->is_empty() ) {

			wc_get_template( 'cart/cart-empty.php',  array('woo-composer-page-template' => 1), NINJA_WOO_PAGE_DIR . 'woo-composer-page-template/', NINJA_WOO_PAGE_DIR . 'woo-composer-page-template/' );

		} else {

			wc_get_template( 'cart/cart.php',  array('woo-composer-page-template' => 1), NINJA_WOO_PAGE_DIR . 'woo-composer-page-template/', NINJA_WOO_PAGE_DIR . 'woo-composer-page-template/'  );

		}

	}

}

}