<?php
get_header( 'shop' );
do_action( 'mwb_cgc_before_title' );
the_title( '<h1 class="product_title entry-title mwb_cgc_title">', '</h1>' );
global $post;
$product_id = $post->ID;
$product_pricing = get_post_meta( $product_id, 'mwb_wgm_pricing', true );
if ( isset( $product_pricing ) && ! empty( $product_pricing ) ) {

	$public_obj = new MWB_WGM_Shipping_Manager();
	$price_type = $public_obj->cgc_get_prcie_type( $product_pricing );
	$price_html = $public_obj->cgc_get_prcie_html( $product_pricing );

}
$checkout_url = wc_get_page_permalink( 'checkout' ) . '?add-to-cart=' . $post->ID;


?>
<!-- mwb-cgc-main-container -->
	<div class="mwb-cgc-main-container">
		<?php do_action( 'mwb_cgc_before_main_content' ); ?>
		<form class="cart" action="<?php echo $checkout_url; ?>" method="post" enctype='multipart/form-data'>
		<!-- mwb-cgc-wrapper -->
		<div class="mwb-cgc-wrapper">
			<!-- mwb-cgc-wrapper-row -->
			<div class="mwb-cgc-wrapper-row clearfix">
				<!-- mwb-cgc-product-image -->
				<div class="mwb-cgc-product-image mwb-cgc-column">
					<div class="mwb-cgc-product-image-wrapper">
						<h4 class="mwb-cgc-heading"><?php esc_html_e( 'Gift Card Design', 'woocommerce-ultimate-gift-card' ); ?></h4>
						<ul>
							<?php
							$wcgc_plugin_enable = get_option( 'wcgc_plugin_enable', false );
							$wcgc_image_enable = get_option( 'wcgc_image_enable', false );

							if ( isset( $wcgc_image_enable ) && ! empty( $wcgc_image_enable ) && $wcgc_image_enable == 'default_img' ) {
								list_default_images();
							}
							if ( isset( $wcgc_image_enable ) && ! empty( $wcgc_image_enable ) && $wcgc_image_enable == 'upload_img' ) {
								list_all_uploaded_images();
							}
							if ( isset( $wcgc_image_enable ) && ! empty( $wcgc_image_enable ) && $wcgc_image_enable == 'upload_and_default_img' ) {
								list_uploaded_images();
								list_default_images();
							}
							?>
						</ul>
					</div>
				</div><!-- mwb-cgc-product-image -->
				<!-- mwb-cgc-preview -->
				<div class="mwb-cgc-column mwb-cgc-preview">
					<div class="mwb-cgc-preview-wrapper">
						<h4 class="mwb-cgc-heading"><?php esc_html_e( 'Preview', 'woocommerce-ultimate-gift-card' ); ?></h4>
						<div class="mwb-cgc-preview-image"><img class="mwb_cgc_preview_image" src="<?php echo MWB_WGM_URL . 'Shipping/public/images/gift_card-1.jpg'; ?>?>" alt="image"></div>

						<div class="mwb-cgc-coupon-code-preview">
							<p class="mwb-cgc-coupon"><span><?php echo MWB_WGM_Shipping_Manager::get_coupon_prefix() . 'XXXXX'; ?></span></p>
							<div class="clearfix">
								<p class="mwb-cgc-expiry"><label><?php esc_html_e( 'ED:', 'woocommerce-ultimate-gift-card' ); ?> </label><?php echo MWB_WGM_Shipping_Manager::get_expiry_date_format( get_option( 'mwb_wgm_general_setting_giftcard_expiry', 10 ) ); ?></p>
								<p class="mwb-cgc-coupon-price"><label class="mwb-cgc-pro-price"><?php echo wc_price( 100 ); ?></label></p>
							</div>
						</div>
						<div class="mwb-cgc-from-name">
							<p class="mwb-cgc-gift-content"><?php esc_html_e( 'A gift is waiting for you!', 'woocommerce-ultimate-gift-card' ); ?></p>
							<div class="mwb-cgc-name"><label><?php esc_html_e( 'From: ', 'woocommerce-ultimate-gift-card' ); ?></label><span class="mwb_cgc_from_name"><?php esc_html_e( 'Your Name', 'woocommerce-ultimate-gift-card' ); ?></span></div>
						</div>
						<div class="mwb-cgc-desclaimer"><?php echo MWB_WGM_Shipping_Manager::get_disclaimer(); ?>
						</div>
					</div>
				</div><!-- mwb-cgc-preview -->
				<!-- mwb-cgc-gift-details -->
				<div class="mwb-cgc-column mwb-cgc-gift-details">
					<div class="mwb-cgc-gift-details-wrapper">
						<h4 class="mwb-cgc-heading"><?php esc_html_e( 'Gift Card Details', 'woocommerce-ultimate-gift-card' ); ?></h4>
						<p class="mwb-cgc-price">
							<span><?php echo ( $price_type ); ?></span>
						</p>
						<p class="mwb-cgc-price">
							<?php echo ( $price_html ); ?>
						</p>
						<?php if ( $public_obj->mwb_check_scheduling_enable() ) { ?>
						<p class="mwb_cgc_heading"><?php esc_html_e( 'Send Date', 'woocommerce-ultimate-gift-card' ); ?></p>
						<p>
							<input type="text"  name="mwb_wgm_send_date" id="mwb_wgm_send_date" class="mwb_wgm_send_date">
						</p>
						<?php } ?>
						<p>
							<textarea id="mwb_wgm_message" name="mwb_wgm_message" cols="30" rows="3" class="mwb-cgc-text" placeholder="<?php esc_html_e( 'Gift Message', 'woocommerce-ultimate-gift-card' ); ?>"></textarea>
						</p>
						<p class="mwb_cgc_heading"><?php esc_html_e( 'Delivery Method', 'woocommerce-ultimate-gift-card' ); ?></p>
						<?php do_action( 'mwb_add_delivery_methods', $product_id ); ?>
						<p><label><?php esc_html_e( 'From: ', 'woocommerce-ultimate-gift-card' ); ?></label> <input type="text"  id="mwb_wgm_from_name" class="mwb-cgc-text" name="mwb_wgm_from_name" placeholder="<?php esc_html_e( 'Buyer\'s Name: ', 'woocommerce-ultimate-gift-card' ); ?>"></p>
					</div>
					<div class="mwb-cgc-gift-details-wrapper mwb-cgc-button-wrapper">
						<input type="hidden" value="<?php echo $post->ID; ?>" name="product_id">
						<input type="hidden" value="1" name="quantity">
						<button type="submit" value="" class="single_add_to_cart_button button alt support_cart" name="support_cart"><?php esc_html_e( 'Buy Now', 'woocommerce-ultimate-gift-card' ); ?></button>
					</div>
				</div><!-- mwb-cgc-gift-details -->
			</div>	<!-- mwb-cgc-wrapper-row -->
		</div><!-- mwb-cgc-wrapper -->
	</form>
	</div><!-- mwb-cgc-main-container -->
<?php
get_footer( 'shop' );


/**
 * List_default_images .
 */
function list_default_images() {
	?>
	
	<li>
		<a href="javascript:;" class="mwb-cgc-image"><img class="mwb_cgc_choose_img" src="<?php echo esc_html( MWB_WGM_URL ) . 'Shipping/public/images/christmas.jpg'; ?>" data-img="Christmas" alt="image"></a>
	</li>
	<li>
		<a href="javascript:;" class="mwb-cgc-image"><img  class="mwb_cgc_choose_img" src="<?php echo esc_html( MWB_WGM_URL ) . 'Shipping/public/images/new_year.jpg'; ?>" data-img="Newyear" alt="image"></a>
	</li>
	<li>
		<a href="javascript:;" class="mwb-cgc-image"><img class="mwb_cgc_choose_img" src="<?php echo esc_html( MWB_WGM_URL ) . 'Shipping/public/images/anniversary.jpg'; ?>" data-img="Anniversary" alt="image"></a>
	</li>
	<li>
		<a href="javascript:;" class="mwb-cgc-image"><img class="mwb_cgc_choose_img" src="<?php echo esc_html( MWB_WGM_URL ) . 'Shipping/public/images/happy_birthday.jpg'; ?>" data-img="Birthday" alt="image"></a>
	</li>
	<li>
		<a href="javascript:void(0);" class="mwb-cgc-image"><img class="mwb_cgc_choose_img" src="<?php echo esc_html( MWB_WGM_URL ) . 'Shipping/public/images/gift_card-1.jpg'; ?>" data-img="Giftcard" alt="image"></a>
	</li>
	<li class="mwb_cgc_choose_img" data-img="Custom">
		<input type="file" value="Upload Image" class="mwb-cgc-text-upload" id="mwb_cgc_upload_img" name="mwb_cgc_custom_img" >
		<input type="hidden" name="upload_path" id="upload_path" value="<?php echo wp_upload_dir()['baseurl']; ?>">
		<input type="hidden" name="selected_image" id="selected_image" value="Giftcard">
		<div class="mwb-cgc-image-upload"><span>&#10010;</span><?php esc_html_e( 'Upload Image', 'woocommerce-ultimate-gift-card' ); ?></div>
		<span class="mwb-cgc-description"><?php esc_html_e( '(Suggested Dimension: 600*400)', 'woocommerce-ultimate-gift-card' ); ?></span>
	</li>
	<?php
}
/**
 * List all uploaded .
 */
function list_all_uploaded_images() {
	list_uploaded_images();
	?>
	 <li class="mwb_cgc_choose_img" data-img="Custom">
		<input type="file" value="Upload Image" class="mwb-cgc-text-upload" id="mwb_cgc_upload_img" name="mwb_cgc_custom_img" >
		<input type="hidden" name="upload_path" id="upload_path" value="<?php echo wp_upload_dir()['baseurl']; ?>">
		<input type="hidden" name="selected_image" id="selected_image" value="Giftcard">
		<input type="hidden" name="uploaded_image_value" id="uploaded_image_value" value="Giftcard">
		<div class="mwb-cgc-image-upload"><span>&#10010;</span>Upload Image</div>
	</li>
	<?php
}
/**
 * List_uploaded.
 */
function list_uploaded_images() {
	$imageurl = get_option( 'cgc_product_image', false );
	if ( isset( $imageurl ) && ! empty( $imageurl ) && is_array( $imageurl ) ) {
		foreach ( $imageurl as $value ) {
			?>
			<li>
			<a href="javascript:;" class="mwb-cgc-image"><img class="mwb_cgc_choose_img" data-img="<?php echo $value; ?>" data-value="<?php echo $value; ?>" src="<?php echo wp_upload_dir()['baseurl'] . '/cgc_admin_own_img/' . $value; ?>"  alt="image" ></a>
		   </li>
			<?php
		}
	}

}
?>
