<?php

/**
 * Exit if accessed directly.
 *
 * @package woocommerce ultimate gift card .
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


if ( ! class_exists( 'MWB_WGM_Shipping_Card_Product' ) ) {

	/**
	 * This is class for managing order status and other functionalities .
	 *
	 * @name    MWB_WGM_Shipping_Card_Product
	 * @category Class
	 * @author   WP Swings <webmaster@wpswings.com>
	 */

	class MWB_WGM_Shipping_Card_Product {

		/**
		 * This is construct of class where all action and filter is defined
		 *
		 * @name __construct
		 * @author WP Swings <webmaster@wpswings.com>
		 * @link http://www.makewebbetter.com/
		 */
		public function __construct() {
			 $this->shippingtab = '';
			$this->shippingtabactive = false;
			$this->licensetab = '';
			$this->licensetabactive = false;
			$this->addontab = '';
			$this->addonactive = false;

			add_action( 'mwb_wgm_setting_tab', array( $this, 'mwb_wgm_shipping_setting_tab' ) );
			add_action( 'mwb_wgm_setting_tab_active', array( $this, 'mwb_wgm_shipping_setting_tab_active' ) );
			add_action( 'mwb_wgm_setting_tab_html', array( $this, 'mwb_wgm_shipping_setting_tab_html' ) );
			add_action( 'admin_enqueue_scripts', array( $this, 'mwb_wgm_shipping_enqueue_scripts' ), 10, 1 );

			add_action( 'wp_ajax_mwb_wgm_remove_image_name', array( $this, 'mwb_wgm_remove_image_name' ) );
			add_action( 'wp_ajax_nopriv_mwb_wgm_remove_image_name', array( $this, 'mwb_wgm_remove_image_name' ) );
			add_action( 'wp_ajax_wcgc_create_gift_cards', array( $this, 'wcgc_create_gift_cards' ) );

		}

		/**
		 * This is function where scripts are enqueued
		 *
		 * @name mwb_wgm_shipping_enqueue_scripts
		 * @author WP Swings <webmaster@wpswings.com>
		 * @link http://www.makewebbetter.com/
		 */
		public function mwb_wgm_shipping_enqueue_scripts() {
			$screen = get_current_screen();
			if ( isset( $screen->id ) ) {
				$pagescreen = $screen->id;
				if ( $pagescreen == 'woocommerce_page_mwb-wgc-setting' && isset( $_GET['tab'] ) && ( $_GET['tab'] == 'shipping' || $_GET['tab'] == 'addon' ) ) {
					wp_register_script( 'mwb_wgm_shipping', MWB_WGM_SD_URL . 'assets/js/woocommerce-ultimate-gift-card-shipping.js' );
					wp_enqueue_script( 'mwb_wgm_shipping' );

					$cgc_product_image = get_option( 'cgc_product_image', true );
					wp_localize_script(
						'mwb_wgm_shipping',
						'mwb_wgm_shipping_obj',
						array(
							'ajaxurl' => admin_url( 'admin-ajax.php' ),
							'reloadurl' => admin_url( 'admin.php?page=mwb-wgc-setting&tab=addon' ),
							'license_nonce' => wp_create_nonce( 'woocommerce-customizable-gift-card-license-nonce-action' ),
							'imageurl' => $cgc_product_image,
						)
					);
				}
			}
		}

		/**
		 * This is function is used to add shipping section in settings
		 *
		 * @name mwb_wgm_shipping_setting_tab
		 * @author WP Swings <webmaster@wpswings.com>
		 * @link http://www.makewebbetter.com/
		 */
		public function mwb_wgm_shipping_setting_tab() {
			$mwb_wgm_plugin_verified_pre = get_option( 'mwb_wgm_plugin_verified', false );
			?>
				<a class="nav-tab <?php echo $this->shippingtab; ?>" href="?page=mwb-wgc-setting&tab=shipping"><?php _e( 'Delivery Method', MWB_WGM_SD_DOM ); ?></a>
				<?php
				$host_server = $_SERVER['HTTP_HOST'];
				if ( strpos( $host_server, 'www.' ) == 0 ) {

					$host_server = str_replace( 'www.', '', $host_server );
				}
				if ( ! get_option( 'mwb_wgm_plugin_verified' . $host_server, $mwb_wgm_plugin_verified_pre ) ) {
					?>
					<a class="nav-tab <?php echo $this->licensetab; ?>" href="?page=mwb-wgc-setting&tab=validate_license"><?php esc_html_e( 'Add License', MWB_WGM_SD_DOM ); ?></a>
				<?php } ?>
				<a class="nav-tab <?php echo $this->addontab; ?>" href="?page=mwb-wgc-setting&tab=addon"><?php esc_html_e( 'Customizable Gift Card', MWB_WGM_SD_DOM ); ?></a>
				<?php
		}
		/**
		 * This is function is used to add active class to shipping section in settings
		 *
		 * @name mwb_wgm_shipping_setting_tab_active
		 * @author WP Swings <webmaster@wpswings.com>
		 * @link http://www.makewebbetter.com/
		 */
		public function mwb_wgm_shipping_setting_tab_active() {
			if ( isset( $_GET['tab'] ) && ! empty( $_GET['tab'] ) ) {
				$tab = $_GET['tab'];
				if ( $tab == 'shipping' ) {
					$this->shippingtab = 'nav-tab-active';
					$this->shippingtabactive = true;
				}
				if ( $tab == 'validate_license' ) {
					$this->licensetab = 'nav-tab-active';
					$this->licensetabactive = true;
				}
				if ( $tab == 'addon' ) {
					$this->addontab = 'nav-tab-active';
					$this->addonactive = true;
				}
			}
		}
		/**
		 * This is function is used to add template to shipping section in settings
		 *
		 * @name mwb_wgm_shipping_setting_tab_html
		 * @author WP Swings <webmaster@wpswings.com>
		 * @link http://www.makewebbetter.com/
		 */
		public function mwb_wgm_shipping_setting_tab_html() {
			if ( $this->shippingtabactive == true ) {
				include_once MWB_WGM_SD_DIRPATH . '/admin/shipping-setting.php';
			}
			if ( $this->licensetabactive == true ) {
				include_once MWB_WGM_SD_DIRPATH . '/admin/license-setting.php';
			}
			if ( $this->addonactive == true ) {
				include_once MWB_WGM_SD_DIRPATH . '/admin/addon.php';
			}
		}
		/**
		 * Remove image .
		 */
		public function mwb_wgm_remove_image_name() {
			$cgc_product_image = get_option( 'cgc_product_image', true );
			$remove_image = $_POST['remove_image'];
			unset( $cgc_product_image[ $remove_image ] );
			$cgc_product_image = array_values( $cgc_product_image );
			if ( isset( $cgc_product_image ) && ! empty( $cgc_product_image ) && is_array( $cgc_product_image ) ) {
				update_option( 'cgc_product_image', $cgc_product_image );
			} else {
				delete_option( 'cgc_product_image' );
			}
			wp_die();
		}
		/**
		 * Create gift card .
		 */
		public function wcgc_create_gift_cards() {
			$response['result'] = false;
			$response['message'] = __( 'Failed to create Product!', 'woocommerce-ultimate-gift-card' );
			$pro_img_url = MWB_WGM_SD_DIRPATH . '/admin/images/customized_card.jpg';
			if ( ! empty( $pro_img_url ) ) {
				$filename = array( $pro_img_url );
				foreach ( $filename as $key => $value ) {
					$upload_file = wp_upload_bits( basename( $value ), null, file_get_contents( $value ) );
					if ( ! $upload_file['error'] ) {
						$filename = $upload_file['file'];
						// The ID of the post this attachment is for.

						$parent_post_id = 0;

						// Check the type of file. We'll use this as the 'post_mime_type'.
						$filetype = wp_check_filetype( basename( $filename ), null );

						// Get the path to the upload directory.
						$wp_upload_dir = wp_upload_dir();

						// Prepare an array of post data for the attachment.
						$attachment = array(
							'guid'           => $wp_upload_dir['url'] . '/' . basename( $filename ),
							'post_mime_type' => $filetype['type'],
							'post_title'     => preg_replace( '/\.[^.]+$/', '', basename( $filename ) ),

							'post_status'    => 'inherit',
						);
						// Insert the attachment.
						$attach_id = wp_insert_attachment( $attachment, $filename, 0 );
						// Make sure that this file is included, as wp_generate_attachment_metadata() depends on it.
						require_once( ABSPATH . 'wp-admin/includes/image.php' );

						// Generate the metadata for the attachment, and update the database record.
						$attach_data = wp_generate_attachment_metadata( $attach_id, $filename );

						wp_update_attachment_metadata( $attach_id, $attach_data );

					}
				}
			}
			$product_array = array(
				'post_title' => 'Customize Your Gift Card',
				'post_content' => '',
				'post_excerpt' => '',
				'post_status' => 'draft',
				'post_author' => get_current_user_id(),
				'post_type'     => 'product',
			);

			$product_id = wp_insert_post( $product_array );

			if ( isset( $product_id ) && ! empty( $product_id ) ) {

				$mwb_wgm_pricing['type'] = 'mwb_wgm_default_price';
				$mwb_wgm_pricing['default_price'] = 35;
				wp_set_object_terms( $product_id, 'wgm_gift_card', 'product_type' );
				update_post_meta( $product_id, '_regular_price', 35 );
				update_post_meta( $product_id, '_price', 35 );
				update_post_meta( $product_id, 'mwb_wgm_pricing', $mwb_wgm_pricing );
				update_post_meta( $product_id, 'woocommerce_customizable_gift_card', 'yes' );
				update_option( 'wcgc_product_created', true );
				if ( ! empty( $attach_id ) ) {
					set_post_thumbnail( $product_id, $attach_id );
				}
				$response['result'] = true;
				$response['message'] = __( 'Successfully Created!', 'woocommerce-ultimate-gift-card' );
				$redirection = "post.php?post={$product_id}&action=edit";
				$response['redirect_url'] = admin_url( $redirection );
			}
			echo json_encode( $response );
			wp_die();
		}

	}
	new MWB_WGM_Shipping_Card_Product();
}
