<?php
/**
 * Exit if accessed directly.
 *
 * @package woocomerce ultimate gift card.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$saved = false;
$reset = false;
$value_check = isset( $_POST['message-expiration-setting'] ) ? sanitize_text_field( wp_unslash( $_POST['message-expiration-setting'] ) ) : '';

if ( isset( $_POST['mwb_wgm_qrcode_reset_save'] ) && wp_verify_nonce( $value_check, 'point-expiration-setings' ) ) {
	unset( $_POST['mwb_wgm_qrcode_reset_save'] );
	delete_option( 'mwb_wgm_qrcode_enable' );
	delete_option( 'mwb_wgm_qrcode_ecc_level' );
	delete_option( 'mwb_wgm_qrcode_size' );
	delete_option( 'mwb_wgm_qrcode_margin' );
	delete_option( 'mwb_wgm_barcode_display_enable' );
	delete_option( 'mwb_wgm_barcode_codetype' );
	delete_option( 'mwb_wgm_barcode_size' );
	unset( $_POST );
	$reset = true;

}
if ( isset( $_POST['mwb_wgm_qrcode_setting_save'] ) ) {
	unset( $_POST['mwb_wgm_qrcode_setting_save'] );

	if ( ! isset( $_POST['mwb_wgm_qrcode_ecc_level'] ) ) {
		$_POST['mwb_wgm_qrcode_ecc_level'] = 'L';
	}
	if ( ! isset( $_POST['mwb_wgm_qrcode_size'] ) || empty( $_POST['mwb_wgm_qrcode_size'] ) ) {
		$_POST['mwb_wgm_qrcode_size'] = 3;
	}
	if ( ! isset( $_POST['mwb_wgm_qrcode_margin'] ) ) {
		$_POST['mwb_wgm_qrcode_margin'] = 4;
	}
	if ( ! isset( $_POST['mwb_wgm_barcode_display_enable'] ) ) {
		$_POST['mwb_wgm_barcode_display_enable'] = 'off';
	}
	if ( ! isset( $_POST['mwb_wgm_barcode_codetype'] ) ) {
		$_POST['mwb_wgm_barcode_codetype'] = 'code39';
	}
	if ( ! isset( $_POST['mwb_wgm_barcode_size'] ) || empty( $_POST['mwb_wgm_barcode_size'] ) ) {
		$_POST['mwb_wgm_barcode_size'] = 20;
	}

	$postdata = $_POST;

	foreach ( $postdata as $key => $data ) {
		update_option( $key, $data );
		$saved = true;
	}
}
if ( $saved ) {
	?>
	<div class="notice notice-success is-dismissible"> 
		<p><strong><?php esc_html_e( 'Settings saved', 'woocommerce-ultimate-gift-card' ); ?></strong></p>
		<button type="button" class="notice-dismiss">
			<span class="screen-reader-text"><?php esc_html_e( 'Dismiss this notice', 'woocommerce-ultimate-gift-card' ); ?></span>
		</button>
	</div>
	<?php
}
if ( $reset ) {
	?>
	<div class="notice notice-success is-dismissible"> 
		<p><strong><?php esc_html_e( 'Settings are Reset', 'woocommerce-ultimate-gift-card' ); ?></strong></p>
		<button type="button" class="notice-dismiss">
			<span class="screen-reader-text"><?php esc_html_e( 'Dismiss this notice', 'woocommerce-ultimate-gift-card' ); ?></span>
		</button>
	</div>
	<?php
}
$qrcode_enable = get_option( 'mwb_wgm_qrcode_enable', false );
$qrcode_level = get_option( 'mwb_wgm_qrcode_ecc_level', 'L' );
$qrcode_size = get_option( 'mwb_wgm_qrcode_size', 3 );
$qrcode_margin = get_option( 'mwb_wgm_qrcode_margin', 4 );

$barcode_display = get_option( 'mwb_wgm_barcode_display_enable', false );
$barcode_type = get_option( 'mwb_wgm_barcode_codetype', 'code39' );
$barcode_size = get_option( 'mwb_wgm_barcode_size', 40 );
?>
<div class="mwb_table">
<table class="mwb_qrcode form-table mwb_wgm_general_setting">
	<tbody>		
		<tr valign="top">		
			<th scope="row" class="titledesc">
				<label for="mwb_wgm_qrcode_setting_enable"><?php esc_html_e( 'Enable QR Code', 'woocommerce-ultimate-gift-card' ); ?></label>
			</th>
			<td class="forminp forminp-text">
				<?php
				$attribute_description = __( 'Check this box to enable QR Code. QR Code will be displayed instead of coupon Code', 'woocommerce-ultimate-gift-card' );
				echo wp_kses_post( wc_help_tip( $attribute_description ) );
				?>
				<label for="mwb_wgm_qrcode_enable">
					<input type="radio" <?php echo ( 'qrcode' == $qrcode_enable ) ? "checked='checked'" : ''; ?> name="mwb_wgm_qrcode_enable" id="mwb_wgm_qrcode_enable" class="input-text" value="qrcode"> <?php esc_html_e( 'Enable QR Code to display in Email Template', 'woocommerce-ultimate-gift-card' ); ?>
				</label>						
			</td>
		</tr>
		<tr valign="top">		
			<th scope="row" class="titledesc">
				<label for="mwb_wgm_qrcode_ecc_level"><?php esc_html_e( 'ECC Level', 'woocommerce-ultimate-gift-card' ); ?></label>
			</th>
			<td class="forminp forminp-text">
				<?php
				$attribute_description = __( 'ECC (Error Correction Capability) level. This compensates for dirt, damage or fuzziness of the barcode. ', 'woocommerce-ultimate-gift-card' );
				echo wp_kses_post( wc_help_tip( $attribute_description ) );
				?>
				<label for="mwb_wgm_qrcode_ecc_level">
					<select name ="mwb_wgm_qrcode_ecc_level" class="mwb_wgm_new_woo_ver_style_select">
						<option value="L" <?php selected( $qrcode_level, 'L' ); ?>><?php esc_html_e( 'L-Smallest', 'woocommerce-ultimate-gift-card' ); ?></option>
						<option value="M" <?php selected( $qrcode_level, 'M' ); ?>><?php esc_html_e( 'M', 'woocommerce-ultimate-gift-card' ); ?></option>			
						<option value="Q" <?php selected( $qrcode_level, 'Q' ); ?>><?php esc_html_e( 'Q', 'woocommerce-ultimate-gift-card' ); ?></option>
						<option value="H" <?php selected( $qrcode_level, 'H' ); ?>><?php esc_html_e( 'H-Best', 'woocommerce-ultimate-gift-card' ); ?></option>
					</select>
					<?php esc_html_e( 'Select the ECC Level', 'woocommerce-ultimate-gift-card' ); ?>
				</label>						
			</td>
		</tr>
		<tr valign="top">		
			<th scope="row" class="titledesc">
				<label for="mwb_wgm_qrcode_size"><?php esc_html_e( 'Size', 'woocommerce-ultimate-gift-card' ); ?></label>
			</th>
			<td class="forminp forminp-text">
				<?php
				$attribute_description = __( 'It is the size of a QR Code', 'woocommerce-ultimate-gift-card' );
				echo wp_kses_post( wc_help_tip( $attribute_description ) );
				?>
				<label for="mwb_wgm_qrcode_size">
					<input type="number" min="1" name="mwb_wgm_qrcode_size" id="mwb_wgm_qrcode_size" class="input-text mwb_wgm_new_woo_ver_style_text" value="<?php echo esc_html( $qrcode_size ); ?>"> <?php esc_html_e( 'Enter the size of the QR Code.', 'woocommerce-ultimate-gift-card' ); ?>
				</label>						
			</td>
		</tr>
		<tr valign="top">		
			<th scope="row" class="titledesc">
				<label for="mwb_wgm_qrcode_margin"><?php esc_html_e( 'Margin', 'woocommerce-ultimate-gift-card' ); ?></label>
			</th>
			<td class="forminp forminp-text">
				<?php
				$attribute_description = __( 'It is the Margin of QR Code', 'woocommerce-ultimate-gift-card' );
				echo wp_kses_post( wc_help_tip( $attribute_description ) );
				?>
				<label for="mwb_wgm_qrcode_margin">
					<input type="number" min="1" name="mwb_wgm_qrcode_margin" id="mwb_wgm_qrcode_margin" class="input-text mwb_wgm_new_woo_ver_style_text" value="<?php echo esc_html( $qrcode_margin ); ?>"> <?php esc_html_e( 'Enter the margin of the QR Code.', 'woocommerce-ultimate-gift-card' ); ?>
				</label>						
			</td>
		</tr>
	</tbody>
</table>
<table class="mwb_barcode form-table mwb_wgm_general_setting">
	<tbody>
		<tr valign="top">		
			<th scope="row" class="titledesc">
				<label for="mwb_wgm_barcode_enable"><?php esc_html_e( 'Enable Barcode', 'woocommerce-ultimate-gift-card' ); ?></label>
			</th>
			<td class="forminp forminp-text">
				<?php
				$attribute_description = __( 'Check this box to enable Barcode. Barcode will be displayed instead of coupon Code', 'woocommerce-ultimate-gift-card' );
				echo wp_kses_post( wc_help_tip( $attribute_description ) );
				?>
				<label for="mwb_wgm_barcode_enable">
					<input type="radio" <?php echo ( 'barcode' == $qrcode_enable ) ? "checked='checked'" : ''; ?> name="mwb_wgm_qrcode_enable" id="mwb_wgm_barcode_enable" class="input-text" value="barcode"> <?php esc_html_e( 'Enable Barcode to display in Email Template', 'woocommerce-ultimate-gift-card' ); ?>
				</label>						
			</td>
		</tr>
		<tr valign="top">		
			<th scope="row" class="titledesc">
				<label for="mwb_wgm_barcode_display_enable"><?php esc_html_e( 'Display Code', 'woocommerce-ultimate-gift-card' ); ?></label>
			</th>
			<td class="forminp forminp-text">
				<?php
				$attribute_description = __( 'Check this box to display Coupon Code below Barcode.', 'woocommerce-ultimate-gift-card' );
				echo wp_kses_post( wc_help_tip( $attribute_description ) );
				?>
				<label for="mwb_wgm_barcode_display_enable">
					<input type="checkbox" <?php echo ( 'on' == $barcode_display ) ? "checked='checked'" : ''; ?> name="mwb_wgm_barcode_display_enable" id="mwb_wgm_barcode_display_enable" class="input-text"> <?php esc_html_e( 'Enable this to display Coupon Code', 'woocommerce-ultimate-gift-card' ); ?>
				</label>						
			</td>
		</tr>
		<tr valign="top">		
			<th scope="row" class="titledesc">
				<label for="mwb_wgm_barcode_codetype"><?php esc_html_e( 'CodeType', 'woocommerce-ultimate-gift-card' ); ?></label>
			</th>
			<td class="forminp forminp-text">
				<?php
				$attribute_description = __( 'It is the CodeType of Barcode', 'woocommerce-ultimate-gift-card' );
				echo wp_kses_post( wc_help_tip( $attribute_description ) );
				?>
				<label for="mwb_wgm_barcode_codetype">
					<select name ="mwb_wgm_barcode_codetype" class="mwb_wgm_new_woo_ver_style_select">
						<option value="code39" <?php selected( $barcode_type, 'code39' ); ?>><?php esc_html_e( 'Code39', 'woocommerce-ultimate-gift-card' ); ?></option>
						<option value="code25" <?php selected( $barcode_type, 'code25' ); ?>><?php esc_html_e( 'Code25', 'woocommerce-ultimate-gift-card' ); ?></option>			
						<option value="codabar" <?php selected( $barcode_type, 'codabar' ); ?>><?php esc_html_e( 'Codeabar', 'woocommerce-ultimate-gift-card' ); ?></option>
						<option value="code128" <?php selected( $barcode_type, 'code128' ); ?>><?php esc_html_e( 'Code128', 'woocommerce-ultimate-gift-card' ); ?></option>
						<option value="code128a" <?php selected( $barcode_type, 'code128a' ); ?>><?php esc_html_e( 'Code128a', 'woocommerce-ultimate-gift-card' ); ?></option>
						<option value="code128b" <?php selected( $barcode_type, 'code128b' ); ?>><?php esc_html_e( 'Code128b', 'woocommerce-ultimate-gift-card' ); ?></option>
					</select>
					<?php esc_html_e( 'Select the CodeType', 'woocommerce-ultimate-gift-card' ); ?>
				</label>						
			</td>
		</tr>
		<tr valign="top">		
			<th scope="row" class="titledesc">
				<label for="mwb_wgm_barcode_size"><?php esc_html_e( 'Size', 'woocommerce-ultimate-gift-card' ); ?></label>
			</th>
			<td class="forminp forminp-text">
				<?php
				$attribute_description = __( 'It is the Size of Barcode', 'woocommerce-ultimate-gift-card' );
				echo wp_kses_post( wc_help_tip( $attribute_description ) );
				?>
				<label for="mwb_wgm_barcode_size">
					<input type="number" min="1" name="mwb_wgm_barcode_size" id="mwb_wgm_barcode_size" class="input-text mwb_wgm_new_woo_ver_style_text" value="<?php echo esc_html( $barcode_size ); ?>"> <?php esc_html_e( 'Enter the size of the Barcode.', 'woocommerce-ultimate-gift-card' ); ?>
				</label>						
			</td>
		</tr>
	</tbody>
</table>
</div>
<p class="submit">
<?php $nonce = wp_create_nonce( 'point-expiration-setings' ); ?>
<input type="hidden" name="message-expiration-setting" value="<?php echo esc_attr( $nonce ); ?>" />
	<input type="submit" value="<?php esc_html_e( 'Save changes', 'woocommerce-ultimate-gift-card' ); ?>" class="button-primary woocommerce-save-button" name="mwb_wgm_qrcode_setting_save" id="mwb_wgm_qrcode_setting_save" >
	<input type="submit" value="<?php esc_html_e( 'Reset', 'woocommerce-ultimate-gift-card' ); ?>" class="button-primary woocommerce-save-button" name="mwb_wgm_qrcode_reset_save" id="mwb_wgm_qrcode_setting_save" >

</p>
<div class="clear"></div>

