<?php
/**
 * Exit if accessed directly
 *
 * @package woocomerce ultimate gift card.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$value_check = isset( $_POST['message-expiration-setting'] ) ? sanitize_text_field( wp_unslash( $_POST['message-expiration-setting'] ) ) : '';


if ( isset( $_POST['mwb_wgm_thankyouorder_setting_save_hidden'] ) && wp_verify_nonce( $value_check, 'point-expiration-setings' ) ) {
	unset( $_POST['mwb_wgm_thankyouorder_setting_save_hidden'] );
	if ( ! isset( $_POST['mwb_wgm_thankyouorder_enable'] ) ) {
		$_POST['mwb_wgm_thankyouorder_enable'] = 'off';
	}
	if ( ! isset( $_POST['mwb_wgm_thankyouorder_type'] ) ) {
		$_POST['mwb_wgm_thankyouorder_type'] = 'mwb_wgm_fixed_thankyou';
	}
	if ( ! isset( $_POST['mwb_wgm_thankyouorder_minimum'] ) ) {
		$_POST['mwb_wgm_thankyouorder_minimum'] = array();
	}
	if ( ! isset( $_POST['mwb_wgm_thankyouorder_maximum'] ) ) {
		$_POST['mwb_wgm_thankyouorder_maximum'] = array();
	}
	if ( ! isset( $_POST['mwb_wgm_thankyouorder_current_type'] ) ) {
		$_POST['mwb_wgm_thankyouorder_current_type'] = array();
	}
	if ( ! isset( $_POST['mwb_wgm_thankyouorder_time'] ) ) {
		$_POST['mwb_wgm_thankyouorder_time'] = 'mwb_wgm_completed_status';
	}
	if ( ! isset( $_POST['mwb_wgm_thankyou_message'] ) ) {
		$_POST['mwb_wgm_thankyou_message'] = 'You have recieved a coupon [COUPONCODE], having amount of [COUPONAMOUNT] with the expiration date of [COUPONEXPIRY]';
	}
	do_action( 'mwb_wgm_thankyouorder_setting_save' );
	$postdata = $_POST;
	foreach ( $postdata as $key => $data ) {
		update_option( $key, $data );
	}
	?>
	<div class="notice notice-success is-dismissible"> 
		<p><strong><?php esc_html_e( 'Settings Saved Successfully!', 'woocommerce-ultimate-gift-card' ); ?></strong></p>
	</div>
	<?php
}
$thankyouorder_enable = get_option( 'mwb_wgm_thankyouorder_enable', false );
$thankyouorder_type = get_option( 'mwb_wgm_thankyouorder_type', 'mwb_wgm_fixed_thankyou' );
$thankyouorder_time = get_option( 'mwb_wgm_thankyouorder_time', 'mwb_wgm_completed_status' );
$thankyouorder_min = get_option( 'mwb_wgm_thankyouorder_minimum', array() );
$thankyouorder_max = get_option( 'mwb_wgm_thankyouorder_maximum', array() );
$thankyouorder_value = get_option( 'mwb_wgm_thankyouorder_current_type', array() );
$mwb_wgm_thankyouorder_number = get_option( 'mwb_wgm_thankyouorder_number', 1 );
$thnku_giftcard_expiry = get_option( 'mwb_wgm_thnku_giftcard_expiry', 0 );
$mwb_wgm_thankyou_message = get_option( 'mwb_wgm_thankyou_message', 'You have recieved a coupon [COUPONCODE], having amount of [COUPONAMOUNT] with the expiration date of [COUPONEXPIRY]' );
if ( empty( $mwb_wgm_thankyouorder_number ) ) {
	$mwb_wgm_thankyouorder_number = 1;
}
?>
<table class="form-table mwb_wgm_thankyouorder_setting wp-list-table widefat  striped">
	<tbody>	
		<tr valign="top">
			<th scope="row" class="titledesc">
				<label for="mwb_wgm_thankyouorder_enable"><?php esc_html_e( 'Want to give ThankYou Gift coupon to your customers ?', 'woocommerce-ultimate-gift-card' ); ?></label>
			</th>
			<td class="forminp forminp-text">
				<?php
				$attribute_description = __( 'Check this box to enable gift coupon for those customers who had placed orders in your site', 'woocommerce-ultimate-gift-card' );
				echo wp_kses_post( wc_help_tip( $attribute_description ) );
				?>
				<label for="mwb_wgm_thankyouorder_enable">
					<input type="checkbox" <?php echo ( 'on' == $thankyouorder_enable ) ? "checked='checked'" : ''; ?> name="mwb_wgm_thankyouorder_enable" id="mwb_wgm_thankyouorder_enable" class="input-text"> <?php esc_html_e( 'Enable ThankYou Gift Coupon to Customers.', 'woocommerce-ultimate-gift-card' ); ?>
				</label>						
			</td>
		</tr>
		<tr valign="top">
			<th scope="row" class="titledesc">
				<label for="mwb_wgm_thankyouorder_time"><?php esc_html_e( 'Select the Order Status', 'woocommerce-ultimate-gift-card' ); ?></label>
			</th>
			<td class="forminp forminp-text">
				<?php
				$attribute_description = __( 'Select the status when the ThankYou Gift Coupon would be send', 'woocommerce-ultimate-gift-card' );
				echo wp_kses_post( wc_help_tip( $attribute_description ) );
				?>
				<label for="mwb_wgm_thankyouorder_time">
					<select name="mwb_wgm_thankyouorder_time" class="mwb_wgm_new_woo_ver_style_select">
						<option value="mwb_wgm_order_creation" <?php selected( $thankyouorder_time, 'mwb_wgm_order_creation' ); ?>><?php esc_html_e( 'Order Creation', 'woocommerce-ultimate-gift-card' ); ?></option>
						<option value="mwb_wgm_processing_status" <?php selected( $thankyouorder_time, 'mwb_wgm_processing_status' ); ?>><?php esc_html_e( 'Order is in Processing', 'woocommerce-ultimate-gift-card' ); ?></option>
						<option value="mwb_wgm_completed_status" <?php selected( $thankyouorder_time, 'mwb_wgm_completed_status' ); ?>><?php esc_html_e( 'Order is in Complete', 'woocommerce-ultimate-gift-card' ); ?></option>
					</select>
				</label>						
			</td>
		</tr>
		<tr valign="top">
			<th scope="row" class="titledesc">
				<label for="mwb_wgm_thankyouorder_number"><?php esc_html_e( 'Number of Orders, after which the thankyou gift card would sent', 'woocommerce-ultimate-gift-card' ); ?></label>
			</th>
			<td class="forminp forminp-text">
				<?php
				$attribute_description = __( 'Enter the number of orders, after that you want to give a thank you gift card to your customers', 'woocommerce-ultimate-gift-card' );
				echo wp_kses_post( wc_help_tip( $attribute_description ) );
				?>
				<input type="number" min="1" value="<?php echo $mwb_wgm_thankyouorder_number; ?>" name="mwb_wgm_thankyouorder_number" id="mwb_wgm_thankyouorder_number" class="input-text mwb_wgm_new_woo_ver_style_text"> 	
			</td>
		</tr>
		<tr valign="top">
			<th scope="row" class="titledesc">
				<label for="mwb_wgm_thnku_giftcard_expiry"><?php esc_html_e( 'ThankYou Coupon Expiry', 'woocommerce-ultimate-gift-card' ); ?></label>
			</th>
			<td class="forminp forminp-text">
				<?php
				$attribute_description = __( 'Enter number of days for Coupon Expiry,  Keep value "1" for one day expiry after generating coupon, Keep value "0" for no expiry.', 'woocommerce-ultimate-gift-card' );
				echo wp_kses_post( wc_help_tip( $attribute_description ) );
				?>
				<input type="number" min="0" value="<?php echo $thnku_giftcard_expiry; ?>" name="mwb_wgm_thnku_giftcard_expiry" id="mwb_wgm_thnku_giftcard_expiry" class="input-text mwb_wgm_new_woo_ver_style_text" > 	
			</td>
		</tr>
		<tr valign="top">
			<th scope="row" class="titledesc">
				<label for="mwb_wgm_thankyouorder_type"><?php esc_html_e( 'Select ThankYou Gift Coupon Type', 'woocommerce-ultimate-gift-card' ); ?></label>
			</th>
			<td class="forminp forminp-text">
				<?php
				$attribute_description = __( 'Choose the ThankYou Gift Coupon Type for Customers', 'woocommerce-ultimate-gift-card' );
				echo wp_kses_post( wc_help_tip( $attribute_description ) );
				?>
				<label for="mwb_wgm_thankyouorder_type">
					<select name="mwb_wgm_thankyouorder_type" class="mwb_wgm_new_woo_ver_style_select">
						<option value="mwb_wgm_fixed_thankyou" <?php selected( $thankyouorder_type, 'mwb_wgm_fixed_thankyou' ); ?>><?php esc_html_e( 'Fixed', 'woocommerce-ultimate-gift-card' ); ?></option>
						<option value="mwb_wgm_percentage_thankyou" <?php selected( $thankyouorder_type, 'mwb_wgm_percentage_thankyou' ); ?>><?php esc_html_e( 'Percentage', 'woocommerce-ultimate-gift-card' ); ?></option>
					</select>
				</label>						
			</td>
		</tr>
		<tr valign="top">
			<th scope="row" class="titledesc">
				<label for="mwb_wgm_thankyou_message"><?php esc_html_e( 'Enter a Thankyou Message for your customers', 'woocommerce-ultimate-gift-card' ); ?></label>
			</th>
			<td class="forminp forminp-text">
				<?php
				$attribute_description = __( 'This message will print inside the Thankyou Gift coupon Template', 'woocommerce-ultimate-gift-card' );
				echo wp_kses_post( wc_help_tip( $attribute_description ) );
				?>
				<span class="description"><?php esc_html_e( 'You may use shortcodes [COUPONCODE], [COUPONAMOUNT] and [COUPONEXPIRY]', 'woocommerce-ultimate-gift-card' ); ?></span>
				<label for="mwb_wgm_thankyou_message">
					<textarea cols="35" rows="5" name="mwb_wgm_thankyou_message" id="mwb_wgm_thankyou_message" class="input-text" ><?php echo $mwb_wgm_thankyou_message; ?></textarea>
				</label>						
			</td>
		</tr>
		<tr valign="top" class="mwb_wgm_thankyouorder_row" style="display: none;">
			<th>
				<label for="mwb_wgm_thankyouorder_fields"><?php esc_html_e( 'Enter Coupon Amount within Order Range', 'woocommerce-ultimate-gift-card' ); ?></label>
			</th>
			<td class="forminp forminp-text">
				<table class="form-table wp-list-table widefat fixed striped">
					<tbody class="mwb_wgm_thankyouorder_tbody">	
						<tr valign="top">
							<th><?php esc_html_e( 'Minimum', 'woocommerce-ultimate-gift-card' ); ?></th>
							<th><?php esc_html_e( 'Maximum', 'woocommerce-ultimate-gift-card' ); ?></th>
							<?php
							if ( 'mwb_wgm_fixed_thankyou' == $thankyouorder_type ) {
								?>
										<th><?php esc_html_e( 'ThankYou Gift Coupon Amount', 'woocommerce-ultimate-gift-card' ); ?></th>
									<?php
							} else if ( 'mwb_wgm_percentage_thankyou' == $thankyouorder_type ) {
								?>
										<th><?php esc_html_e( 'ThankYou Gift Coupon Percentage(%)', 'woocommerce-ultimate-gift-card' ); ?></th>
									<?php
							}
							?>
							<th class="mwb_wgm_remove_thankyouorder_content"><?php esc_html_e( 'Action', 'woocommerce-ultimate-gift-card' ); ?></th>
						</tr>
						<?php
						if ( isset( $thankyouorder_min ) && null != $thankyouorder_min && isset( $thankyouorder_max ) && null != $thankyouorder_max && isset( $thankyouorder_value ) && null != $thankyouorder_value ) {
							if ( count( $thankyouorder_min ) == count( $thankyouorder_max ) && count( $thankyouorder_max ) == count( $thankyouorder_value ) ) {
								foreach ( $thankyouorder_min as $key => $value ) {
									?>
											<tr valign="top">
												<td class="forminp forminp-text">
													<label for="mwb_wgm_thankyouorder_minimum">
														<input type="text" name="mwb_wgm_thankyouorder_minimum[]" class="mwb_wgm_thankyouorder_minimum input-text wc_input_price" required="" placeholder = "No minimum" value="<?php echo $thankyouorder_min[ $key ]; ?>">
													</label>
												</td>
												<td class="forminp forminp-text">
													<label for="mwb_wgm_thankyouorder_maximum">
														<input type="text" name="mwb_wgm_thankyouorder_maximum[]" class="mwb_wgm_thankyouorder_maximum input-text wc_input_price" required="" placeholder = "No maximum" value="<?php echo $thankyouorder_max[ $key ]; ?>">
													</label>
												</td>
												<td class="forminp forminp-text">
													<label for="mwb_wgm_thankyouorder_current_type">
														<input type="text" name="mwb_wgm_thankyouorder_current_type[]" class="mwb_wgm_thankyouorder_current_type input-text wc_input_price" required=""  value="<?php echo $thankyouorder_value[ $key ]; ?>">
													</label>
												</td>							
												<td class="mwb_wgm_remove_thankyouorder_content forminp forminp-text">
													<input type="button" value="<?php esc_html_e( 'Remove', 'woocommerce-ultimate-gift-card' ); ?>" class="mwb_wgm_remove_thankyouorder button" >
												</td>
											</tr>
										<?php
								}
							}
						} else {
							?>
									<tr valign="top">
										<td class="forminp forminp-text">
											<label for="mwb_wgm_thankyouorder_minimum">
												<input type="text" name="mwb_wgm_thankyouorder_minimum[]" class="mwb_wgm_thankyouorder_minimum input-text wc_input_price" required="">
											</label>
										</td>
										<td class="forminp forminp-text">
											<label for="mwb_wgm_thankyouorder_maximum">
												<input type="text" name="mwb_wgm_thankyouorder_maximum[]" class="mwb_wgm_thankyouorder_maximum input-text wc_input_price" required="">
											</label>
										</td>
										<td class="forminp forminp-text">
											<label for="mwb_wgm_thankyouorder_current_type">
												<input type="text" name="mwb_wgm_thankyouorder_current_type[]" class="mwb_wgm_thankyouorder_current_type input-text wc_input_price" required="">
											</label>
										</td>							
										<td class="mwb_wgm_remove_thankyouorder_content forminp forminp-text">
											<input type="button" value="<?php esc_html_e( 'Remove', 'woocommerce-ultimate-gift-card' ); ?>" class="mwb_wgm_remove_thankyouorder button" >
										</td>
									</tr>
								<?php
						}
						?>
					</tbody>
				</table>
				<input type="button" value="<?php esc_html_e( 'Add More', 'woocommerce-ultimate-gift-card' ); ?>" class="mwb_wgm_add_more button" id="mwb_wgm_add_more">
			</td>
		</tr>
	</tbody>
</table>
<p class="submit">
<?php $nonce = wp_create_nonce( 'point-expiration-setings' ); ?>
<input type="hidden" name="message-expiration-setting" value="<?php echo esc_attr( $nonce ); ?>" />
	<input type="hidden" name="mwb_wgm_thankyouorder_setting_save_hidden">
	<input type="submit" value="<?php esc_html_e( 'Save changes', 'woocommerce-ultimate-gift-card' ); ?>" class="button-primary woocommerce-save-button" name="mwb_wgm_thankyouorder_setting_save" id="mwb_wgm_thankyouorder_setting_save" >
</p>
