<?php
/**
 * Exit if accessed directly.
 *
 * @package woocomerce ultimate gift card.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$value_check = isset( $_POST['message-expiration-setting'] ) ? sanitize_text_field( wp_unslash( $_POST['message-expiration-setting'] ) ) : '';

if ( isset( $_POST['mwb_wgm_discount_setting_save_hidden'] ) && wp_verify_nonce( $value_check, 'point-expiration-setings' ) ) {
	unset( $_POST['mwb_wgm_discount_setting_save_hidden'] );
	if ( ! isset( $_POST['mwb_wgm_discount_enable'] ) ) {
		$_POST['mwb_wgm_discount_enable'] = 'off';
	}
	if ( ! isset( $_POST['mwb_wgm_discount_type'] ) ) {
		$_POST['mwb_wgm_discount_type'] = 'mwb_wgm_fixed';
	}
	if ( ! isset( $_POST['mwb_wgm_discount_minimum'] ) ) {
		$_POST['mwb_wgm_discount_minimum'] = array();
	}
	if ( ! isset( $_POST['mwb_wgm_discount_maximum'] ) ) {
		$_POST['mwb_wgm_discount_maximum'] = array();
	}
	if ( ! isset( $_POST['mwb_wgm_discount_current_type'] ) ) {
		$_POST['mwb_wgm_discount_current_type'] = array();
	}
	do_action( 'mwb_wgm_discount_setting_save' );
	$postdata = $_POST;
	foreach ( $postdata as $key => $data ) {
		update_option( $key, $data );
	}
	?>
	<div class="notice notice-success is-dismissible"> 
		<p><strong><?php esc_html_e( 'Settings Saved Successfully!', 'woocommerce-ultimate-gift-card' ); ?></strong></p>
	</div>
	<?php
}
$discount_enable = get_option( 'mwb_wgm_discount_enable', false );
$discount_type = get_option( 'mwb_wgm_discount_type', 'mwb_wgm_fixed' );
$discount_min = get_option( 'mwb_wgm_discount_minimum', array() );
$discount_max = get_option( 'mwb_wgm_discount_maximum', array() );
$discount_value = get_option( 'mwb_wgm_discount_current_type', array() );
?>
<table class="form-table mwb_wgm_discount_setting wp-list-table widefat  striped">
	<tbody>	
		<tr valign="top">
			<th scope="row" class="titledesc">
				<label for="mwb_wgm_discount_enable"><?php esc_html_e( 'Enable Discount on Gift Card Products', 'woocommerce-ultimate-gift-card' ); ?></label>
			</th>
			<td class="forminp forminp-text">
				<?php
				$attribute_description = __( 'Check this box to enable Discount for Gift Card Products', 'woocommerce-ultimate-gift-card' );
				echo wp_kses_post( wc_help_tip( $attribute_description ) );
				?>
				<label for="mwb_wgm_discount_enable">
					<input type="checkbox" <?php echo ( 'on' == $discount_enable ) ? "checked='checked'" : ''; ?> name="mwb_wgm_discount_enable" id="mwb_wgm_discount_enable" class="input-text"> <?php esc_html_e( 'Enable Discount on Gift Card Products.', 'woocommerce-ultimate-gift-card' ); ?>
				</label>						
			</td>
		</tr>
		<tr valign="top">
			<th scope="row" class="titledesc">
				<label for="mwb_wgm_discount_type"><?php esc_html_e( 'Select Discount Type', 'woocommerce-ultimate-gift-card' ); ?></label>
			</th>
			<td class="forminp forminp-text">
				<?php
				$attribute_description = __( 'Choose the Discount Type for Gift Card Products', 'woocommerce-ultimate-gift-card' );
				echo wp_kses_post( wc_help_tip( $attribute_description ) );
				?>
				<label for="mwb_wgm_discount_type">
					<select name="mwb_wgm_discount_type" class="mwb_wgm_new_woo_ver_style_select">
						<option value="mwb_wgm_fixed" <?php selected( $discount_type, 'mwb_wgm_fixed' ); ?>><?php esc_html_e( 'Fixed', 'woocommerce-ultimate-gift-card' ); ?></option>
						<option value="mwb_wgm_percentage" <?php selected( $discount_type, 'mwb_wgm_percentage' ); ?>><?php esc_html_e( 'Percentage', 'woocommerce-ultimate-gift-card' ); ?></option>
					</select>
				</label>						
			</td>
		</tr>
		<tr valign="top" class="mwb_wgm_discount_row" style="display: none;">
			<th>
				<label for="mwb_wgm_discount_fields"><?php esc_html_e( 'Enter Discount within Price Range', 'woocommerce-ultimate-gift-card' ); ?></label>
			</th>
			<td class="forminp forminp-text">
				<table class="form-table wp-list-table widefat fixed striped">
					<tbody class="mwb_wgm_discount_tbody">	
						<tr valign="top">
							<th><?php esc_html_e( 'Minimum', 'woocommerce-ultimate-gift-card' ); ?></th>
							<th><?php esc_html_e( 'Maximum', 'woocommerce-ultimate-gift-card' ); ?></th>
							<?php
							if ( 'mwb_wgm_fixed' == $discount_type ) {
								?>
										<th><?php esc_html_e( 'Discount Amount', 'woocommerce-ultimate-gift-card' ); ?></th>
									<?php
							} else if ( 'mwb_wgm_percentage' == $discount_type ) {
								?>
										<th><?php esc_html_e( 'Discount Percentage(%)', 'woocommerce-ultimate-gift-card' ); ?></th>
									<?php
							}
							?>
							<th class="mwb_wgm_remove_discount_content"><?php esc_html_e( 'Action', 'woocommerce-ultimate-gift-card' ); ?></th>
						</tr>
						<?php
						if ( isset( $discount_min ) && null != $discount_min && isset( $discount_max ) && null != $discount_max && isset( $discount_value ) && null != $discount_value ) {
							if ( count( $discount_min ) == count( $discount_max ) && count( $discount_max ) == count( $discount_value ) ) {

								foreach ( $discount_min as $key => $value ) {
									?>
											<tr valign="top">
												<td class="forminp forminp-text">
													<label for="mwb_wgm_discount_minimum">
														<input type="text" name="mwb_wgm_discount_minimum[]" class="mwb_wgm_discount_minimum input-text wc_input_price" required="" value="<?php echo $discount_min[ $key ]; ?>">
													</label>
												</td>
												<td class="forminp forminp-text">
													<label for="mwb_wgm_discount_maximum">
														<input type="text" name="mwb_wgm_discount_maximum[]" class="mwb_wgm_discount_maximum input-text wc_input_price" required="" value="<?php echo esc_html( $discount_max[ $key ] ); ?>">
													</label>
												</td>
												<td class="forminp forminp-text">
													<label for="mwb_wgm_discount_current_type">
														<input type="text" name="mwb_wgm_discount_current_type[]" class="mwb_wgm_discount_current_type input-text wc_input_price" required=""  value="<?php echo esc_html( $discount_value[ $key ] ); ?>">
													</label>
												</td>							
												<td class="mwb_wgm_remove_discount_content forminp forminp-text">
													<input type="button" value="<?php esc_html_e( 'Remove', 'woocommerce-ultimate-gift-card' ); ?>" class="mwb_wgm_remove_discount button" >
												</td>
											</tr>
										<?php
								}
							}
						} else {
							?>
									<tr valign="top">
										<td class="forminp forminp-text">
											<label for="mwb_wgm_discount_minimum">
												<input type="text" name="mwb_wgm_discount_minimum[]" class="mwb_wgm_discount_minimum input-text wc_input_price" required="">
											</label>
										</td>
										<td class="forminp forminp-text">
											<label for="mwb_wgm_discount_maximum">
												<input type="text" name="mwb_wgm_discount_maximum[]" class="mwb_wgm_discount_maximum input-text wc_input_price" required="">
											</label>
										</td>
										<td class="forminp forminp-text">
											<label for="mwb_wgm_discount_current_type">
												<input type="text" name="mwb_wgm_discount_current_type[]" class="mwb_wgm_discount_current_type input-text wc_input_price" required="">
											</label>
										</td>							
										<td class="mwb_wgm_remove_discount_content forminp forminp-text">
											<input type="button" value="<?php esc_html_e( 'Remove', 'woocommerce-ultimate-gift-card' ); ?>" class="mwb_wgm_remove_discount button" >
										</td>
									</tr>
								<?php
						}
						?>
					</tbody>
				</table>
				<input type="button" value="<?php esc_html_e( 'Add More', 'woocommerce-ultimate-gift-card' ); ?>" class="mwb_wgm_add_more button" id="mwb_wgm_add_more">
			</td>
		</tr>
	</tbody>
</table>
<p class="submit">
	<?php $nonce = wp_create_nonce( 'point-expiration-setings' ); ?>
	<input type="hidden" name="message-expiration-setting" value="<?php echo esc_attr( $nonce ); ?>" />
	<input type="hidden" name="mwb_wgm_discount_setting_save_hidden">
	<input type="submit" value="<?php esc_html_e( 'Save changes', 'woocommerce-ultimate-gift-card' ); ?>" class="button-primary woocommerce-save-button" name="mwb_wgm_discount_setting_save" id="mwb_wgm_discount_setting_save" >
</p>
