<?php
/**
 * Exit if accessed directly.
 *
 * @package woocommerce ultimate gift card .
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


if ( ! class_exists( 'MWB_WGM_Shipping_Manager' ) ) {

	/**
	 * This is class for managing front end giftcard functionality
	 *
	 * @name    MWB_WGM_Shipping_Manager
	 * @category Class
	 * @author   WP Swings <webmaster@wpswings.com>
	 */
	class MWB_WGM_Shipping_Manager {

		/**
		 * This is construct of class where all action and filter is defined
		 *
		 * @name __construct
		 * @author WP Swings <webmaster@wpswings.com>
		 * @link http://www.makewebbetter.com/
		 */
		public function __construct() {
			  add_action( 'plugins_loaded', array( $this, 'mwb_wgm_shipping_load_woocommerce' ) );
		}
		/**
		 * This is function of class where shipping addon is checked
		 *
		 * @name mwb_wgm_shipping_load_woocommerce
		 * @author WP Swings <webmaster@wpswings.com>
		 * @link http://www.makewebbetter.com/
		 */
		public function mwb_wgm_shipping_load_woocommerce() {
			if ( function_exists( 'WC' ) ) {
				$this->add_hooks_and_filters();
			}
		}
		/**
		 * This is function of class where all action and filter is defined
		 *
		 * @name add_hooks_and_filters
		 * @author WP Swings <webmaster@wpswings.com>
		 * @link http://www.makewebbetter.com/
		 */
		public function add_hooks_and_filters() {
			add_action( 'woocommerce_after_calculate_totals', array( $this, 'mwb_apply_coupon_on_cart_total' ) );
						$enable = get_option( 'wcgc_plugin_enable', false );
			$giftcard_enable = get_option( 'mwb_wgm_general_setting_enable', false );

			if ( ( ! empty( $enable ) && $enable != 'off' ) && ( ! empty( $giftcard_enable ) && $giftcard_enable != 'off' ) ) {

				add_filter( 'wp_enqueue_scripts', array( $this, 'enqueue_styles' ) );
				add_filter( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );

				add_filter( 'woocommerce_locate_template', array( $this, 'mwb_woocommerce_locate_template' ), 10, 3 );
				add_filter( 'template_include', array( $this, 'mwb_locate_template' ), 30 );
				add_action( 'wp_ajax_mwb_cgc_upload_own_img', array( $this, 'mwb_cgc_upload_own_img' ) );
				add_action( 'wp_ajax_nopriv_mwb_cgc_upload_own_img', array( $this, 'mwb_cgc_upload_own_img' ) );
				add_filter( 'mwb_wgm_price_meta_data', array( $this, 'cgc_mwb_wgm_price_meta_data' ), 10, 3 );
				add_filter( 'mwb_wgm_product_item_meta', array( $this, 'cgc_mwb_wgm_product_item_meta' ), 10, 3 );
				add_action( 'mwb_wgm_add_meta_data', array( $this, 'cgc_mwb_wgm_add_meta_data' ), 10, 3 );
				add_filter( 'mwb_wgm_customized_gc_cgc', array( $this, 'cgc_mwb_wgm_customized_gc_cgc' ), 10, 3 );
				add_filter( 'mwb_wgm_customized_email_cgc', array( $this, 'cgc_mwb_wgm_customized_email_cgc' ), 10, 2 );
				add_filter( 'mwb_wgm_resend_mail_arr_update', array( $this, 'cgc_mwb_wgm_resend_mail_arr_update' ), 10, 2 );
				add_action( 'mwb_cgc_before_main_content', array( $this, 'mwb_cgc_before_main_content' ) );
				add_action( 'mwb_add_delivery_methods', array( $this, 'mwb_add_delivery_methods' ) );
				add_action( 'wp_ajax_mwb_cgc_admin_uploads_name', array( $this, 'mwb_cgc_admin_uploads_name' ) );
				add_action( 'wp_ajax_nopriv_mwb_cgc_admin_uploads_name', array( $this, 'mwb_cgc_admin_uploads_name' ) );
			}
		}
		/**
		 * Style.
		 */
		public function enqueue_styles() {

			wp_enqueue_style( 'name', MWB_WGM_SD_URL . 'public/assets/css/woocommerce-customizable-gift-card-public.css' );
			if ( is_product() ) {
				global $post;
				$product_id = $post->ID;
				$is_customizable = get_post_meta( $product_id, 'woocommerce_customizable_gift_card', true );

				if ( isset( $is_customizable ) && ! empty( $is_customizable ) && $is_customizable == 'yes' ) {

					 wp_enqueue_style( 'hemml', MWB_WGM_SD_URL . 'public/assets/css/mwb_customized_temp.css' );
				}
			}
		}
		   /**
			* All scripts are enqueue .
			*/
		public function enqueue_scripts() {

				$mwb_custom = array();
			$mwb_custom['ajaxurl'] = admin_url( 'admin-ajax.php' );
			$mwb_custom['currency'] = get_woocommerce_currency_symbol();

			wp_register_script( 'namejs', MWB_WGM_SD_URL . 'public/assets/js/woocommerce-ultimate-gift-card-shipping-front.js', array( 'jquery' ) );
			wp_localize_script( 'namejs', 'mwb_custom', $mwb_custom );
			wp_enqueue_script( 'namejs' );

		}
				/**
				 * This is function of class where coupon on shipping is applied
				 *
				 * @name add_hooks_and_filters
				 * @author WP Swings <webmaster@wpswings.com>
				 * @link http://www.makewebbetter.com/
				 */
		public function mwb_apply_coupon_on_cart_total( $cart ) {
			$gift_cart_ship = get_option( 'mwb_wgm_general_cart_shipping_enable', 'off' );
			if ( 'on' == $gift_cart_ship ) {

				$mwb_cart_discount = $cart->discount_cart;
				if ( 'incl' === WC()->cart->get_tax_price_display_mode() ) {
					if ( isset( $cart->discount_cart_tax ) && $cart->discount_cart_tax != null ) {
						$mwb_cart_discount += $cart->discount_cart_tax;
					}
				}
				$applied_coupons = $cart->get_applied_coupons();
				if ( is_array( $applied_coupons ) && ! empty( $applied_coupons ) ) {
					$mwb_coupon_arr = array();
					foreach ( $applied_coupons as $key => $code ) {
						$the_coupon = new WC_Coupon( $code );
						$coupon_id = $the_coupon->get_id();
						if ( isset( $coupon_id ) && ! empty( $coupon_id ) ) {
							$coupon_type = get_post_meta( $coupon_id, 'discount_type', true );
							if ( isset( $coupon_type ) && $coupon_type == 'fixed_cart' ) {

								$mwb_coupon_total = $this->mwb_wgm_coupons_total( $cart->get_coupons() );
								$mwb_wgm_coupon_amount_left = $mwb_coupon_total - $mwb_cart_discount;
								$total_shipping_tax = $cart->shipping_total + $cart->shipping_tax_total;
								if ( $mwb_wgm_coupon_amount_left > 0 && ! empty( $cart->shipping_total ) ) {

									if ( $mwb_wgm_coupon_amount_left >= $total_shipping_tax ) {
										$cart->discount_cart += $total_shipping_tax;
										$this->mwb_adjust_coupon_amount( $total_shipping_tax );

										$cart->total -= $total_shipping_tax;
										return $cart;
									} elseif ( $mwb_wgm_coupon_amount_left < $total_shipping_tax ) {

										$cart->discount_cart += $mwb_wgm_coupon_amount_left;
										$this->mwb_adjust_coupon_amount( $mwb_wgm_coupon_amount_left );

										$cart->total -= $mwb_wgm_coupon_amount_left;
										return $cart;
									}
								} else {
									return $cart;
								}
							} else {
								return $cart;
							}
						} else {
							return $cart;
						}
					}
				} else {
					return $cart;
				}
			} else {
				return $cart;
			}
		}
		 /**
		  * This is used to adjust the coupon price
		  *
		  * @name mwb_adjust_coupon_amount
		  * @author WP Swings <webmaster@wpswings.com>
		  * @link http://www.makewebbetter.com/
		  */
		public function mwb_adjust_coupon_amount( $more_amount ) {
			$coupons = WC()->cart->get_coupons();
			$woo_ver = WC()->version;
			if ( $woo_ver < '3.0.0' ) {
				foreach ( $coupons as $coupon ) {
					$mwb_already_applied_coupon_amount = isset( WC()->cart->coupon_discount_amounts[ $coupon->code ] ) ? round( WC()->cart->coupon_discount_amounts[ $coupon->code ] ) : 0;
					if ( $mwb_already_applied_coupon_amount < $coupon->coupon_amount ) {
						$remaining_coupon_amount = $coupon->coupon_amount - $mwb_already_applied_coupon_amount;
						if ( $more_amount <= $remaining_coupon_amount ) {
							WC()->cart->coupon_discount_amounts[ $coupon->code ] = ( isset( WC()->cart->coupon_discount_amounts[ $coupon->code ] ) ? WC()->cart->coupon_discount_amounts[ $coupon->code ] : 0 ) + $more_amount;
							$more_amount = 0;
						} elseif ( $more_amount > $remaining_coupon_amount ) {
							$more_amount = $more_amount - $remaining_coupon_amount;
							WC()->cart->coupon_discount_amounts[ $coupon->code ] += $remaining_coupon_amount;
						}
					}
					if ( $more_amount == 0 ) {
						break;
					}
				}
			} else {
				foreach ( $coupons as $coupon ) {
					$mwb_already_applied_coupon_amount = isset( WC()->cart->coupon_discount_amounts[ $coupon->get_code() ] ) ? round( WC()->cart->coupon_discount_amounts[ $coupon->get_code() ] ) : 0;
					if ( $mwb_already_applied_coupon_amount < $coupon->get_amount() ) {
						$remaining_coupon_amount = $coupon->get_amount() - $mwb_already_applied_coupon_amount;
						if ( $more_amount <= $remaining_coupon_amount ) {
							WC()->cart->coupon_discount_amounts[ $coupon->get_code() ] = ( isset( WC()->cart->coupon_discount_amounts[ $coupon->get_code() ] ) ? WC()->cart->coupon_discount_amounts[ $coupon->get_code() ] : 0 ) + $more_amount;
							$more_amount = 0;
						} elseif ( $more_amount > $remaining_coupon_amount ) {
							$more_amount = $more_amount - $remaining_coupon_amount;
							WC()->cart->coupon_discount_amounts[ $coupon->get_code() ] += $remaining_coupon_amount;
						}
					}
					if ( $more_amount == 0 ) {
						break;
					}
				}
			}

		}
		/**
		 * This is used to get all coupon total amount
		 *
		 * @param string $mwb_coupon coupon.
		 * @name mwb_wgm_coupons_total
		 * @author WP Swings <webmaster@wpswings.com>
		 * @link http://www.makewebbetter.com/
		 */
		public function mwb_wgm_coupons_total( $mwb_coupon ) {
			$mwb_coupon_total = 0;

			foreach ( $mwb_coupon as $coupon ) {
				$woo_ver = WC()->version;
				if ( $woo_ver < '3.0.0' ) {
					$mwb_coupon_total = $mwb_coupon_total + $coupon->coupon_amount;
				} else {
					$mwb_coupon_total = $mwb_coupon_total + $coupon->get_amount();
				}
			}
			return $mwb_coupon_total;
		}
		/**
		 * Cpc get price .
		 *
		 * @param string $product_pricing product_price.
		 */
		public function cgc_get_prcie_type( $product_pricing ) {

			$price_html = '';
			if ( isset( $product_pricing ) && ! empty( $product_pricing ) ) {

				if ( isset( $product_pricing['type'] ) ) {

					$product_pricing_type = $product_pricing['type'];
					if ( 'mwb_wgm_default_price' == $product_pricing_type ) {
						$new_price = '';
						$default_price = $product_pricing['default_price'];
						$price_html .= '<ins><span class="woocommerce-Price-amount amount">' . wc_price( $default_price ) . '</span></ins>';
					}
					if ( 'mwb_wgm_range_price' == $product_pricing_type ) {
						$price_html = '';
						$from_price = $product_pricing['from'];
						$to_price = $product_pricing['to'];
						$price_html .= '<ins><span class="woocommerce-Price-amount amount">' . wc_price( $from_price ) . ' - ' . wc_price( $to_price ) . '</span></ins>';
					}
					if ( 'mwb_wgm_selected_price' == $product_pricing_type ) {
						$selected_price = $product_pricing['price'];
						if ( ! empty( $selected_price ) ) {
							$selected_prices = explode( '|', $selected_price );
							$price_html = __( 'Select your Gift Card Value', 'woocommerce-ultimate-gift-card' );
						}
					}
					if ( 'mwb_wgm_user_price' == $product_pricing_type ) {
						$price_html = apply_filters( 'mwb_wgm_user_price_text', __( 'Enter Gift Card Value:', 'woocommerce-ultimate-gift-card' ) );
					}
					if ( 'mwb_wgm_variable_price' == $product_pricing_type ) {
						$price_html = apply_filters( 'mwb_wgm_user_price_text', __( 'Select Gift Card Price :', 'woocommerce-ultimate-gift-card' ) );
					}
				}

				return $price_html;
			}
		}
		/**
		 * Returns the html for various price types
		 *
		 * @param string $product_pricing pricing .
		 * @since    1.0.0
		 */
		public function cgc_get_prcie_html( $product_pricing ) {

			$price_html = '';
			if ( isset( $product_pricing ) && ! empty( $product_pricing ) ) {

				if ( isset( $product_pricing['type'] ) ) {
						 $product_pricing_type = $product_pricing['type'];
						 $default_price = $product_pricing['default_price'];

					if ( 'mwb_wgm_range_price' == $product_pricing_type ) {
						$from_price = $product_pricing['from'];
						$to_price = $product_pricing['to'];
						$text_box_price = ( $default_price >= $from_price && $default_price <= $to_price ) ? $default_price : $from_price;

						$price_html = '<p class="mwb_wgm_section"><input type="number" class="input-text mwb_wgm_price" id="mwb_wgm_price" name="mwb_wgm_price" value="' . $text_box_price . '" max="' . $to_price . '" min="' . $from_price . '"></p>';
					} elseif ( 'mwb_wgm_default_price' == $product_pricing_type ) {

						$price_html = '<input type="hidden" class="mwb_wgm_price" id="mwb_wgm_price" name="mwb_wgm_price" value="' . $default_price . '">';
					} elseif ( 'mwb_wgm_selected_price' == $product_pricing_type ) {
						$selected_price = $product_pricing['price'];
						if ( ! empty( $selected_price ) ) {
							$selected_prices = explode( '|', $selected_price );
							foreach ( $selected_prices as $price ) {
								$price_html .= '<input type="button" class="mwb_cgc_price_button" value="' . $price . '">';
							}
							$price_html .= '<input type="hidden" class="mwb_wgm_price_select" id="mwb_wgm_price" name="mwb_wgm_price" value="' . $default_price . '">';
						}
					}

					if ( 'mwb_wgm_user_price' == $product_pricing_type ) {
						$price_html = '<p class="mwb_wgm_section"><input type="number" class="mwb_wgm_price" id="mwb_wgm_price" name="mwb_wgm_price" min="1" value="' . $default_price . '"></p>';
					}
					if ( 'mwb_wgm_variable_price' == $product_pricing_type ) {
						$mwb_variation_price = $product_pricing['mwb_wgm_variation_price'];
						if ( isset( $mwb_variation_price ) && ! empty( $mwb_variation_price ) && is_array( $mwb_variation_price ) ) {
							$start_price = min( $mwb_variation_price );
							$end_price = ( max( $mwb_variation_price ) == '' ) ? $start_price : max( $mwb_variation_price );
							if ( class_exists( 'WCPBC_Pricing_Zone' ) ) {
								if ( wcpbc_the_zone() != null && wcpbc_the_zone() ) {
									$start_price = wcpbc_the_zone()->get_exchange_rate_price( $start_price );
									$end_price = wcpbc_the_zone()->get_exchange_rate_price( $end_price );
								}
							}
							$decimal_separator  = get_option( 'woocommerce_price_decimal_sep' );
							$start_price = floatval( str_replace( $decimal_separator, '.', $start_price ) );
							$end_price = floatval( str_replace( $decimal_separator, '.', $end_price ) );
							$price_html = '<span>' . wc_price( $start_price ) . ' - ' . wc_price( $end_price ) . '</span><br>';
						}
						$variation_amount = $product_pricing['mwb_wgm_variation_price'];
								  $varable_text = $product_pricing['mwb_wgm_variation_text'];

						if ( isset( $variation_amount ) && is_array( $variation_amount ) && ! empty( $variation_amount ) ) {
							$mwb_price = ( $variation_amount[0] != '' ) ? $variation_amount[0] : 0;
							if ( class_exists( 'WCPBC_Pricing_Zone' ) ) {
								if ( wcpbc_the_zone() != null && wcpbc_the_zone() ) {
									$mwb_price = wcpbc_the_zone()->get_exchange_rate_price( $mwb_price );
								}
							}
							$decimal_separator  = get_option( 'woocommerce_price_decimal_sep' );
							$mwb_price .= floatval( str_replace( $decimal_separator, '.', $mwb_price ) );
							?>
												<p class="mwb_wgm_section">
							<?php $price_html .= '<span id="mwb_wgm_text" class="mwb_variable_currency">' . wc_price( $mwb_price ) . '</span>'; ?>
												
												</p>
												<p class="mwb_wgm_section">
							<?php
								  $price_html .= '<select name="mwb_wgm_price" class="mwb_wgm_price" id="mwb_wgm_price">';

							foreach ( $variation_amount as $key => $value ) {
								if ( isset( $value ) && ! empty( $value ) ) {
									?>
									<?php $price_html .= ' <option value="' . $value . '">' . $varable_text[ $key ] . '</option>'; ?>
									<?php
								}
							}
							?>
							<?php
									  $price_html .= '	</select>';
							?>
												</p>
							<?php
						}
					}
				}
				return $price_html;
			}
		}
		/**
		 * Check scheduling enable.
		 */
		public function mwb_check_scheduling_enable() {
			$giftcard_selected_date = get_option( 'mwb_wgm_general_setting_enable_selected_date', false );
			$enable = false;
			if ( isset( $giftcard_selected_date ) && $giftcard_selected_date == 'on' ) {
				$enable = true;
			}
			return $enable;
		}

		/**
		 * Render the required template for Customizable Gift Card Product
		 *
		 * @param string $template tepmlate .
		 * @param string $template_name name .
		 * @param string $template_path path.
		 * @since    1.0.0
		 */
		public function mwb_woocommerce_locate_template( $template, $template_name, $template_path ) {
			if ( ! is_admin() ) {
				global $woocommerce;
				$_template = $template;

				if ( ! $template_path ) {
					$template_path = $woocommerce->template_url;
				}

				 $plugin_path  = untrailingslashit( MWB_WGM_SD_DIRPATH ) . '/woocommerce/';
				$template = locate_template(
					array(
						$template_path . $template_name,
						$template_name,
					)
				);
				 // Modification: Get the template from this plugin, if it exists.
				if ( ! $template && file_exists( $plugin_path . $template_name ) ) {
					 $template = $plugin_path . $template_name;
				}
				/**
				 * Use default template.
				 */
				if ( ! $template ) {
					$template = $_template;
				}
			}
			// Return what we found .
			return $template;
		}
		/**
		 * Locate templlate .
		 */
		public function mwb_locate_template( $template ) {

			$pre_template = $template;
			global $post;
			 $product_id = $post->ID;
			 $is_customizable = get_post_meta( $product_id, 'woocommerce_customizable_gift_card', true );
			if ( is_single() && 'product' == get_post_type() ) {

				$template = locate_template( array( 'woocommerce/single-product.php' ) );

				if ( $template || ! $template ) {

					if ( isset( $is_customizable ) && ! empty( $is_customizable ) && $is_customizable == 'yes' ) {

						$template = MWB_WGM_SD_DIRPATH . 'woocommerce/customized_temp.php';
					} else {
						return $pre_template;
					}
				}
			}
			return $template;
		}
		/**
		 * Uploaded the custom images for end users
		 *
		 * @since    1.0.0
		 */
		public function mwb_cgc_upload_own_img() {

			$response['result'] = false;
			$response['message'] = __( 'Image cannot upload right now, please try later!', 'woocommerce-ultimate-gift-card' );
			$upload_dir_path = MWB_UPLOAD_DIR . '/cgw_own_img';

			if ( ! is_dir( $upload_dir_path ) ) {
				wp_mkdir_p( $upload_dir_path );
				chmod( $upload_dir_path, 0775 );
			}
			if ( ( $_FILES['file']['type'] == 'image/gif' ) || ( $_FILES['file']['type'] == 'image/jpeg' ) || ( $_FILES['file']['type'] == 'image/jpg' ) || ( $_FILES['file']['type'] == 'image/pjpeg' ) || ( $_FILES['file']['type'] == 'image/x-png' ) || ( $_FILES['file']['type'] == 'image/png' ) ) {
				$file_name = $_FILES['file']['name'];
				$file_name = ( $file_name );
				if ( ! file_exists( MWB_UPLOAD_DIR . '/cgc_own_img/' . $file_name ) ) {
					move_uploaded_file( $_FILES['file']['tmp_name'], MWB_UPLOAD_DIR . '/cgc_own_img/' . $file_name );
				}
				$response['result'] = true;
				$response['message'] = __( 'Successfully Uploaded!', 'woocommerce-ultimate-gift-card' );
			}
			echo json_encode( $response );
			wp_die();
		}

		/**
		 * Upload Admin's Images
		 *
		 * @since    1.0.0
		 */
		public function mwb_cgc_admin_uploads_name() {

			$image = sanitize_text_field( $_POST['image_name'] );
			if ( isset( $image ) && ! empty( $image ) ) {
				echo ( $image );
				die;
			}

		}

		/**
		 * Add filename in Gift Card's Item Meta
		 *
		 * @since    1.0.0
		 */
		public function cgc_mwb_wgm_price_meta_data( $item_meta, $the_cart_data, $product_id ) {
			if ( isset( $_POST['selected_image'] ) && ! empty( $_POST['selected_image'] ) ) {
				$item_meta['mwb_cgc_image'] = sanitize_text_field( $_POST['selected_image'] );
				if ( $_POST['selected_image'] == 'Custom' ) {
					$upload_dir_path = wp_upload_dir()['basedir'] . '/cgc_own_img';
					if ( ! is_dir( $upload_dir_path ) ) {
						wp_mkdir_p( $upload_dir_path );
						chmod( $upload_dir_path, 0775 );
					}
					if ( ( $_FILES['mwb_cgc_custom_img']['type'] == 'image/gif' ) || ( $_FILES['mwb_cgc_custom_img']['type'] == 'image/jpeg' ) || ( $_FILES['mwb_cgc_custom_img']['type'] == 'image/jpg' ) || ( $_FILES['mwb_cgc_custom_img']['type'] == 'image/pjpeg' ) || ( $_FILES['mwb_cgc_custom_img']['type'] == 'image/x-png' ) || ( $_FILES['mwb_cgc_custom_img']['type'] == 'image/png' ) ) {
						$file_name = $_FILES['mwb_cgc_custom_img']['name'];
						$file_name = sanitize_file_name( $file_name );
						if ( ! file_exists( wp_upload_dir()['basedir'] . '/cgc_own_img/' . $file_name ) ) {
							move_uploaded_file( $_FILES['mwb_cgc_custom_img']['tmp_name'], wp_upload_dir()['basedir'] . '/cgc_own_img/' . $file_name );
						}
						$item_meta['mwb_cgc_custom_img'] = $file_name;
					}
				}
			}
			return $item_meta;
		}

		/**
		 * Display Item Meta Data in Cart.
		 *
		 * @param string $item_meta meta .
		 * @param string $key key .
		 * @param string $val val .
		 * @since    1.0.0
		 */
		public function cgc_mwb_wgm_product_item_meta( $item_meta, $key, $val ) {

			if ( 'mwb_cgc_image' == $key ) {
					$item_meta [] = array(
						'name' => __( 'Chosen Image', 'woocommerce-ultimate-gift-card' ),
						'value' => stripslashes( $val ),
					);
			}
			if ( 'mwb_cgc_custom_img' == $key ) {
					$item_meta [] = array(
						'name' => __( 'File Name', 'woocommerce-ultimate-gift-card' ),
						'value' => stripslashes( $val ),
					);
			}
			return $item_meta;
		}

		/**
		 * Add Meta Data
		 *
		 * @since    1.0.0
		 */
		public function cgc_mwb_wgm_add_meta_data( $item, $key, $order_val ) {

			if ( 'mwb_cgc_image' == $key ) {
				$item->add_meta_data( 'Chosen Image', $order_val );
			}
			if ( 'mwb_cgc_custom_img' == $key ) {
				$item->add_meta_data( 'File Name', $order_val );
			}
		}

		/**
		 * Return modified array which is required for placing the Gift Card order for customized gitf cards
		 *
		 * @param string $mwb_wgm_common_arr arr .
		 * @param string $item item .
		 * @param string $order order .
		 * @since    1.0.0
		 */
		public function cgc_mwb_wgm_customized_gc_cgc( $mwb_wgm_common_arr, $item, $order ) {
			$product_id = $mwb_wgm_common_arr['product_id'];
			$is_customizable = get_post_meta( $product_id, 'woocommerce_customizable_gift_card', true );
			$cgc_file_name = '';
			$chosen_image = '';
			$cgc_uploaded_file_name = '';
			if ( isset( $is_customizable ) && ! empty( $is_customizable ) && $is_customizable == 'yes' ) {

				$item_meta_data = $item->get_meta_data();
				foreach ( $item_meta_data as $key => $value ) {
					if ( isset( $value->key ) && $value->key == 'Chosen Image' && ! empty( $value->value ) ) {

						$chosen_image = $value->value;
					}
					if ( isset( $value->key ) && $value->key == 'File Name' && ! empty( $value->value ) ) {

						$cgc_file_name = $value->value;
					}
				}

				$new_common_arr = array();

				$new_common_arr['order_id'] = $mwb_wgm_common_arr['order_id'];
				$new_common_arr['product_id'] = $mwb_wgm_common_arr['product_id'];
				$new_common_arr['to'] = $mwb_wgm_common_arr['to'];
				$new_common_arr['from'] = $mwb_wgm_common_arr['from'];
				$new_common_arr['to_name'] = '';
				$new_common_arr['gift_couponnumber'] = $mwb_wgm_common_arr['gift_couponnumber'];
				$new_common_arr['gift_msg'] = $mwb_wgm_common_arr['gift_msg'];
				$new_common_arr['expirydate_format'] = $mwb_wgm_common_arr['expirydate_format'];
				$new_common_arr['selected_template'] = '';
				$new_common_arr['couponamont'] = $mwb_wgm_common_arr['couponamont'];
				$new_common_arr['delivery_method'] = $mwb_wgm_common_arr['delivery_method'];
				$new_common_arr['gift_img_name'] = $mwb_wgm_common_arr['gift_img_name'];
				$new_common_arr['item_id'] = $mwb_wgm_common_arr['item_id'];
				$new_common_arr['chosen_image'] = $chosen_image;
				$new_common_arr['cgc_file_name'] = $cgc_file_name;

				return $new_common_arr;

			} else {
				return $mwb_wgm_common_arr;
			}
		}

		/**
		 * Returns the email template html for Customizable Gift Card
		 *
		 * @param string $return return .
		 * @param string $args args .
		 * @since    1.0.0
		 */
		public function cgc_mwb_wgm_customized_email_cgc( $return, $args ) {

			if ( isset( $args['product_id'] ) && ! empty( $args['product_id'] ) ) {
				$product_id = $args['product_id'];
				$is_customizable = get_post_meta( $product_id, 'woocommerce_customizable_gift_card', true );
				if ( isset( $is_customizable ) && ! empty( $is_customizable ) && $is_customizable == 'yes' ) {

					$message = $this->cgc_customized_email_templates( $args );
					return $message;

				}
			}
			return $return;
		}

		/**
		 * Creating the Email Template
		 *
		 * @param string $args args .
		 * @since    1.0.0
		 */
		public function cgc_customized_email_templates( $args ) {

			if ( ! empty( $args ) ) {

				$disclaimer = self::get_disclaimer();
				if ( isset( $args['chosen_image'] ) && ! empty( $args['chosen_image'] ) ) {
					if ( $args['chosen_image'] == 'Giftcard' ) {
						$featured_image = MWB_WGM_URL . 'Shipping/public/images/gift_card-1.jpg';
					} elseif ( $args['chosen_image'] == 'Christmas' ) {
						$featured_image = MWB_WGM_URL . 'Shipping/public/images/christmas.jpg';
					} elseif ( $args['chosen_image'] == 'Newyear' ) {
						$featured_image = MWB_WGM_URL . 'Shipping/public/images/new_year.jpg';
					} elseif ( $args['chosen_image'] == 'Anniversary' ) {
						$featured_image = MWB_WGM_URL . 'Shipping/public/images/anniversary.jpg';
					} elseif ( $args['chosen_image'] == 'Birthday' ) {
						$featured_image = MWB_WGM_URL . 'Shipping/public/images/happy_birthday.jpg';
					} elseif ( $args['chosen_image'] == 'Custom' ) {
						$featured_image = wp_upload_dir()['baseurl'] . '/cgc_own_img/' . $args['cgc_file_name'];
					} else {
						$featured_image = wp_upload_dir()['baseurl'] . '/cgc_admin_own_img/' . $args['chosen_image'];
					}
				}
				$featured_image = "<img src='$featured_image'  class='center-on-narrow' style='width: 100%; margin: 0 auto; line-height: 1.5;font-family: Helvetica;box-sizing: border-box;border-collapse: collapse';>";

				$html = '<div class="main-container" width="600px" style="width: 600px; margin: 0 auto;line-height: 1.5;font-family: Helvetica;background-color: #ffffff;box-shadow: 2px 3px 10px rgba(0,0,0,0.22);padding: 15px 20px;border: 1px solid #e4dada;box-sizing: border-box;"><table class="main-container" width="100%" cellpadding="0" cellpadding="0" style="width: 100%; margin: 0 auto;line-height: 1.5;font-family: Helvetica;box-sizing: border-box;border-collapse: collapse;"><tbody><tr><td>[FEATUREDIMAGE]</td></tr><tr style="background-color: #e33b3b;color: #ffffff;"><td style="padding:20px 15px;"><p style="text-align: center;margin: 0;"><span style="font-size: 30px;font-weight: bold;border: 2px solid #fff;padding: 8px 40px;display: inline-block;background-color: #ffffFF;border-radius: 5px;color: #000000;">[COUPONCODE]</span></p><div style="font-size:22px; clear:both; display: block;margin-top: 20px;"><div style="float: left;"><span style="font-weight: bold;">ED-</span> [EXPIRYDATE]</div><div style="float: right;font-weight: bold;">[AMOUNT]</div></div></td></tr><tr><td style="text-align: center;background-color: #f1f1f1;padding: 20px 10px;font-size: 16px;"><div>[MESSAGE]</div><div style="text-align: right;font-size: 22px;padding-top: 10px;"><span style="font-weight: bold;">From: </span>[FROM]</div></td></tr><tr style="background-color: #9b9090;color: #ffffff;;text-align: center;margin-top: 15px;"><td style="padding: 30px 10px;">[DISCLAIMERTEXT]</td></tr></tbody></table></div><style>@media screen and (max-width: 600px){.main-container{width: 100% !important;}}</style>';

				$html = str_replace( '[FEATUREDIMAGE]', $featured_image, $html );
				$html = str_replace( '[EXPIRYDATE]', $args['expirydate'], $html );
				$html = str_replace( '[AMOUNT]', $args['amount'], $html );
				$html = str_replace( '[MESSAGE]', nl2br( $args['message'] ), $html );
				$html = str_replace( '[FROM]', $args['from'], $html );
				$html = str_replace( '[DISCLAIMERTEXT]', $disclaimer, $html );
				$html = str_replace( '[COUPONCODE]', $args['coupon'], $html );

				return $html;
			}
		}


		/**
		 * Resend for Customizable Gift Card
		 *
		 * @param string $args args.
		 * @param string $item item.
		 * @since    1.0.0
		 */
		public function cgc_mwb_wgm_resend_mail_arr_update( $args, $item ) {

			$product_id = $args['product_id'];
			$is_customizable = get_post_meta( $product_id, 'woocommerce_customizable_gift_card', true );
			$cgc_file_name = '';
			$chosen_image = '';
			$cgc_uploaded_file_name = '';
			if ( isset( $is_customizable ) && ! empty( $is_customizable ) && $is_customizable == 'yes' ) {

				$item_meta_data = $item->get_meta_data();
				foreach ( $item_meta_data as $key => $value ) {
					if ( isset( $value->key ) && $value->key == 'Chosen Image' && ! empty( $value->value ) ) {

						$chosen_image = $value->value;
					}
					if ( isset( $value->key ) && $value->key == 'File Name' && ! empty( $value->value ) ) {

						$cgc_file_name = $value->value;
					}
					if ( isset( $value->key ) && $value->key == 'Uploaded File Name' && ! empty( $value->value ) ) {

						$cgc_uploaded_file_name = $value->value;
					}
				}

				$new_common_arr = array();

				$new_common_arr['product_id'] = $args['product_id'];
				$new_common_arr['to'] = $args['to'];
				$new_common_arr['from'] = $args['from'];
				$new_common_arr['to_name'] = '';
				$new_common_arr['coupon'] = $args['coupon'];
				$new_common_arr['message'] = $args['message'];
				$new_common_arr['expirydate'] = $args['expirydate'];
				$new_common_arr['amount'] = $args['amount'];
				$new_common_arr['chosen_image'] = $chosen_image;
				$new_common_arr['cgc_file_name'] = $cgc_file_name;
				$new_common_arr['cgc_uploaded_file_name'] = $cgc_uploaded_file_name;

				return $new_common_arr;
			} else {
				return $args;
			}
		}

		/**
		 * Adding the required div for displaying the error otice on single product page
		 *
		 * @since    1.0.0
		 */
		public function mwb_cgc_before_main_content() {
			?>
	<div class="woocommerce-error" id="mwb_wgm_error_notice" style="display:none;">
		
	</div>
			<?php
		}

		/**
		 * Render the Delivery Methods in single product page
		 *
		 * @param string $product_id id.
		 * @since    1.0.0
		 */
		public function mwb_add_delivery_methods( $product_id ) {

			$mwb_wgm_method_enable = get_option( 'mwb_wgm_send_giftcard', false );
			$mwb_wgm_mail_to_recipient_text = stripcslashes( get_option( 'mwb_wgm_mail_to_recipient_text', 'Email To Recipient' ) );
			$mwb_wgm_shipping_text = stripslashes( get_option( 'mwb_wgm_shipping_text', 'Want To Ship Your Card' ) );
			$mwb_wgm_downloadable_text = stripslashes( get_option( 'mwb_wgm_downloadable_text', 'You Print & Give To Recipient' ) );
			$mwb_wgm_mail_to_recipient_desc = stripslashes( get_option( 'mwb_wgm_mail_to_recipient_desc', 'We will send it to recipient email address.' ) );
			$mwb_wgm_downloadable_desc = stripslashes( get_option( 'mwb_wgm_downloadable_desc', 'After checking out, you can print your gift card' ) );
			$mwb_wgm_shipping_desc = stripcslashes( get_option( 'mwb_wgm_shipping_desc', 'We will ship your card' ) );
			if ( $mwb_wgm_method_enable == false ) {
				$mwb_wgm_method_enable = 'normal_mail';
			}
			$mwb_wgm_customer_selection = get_option( 'mwb_wgm_customer_selection', false );
			$mwb_wgm_is_overwrite = get_post_meta( $product_id, 'mwb_wgm_overwrite', true );
			$mwb_wgm_email_to_recipient = get_post_meta( $product_id, 'mwb_wgm_email_to_recipient', true );
			$mwb_wgm_download = get_post_meta( $product_id, 'mwb_wgm_download', true );
			$mwb_wgm_shipping = get_post_meta( $product_id, 'mwb_wgm_shipping', true );
			if ( isset( $mwb_wgm_method_enable ) && $mwb_wgm_method_enable == 'normal_mail' ) {
				?>
		<p class="mwb-cgc-radio">
			<input type="radio" name="mwb_wgm_send_giftcard" id="to_email" value="Mail to recipient" checked="checked"><label for="to_email"><?php echo esc_html( $mwb_wgm_mail_to_recipient_text ); ?></label>
			<input type="email" name="mwb_wgm_to_email"  id="mwb_wgm_to_email" class="mwb-cgc-text" placeholder="<?php esc_html_e( "Receiver's Email", 'woocommerce-ultimate-gift-card' ); ?>">	
		</p>
				<?php
			}
			if ( isset( $mwb_wgm_method_enable ) && $mwb_wgm_method_enable == 'download' ) {
				?>
	<p class="mwb-cgc-radio">
		<input type="radio" id="to_download"  name="mwb_wgm_send_giftcard" value="Downloadable" checked="checked"> <label for="to_download"><?php echo esc_html( $mwb_wgm_downloadable_text ); ?></label>
		<input type="text" id="mwb_wgm_to_download" name="mwb_wgm_to_email_name" class="mwb-cgc-text" placeholder="<?php esc_html_e( "Receiver's Name", 'woocommerce-ultimate-gift-card' ); ?>">	
	</p>
				<?php
			}
			if ( isset( $mwb_wgm_method_enable ) && $mwb_wgm_method_enable == 'shipping' ) {
				?>
	<p class="mwb-cgc-radio">
		<input type="radio" value="Shipping" id="to_ship"  name="mwb_wgm_send_giftcard" checked="checked"> <label for="to_ship"><?php echo esc_html( $mwb_wgm_shipping_text ); ?></label>
		<input type="text" id="mwb_wgm_to_ship" name="mwb_wgm_to_email_ship" class="mwb-cgc-text" placeholder="<?php esc_html_e( "Receiver's Name", 'woocommerce-ultimate-gift-card' ); ?>">
	</p>
				<?php
			}
			if ( isset( $mwb_wgm_method_enable ) && $mwb_wgm_method_enable == 'customer_choose' ) {
				if ( isset( $mwb_wgm_is_overwrite ) && $mwb_wgm_is_overwrite == 'yes' ) {
					if ( isset( $mwb_wgm_email_to_recipient ) && $mwb_wgm_email_to_recipient == 'yes' ) {
						?>
				<p class="mwb-cgc-radio">
					<input type="radio" class="mwb_wgm_send_giftcard" name="mwb_wgm_send_giftcard" id="to_mail" value="Mail to recipient" checked="checked"><label for="to_mail"><?php echo esc_html( $mwb_wgm_mail_to_recipient_text ); ?></label>
					<input type="email" name="mwb_wgm_to_email"  id="mwb_wgm_to_email" class="mwb-cgc-text" placeholder="<?php esc_html_e( "Receiver's Email", 'woocommerce-ultimate-gift-card' ); ?>">	
				</p>
						<?php
					}
					if ( isset( $mwb_wgm_download ) && $mwb_wgm_download == 'yes' ) {
						?>
			<p class="mwb-cgc-radio">
				<input type="radio" id="mwb_wgm_send_giftcard_download" class="mwb_wgm_send_giftcard" name="mwb_wgm_send_giftcard" value="Downloadable" > <label for="mwb_wgm_send_giftcard_download"><?php echo esc_html( $mwb_wgm_downloadable_text ); ?></label>
				<input type="text"  id="mwb_wgm_to_download"  name="mwb_wgm_to_email_name" class="mwb-cgc-text" placeholder="<?php esc_html_e( "Receiver's Name", 'woocommerce-ultimate-gift-card' ); ?>">	
			</p>
						<?php
					}
					if ( isset( $mwb_wgm_shipping ) && $mwb_wgm_shipping == 'yes' ) {
						?>
				<p class="mwb-cgc-radio">
					<input type="radio" value="Shipping" id="mwb_wgm_send_giftcard_ship" class="mwb_wgm_send_giftcard" name="mwb_wgm_send_giftcard" > <label for="mwb_wgm_send_giftcard_ship"><?php echo esc_html( $mwb_wgm_shipping_text ); ?></label>
					<input type="text"  id="mwb_wgm_to_ship" name="mwb_wgm_to_email_ship" class="mwb-cgc-text" placeholder="<?php esc_html_e( "Receiver's Name", 'woocommerce-ultimate-gift-card' ); ?>">
				</p>
						<?php
					}
				} else {
					if ( isset( $mwb_wgm_customer_selection['Email_to_recipient'] ) && $mwb_wgm_customer_selection['Email_to_recipient'] == '1' ) {
						?>
				<p class="mwb-cgc-radio">
					<input type="radio" name="mwb_wgm_send_giftcard" class="mwb_wgm_send_giftcard" id="to_mail" value="Mail to recipient" checked="checked"><label for="to_mail"><?php echo esc_html( $mwb_wgm_mail_to_recipient_text ); ?></label>
					<input type="email" name="mwb_wgm_to_email"  id="mwb_wgm_to_email" class="mwb-cgc-text" placeholder="<?php esc_html_e( "Receiver's Email", 'woocommerce-ultimate-gift-card' ); ?>">	
				</p>
						<?php
					}
					if ( isset( $mwb_wgm_customer_selection['Downloadable'] ) && $mwb_wgm_customer_selection['Downloadable'] == '1' ) {
						?>
				<p class="mwb-cgc-radio">
					<input type="radio" id="mwb_wgm_send_giftcard_download" class="mwb_wgm_send_giftcard" name="mwb_wgm_send_giftcard" value="Downloadable" > <label for="mwb_wgm_send_giftcard_download"><?php echo esc_html( $mwb_wgm_downloadable_text ); ?></label>
					<input type="text"  id="mwb_wgm_to_download" name="mwb_wgm_to_email_name" class="mwb-cgc-text" placeholder="<?php esc_html_e( "Receiver's Name", 'woocommerce-ultimate-gift-card' ); ?>">	
				</p>
						<?php
					}
					if ( isset( $mwb_wgm_customer_selection['Shipping'] ) && $mwb_wgm_customer_selection['Shipping'] == '1' ) {
						?>
				<p class="mwb-cgc-radio">
					<input type="radio" value="Shipping" id="mwb_wgm_send_giftcard_ship" class="mwb_wgm_send_giftcard"  name="mwb_wgm_send_giftcard" > <label for="mwb_wgm_send_giftcard_ship"><?php echo esc_html( $mwb_wgm_shipping_text ); ?></label>
					<input type="text"  id="mwb_wgm_to_ship"  name="mwb_wgm_to_email_ship" class="mwb-cgc-text" placeholder="<?php esc_html_e( "Receiver's Name", 'woocommerce-ultimate-gift-card' ); ?>">
				</p>
						<?php
					}
				}
			}
		}

		/**
		 * Returns the Coupon Prefix
		 *
		 * @since    1.0.0
		 */

		public static function get_coupon_prefix() {

			return $giftcard_prefix = get_option( 'mwb_wgm_general_setting_giftcard_prefix', '' );
		}

		/**
		 * Returns Expiry Date Format & display in Preview
		 *
		 * @since    1.0.0
		 */

		public static function get_expiry_date_format( $expiry_date ) {

			$todaydate = date_i18n( 'Y-m-d' );
			if ( isset( $expiry_date ) && ! empty( $expiry_date ) ) {
				if ( $expiry_date > 0 || $expiry_date === 0 ) {
					$expirydate = date_i18n( 'Y-m-d', strtotime( "$todaydate +$expiry_date day" ) );
					$expirydate_format = date_create( $expirydate );
					$selected_date = get_option( 'mwb_wgm_general_setting_enable_selected_format_1', false );
					if ( isset( $selected_date ) && $selected_date != null && $selected_date != '' ) {

						$expirydate_format = date_i18n( $selected_date, strtotime( "$todaydate +$expiry_date day" ) );
					} else {
						$expirydate_format = date_format( $expirydate_format, 'jS M Y' );
					}
				}
			} else {
				$expirydate_format = __( 'No Expiration', 'woocommerce-ultimate-gift-card' );
			}
			return $expirydate_format;
		}

		/**
		 * Returns the Disclaimer text
		 *
		 * @since    1.0.0
		 */

		public static function get_disclaimer() {

			$disclaimer = get_option( 'mwb_wgm_other_setting_disclaimer', false );

			return $disclaimer = stripcslashes( $disclaimer );
		}
	}
	new MWB_WGM_Shipping_Manager();
}
