<?php
/**
 * Exit if accessed directly.
 *
 * @package woocommerce ultimate gift card .
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/*
 * Addon Setting Template
 */

/**
 * Exit if accessed directly
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}



if ( isset( $_POST['cgc_submit_per_upload_image'] ) ) {

	$index = 0;

	$upload_dir_path = wp_upload_dir()['basedir'] . '/cgc_admin_own_img';
	if ( ! is_dir( $upload_dir_path ) ) {
		wp_mkdir_p( $upload_dir_path );
		chmod( $upload_dir_path, 0775 );
	}
	$file_name = $_FILES['mwb_cgc_admin_custom_img']['name'];
	if ( ( $_FILES['mwb_cgc_admin_custom_img']['type'] == 'image/gif' ) || ( $_FILES['mwb_cgc_admin_custom_img']['type'] == 'image/jpeg' ) || ( $_FILES['mwb_cgc_admin_custom_img']['type'] == 'image/jpg' ) || ( $_FILES['mwb_cgc_admin_custom_img']['type'] == 'image/pjpeg' ) || ( $_FILES['mwb_cgc_admin_custom_img']['type'] == 'image/x-png' ) || ( $_FILES['mwb_cgc_admin_custom_img']['type'] == 'image/png' ) ) {
		$file_name = $_FILES['mwb_cgc_admin_custom_img']['name'];
		if ( ! file_exists( wp_upload_dir()['basedir'] . '/cgc_admin_own_img/' . $file_name ) ) {
			move_uploaded_file( $_FILES['mwb_cgc_admin_custom_img']['tmp_name'], wp_upload_dir()['basedir'] . '/cgc_admin_own_img/' . $file_name );
		}
		$cgc_product_image = get_option( 'cgc_product_image', true );
		if ( isset( $cgc_product_image ) && ! empty( $cgc_product_image ) && is_array( $cgc_product_image ) ) {
			array_push( $cgc_product_image, $file_name );
			update_option( 'cgc_product_image', $cgc_product_image );
		} else {
			$cgc_product_image = array();
			array_push( $cgc_product_image, $file_name );
			update_option( 'cgc_product_image', $cgc_product_image );
		}
	}
}
$value_check = isset( $_POST['message-expiration-setting'] ) ? sanitize_text_field( wp_unslash( $_POST['message-expiration-setting'] ) ) : '';

if ( isset( $_POST['wcgc_save_settings'] ) && wp_verify_nonce( $value_check, 'point-expiration-setings' ) ) {

	if ( ! isset( $_POST['wcgc_plugin_enable'] ) ) {
		$_POST['wcgc_plugin_enable'] = 'off';
	}
	if ( ! isset( $_POST['wcgc_image_enable'] ) ) {
		$_POST['wcgc_image_enable'] = 'default_img';
	} elseif ( isset( $_POST['wcgc_image_enable'] ) && $_POST['wcgc_image_enable'] == 'default_img' ) {
		$_POST['wcgc_image_enable'] = 'default_img';
	} elseif ( isset( $_POST['wcgc_image_enable'] ) && $_POST['wcgc_image_enable'] == 'upload_img' ) {
		$_POST['wcgc_image_enable'] = 'upload_img';
	} elseif ( isset( $_POST['wcgc_image_enable'] ) && $_POST['wcgc_image_enable'] == 'upload_and_default_img' ) {
		$_POST['wcgc_image_enable'] = 'upload_and_default_img';
	}

	update_option( 'wcgc_plugin_enable', sanitize_text_field( wp_unslash( $_POST['wcgc_plugin_enable'] ) ) );
	update_option( 'wcgc_image_enable', sanitize_text_field( wp_unslash( $_POST['wcgc_image_enable'] ) ) );
	?>
	<div class="notice notice-success is-dismissible"> 
		<p><strong><?php esc_html_e( 'Settings saved', 'woocommerce-ultimate-gift-card' ); ?></strong></p>
		<button type="button" class="notice-dismiss">
			<span class="screen-reader-text"><?php esc_html_e( 'Dismiss this notice', 'woocommerce-ultimate-gift-card' ); ?></span>
		</button>
	</div>
	<?php
}
$wcgc_plugin_enable = get_option( 'wcgc_plugin_enable', false );
$wcgc_image_enable = get_option( 'wcgc_image_enable', false );
?>
<div class="wcgc_wrapper">
	<div style="display:none;" class="loading-style-bg" id="mwb_wgm_loader">
	
		<img src="<?php echo esc_html( MWB_WGM_SD_URL ); ?>/admin/images/loading.gif">
	</div>
	<table class="form-table wcgc_general_setting">
		<tbody>
			<tr valign="top">
			
				<th scope="row" class="titledesc">
					<label for="wcgc_plugin_enable"><?php esc_html_e( 'Enable', 'woocommerce-ultimate-gift-card' ); ?></label>
				</th>
				<td class="forminp forminp-text">
					<?php
					$attribut_description = __( 'Check this box to enable Woocommerce Customizable Gift Card', 'woocommerce-ultimate-gift-card' );
					echo wp_kses_post( wc_help_tip( $attribut_description ) );
					?>
					<label for="wcgc_plugin_enable">
						<input type="checkbox" <?php echo ( $wcgc_plugin_enable == 'on' ) ? "checked='checked'" : ''; ?> name="wcgc_plugin_enable" id="wcgc_plugin_enable" class="input-text">
					</label>						
				</td>
			</tr>
			<tr valign="top">
				<th scope="row" class="titledesc">
					<label for="wcgc_default_enable"><?php esc_html_e( 'Allow default template images', 'woocommerce-ultimate-gift-card' ); ?></label>
				</th>
				<td class="forminp forminp-text">
					<?php
					$attribut_description = __( 'Check this box to allow all pre-defined images.', 'woocommerce-ultimate-gift-card' );
					echo wp_kses_post( wc_help_tip( $attribut_description ) );
					?>
					<label for="wcgc_default_enable">
						<input type="radio" <?php echo ( $wcgc_image_enable == 'default_img' ) ? "checked='checked'" : ''; ?> name="wcgc_image_enable" value="default_img" id="wcgc_default_enable" class="input-text">
					</label>	
				</td>
			</tr>
			<tr valign="top">
				<th scope="row" class="titledesc">
					<label for="wcgc_upload_enable"><?php esc_html_e( 'Allow uploaded template images', 'woocommerce-ultimate-gift-card' ); ?></label>
				</th>
				<td class="forminp forminp-text">
					<?php
					$attribut_description = __( 'Check this box to upload images.', 'woocommerce-ultimate-gift-card' );
					echo wp_kses_post( wc_help_tip( $attribut_description ) );
					?>
					<label for="wcgc_upload_enable">
						<input type="radio" <?php echo ( $wcgc_image_enable == 'upload_img' ) ? "checked='checked'" : ''; ?> name="wcgc_image_enable" value="upload_img" id="wcgc_upload_enable" class="input-text">
					</label>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row" class="titledesc">
					<label for="wcgc_default_and_upload_enable"><?php esc_html_e( 'Allow Uploaded images and retain default images', 'woocommerce-ultimate-gift-card' ); ?></label>
				</th>
				<td class="forminp forminp-text">
					<?php
					$attribut_description = __( 'Check this box to upload images and retain default images.', 'woocommerce-ultimate-gift-card' );
					echo wp_kses_post( wc_help_tip( $attribut_description ) );
					?>
					<label for="wcgc_default_and_upload_enable">
						<input type="radio" <?php echo ( $wcgc_image_enable == 'upload_and_default_img' ) ? "checked='checked'" : ''; ?> name="wcgc_image_enable" value="upload_and_default_img" id="wcgc_default_and_upload_enable" class="input-text">
					</label>	
				</td>
			</tr>
			<tr valign="top">
				<th scope="row" class="titledesc">
					<label for="browse_img_section"><?php esc_html_e( 'Upload images for email template', 'woocommerce-ultimate-gift-card' ); ?></label>
				</th>

				<td class="forminp forminp-text">
				 <div id="browse_img_section">
					<?php

					$upload_dir_path = wp_upload_dir()['baseurl'] . '/cgc_admin_own_img';
						$cgc_product_image = get_option( 'cgc_product_image', true );
						$count = 0;
					if ( isset( $cgc_product_image ) && ! empty( $cgc_product_image ) && is_array( $cgc_product_image ) ) {

						foreach ( $cgc_product_image as $value ) {
							?>

									 <div class='<?php echo 'mwb_wgm_addon_bulk_image_div mwb_add_on_class_' . $count; ?>'>
									
										 <input class="<?php echo 'mwb_wgm_image_upload'; ?>" data-count='<?php echo $count; ?>' type="file" name="<?php echo 'mwb_cgc_admin_custom_img'; ?>" style="display: none;">
										 
										 <input type="submit" name="<?php echo 'cgc_submit_per_upload_image'; ?>" data-count="<?php echo $count; ?>" style="display:none" class='button cgm_upload_image_for_email' value='upload'>
										 <input type="hidden" name="upload_path" id="upload_path" value="<?php echo wp_upload_dir()['baseurl']; ?>">
										<input type="hidden" name="uploaded_image_value" id="uploaded_image_value" value="Giftcard">
										 <p id="<?php echo 'mwb_wgm_email_template_background_' . $count; ?>">
											 <span class="mwb_wgm_other_setting_remove_background wcgc_remove_img">
												 <img src="<?php echo $upload_dir_path . '/' . $value; ?>" id="<?php echo 'mwb_wgm_email_template_image_' . $count; ?>" width="150px" height="150px">
												 <span id='<?php echo 'mwb_wgm_remove_background_span_' . $count; ?>' class="mwb_wgm_other_setting_remove_background_span mwb_wgm_remove_background_span" data-value="<?php echo $count; ?>">X</span>
											 </span>
										 </p>
									 </div>
									<?php
									$count++;
						}
						?>
									 <input class="button mwb_wgm_add_more_image image_upload_button"  id="<?php echo 'mwb_wgm_add_more_image_' . $count; ?>" type="button" data-count='<?php echo $count; ?>' value="Add more">
									<?php
					} else {

						?>
							<?php
							$count = 0;
							?>
								 <div class="mwb_wgm_addon_bulk_image_div mwb_add_on_class_<?php echo $count; ?>" >
					
								<input class="<?php echo 'mwb_wgm_image_upload_' . esc_html( $count ); ?>" data-count="0"  type="file" name="<?php echo 'mwb_cgc_admin_custom_img'; ?>">
								<input type="submit" name="<?php echo 'cgc_submit_per_upload_image'; ?>" data-count="<?php echo esc_html( $count ); ?>" class='button cgm_upload_image_for_email' value='upload'>
								<p class="description"><?php esc_html_e( 'Note: Suggested Dimension is (600*400)', 'woocommerce-ultimate-gift-card' ); ?></p>
								<input type="hidden" name="upload_path" id="upload_path" value="<?php echo wp_upload_dir()['baseurl']; ?>">
								<input type="hidden" name="uploaded_image_value" id="uploaded_image_value" value="Giftcard">
								<p id="<?php echo 'mwb_wgm_email_template_background_' . esc_html( $count ); ?>" style="display: none;">
									<span class="mwb_wgm_other_setting_remove_background wcgc_remove_img">
									<img src="" id="<?php echo 'mwb_wgm_email_template_image_' . esc_html( $count ); ?>" width="150px" height="150px">
									<span id='<?php echo 'mwb_wgm_remove_background_span_' . esc_html( $count ); ?>' style="display: none;" class="mwb_wgm_other_setting_remove_background_span mwb_wgm_remove_background_span" data-value="0">X</span>
									</span>
								</p>
							 </div>
						 <?php
					}
					?>
						</div>
					<input type="hidden" value="0">
					</td>
			</tr>
			<tr valign="top">
				<th scope="row" class="titledesc">
					<label for="wcgc_create_custom_gift_card"><?php esc_html_e( 'Create another Gift Card', 'woocommerce-ultimate-gift-card' ); ?></label>
				</th>
				<td class="forminp forminp-text">
					<?php
					$attribut_description = __( 'Check this box to upload images and retain default images.', 'woocommerce-ultimate-gift-card' );
					echo wp_kses_post( wc_help_tip( $attribut_description ) );
					?>
					<label for="wcgc_create_custom_gift_card">
						<input type="button" name="cgc_custom_giftcard" class=" button-primary" id="cgc_custom_giftcard" value="<?php _e( 'Create Gift Card', 'woocommerce-ultimate-gift-card' ); ?>">
						<p class="description"><?php esc_html_e( 'If you have deleted your customizable gift card, you can create another one!', 'woocommerce-ultimate-gift-card' ); ?></p>
					</label>	
				</td>
			</tr>
		</tbody>
	</table>
</div>
<div class="clear"></div>
<p class="submit">
	<?php $nonce = wp_create_nonce( 'point-expiration-setings' ); ?>
	<input type="hidden" name="message-expiration-setting" value="<?php echo esc_attr( $nonce ); ?>" />
	<input type="submit" value="<?php esc_html_e( 'Save changes', 'woocommerce-ultimate-gift-card' ); ?>" class="button-primary woocommerce-save-button" name="wcgc_save_settings" id="wcgc_save_settings" >
</p>
