<?php
/**
 * Exit if accessed directly.
 *
 * @package woocommerce ultimate gift card .
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


if ( ! class_exists( 'MWB_WGM_QR_Barcode_Card_Product' ) ) {

	/**
	 * This is class for managing order status and other functionalities .
	 *
	 * @name    MWB_WGM_QR_Barcode_Card_Product
	 * @category Class
	 * @author   WP Swings <webmaster@wpswings.com>
	 */
	class MWB_WGM_QR_Barcode_Card_Product {

		/**
		 * This function sets qrcode image
		 *
		 * @param string $coupon $coupon.
		 * @param string $qrcode_level $qrcode_level.
		 * @param string $qrcode_size $qrcode_size.
		 * @param string $qrcode_margin $qrcode_margin.
		 * @param string $time_stamp $time_stamp.
		 * @param string $site_name $site_name.
		 * @name getqrcode()
		 * @author WP Swings <webmaster@wpswings.com>
		 * @link http://www.makewebbetter.com/
		 */
		public function getqrcode( $coupon, $qrcode_level, $qrcode_size, $qrcode_margin, $time_stamp, $site_name ) {

			$path = MWB_UPLOAD_DIR . '/qrcode_barcode/mwb__' . $time_stamp . $coupon . '.png';

			if ( 'L' == $qrcode_level ) {
				$qrcode_level = QR_ECLEVEL_L;
			} elseif ( 'M' == $qrcode_level ) {
				$qrcode_level = QR_ECLEVEL_M;
			} elseif ( 'Q' == $qrcode_level ) {
				$qrcode_level = QR_ECLEVEL_Q;
			} elseif ( 'H' == $qrcode_level ) {
				$qrcode_level = QR_ECLEVEL_H;
			}
			QRcode::png( $coupon, $path, $qrcode_level, $qrcode_size, $qrcode_margin );

		}
		/**
		 * This function sets barrcode image
		 *
		 * @param string  $coupon coupon.
		 * @param boolean $barcode_display barcode_display.
		 * @param string  $barcode_type barcode_type.
		 * @param string  $barcode_size barcode_size.
		 * @param string  $time_stamp time_stamp.
		 * @param string  $site_name site_name.
		 * @author WP Swings <webmaster@wpswings.com>
		 * @link http://www.makewebbetter.com
		 */
		public function getbarcode( $coupon, $barcode_display, $barcode_type, $barcode_size, $time_stamp, $site_name ) {
			$path = MWB_UPLOAD_DIR . '/qrcode_barcode/mwb__' . $time_stamp . $coupon . '.png';
			if ( 'on' == $barcode_display ) {
				$barcode_display = true;
			} else {
				$barcode_display = false;
			}
			barcode( $path, $coupon, $barcode_size, 'horizontal', $barcode_type, $barcode_display, 1 );
		}
	}
}
