<?php

$url_options = array();
if ( isset( $_GET[ 'status' ] ) ) {
    $url_options[ 'status' ] = sanitize_text_field( $_GET[ 'status' ] );
}
if ( isset( $_GET[ 'search' ] ) ) {
    $url_options[ 'search' ] = sanitize_text_field( $_GET[ 'search' ] );
}



$url_format = admin_url( 'admin.php?page=wznd-wallet-refunds&pg={{page}}' );

$default_url = admin_url( 'admin.php?page=wznd-wallet-refunds' );

foreach ( $url_options as $key => $value ) {
    $url_format .= ('&' . $key . '={{' . $key . '}}');
    $default_url .= ('&' . $key . '={{' . $key . '}}');
}
$status = -1;
if ( !empty( $_GET[ 'status' ] ) ) {
    $status = sanitize_text_field( $_GET[ 'status' ] );
}
$search = !empty( $_GET[ 'search' ] ) ? sanitize_text_field( $_GET[ 'search' ] ) : '';

$totals = WooZnd_RefundDB::GetRequestsCount( ($search != '') ? $search . '%' : '', $status );
$pagesize = 25;

$pg = isset( $_GET[ 'pg' ] ) ? $_GET[ 'pg' ] : 1;
$paging = new WooZnd_Paginator( $totals, $pagesize, $pg );


$rows = WooZnd_RefundDB::LoadRequests( ($search != '') ? $search . '%' : '', $status, $paging->offset(), $paging->limit() );

