const checkbox = (
	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 66 66">
		<path d="M51.68,23.37l-22.65,23.1c-1.04,1.06-2.73,1.06-3.78,0l-11.32-11.55c-.53-1.06-.53-2.79,0-3.23,1.04-1.09,2.73-1.09,3.77,0l9.44,9,20.76-21.18c1.04-1.07,2.73-1.07,3.78,0,1.04,1.06,1.04,2.79,0,3.85Z" />
	</svg>
);

const colorSwatches = (
	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 66 66">
		<path d="M22.29,4.28l-3.18,3.25,4.03,4.15L7.74,28.11h0c-2.67,2.75-2.11,7.07,.57,9.83h0l13.7,14.69c2.67,2.75,7.07,2.75,9.74,0l17.16-17.67,1.62-1.6-1.62-1.67L28.58,10.73l-1.77-1.89-.5-.44-4.03-4.12Zm4.1,10.74l17.8,18.33-15.61,16c-.94,.97-2.45,.97-3.39,0l-14.41-14.91c-.94-.97-.94-2.45,0-3.42L26.39,15.02Zm27.4,26.33l-2.29,2.9s-1.04,1.55-2.51,3.72c-.59,1.05-1.15,2.15-1.62,3.27-.48,1.12-.92,2.15-.92,3.49,0,3.83,3.06,6.98,7.34,6.98,3.15,0,6.21-3.15,6.21-6.98,0-1.35-.44-2.37-.92-3.49-.48-1.12-1.03-2.22-1.62-3.27-1.01-1.79-2.24-3.85-2.24-3.85l-1.43-2.77Zm-.25,8.78c-.14-.06-.21-.09-.23-.1-.03,0,.1,.09,.2,.26,.54,.96,1.11,1.97,1.48,2.84,.37,.87,.49,1.67,.49,1.6,0,1.29-1.01,2.33-1.69,2.33-1.82,0-2.82-1.04-2.82-2.33,0,.07,.12-.73,.49-1.6,.37-.87,.86-1.89,1.4-2.84,.14-.17-.03-.34,.68-.16Z" />
	</svg>
);

const customerPrice = (
	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 66 66">
		<path d="M53.46,17.6v5.26c1.25,.29,2.29,.62,3.11,.96,.82,.35,1.52,.86,2.08,1.55,.56,.69,.85,1.59,.85,2.72,0,1.41-.11,3.35-1.28,4.01-1.18,.65-2.79,1.14-4.75,1.35v2.92h-2.13v-2.89c-1.28-.09-1.97-.32-3.64-.7-1.14-.38-2.06-.87-2.73-1.46l1.17-2.63c.9,.52,1.42,1.49,2.34,1.31,.92,.36,1.87,.58,2.86,1.22v-5.77c-1.23-.29-2.26-.62-3.08-.98-.82-.36-1.51-.88-2.07-1.56-.56-.69-.83-1.59-.83-2.72,0-1.41,.51-2.6,1.54-3.59,1.02-.99,2.51-1.58,4.45-1.77v-2.94h2.13v2.89c.97,.05,1.92,.22,2.85,.5,.93,.28,1.74,.64,2.43,1.29l-1.07,2.43c-1.32-.76-1.98-1.23-4.22-1.41Zm0,13.92c.92-1.04,1.6-1.31,2.04-1.71,.97-.4,.66-.89,.66-1.48s.18-1.06-.7-1.42c-.47-.25-1.14-.65-2-.9v5.51Zm-2.13-13.85c-.88,.14-1.54,.42-1.98,.83-.43,.42-.65,1.08-.65,1.54,0,.57,.23,1.03,.68,1.38,.81,.35,1.1,.64,1.95,.89v-4.63Zm-10.13,36.43c-1.29,0-2.34-.32-2.34-2.34h-.39c.04-.39,.06-.35,.06-1.17,0-6.36-4.02-11.63-11.37-12.67v11.53c0,.63-.51,1.14-1.14,1.14h-2.4c-.63,0-1.14-.51-1.14-1.14v-11.53c-6.45,1.04-11.37,6.31-11.37,12.67,0,.82,.03,.79,.34,1.17h-.67c0,2.02-1.05,2.34-2.34,2.34-.62,0-1.95-.32-1.95-2.34,0-.14,.17-.27,.41-.41-.18-.25-.41-.51-.41-.76,0-6.95,3.93-12.94,10.17-15.79-2.88-2.36-4.72-5.95-4.72-9.96,0-7.11,5.76-12.88,12.87-12.88s12.87,5.76,12.87,12.88c0,4.02-1.84,7.6-4.72,9.96,6.25,2.84,10.57,8.83,10.57,15.79,0,.26-.02,.51-.04,.76,.02,.13,.04,.27,.04,.41,0,2.03-1.05,2.34-2.34,2.34Zm-8.19-29.26c0-4.52-3.67-8.19-8.19-8.19s-8.19,3.67-8.19,8.19,3.87,8.19,8.19,8.19,8.19-3.67,8.19-8.19Z" />
	</svg>
);

const dropdown = (
	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 66 66">
		<g>
			<path d="M58.94,13.22H6.94c-3.33-.19-6.2,2.32-6.44,5.65v28.26c.27,3.34,3.16,5.85,6.5,5.65H59c3.35,.21,6.24-2.31,6.5-5.65V18.87c-.26-3.37-3.19-5.9-6.56-5.65Zm3.33,33.35c0,1.56-1.27,2.83-2.83,2.83H6.52c-1.56,0-2.83-1.27-2.83-2.83V19.3c0-1.56,1.27-2.83,2.83-2.83H59.45c1.56,0,2.83,1.27,2.83,2.83v27.27Z" />
			<path d="M53.94,23.14h0l-5.43,5.43-5.4-5.43c-.55-.51-1.4-.51-1.95,0-.54,.54-.54,1.41,0,1.95l6.36,6.42c.55,.51,1.4,.51,1.95,0l6.42-6.42c.59-.49,.67-1.36,.18-1.95-.49-.59-1.36-.67-1.95-.18-.07,.05-.13,.12-.18,.18Z" />
		</g>
	</svg>
);

const fileUpload = (
	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 66 66">
		<path d="M54.36,17.99H12.12c-1.11,0-1.62-.51-1.62-1.14v-1.94c0-1.42,.51-1.93,1.62-1.93H54.36c.63,0,1.14,.51,1.14,1.93v1.94c0,.63-.51,1.14-1.14,1.14ZM19.21,30.83l11.29-6.7h0c0-.63,.51-1.14,1.14-1.14h2.72c1.11,0,1.14,.51,1.14,1.14h0l11.29,6.7c1.16,.69,1.56,2.22,.89,3.42-.67,1.97-2.16,1.61-3.33,.91l-8.86-5.25v21.96c0,.63-.03,1.14-1.14,1.14h-2.72c-.63,0-1.14-.51-1.14-1.14V29.91l-8.86,5.25c-1.16,.69-2.65,1.06-3.33-.91-.67-1.2-.27-2.73,.89-3.42Z" />
	</svg>
);

const html = (
	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 66 66">
		<g>
			<path d="M44.87,21.76h0l11.21,11.21-11.21,11.21c-1.12,1.11-1.13,2.92-.02,4.03,0,0,.01,.01,.02,.02,1.11,1.11,2.91,1.11,4.02,0l13.27-13.21c1.12-1.11,1.13-2.92,.02-4.03,0,0-.01-.01-.02-.02l-13.27-13.27c-1.11-1.11-2.91-1.11-4.02,0-1.12,1.11-1.13,2.92-.02,4.03,0,0,.01,.01,.02,.02Z" />
			<path d="M21.13,44.21h0l-11.21-11.21,11.21-11.21c1.12-1.11,1.13-2.92,.02-4.03,0,0-.01-.01-.02-.02-1.11-1.11-2.91-1.11-4.02,0L3.84,30.95c-1.12,1.11-1.13,2.92-.02,4.03,0,0,.01,.01,.02,.02l13.27,13.29c1.13,1.11,2.94,1.1,4.05-.03,1.11-1.13,1.1-2.94-.03-4.05Z" />
		</g>
	</svg>
);

const imageButtons = (
	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 66 66">
		<path d="M54.88,55.51H12.55c-1.48,0-2.05-.57-2.05-1.28v-3.07c0-.7,.57-1.28,2.05-1.28H54.88c.05,0,.62,.57,.62,1.28v3.07c0,.71-.57,1.28-.62,1.28Zm-.83-11.26H13.39c-1.87,0-2.89-1.02-2.89-2.27V12.76c0-1.25,1.02-2.27,2.89-2.27H54.05c.43,0,1.45,1.02,1.45,2.27v29.23c0,1.25-1.02,2.27-1.45,2.27Zm-3.55-28.77H15.5v23.76H50.5V15.49Zm-29.43,11.26h6.36c.31,0,.57,.25,.57,.57v6.37c0,.31-.25,.57-.57,.57h-6.36c-.31,0-.57-.25-.57-.57v-6.37c0-.31,.25-.57,.57-.57Z" />
	</svg>
);

const number = (
	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 66 66">
		<path d="M59.21,25.74l-15.72,15.75c-.36,.36-.8,.58-1.25,.67,.14,.38,.04,.74-.19,.77-.71,.03-10.85,.62-11.72,1.01-.57,.32-1.2-.96-1.18-1.52,.03-.63,.62-10.43,.92-11.56,.31-.4,.15-.55,.57-.38,.09-.46,.27-.47,.63-1.25l15.72-15.75c.96-.37,2.53-.37,3.49,0l8.73,8.75c.96,.97,.96,2.53,0,3.5Zm-10.8-7.8l-14.12,14.12v6.42h6.42l14.12-14.12-6.42-6.42ZM7.19,47.46h31.11c.62,0,1.12,.5,1.12,1.27v2.74c0,.62-.5,1.31-1.12,1.31H7.19c-.62,0-1.12-.69-1.12-1.31v-2.74c0-.77,.5-1.27,1.12-1.27Z" />
		<path d="M19.6,37.92v2.74H6.74v-2.17l6.93-6.58c.78-.75,1.31-1.4,1.58-1.96,.27-.56,.41-1.11,.41-1.66,0-.81-.27-1.44-.82-1.87-.55-.43-1.35-.65-2.42-.65-1.78,0-3.14,.61-4.09,1.82l-2.27-1.74c.68-.91,1.6-1.62,2.75-2.13,1.15-.51,2.45-.76,3.87-.76,1.89,0,3.41,.45,4.54,1.35,1.13,.9,1.69,2.12,1.69,3.66,0,.95-.2,1.84-.6,2.67-.4,.83-1.16,1.78-2.29,2.84l-4.66,4.44h8.22Z" />
	</svg>
);

const paragraph = (
	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 66 66">
		<path d="M59.27,20.06l-15.76,15.79c-.36,.36-.8,.58-1.26,.68,.14,.39,.04,.75-.4,.77-.5,.03-10.67,.62-11.54,.67-.03,.03-1.21-.62-1.18-1.18,.03-.63,1.24-10.86,.67-11.59,.03-.38,.37-.53,.77-.39,.09-.46,.32-.89,.67-1.25l15.76-15.79c.97-.13,2.53-.13,3.5,0l8.75,8.77c.97,.97,.97,2.54,0,3.51Zm-10.83-7.82l-14.15,14.16v6.44h6.43l14.94-14.16-7.23-6.44Zm-9,30.73v2.89c0,.62-.5,1.13-1.13,1.13H7.13c-.62,0-1.13-.5-1.13-1.13v-2.89c0-.62,.5-1.13,1.13-1.13h31.19c.62,0,1.13,.5,1.13,1.13Zm-13.67,15.35H6.25v-5.14H25.78v5.14Z" />
	</svg>
);

const priceFormula = (
	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 66 66">
		<path d="M20.7,22.99l-1.5,1.7,.15,1.26h3.87c-.3,3.96-1.38,8.09-2.52,14.45-1.36,8.12-2.13,10.11-2.6,10.84-.41,.72-.99,1.92-1.78,1.92-.16,0-2.44-1.52-3.28-2.3-.3-.21-.26-.15-1.04,.1-.76,.64-1.5,1.63-1.5,2.52,.66,1.2,1.55,2.24,3.08,2.24,1.35,0,3.32-.84,5.41-2.83,2.85-2.7,4.98-6.41,6.76-14.43,1.15-4.3,2.29-8.45,2.49-12.48l4.81-1.09,1.04-1.91h-5.42c1.4-8.82,2.49-10.12,3.84-10.12s2.71,.69,3.13,2.04c.35,.49,.89,1.08,1.29,.1,.68-.41,1.52-1.45,1.58-2.4,.04-1.04-1.2-2.34-3.34-2.34-1.94,0-4.9,1.29-7.39,3.84-2.19,2.32-2.55,5.76-4.12,8.87h-2.97Zm15.39,5.9c1.49-1.99,2.39-2.65,2.85-2.65,.96,0,.86,.47,1.67,3.91l1.4,3.71c-2.7,4.14-4.68,6.85-5.88,6.85-.4,0-.8-.54-1.09-.82-.28-.28,.22-.51-.89-.51-.99,0-2.22,1.2-2.24,2.69-.02,1.52,1.04,2.61,2.44,2.61,2.4,0,4.43-1.72,8.34-8.6l1.15,3.87c.98,3.43,2.13,4.74,4.09,4.74,1.27,0,3.66-1.52,6.27-5.63l-1.09-1.25c-1.57,1.89-2.61,2.78-3.23,2.78-.69,0-1.29-1.05-2.08-3.63l-1.67-5.45c.99-1.46,1.97-2.69,2.82-3.67,1.02-1.17,1.81-1.66,2.34-1.66,.45,0,.84,1.07,1.24,.46,.17,.36,.36,.52,.74,.52,.86,0,2.19-1.09,2.24-2.54,.04-1.35-.79-2.49-2.24-2.49-2.19,0-4.12,1.89-7.12,7.41l-1.47-2.37c-1.07-3.33-1.78-5.04-2.92-5.04-2.09,0-4.47,2.14-6.81,5.53l1.15,1.25h0Z" />
	</svg>
);

const radio = (
	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 66 66">
		<path d="M33,53c-11.05,0-20-8.95-20-20S21.95,13,33,13s20,8.95,20,20-8.95,20-20,20Zm0-36.67c-9.2,0-16.67,7.46-16.67,16.67s7.46,17.09,16.67,17.09,16.67-7.89,16.67-17.09-7.46-16.67-16.67-16.67Zm.01,27.25c-5.52,0-9.99-4.47-9.99-9.74,0-5.77,4.48-9.61,9.99-9.61s10,3.84,10,9.61c0,5.27-4.48,9.74-10,9.74Z" />
	</svg>
);

const textInput = (
	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 66 66">
		<path d="M59.27,26.04l-15.76,15.79c-.36,.36-.8,.58-1.26,.68,.14,.39,.17,.75-.4,.77,.15,.03-10.67,.62-10.8,.67-1.31,.03-1.95-.62-1.92-.76,.03-1.06,.62-11.28,.67-12.01,.03-.4,.4-.56,.82-.38,.09-.46,.27-.9,.78-1.25l15.6-15.79c.97-.97,2.53-.97,3.5,0l8.75,8.77c.97,.97,.97,2.54,0,3.51Zm-10.83-7.82l-13.77,14.16v6.44h6.05l14.15-13.86-6.43-6.73Zm-9,30.73v3.65c0-.14-.5,.37-.73,.37H7.13c-.62,0-1.13-.5-1.13-.37v-3.65c0-.62,.5-.41,1.13-.41h31.59c.22,0,.73-.21,.73,.41Z" />
	</svg>
);

const textLabels = (
	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 66 66">
		<path d="M13.17,9.16h14.46c.88,.04,1.8,.08,2.59,.53,.76,.43,1.36,1.07,1.98,1.67l23.3,23.3c.87,.86,1.36,2.04,1.5,3.25v.99c-.11,.85-.35,1.7-.83,2.43-.34,.55-.83,.98-1.28,1.44l-12.24,12.24c-.43,.42-.82,.9-1.36,1.17-1.07,.56-2.32,.71-3.51,.66-.94-.05-1.88-.25-2.7-.73-.44-.26-.78-.66-1.14-1.01-6.54-6.55-13.07-13.12-19.64-19.65-1.29-1.3-2.72-2.47-3.9-3.88-.65-.78-1.25-1.66-1.41-2.68V13.33c.07-.92,.36-1.84,.96-2.56,.78-.96,1.99-1.5,3.22-1.6Zm1.58,3.05c-.84,.13-1.6,.59-2.12,1.26-.44,.59-.64,1.33-.64,2.06v11.25c-.02,.8,.43,1.5,.9,2.11,.94,1.18,2.11,2.13,3.16,3.21,6.55,6.55,13.07,13.11,19.58,19.69,.74,.69,1.81,.87,2.79,.88,1-.03,2.09-.2,2.84-.92l9.76-9.83c.36-.36,.73-.73,.97-1.18,.85-1.53,.6-3.6-.65-4.84L29.99,14.42c-.62-.6-1.19-1.27-1.91-1.75-.81-.54-1.83-.49-2.77-.5H15.94c-.39,0-.79-.02-1.18,.05Z" />
		<path d="M15.81,13.73c1.36-.36,2.89,.4,3.44,1.69,.65,1.36,.05,3.14-1.28,3.84-1.27,.75-3.04,.36-3.88-.84-.87-1.14-.74-2.89,.29-3.88,.39-.39,.89-.67,1.43-.8Zm.26,1.49c-.63,.2-1.06,.78-1.06,1.44-.01,.8,.7,1.51,1.5,1.49,.87,.03,1.63-.82,1.49-1.69-.09-.89-1.08-1.53-1.93-1.24Z" />
		<path d="M26.47,21.69c.35-.35,.71-.71,1.06-1.06l15,15c-.35,.35-.71,.71-1.06,1.06-5-5-10-10-15-15Z" />
		<path d="M23.47,24.69c.35-.35,.71-.71,1.06-1.06l18,18c-.35,.35-.71,.71-1.06,1.06-6-6-12-12-18-18Z" />
		<path d="M20.47,27.69l1.06-1.06c3,3,6,6,9,9-.35,.35-.71,.71-1.06,1.06-3-3-6-6-9-9Z" />
	</svg>
);

const visualEditor = (
	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 66 66">
		<path d="M57.37,48.62h-16.98c-.62,0-1.12-.5-1.12-1.12v-3.4c0-.62,.5-.88,1.12-.88h16.98c1.2,0,1.12,.26,1.12,.88v3.4c0,.62,.07,1.12-1.12,1.12Zm0-15.1H13.5c-.52,0-1.12,.27-1.12-1.12v-3.23c0-.84,.6-1.34,1.12-1.34H57.37c1.2,0,1.12,.5,1.12,1.34v3.23c0,1.4,.07,1.12-1.12,1.12Zm0-15.14H13.5c-.52,0-1.12-.5-1.12-1.12v-3.4c0-.62,.6-1.12,1.12-1.12H57.37c1.2,0,1.12,.5,1.12,1.12v3.4c0,.62,.07,1.12-1.12,1.12ZM15.68,46.65l14.16-8.05c.92-.52,2.37-.21,2.62,.69l.96,1.64c.98,.9,.22,2.56-.7,2.58l-16.64,9.62c-.5,.11-1.08,.14-1.59-.03-.83,.23-1.74,.44-2.19-.87l-4.8-8.19c.35-.9-.22-1.52,.7-2.58l1.66-.95c.92,.14,2.84-.21,2.62,.69l3.18,5.43Z" />
	</svg>
);

const datePicker = (
	<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 66 66">
		<g transform="scale(0.8, 0.8) translate(9, 13.2)">
			<path d="M59.57,16.65V57.53a4.13,4.13,0,0,1-4.09,4.08h-45A3.89,3.89,0,0,1,7.65,60.4a3.93,3.93,0,0,1-1.22-2.87V16.65a3.92,3.92,0,0,1,1.22-2.87,3.9,3.9,0,0,1,2.87-1.22h4.09V9.5a4.92,4.92,0,0,1,1.5-3.61,4.92,4.92,0,0,1,3.61-1.5h2a4.93,4.93,0,0,1,3.61,1.5,4.92,4.92,0,0,1,1.5,3.61v3.06H39.13V9.5a4.92,4.92,0,0,1,1.5-3.61,4.93,4.93,0,0,1,3.61-1.5h2a4.91,4.91,0,0,1,3.6,1.5,4.92,4.92,0,0,1,1.5,3.61v3.06h4.09a4.15,4.15,0,0,1,4.09,4.09ZM10.52,34h9.2V24.83h-9.2Zm0,12.26h9.2V36.07h-9.2Zm0,11.25h9.2v-9.2h-9.2ZM22.78,18.7V9.5a1,1,0,0,0-1-1h-2a1,1,0,0,0-1,1v9.2a1,1,0,0,0,.31.71,1,1,0,0,0,.72.31h2a1,1,0,0,0,.72-.31A1,1,0,0,0,22.78,18.7ZM21.76,34H32V24.83H21.76Zm0,12.26H32V36.07H21.76Zm0,11.25H32v-9.2H21.76ZM34,34H44.24V24.83H34Zm0,12.26H44.24V36.07H34Zm0,11.25H44.24v-9.2H34ZM47.31,18.7V9.5A1,1,0,0,0,47,8.78a1,1,0,0,0-.71-.3h-2a1,1,0,0,0-1,1v9.2a1,1,0,0,0,.3.71,1,1,0,0,0,.72.31h2a1.06,1.06,0,0,0,1-1ZM46.29,34h9.19V24.83H46.29Zm0,12.26h9.19V36.07H46.29Zm0,11.25h9.19v-9.2H46.29Z" />
		</g>
	</svg>
);

const productSelect = (
	<svg width="32" height="32" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg">
		<path d="M26.8801 9.62007C26.5201 9.15007 25.9701 8.88007 25.3801 8.88007H8.61012L7.87012 5.86007C7.71012 5.20007 7.20012 4.67007 6.55012 4.49007L4.96012 4.03007C4.56012 3.91007 4.15012 4.15007 4.03012 4.54007C3.91012 4.94007 4.14012 5.35007 4.54012 5.47007L6.13012 5.93007C6.27012 5.97007 6.38012 6.08007 6.41012 6.22007L9.59012 19.1901C9.80012 20.0401 10.5601 20.6401 11.4401 20.6401H23.3001C24.1701 20.6401 24.9201 20.0501 25.1401 19.2201L27.2101 11.2701C27.3601 10.7001 27.2401 10.1001 26.8701 9.63007L26.8801 9.62007ZM23.7001 18.8401C23.6501 19.0201 23.4901 19.1401 23.3101 19.1401H11.4401C11.2501 19.1401 11.0901 19.0101 11.0501 18.8301L8.98012 10.3801H25.3801C25.5501 10.3801 25.6501 10.4801 25.7001 10.5401C25.7401 10.6001 25.8101 10.7201 25.7701 10.8901L23.7001 18.8401Z" fill="black"/>
		<path d="M19.2401 14.05H17.9401V12.75C17.9401 12.34 17.6001 12 17.1901 12C16.7801 12 16.4401 12.34 16.4401 12.75V14.05H15.1401C14.7301 14.05 14.3901 14.39 14.3901 14.8C14.3901 15.21 14.7301 15.55 15.1401 15.55H16.4401V16.85C16.4401 17.26 16.7801 17.6 17.1901 17.6C17.6001 17.6 17.9401 17.26 17.9401 16.85V15.55H19.2401C19.6501 15.55 19.9901 15.21 19.9901 14.8C19.9901 14.39 19.6501 14.05 19.2401 14.05Z" fill="black"/>
		<path d="M22.4801 22.6699C21.1401 22.6699 20.0501 23.7499 20.0401 25.0899C20.0301 26.4399 21.1201 27.5499 22.4601 27.5599H22.4801C23.1301 27.5599 23.7401 27.3099 24.2001 26.8499C24.6701 26.3899 24.9301 25.7799 24.9301 25.1399C24.9301 24.4999 24.6801 23.8599 24.2201 23.3899C23.7601 22.9199 23.1401 22.6699 22.4801 22.6699ZM22.5001 26.0899H22.4901C22.2301 26.0899 21.9801 25.9899 21.8001 25.8099C21.6101 25.6199 21.5001 25.3699 21.5101 25.1099C21.5101 24.5699 21.9501 24.1299 22.4801 24.1299C23.0101 24.1299 23.4601 24.5699 23.4701 25.0999C23.4701 25.6299 23.0301 26.0799 22.5001 26.0899Z" fill="black"/>
		<path d="M12.2001 22.6699H12.1901C10.8601 22.6699 9.77008 23.7499 9.76008 25.0899C9.75008 26.4399 10.8401 27.5499 12.1801 27.5599H12.2001C12.8501 27.5599 13.4601 27.3099 13.9201 26.8499C14.3901 26.3899 14.6401 25.7799 14.6501 25.1399C14.6501 24.4799 14.4001 23.8599 13.9301 23.3899C13.4701 22.9199 12.8601 22.6699 12.2001 22.6699ZM13.1801 25.1199C13.1801 25.6399 12.7401 26.0799 12.2201 26.0899H12.2101C11.6801 26.0899 11.2401 25.6699 11.2201 25.1399C11.2201 24.8699 11.3101 24.6199 11.5001 24.4299C11.6901 24.2399 11.9301 24.1299 12.2001 24.1299C12.7401 24.1299 13.1801 24.5699 13.1801 25.0999V25.1199Z" fill="black"/>
	</svg>
);

const spinner = (
<svg width="38" height="38" viewBox="0 0 38 38" xmlns="http://www.w3.org/2000/svg" stroke="#fff">
    <g fill="none" fillRule="evenodd">
        <g transform="translate(1 1)" strokeWidth="2">
            <circle strokeOpacity=".5" cx="18" cy="18" r="18"/>
            <path d="M36 18c0-9.94-8.06-18-18-18">
                <animateTransform
                    attributeName="transform"
                    type="rotate"
                    from="0 18 18"
                    to="360 18 18"
                    dur="1s"
                    repeatCount="indefinite"/>
            </path>
        </g>
    </g>
</svg>
);

const crossX = (
<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" width="20" height="20" className="clear-icon" aria-hidden="true" focusable="false">
	<path d="M12 21C16.9706 21 21 16.9706 21 12C21 7.02944 16.9706 3 12 3C7.02944 3 3 7.02944 3 12C3 16.9706 7.02944 21 12 21ZM15.5303 8.46967C15.8232 8.76256 15.8232 9.23744 15.5303 9.53033L13.0607 12L15.5303 14.4697C15.8232 14.7626 15.8232 15.2374 15.5303 15.5303C15.2374 15.8232 14.7626 15.8232 14.4697 15.5303L12 13.0607L9.53033 15.5303C9.23744 15.8232 8.76256 15.8232 8.46967 15.5303C8.17678 15.2374 8.17678 14.7626 8.46967 14.4697L10.9393 12L8.46967 9.53033C8.17678 9.23744 8.17678 8.76256 8.46967 8.46967C8.76256 8.17678 9.23744 8.17678 9.53033 8.46967L12 10.9393L14.4697 8.46967C14.7626 8.17678 15.2374 8.17678 15.5303 8.46967Z"></path>
</svg>
);

export {
	checkbox,
	colorSwatches,
	customerPrice,
	datePicker,
	dropdown,
	fileUpload,
	html,
	imageButtons,
	number,
	paragraph,
	priceFormula,
	radio,
	textInput,
	textLabels,
	visualEditor,
	productSelect,
	spinner,
	crossX
};
