const Icon = ( { id, color } ) => {
	switch ( id ) {
		case 'import':
			color = color || '#1d2327';

			return (
				<svg width="14" height="16" viewBox="0 0 14 16" fill={ color } xmlns="http://www.w3.org/2000/svg">
					<g clipPath="url(#clip0_2584_945)">
						<path
							d="M3.94034 8.029C3.94034 8.21416 4.01683 8.38711 4.15388 8.51631L7.56836 11.7383C7.59279 11.7617 7.61935 11.7831 7.64697 11.8024C7.67672 11.8237 7.70859 11.8431 7.74153 11.8594C7.78296 11.8807 7.82545 11.897 7.87007 11.9092C7.89132 11.9153 7.91363 11.9214 7.93594 11.9255C8.0358 11.9438 8.13885 11.9418 8.23766 11.9194C8.23766 11.9194 8.23872 11.9204 8.23978 11.9194C8.25359 11.9153 8.26634 11.9123 8.27909 11.9092H8.28015C8.2929 11.9051 8.30565 11.9011 8.3184 11.896H8.31946C8.34602 11.8868 8.37151 11.8756 8.39701 11.8634C8.39807 11.8624 8.39914 11.8614 8.4002 11.8614C8.42038 11.8512 8.44163 11.84 8.46075 11.8278C8.48094 11.8156 8.50006 11.8014 8.51919 11.7871C8.53831 11.7729 8.55637 11.7576 8.57443 11.7413L8.58293 11.7352C8.72104 11.6081 8.79965 11.4361 8.80284 11.253C8.80603 11.0699 8.73485 10.8959 8.60099 10.7637L6.56441 8.74827H12.6497C13.0438 8.74827 13.3647 8.44103 13.3647 8.06359V8.01475C13.3647 7.6363 13.0438 7.32905 12.6497 7.32905H6.63878L8.6403 5.34826C8.77416 5.216 8.84533 5.04203 8.84215 4.85789C8.8379 4.67375 8.75928 4.50182 8.62117 4.37566L8.55637 4.31666C8.27484 4.06028 7.83714 4.06435 7.55986 4.32581L4.15388 7.54067C4.01683 7.67089 3.94034 7.84384 3.94034 8.029Z"
							fill="#3C434A"
						/>
						<path
							d="M7.93592 11.9255C8.03579 11.9448 8.13884 11.9428 8.23764 11.9194C8.13884 11.9418 8.03579 11.9438 7.93592 11.9255Z"
							fill="#3C434A"
						/>
						<path
							d="M12.5403 3.12533V1.4243H1.48839V14.5767H12.5339V12.8798C12.5339 12.4942 12.8622 12.1798 13.2648 12.1798C13.6675 12.1798 13.9958 12.4942 13.9958 12.8798V14.9308C13.9958 15.5198 13.4954 16 12.8803 16H1.1155C0.500379 16 0 15.5198 0 14.9308V1.06924C0 0.480193 0.500379 0 1.1155 0H12.8845C13.4996 0 14 0.480193 14 1.06924V3.12533C14 3.5109 13.6728 3.82527 13.2701 3.82527C12.8675 3.82527 12.5403 3.5109 12.5403 3.12533Z"
							fill="#3C434A"
						/>
					</g>
					<defs>
						<clipPath id="clip0_2584_945">
							<rect width="14" height="16" fill="white" />
						</clipPath>
					</defs>
				</svg>
			);
		case 'export':
			color = color || '#1d2327';

			return (
				<svg width="14" height="16" viewBox="0 0 14 16" fill={ color } xmlns="http://www.w3.org/2000/svg">
					<g clipPath="url(#clip0_2582_479)">
						<path
							d="M13.3647 8.029C13.3647 8.21416 13.2882 8.38711 13.1512 8.51631L9.7367 11.7383C9.71226 11.7617 9.6857 11.7831 9.65808 11.8024C9.62833 11.8237 9.59646 11.8431 9.56353 11.8594C9.5221 11.8807 9.4796 11.897 9.43498 11.9092C9.41373 11.9153 9.39142 11.9214 9.36911 11.9255C9.26925 11.9438 9.1662 11.9418 9.0674 11.9194C9.0674 11.9194 9.06634 11.9204 9.06527 11.9194C9.05146 11.9153 9.03871 11.9123 9.02597 11.9092H9.0249C9.01215 11.9051 8.99941 11.9011 8.98666 11.896H8.9856C8.95904 11.8868 8.93354 11.8756 8.90804 11.8634C8.90698 11.8624 8.90592 11.8614 8.90485 11.8614C8.88467 11.8512 8.86342 11.84 8.8443 11.8278C8.82411 11.8156 8.80499 11.8014 8.78587 11.7871C8.76675 11.7729 8.74869 11.7576 8.73063 11.7413L8.72213 11.7352C8.58402 11.6081 8.5054 11.4361 8.50221 11.253C8.49903 11.0699 8.57021 10.8959 8.70407 10.7637L10.7406 8.74827H4.65535C4.26121 8.74827 3.94037 8.44103 3.94037 8.06359V8.01475C3.94037 7.6363 4.26121 7.32906 4.65535 7.32906H10.6663L8.66476 5.34826C8.5309 5.216 8.45972 5.04203 8.46291 4.85789C8.46716 4.67375 8.54577 4.50182 8.68388 4.37566L8.74869 4.31666C9.03021 4.06028 9.46791 4.06435 9.74519 4.32581L13.1512 7.54067C13.2882 7.67089 13.3647 7.84384 13.3647 8.029Z"
							fill="#3C434A"
						/>
						<path
							d="M9.36913 11.9255C9.26927 11.9448 9.16621 11.9428 9.06741 11.9194C9.16621 11.9418 9.26927 11.9438 9.36913 11.9255Z"
							fill="#3C434A"
						/>
						<path
							d="M12.5403 3.12533V1.4243H1.48839V14.5767H12.5339V12.8798C12.5339 12.4942 12.8622 12.1798 13.2648 12.1798C13.6675 12.1798 13.9958 12.4942 13.9958 12.8798V14.9308C13.9958 15.5198 13.4954 16 12.8803 16H1.1155C0.500379 16 0 15.5198 0 14.9308V1.06924C0 0.480193 0.500379 0 1.1155 0H12.8845C13.4996 0 14 0.480193 14 1.06924V3.12533C14 3.5109 13.6728 3.82527 13.2701 3.82527C12.8675 3.82527 12.5403 3.5109 12.5403 3.12533Z"
							fill="#3C434A"
						/>
					</g>
					<defs>
						<clipPath id="clip0_2582_479">
							<rect width="14" height="16" fill="white" />
						</clipPath>
					</defs>
				</svg>
			);
		case 'warning':
		case 'exclamation':
			color = color || '#ff7f00';

			return (
				<svg
					className="svg-icon"
					viewBox="0 0 1024 1024"
					version="1.1"
					xmlns="http://www.w3.org/2000/svg"
					fill={ color }
				>
					<path d="M565.3 148.3l365.1 669.4c11.1 20 10.8 39.9-1 59.9-5.4 9.2-12.8 16.5-22.1 21.9-9.4 5.4-19.4 8.1-30.2 8.1H146.8c-10.8 0-20.8-2.7-30.2-8.1-9.4-5.4-16.7-12.7-22.1-21.9-11.7-20-12-39.9-1-59.9l365.2-669.5c5.4-9.8 12.8-17.6 22.3-23.3 9.5-5.7 19.8-8.6 30.9-8.6s21.4 2.9 30.9 8.6c9.6 5.8 17.1 13.6 22.5 23.4z m6.6 444.2l8.6-218.2c0-3.8-1.6-6.8-4.8-9-4.1-3.5-7.9-5.2-11.4-5.2H459.7c-3.5 0-7.3 1.7-11.4 5.2-3.2 2.2-4.8 5.5-4.8 10l8.1 217.3c0 3.2 1.6 5.8 4.8 7.8 3.2 2.1 7 3.1 11.4 3.1h88c4.4 0 8.2-1 11.2-3.1 2.9-2.1 4.6-4.9 4.9-7.9z m1 177.8V680c0-4.4-1.5-8.2-4.5-11.2s-6.6-4.5-10.7-4.5h-91.3c-4.1 0-7.7 1.5-10.7 4.5s-4.5 6.7-4.5 11.2v90.3c0 4.4 1.5 8.2 4.5 11.2s6.6 4.5 10.7 4.5h91.3c4.1 0 7.7-1.5 10.7-4.5s4.5-6.8 4.5-11.2z" />
				</svg>
			);
		case 'success':
		case 'checkmark':
			color = color || '#43a047';

			return (
				<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 64 64" fill={ color }>
					<path d="M32,2C15.431,2,2,15.432,2,32c0,16.568,13.432,30,30,30c16.568,0,30-13.432,30-30C62,15.432,48.568,2,32,2z M25.025,50l-0.02-0.02L24.988,50L11,35.6l7.029-7.164l6.977,7.184l21-21.619L53,21.199L25.025,50z"/>
				</svg>
			);
	};
};

export default Icon;