<?php

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

final class WC_Gateway_Order_Proposal_Payment extends AbstractPaymentMethodType {

	protected $name = 'orderproposal';
	protected $gateway;

	public function initialize() {
		$this->settings = get_option( 'woocommerce_' . $this->name . '_settings', array() );
		$gateways       = WC()->payment_gateways->payment_gateways();
		$this->gateway  = $gateways[ $this->name ];
	}

	public function is_active(): bool {
		return $this->gateway->is_available();
	}

	/**
	 * Returns an array of scripts to be enqueued later for this payment method.
	 *
	 * @return string[]
	 */
	public function get_payment_method_script_handles(): array {
		$asset_path = wc_order_proposal()->get_plugin_path() . '/assets/blocks/payment-method.asset.php';

		$dependencies = array();

		if ( file_exists( $asset_path ) ) {
			$asset        = include $asset_path;
			$dependencies = $asset['dependencies'] ?? $dependencies;
		}

		wp_register_script(
			'wpo-wcop-payment',
			wc_order_proposal()->get_plugin_url() . '/assets/blocks/payment-method.js',
			$dependencies,
			WC_Order_Proposal::ORDER_PROPOSAL_VERSION,
			true
		);

		return array( 'wpo-wcop-payment' );
	}

	/**
	 * Returns an array of key => value pairs of data made available to the payment methods script.
	 *
	 * @return array
	 */
	public function get_payment_method_data(): array {
		return array(
			'title'       => $this->get_setting( 'title' ),
			'description' => $this->get_setting( 'description' ),
			'supports'    => $this->get_supported_features(),
		);
	}
}