jQuery( function( $ ) {
	// show/hide fields conditionally
	function wcopDisplaySettingsConditionally() {
		$( "[data-show_for_option_name]" ).each( function( elem ) {
			let option_name = $( this ).data( "show_for_option_name" );
			$( document ).on( "change", "[name='" + option_name + "'], [name='" + option_name + "[]']", toggle_conditional_visibility );
			$( "[name='"+option_name+"'], [name='" + option_name + "[]']" ).trigger( "change" );
		} );
	}

	function toggle_conditional_visibility( event ) {
		let name     = $( this ).prop( 'name' );
		let value    = $( this ).val();
		if ( $( this ).is( ":checkbox" ) ) {
			value = $( this ).is( ":checked" );
		}
		$( "[data-show_for_option_name='" + name + "']" ).each( function( elem ) {
			let show     = false;
			let show_for = $( this ).data( "show_for_option_values" );

			if ( Array.isArray( value ) ) { // Multiselect
				if ( 'any' === show_for ) {
					show = value.length > 0;
				} else {
					$.each( value, function( index, item ) {
						// if one option matches, show
						if ( $.inArray( item, show_for ) !== -1 ) {
							show = true;
						}
					} );
				}
			} else {
				show = value === show_for;
			}

			let $row = $( this ).is( "tr" ) ? $( this ) : $( this ).closest( "tr" );
			if( show ) {
				$row.show();
			} else {
				$row.find( ':input' ).prop( 'checked', false ).trigger( 'change' );
				$row.hide();
			}
		} );
	}

	function initializeSelect2Data( $select2, data ) {
		$.each( data, function( index, user ) {
			$select2.append( new Option( user.text, user.id, true, true ) );
		} );
	}

	let autoAcceptUsersSelect2Args = {
		allowClear:         true,
		placeholder:        $( '#woocommerce_orderproposal_auto_accept_proposal_for_users' ).data( 'placeholder' ),
		minimumInputLength: 2,
		escapeMarkup:       function( m ) {
			return m;
		},
		ajax:               {
			url:            wpo_wcop.ajax_url,
			dataType:       'json',
			delay:          250,
			data:           function( params ) {
				return {
					term:     params.term,
					action:   'wcop_search_users',
					security: wpo_wcop.nonce,
				};
			},
			processResults: function( data ) {
				let terms = [];
				if ( data ) {
					$.each( data, function( id, text ) {
						terms.push( { id: id, text: text } );
					} );
				}
				return {
					results: terms
				};
			},
			cache:          true
		}
	};

	let $autoAcceptUsersSelect2 = $( '#woocommerce_orderproposal_auto_accept_proposal_for_users' );
	initializeSelect2Data( $autoAcceptUsersSelect2, $autoAcceptUsersSelect2.data( 'initial_data' ) || [] );
	$autoAcceptUsersSelect2.select2( autoAcceptUsersSelect2Args );

	wcopDisplaySettingsConditionally();
} );
