<?php
/*
Plugin Name: WooCommerce Bulk Product Editor
Description: WCQPE plugin easily allows to bulk edit already existing products!
Author: پرشین اسکریپت
Version: 2.4
*/


/*
Copyright: WooCommerce Bulk Product Editor uses the ACF PRO plugin. ACF PRO files are not to be used or distributed outside of the WooCommerce Bulk Product Editor plugin.
*/

define('WCQPE_PLUGIN_PATH', rtrim(plugin_dir_url(__FILE__), "/") );
define('WCQPE_PLUGIN_ABS_PATH', plugin_dir_path( __FILE__ ) );
define('WCQPE_PLUGIN_LANG_PATH', basename( dirname( __FILE__ ) ) . '/languages' ) ;

if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ||
     (is_multisite() && array_key_exists( 'woocommerce/woocommerce.php', get_site_option('active_sitewide_plugins') ))
	)
{
	
	
	//com
	//include_once( "classes/com/WCQPE_Acf.php");
	include_once( "classes/com/WCQPE_Global.php");

	if(!class_exists('WCQPE_Wpml'))
	{	require_once('classes/com/WCQPE_Wpml.php');
		$wcqpe_wpml_helper = new WCQPE_Wpml();
	}
	if(!class_exists('WCQPE_Product'))
	{	require_once('classes/com/WCQPE_Product.php');
		$wcqpe_product_model = new WCQPE_Product();
	}
	
	//admin
	if(!class_exists('WCQPE_QuckEditor'))
	{	require_once('classes/admin/WCQPE_QuckEditor.php');
		$wcqpe_quick_editor = new WCQPE_QuckEditor();
	}

	//frontend
	

	add_action('admin_menu', 'init_wcqpe_admin_panel');
	add_action('init', 'wcqpe_init');

}
function wcqpe_init()
{
	load_plugin_textdomain('woocommerce-quick-product-editor', false, basename( dirname( __FILE__ ) ) . '/languages' );
}
function wcqpe_get_free_menu_position($start, $increment = 0.1)
{
	foreach ($GLOBALS['menu'] as $key => $menu) {
		$menus_positions[] = $key;
	}

	if (!in_array($start, $menus_positions)) return $start;

	/* the position is already reserved find the closet one */
	while (in_array($start, $menus_positions))
	{
		$start += $increment;
	}
	return $start;
}
function init_wcqpe_admin_panel()
{
	if(!current_user_can('manage_woocommerce'))
		return;
	
	global $wcqpe_quick_editor;
	$place = wcqpe_get_free_menu_position(54, 0.5);

	//add_menu_page( __( 'Shipping tracking', 'woocommerce' ), __( 'Shipping tracking', 'woocommerce' ), 'manage_woocommerce', 'wcst-shipping-tracking', null, WCQPE_PLUGIN_PATH."/img/menu-icon.png", (string)$place );
	$wcqpe_quick_editor->add_page();
	//remove_submenu_page( 'wcst-shipping-tracking', 'wcst-shipping-tracking');
}

function wcqpe_var_dump($var)
{
	echo "<pre>";
	var_dump($var);
	echo "</pre>";
}
?>