var wcqpe_chunk = 20;
var wcqpe_formData;
var wcqpe_total_ids_to_update = 0;
var wcqpe_ids_updated = 0;
var wcqpe_ids_to_update;
jQuery(document).ready(function()
{
	wcqpe_init_product_select2();
	wcqpe_init_category_select2();
	wcqpe_init_taxonomies_select2();
	wcqpe_init_datetime_selectors();
	
	jQuery(document).on('change', '#manage_stock', wcqpe_manage_stock_constrollers);
	jQuery(document).on('change', '.manage_element_display_on_selection', wcqpe_manage_elements_to_show_on_apply_policy_change);
	jQuery(document).on('submit', '#post', wcqpe_on_submit_data);
	wcqpe_init_controllers();
	wcqpe_init_load_values_from_product(); //admin-load-values-from-product.js
});
function wcqpe_init_controllers()
{
	jQuery('#manage_stock').trigger('change');
	jQuery('.wcqpe_sale_date_policy_selector').trigger('change');
	jQuery('.manage_element_display_on_selection').trigger('change');
	
	//Drag & Resize
	jQuery(".wcqpe_sortable").sortable({
		containment: "parent",
		handle: "h3",
		placeholder: 'drag_placeholder',
		forcePlaceholderSize: true,
		opacity: 0.4,
	});
	//jQuery(".wcqpe_sortable").children().resizable();
}
function wcqpe_manage_elements_to_show_on_apply_policy_change(event)
{
	var selected_val = jQuery(event.currentTarget).val();
	var elem = "#"+jQuery(event.currentTarget).data('element');
	switch(selected_val)
	{
		case 'leave_unchanged': jQuery(elem).fadeOut(); break;
		case 'set_new': jQuery(elem).fadeIn(); break;
	}
}
function wcqpe_manage_stock_constrollers(event)
{
	var selected_val = jQuery(event.currentTarget).val();
	switch(selected_val)
	{
		case 'leave_unchanged': jQuery('#enabled_stock_controllers_container, #disabled_stock_controllers_container').fadeOut(); break;
		case 'true': jQuery('#enabled_stock_controllers_container').delay(400).fadeIn();  jQuery('#disabled_stock_controllers_container').fadeOut(); break;
		case 'false': jQuery('#disabled_stock_controllers_container').delay(400).fadeIn(); jQuery('#enabled_stock_controllers_container').fadeOut();break;
	}
}
function wcqpe_on_submit_data(event)
{
	event.preventDefault();
	 
	 var form = jQuery(event.currentTarget);
	/*var form2 = jQuery(this);
	var formData = jQuery(event.currentTarget).serialize(); */
	wcqpe_formData = new FormData(form[0]);
	//var test2 = new FormData(form2[0]);
	
	//Validation
	if(jQuery('#product_id').val() == null && jQuery('#category_id').val() == null)
	{
		jQuery('#wcqpe_product_selection_error_message').fadeIn();
		return false;
	}
	
	jQuery('#wcqpe_product_selection_error_message').fadeOut();
	
	//console.log(event);
	/* for(var pair of wcqpe_formData.entries()) 
		console.log(pair[0]+ ': '+ pair[1]);  */
	
	wcqpe_retrieve_product_ids();
	return false;
}
function wcqpe_reset_save_progress_data(data)
{
	wcqpe_ids_to_update = JSON.parse(data);
	wcqpe_total_ids_to_update = wcqpe_ids_to_update.length;
	wcqpe_ids_updated = 0;
}
//Save process 
// Step 1: send product and categories id 
// Step 2: once received product ids, send chunk by chunk the info
function wcqpe_retrieve_product_ids()
{
	var product_id = wcqpe_formData.getAll('product_id[]');
	var category_id = wcqpe_formData.getAll('category_id[]');
	var product_apply_policy = wcqpe_formData.get('product_apply_policy');
	var children_category_apply_policy = wcqpe_formData.get('children_category_apply_policy');
	var variation_apply_policy = wcqpe_formData.get('variation_apply_policy');
	
	/* console.log(product_id);
	console.log(category_id);
	console.log(product_apply_policy);
	console.log(children_category_apply_policy); */
	
	var  formData = new FormData();
	formData.append('action', 'wcqpe_retrieve_product_ids_to_update');
	formData.append('product_id[]', product_id);
	formData.append('category_id[]', category_id);
	formData.append('product_apply_policy', product_apply_policy);
	formData.append('children_category_apply_policy', children_category_apply_policy);
	formData.append('variation_apply_policy', variation_apply_policy);
	
	//UI 
	wcqpe_show_save_progress_ui();
	
	jQuery.ajax({
		url: ajaxurl,
		type: 'POST',
		data: formData,
		async: true,
		success: function (data) 
		{
			
			wcqpe_reset_save_progress_data(data);
			
			//UI
			wcqpe_update_product_ids();
		},
		error: function (data) 
		{
			//console.log(data);
			alert("Error: "+data);
		},
		cache: false,
		contentType: false,
		processData: false
	}); 
}
function wcqpe_update_product_ids()
{
	wcqpe_formData.set('action', 'wcqpe_update_product_ids');
	//wcqpe_formData.set('product_id', wcqpe_ids_to_update.slice(wcqpe_ids_updated, wcqpe_chunk));
	if(wcqpe_total_ids_to_update - wcqpe_ids_updated >= wcqpe_chunk)
		wcqpe_formData.set('product_id', wcqpe_ids_to_update.slice(wcqpe_ids_updated, wcqpe_ids_updated+wcqpe_chunk));
	else 
		wcqpe_formData.set('product_id', wcqpe_ids_to_update.slice(wcqpe_ids_updated)); 
	
	jQuery.ajax({
		url: ajaxurl,
		type: 'POST',
		data: wcqpe_formData,
		async: true,
		success: function (data) 
		{
			wcqpe_ids_updated += wcqpe_chunk;
			if(wcqpe_ids_updated < wcqpe_total_ids_to_update)
			{
				//UI
				wcqpe_set_progress_ui((wcqpe_ids_updated/wcqpe_total_ids_to_update)*100);
				wcqpe_update_product_ids();
			}
			else 
			{
				wcqpe_set_progress_ui(100);
				wcqpe_end_save_progress_ui();
				//Done!
			}
		},
		error: function (data) 
		{
			if(wcqpe_chunk != 0)
			{
				wcqpe_chunk--;
				wcqpe_update_product_ids();
			}
			else 
				alert("Error: "+data);
		},
		cache: false,
		contentType: false,
		processData: false
	}); 
}

//UI
function wcqpe_show_save_progress_ui()
{
	jQuery('#wcqpe_progress_status').html("").fadeOut(0);
	jQuery('#wcqpe_bar').css('width', "0%");
	jQuery('#wcqpe_progress_percent').html("0%");
	jQuery('#wcqpe_progress_info_container').fadeIn();
	
	jQuery('#submit').fadeOut(0);
	
} 
function wcqpe_set_progress_ui(perc)
{
	jQuery('#wcqpe_bar').animate({'width': perc+"%"}, 500);
	jQuery('#wcqpe_progress_percent').html(Math.round(perc)+"%");
}
function wcqpe_end_save_progress_ui()
{
	jQuery('#wcqpe_progress_status').html(wcqpe_options.done_message).delay(500).fadeIn();
	jQuery('#wcqpe_progress_info_container').delay(2500).fadeOut();
	jQuery('#submit').delay(3000).fadeIn();
}