function wcqpe_init_load_values_from_product()
{
	jQuery(document).on('click', '#load_from_product_button', wcqpe_load_values_from_product)
}
function wcqpe_load_values_from_product(event)
{
	event.preventDefault();
	event.stopImmediatePropagation();
	
	//UI
	jQuery('#wcqpe_load_product_values_status').html("");
	
	var product_id = jQuery('#load_product_id').val();
	var load_name_description_policy = jQuery('#load_name_description_policy').val();
	if(!jQuery.isNumeric( product_id ))
	{
		//UI
		jQuery('#wcqpe_load_product_values_status').html(wcqpe_options.no_product_selected_message);
		jQuery('#wcqpe_load_product_values_status').fadeIn()/* .delay(2000).fadeOut() */;
		return;
	}
	
	//UI
	jQuery('#load_from_product_button').fadeOut(0);
	jQuery('#wcqpe_load_product_values_status').html(wcqpe_options.loading_message);
	jQuery('#wcqpe_load_product_values_status').fadeIn();
	
	var  formData = new FormData();
	formData.append('action', 'wcqpe_retrieve_product_values');
	formData.append('product_id', product_id);
	formData.append('load_name_description_policy', load_name_description_policy);
	
	jQuery.ajax({
		url: ajaxurl,
		type: 'POST',
		data: formData,
		async: true,
		success: wcqpe_on_product_values_loaded,
		error: function (data) 
		{
			//console.log(data);
		},
		cache: false,
		contentType: false,
		processData: false
	}); 
	
	return false;
}
function wcqpe_on_product_values_loaded(data)
{
	if(data == 'no')
	{
		//UI
		jQuery('#wcqpe_load_product_values_status').html(wcqpe_options.product_invalid_message);
		jQuery('#load_from_product_button').fadeIn();
		return;
	}
	
	var loaded_values = JSON.parse(data);
	
	//UI
	jQuery('#wcqpe_load_product_values_status').html("");
	jQuery('#load_from_product_button').fadeIn();
	
	for(var value_key in loaded_values)
	{
		if(loaded_values[value_key] == 'ignore_this_value')
			 continue;
		
		var skip_element = false;
		
		//console.log(value_key+": "+loaded_values[value_key]);
		var elem = document.getElementsByName("wcqpe_data["+value_key+"][value]");
		var elem_policy_applier = document.getElementsByName("wcqpe_data["+value_key+"][apply_policy]");
		
		if(value_key == 'category_ids' || value_key == 'tag_ids') //Taxonomy selector
		{
			wcqpe_init_taxonomies_select2_and_set_val("#taxonomy_"+value_key, loaded_values[value_key]);
		}
		else if(elem.length != 0) //Other input slectors
		{
			var current_value = loaded_values[value_key] == true || loaded_values[value_key] == false ? loaded_values[value_key].toString() : loaded_values[value_key];
			//console.log(elem[0].tagName.toLowerCase()); //type
			if(elem[0].tagName.toLowerCase() == 'select')
			{
				for (i = 0; i < elem[0].options.length; ++i)
					if (elem[0].options[i].value == current_value)
						elem[0].value = current_value;
			}
			else if(elem[0].tagName.toLowerCase() == 'textarea')
			{
				//console.log(value_key+": "+current_value);
				//tinymce.get(value_key).setContent(current_value);
				jQuery('#'+value_key).val(current_value);
				//jQuery('#'+value_key).is(':visible') ? jQuery('#'+value_key).val(current_value) : tinymce.get(value_key).setContent(current_value);
			}
			else if(value_key == 'image_id') //image slector
			{
				if(loaded_values['image_id_url'] != false)
					wcqpe_set_image(current_value, loaded_values['image_id_url']);
				else
				{
					skip_element = true;
					wcqpe_remove_image(null);
				}
			}
			else if(value_key == 'date_on_sale_to' || value_key == 'date_on_sale_from') 
			{
				if(current_value == null)
				{
					skip_element = true;
					elem[0].value = "";
				}
				else 
				{ 
					var date_elem = current_value.date.split(" ");
					elem[0].value = date_elem[0];
				}
			}
			else //Text and number
				elem[0].value = current_value;
			
		}
		
		if(elem_policy_applier.length != 0)
			elem_policy_applier[0].value = !skip_element ? 'set_new' : 'leave_unchanged';
		/* if(!skip_element && elem_policy_applier.length != 0)
		{
			elem_policy_applier[0].value = 'set_new';
		} */
		
		wcqpe_init_controllers();
	}
}