/* jQuery(function($){

  // Set all variables to be used in scope
  var frame,
      metaBox = $('#meta-box-id.postbox'), // Your meta box id here
      addImgLink = metaBox.find('.upload-custom-img'),
      delImgLink = metaBox.find( '.delete-custom-img'),
      imgContainer = metaBox.find( '.custom-img-container'),
      imgIdInput = metaBox.find( '.custom-img-id' );
  
  // ADD IMAGE LINK
  addImgLink.on( 'click', function( event ){
    
    event.preventDefault();
    
    // If the media frame already exists, reopen it.
    if ( frame ) {
      frame.open();
      return;
    }
    
    // Create a new media frame
    //frame = wp.media({
    frame = wp.media.frames.file_frame({
      title: 'Select or Upload Media Of Your Chosen Persuasion',
      button: {
        text: 'Use this media'
      },
      multiple: false  // Set to true to allow multiple files to be selected
    });

    
    // When an image is selected in the media frame...
    frame.on( 'select', function() {
      
      // Get media attachment details from the frame state
      var attachment = frame.state().get('selection').first().toJSON();

      // Send the attachment URL to our custom image input field.
      imgContainer.append( '<img src="'+attachment.url+'" alt="" style="max-width:100%;"/>' );

      // Send the attachment id to our hidden input
      imgIdInput.val( attachment.id );

      // Hide the add image link
      addImgLink.addClass( 'hidden' );

      // Unhide the remove image link
      delImgLink.removeClass( 'hidden' );
    });

    // Finally, open the modal on click
    frame.open();
  });
  
  
  // DELETE IMAGE LINK
  delImgLink.on( 'click', function( event ){

    event.preventDefault();

    // Clear out the preview image
    imgContainer.html( '' );

    // Un-hide the add image link
    addImgLink.removeClass( 'hidden' );

    // Hide the delete image link
    delImgLink.addClass( 'hidden' );

    // Delete the image id from the hidden input
    imgIdInput.val( '' );

  });

});  */

jQuery(document).ready(function()
{
  //var current_index = 0;
  //var curr_id;
  jQuery(document).on('click', '#upload-custom-img', wcqpe_load_image_selector);
  jQuery(document).on('click', '#delete-custom-img', wcqpe_remove_image);
}); 

function wcqpe_load_image_selector(event)
{
	var file_frame; 
	var file_frame_watermark; 
  
	//curr_id = jQuery(this).data('id');
    event.preventDefault();

    // If the media frame already exists, reopen it.
    if ( file_frame ) {
      file_frame.open();
      return;
    }

    // Create the media frame.
    file_frame = wp.media.frames.file_frame = wp.media({
      title: jQuery( this ).data( 'uploader_title' ),
      button: {
        text: jQuery( this ).data( 'uploader_button_text' ),
      },
	  library : {
                   type : 'image',
	  },
      multiple: false  // Set to true to allow multiple files to be selected
    });

    file_frame.on( 'select', function() 
	{
		var selection = file_frame.state().get('selection');
	 	selection.map( function( attachment ) 
		{
		  attachment = attachment.toJSON();
		  wcqpe_set_image(attachment.id, attachment.url);
		  //current_index++;
		});
    });
    file_frame.open();
	
	return false;
}
function wcqpe_set_image(id, url)
{
	jQuery('#wcqpe-product-image').attr('src', url);
	jQuery('#product_image_id').val(id);
	jQuery('#delete-custom-img').removeClass('hidden');
}
function wcqpe_remove_image(event)
{
	if(event!=null)
		event.preventDefault();
	jQuery('#wcqpe-product-image').attr('src', wcqpe_options.placeholder_path);
	jQuery('#product_image_id').val("");
	jQuery('#delete-custom-img').toggleClass('hidden');
	
	return false;
}