<?php 
class WCQPE_Product
{
	var $value_managed = array('image_id', 'name', 'slug', 'regular_price', 'sale_price', 'virtual', 'status', 'catalog_visibility', 'featured', 'tax_status', 'tax_class', 'sku',
								'sold_individually', 'manage_stock', 'stock_status', 'stock_quantity', 'backorders', 'weight', 'length', 'width', 'height', 'date_on_sale_from', 'date_on_sale_to',
								'tag_ids', 'category_ids', 'shipping_class_id', 'description', 'short_description');
	
	var $properties_for_which_empty_value_erases_previous = array('image_id', 'description', 'short_description', 'category_ids','tag_ids', 'date_on_sale_from', 'date_on_sale_to');
	var $field_to_not_eventually_loaded_via_ajax = array('name', 'slug', 'description', 'short_description');
	
	public function __construct()
	{
		add_action('wp_ajax_wcqpe_get_product_list', array(&$this, 'ajax_load_product_list'));
		add_action('wp_ajax_wcqpe_get_category_list', array(&$this, 'ajax_load_category_list'));
		//save process
		add_action('wp_ajax_wcqpe_retrieve_product_ids_to_update', array(&$this, 'ajax_retrieve_product_ids_to_update'));
		add_action('wp_ajax_wcqpe_update_product_ids', array(&$this, 'ajax_update_product_ids'));
		add_action('wp_ajax_wcqpe_retrieve_product_values', array(&$this, 'ajax_retrieve_product_values'));
	}
	public function get_managed_values()
	{
		return $this->value_managed;
	}
	public function ajax_load_category_list()
	{
		$product_categories = $this->get_product_category_list($_GET['product_category']);
		echo json_encode( $product_categories);
		wp_die();
	}
	public function ajax_load_product_list()
	{
		$resultCount = 50;
		$search_string = isset($_GET['search_string']) ? $_GET['search_string'] : null;
		$page = isset($_GET['page']) ? $_GET['page'] : null;
		$offset = isset($page) ? ($page - 1) * $resultCount : null;
		$product_list = $this->get_product_list($search_string ,$offset, $resultCount);
		echo json_encode( $product_list); 
		wp_die();
	}
	public function ajax_retrieve_product_ids_to_update()
	{
		$product_ids = isset($_POST['product_id']) && $_POST['product_id'] != "" ? array_filter($_POST['product_id']) : array();
		$category_ids = isset($_POST['category_id'])  && $_POST['product_id'] != "" ? array_filter($_POST['category_id'] ): array();
		$variation_apply_policy = isset($_POST['variation_apply_policy']) ? $_POST['variation_apply_policy'] : 'variations_only'; //variations_only || master_product || master_and_variations
		$product_apply_policy = isset($_POST['product_apply_policy']) ? $_POST['product_apply_policy'] : 'selected'; //selected || except
		$children_category_apply_policy = isset($_POST['children_category_apply_policy']) ? $_POST['children_category_apply_policy'] : 'selected_only'; //selected_only || selected_and_children
		
		$products_from_cat = !empty($category_ids) ? $this->get_post_ids_using_categories('product_cat', $category_ids, $children_category_apply_policy, $product_apply_policy) : array();
		$products = $product_apply_policy == 'selected' ? $product_ids : $this->get_complementary_ids($product_ids, $variation_apply_policy);
		
		echo json_encode(array_merge($products, $products_from_cat));
		
		wp_die();
	}
	public function ajax_update_product_ids()
	{
		$properties_for_which_empty_value_erases_previous = $this->properties_for_which_empty_value_erases_previous;
		if(!isset($_POST['product_id']) || !isset($_POST['wcqpe_data']))
			wp_die();
		
		$product_ids = explode(",", $_POST['product_id']);
		$variation_apply_policy = isset($_POST['variation_apply_policy']) ? $_POST['variation_apply_policy'] : 'variations_only'; //variations_only || master_product || master_and_variations
		$additional_product_ids = array();
		//wcqpe_var_dump($product_ids);
		
		if($variation_apply_policy != 'master_product')
			foreach($product_ids as $product_index => $product_id)
			{
				$product = wc_get_product($product_id);
				if( $product->is_type('variable'))
				{
					$additional_product_ids = array_merge($additional_product_ids, $product->get_children());
				
					if($variation_apply_policy == 'variations_only')
						unset($product_ids[$product_index]);
				}
			}
		//wcqpe_var_dump($additional_product_ids);
		$product_ids =  array_unique (array_merge($additional_product_ids, $product_ids));
		
		//wcqpe_var_dump($_POST['wcqpe_data']);
		//wcqpe_var_dump($product_ids);
		//wcqpe_var_dump("****");
		foreach($product_ids as $product_id)
		{
			//wcqpe_var_dump($product_id);
			$product = wc_get_product($product_id);
			//wcqpe_var_dump($product->get_name());
			if($product == false || !isset($product))
				continue;
			
		
			foreach($_POST['wcqpe_data'] as $property_name => $data)
			{
				//wcqpe_var_dump($property_name);
				if((isset($data["apply_policy"]) && $data["apply_policy"] == 'leave_unchanged') || $data["value"] == "leave_unchanged")
					continue;
				
				//Skip assignment for "empty" values
				if( (!in_array($property_name, $properties_for_which_empty_value_erases_previous)) && //Only for these special fields, if value is empty, the old value will be removed
					$data["value"] == "")
					continue;
				
				if($data["value"] == 'false' || $data["value"] == 'true')
					$data["value"] = $data["value"] == 'true';
				
				try
				{
					if(isset($data["apply_policy"]) && ($data["apply_policy"] != 'set_new'))
					{
						$old_val = $product->{"get_".$property_name}();
						switch($data["apply_policy"])
						{
							case 'increase_by_val': $data["value"] += $old_val; $data["value"] = $data["value"] < 0 ? 0 : $data["value"]; break;
							case 'decrease_by_val': $data["value"] = $old_val - $data["value"]; $data["value"] = $data["value"] < 0 ? 0 : $data["value"];  break;
							case 'increase_by_perc': $data["value"] = $old_val + (($old_val*$data["value"])/100); $data["value"] = $data["value"] < 0 ? 0 : $data["value"];  break;
							case 'decrease_by_perc': $data["value"] = $old_val - (($old_val*$data["value"])/100); $data["value"] = $data["value"] < 0 ? 0 : $data["value"];  break;
							case 'delete_existing': $data["value"] = "";  break;
						}
						
					}
					/* wcqpe_var_dump("set_".$property_name);*/
					
					if(method_exists($product, "set_".$property_name))
					{
						/* if("set_".$property_name == 'set_date_on_sale_from' || "set_".$property_name == 'set_date_on_sale_to')
						wcqpe_var_dump($data["value"]);   */
					
						if($property_name == 'sale_price')
							$data["value"] = $data["value"] < 0 ? "" : $data["value"];
						
						if($product->is_type('variation') && $property_name == 'status')
						{
							if($data["value"] == 'draft' || $data["value"] == 'pending' )
								$data["value"] = 'private';
						}
						
						$product->{"set_".$property_name}($data["value"]);
						$product->save();
						//wcqpe_var_dump("ok");
					}
				}catch (Exception $e){wcqpe_var_dump($e);};
			}
		}
		
		wp_die();
	}
	public function ajax_retrieve_product_values()
	{
		$field_to_not_eventually_load = $this->field_to_not_eventually_loaded_via_ajax;
		
		$product = isset($_POST['product_id']) ? wc_get_product($_POST['product_id']) : false;
		$load_name_description_policy = isset($_POST['load_name_description_policy']) ? $_POST['load_name_description_policy'] : 'not_load';
		$result = array();
		if(!isset($product) || $product == false)
		{
			echo "no";
			wp_die();
		}
		foreach($this->get_managed_values() as $value)
		{
			if($load_name_description_policy == 'not_load' && in_array($value, $field_to_not_eventually_load))
			{
				$result[$value] = "ignore_this_value";
			}
			else
			{
				$result[$value] = $product->{"get_".$value}();
				
				if("get_".$value == 'get_image_id')
				{
					$result["image_id_url"] = wp_get_attachment_url($result[$value]); //wp_get_attachment_image_src($result[$value], 'medium');
				}
			}
		}
		//echo json_encode((array)$product);
		echo json_encode($result);
		wp_die();
	}
	private function get_complementary_ids($product_ids, $variation_apply_policy, $category = '')
	{
		global $wcqpe_wpml_helper;
		$result = array();
		if(!isset($product_ids) || empty($product_ids))
			return $result;
		
		//Retrieves only main language ids
		$wcqpe_wpml_helper->switch_to_default_language();
		$args = array('exclude' => $product_ids, 
					  'suppress_filters' => false, //default: true.
					  'category'         => $category,
					  'post_type' => array('product' , 'product_variation' ),
					  'numberposts' => -1,
					  'fields' => 'ids',
					  'post_status' => $this->get_product_statuses_for_query() //add others? as option? -> get_post_statuses();
					  
						);
		$result = get_posts($args);
		//wcqpe_var_dump($result);
		return $result;
	}	
	private function get_post_ids_using_categories($category_type_name, $selected_categories, $get_post_belonging_to_children_categories, $strategy)
	{
		//$get_post_belonging_to_children_categories : "selected_only" || "selected_and_children"
		
		global $wpdb, $wcqpe_wpml_helper;
		$not_suffix = $strategy == "selected" ? "  " : " NOT ";
		$results = $additional_categories_ids = array();
		$wcqpe_wpml_helper->switch_to_default_language();
		
		//Retrieve children categories id
		if($get_post_belonging_to_children_categories == 'selected_and_children')
		{
			foreach($selected_categories as $current_category)
			{
				$args = array(
						'type'                     => 'product',
						'child_of'                 => $current_category,
						'parent'                   => '',
						'orderby'                  => 'name',
						'order'                    => 'ASC',
						'hide_empty'               => 1,
						'hierarchical'             => 1,
						'exclude'                  => '',
						'include'                  => '',
						'number'                   => '',
						'taxonomy'                 => $category_type_name,
						'pad_counts'               => false,
						'suppress_filters' => false
						/* 'suppress_filter' 		   => false */

					); 

					$categories = get_categories( $args );
					//wctbp_var_dump($categories);
					foreach($categories as $result)
					{
						if(!is_array($result))
							$additional_categories_ids[] = (int)$result->term_id;
					}
			}
		}
		if(!empty($additional_categories_ids))
			$selected_categories = array_merge($selected_categories, $additional_categories_ids);
		
		/* //GROUP_CONCAT(posts.ID)
		$wpdb->query('SET group_concat_max_len=5000000'); 
		$wpdb->query('SET SQL_BIG_SELECTS=1');
		$query = "SELECT DISTINCT posts.ID
				 FROM {$wpdb->posts} AS posts 
				 INNER JOIN {$wpdb->term_relationships} AS term_rel ON term_rel.object_id = posts.ID
				 INNER JOIN {$wpdb->term_taxonomy} AS term_tax ON term_tax.term_taxonomy_id = term_rel.term_taxonomy_id 
				 INNER JOIN {$wpdb->terms} AS terms ON terms.term_id = term_tax.term_id
				 WHERE  terms.term_id {$not_suffix} IN ('" . implode( "','", $selected_categories). "')  
				 AND term_tax.taxonomy = '{$category_type_name}' "; 
		$ids = $wpdb->get_results($query, ARRAY_A);
	
		foreach($ids as $id)
			$results[] = $id['ID'];
		return $results; */
		
		//Get products
		$args = array('suppress_filters' => false, //default: true.
					  'post_type' => array('product'), //product_variation have not category associated
					  'numberposts' => -1,
					  'fields' => 'ids',
					  'post_status' => $this->get_product_statuses_for_query(), //add others? as option? -> get_post_statuses();
					  'tax_query'             => array(
													array(
														'taxonomy'      => 'product_cat',
														'terms'         => $selected_categories,
														'field'         => 'id',
														'operator'      => 'IN'
														)
										  
												)
					);
		$products = get_posts($args);
		
		//Get variations (if any)
		$variations = array();
		if(!empty($products))
		{
			$args = array('suppress_filters' => false, //default: true.
						  'post_type' => array('product', 'product_variation'),
						  'numberposts' => -1,
						  'fields' => 'ids',
						  'post_parent__in' => $products,
						  'post_status' => $this->get_product_statuses_for_query()
						 );
			$variations = get_posts($args);
		}
		
		//Get complementary 
		if($strategy != 'selected')
		{
			$args = array('suppress_filters' => false, 
					  'post_type' => array('product', 'product_variation'), 
					  'numberposts' => -1,
					  'fields' => 'ids',
					  'post_status' => $this->get_product_statuses_for_query(), 
					  'post__not_in' => $products
					);
			$products = get_posts($args);
		
		}
		
		
		//wcqpe_var_dump($variations);
		return array_merge($products, $variations);
	}
	private function get_product_statuses_for_query()
	{
		return array('publish', 'draft');
	}
	function get_product_list($search_string ,$offset, $resultCount)
	{
		global $wpdb, $wcqpe_wpml_helper;
		 $query_select_string = "SELECT products.ID as id, products.post_parent as product_parent, products.post_title as product_name, product_meta.meta_value as product_sku";
		 $query_select_count_string = "SELECT COUNT(*) as tot";
		 $query_from_string = " FROM {$wpdb->posts} AS products
								 LEFT JOIN {$wpdb->postmeta} AS product_meta ON product_meta.post_id = products.ID AND product_meta.meta_key = '_sku'
								 WHERE  (products.post_type = 'product' OR products.post_type = 'product_variation')
								";
		if($search_string)
				$query_from_string .=  " AND ( products.post_title LIKE '%{$search_string}%' OR product_meta.meta_value LIKE '%{$search_string}%' OR products.ID LIKE '%{$search_string}%' ) 
										AND (products.post_type = 'product' OR products.post_type = 'product_variation') ";
		
		$final_query_string =  $query_select_string.$query_from_string." GROUP BY products.ID LIMIT {$offset}, {$resultCount}";
		
		$result = $wpdb->get_results($final_query_string ) ;
		
		if($wcqpe_wpml_helper->wpml_is_active())
		{
			$product_ids = $variation_ids = array();
			foreach($result as $product)
			{
				if($product->product_parent == 0 )
					$product_ids[] = $product;
				else
					$variation_ids[] = $product;
			}
			//$result = $wcqpe_wpml_helper->remove_translated_id($result, 'product', true);
			
			//Filter products
			if(!empty($product_ids))
				$product_ids = $wcqpe_wpml_helper->remove_translated_id($product_ids, 'product', true);
			
			//Filter variations
			if(!empty($variation_ids))
				$variation_ids = $wcqpe_wpml_helper->remove_translated_id($variation_ids, 'product', true);
			
			$result = array_merge($product_ids, $variation_ids);
		}
		
		if(isset($result) && !empty($result))
			foreach($result as $index => $product)
				{
					if($product->product_parent != 0 )
					{
						$readable_name = $this->get_variation_complete_name($product->id);
						$result[$index]->product_name = $readable_name != false ? "<i>".__('Variation','woocommerce-files-upload')."</i> ".$readable_name : $result[$index]->product_name;
					}
				}
		
		
		if(isset($offset) && isset($resultCount))
		{
			/* $query_string = "SELECT COUNT(*) as tot
							 FROM {$wpdb->posts} AS products
							 WHERE  (products.post_type = 'product' OR products.post_type = 'product_variation')
							  ";  */
			$num_order = $wpdb->get_col($query_select_count_string.$query_from_string);
			$num_order = isset($num_order[0]) ? intval($num_order[0]) : 0;
			//wcqpe_var_dump($wpdb->get_col($query_select_count_string.$query_from_string." GROUP BY products.ID "));
			$endCount = $offset + $resultCount;
			$morePages = empty($result) ? false : $num_order > $endCount;
			$results = array(
				  "results" => $result,
				  "pagination" => array(
					  "more" => $morePages
				  )
			  );
		}
		else
			$results = array(
				  "results" => $result,
				  "pagination" => array(
					  "more" => false
				  )
			  );
		//wcqpe_var_dump($results);
		return $results;
	}
	public function get_product_category_list($search_string = null, $taxonomy_name = 'product_cat')
	 {
		 global $wpdb, $wcqpe_wpml_helper;
		  $query_string = "SELECT product_categories.term_id as id, product_categories.name as category_name
							 FROM {$wpdb->terms} AS product_categories
							 LEFT JOIN {$wpdb->term_taxonomy} AS tax ON tax.term_id = product_categories.term_id 							 						 	 
							 WHERE tax.taxonomy = '{$taxonomy_name}' 
							 AND product_categories.slug <> 'uncategorized' 
							";
		 if($search_string)
					$query_string .=  " AND ( product_categories.name LIKE '%{$search_string}%' )";
			
		$query_string .=  " GROUP BY product_categories.term_id ";
		$result = $wpdb->get_results($query_string ) ;
		
		//WPML
		if($wcqpe_wpml_helper->wpml_is_active())
		{
			$result = $wcqpe_wpml_helper->remove_translated_id($result, $taxonomy_name, true);
		} 
		
		return $result;
	 }
	 public function get_categories()
	 {
		 $result = $this->get_product_category_list();
		 $categories = array();
		 foreach((array)$result as $category)
		 {
			 $categories[$category->id] = $category->category_name;
		 }
		 return $categories;
	 }
	 public function get_tags()
	 {
		/* $terms = get_terms( 'product_tag' );
		$term_array = array();
		if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
			foreach ( $terms as $term ) {
				$term_array[$term->term_id] = $term->name;
			}
		} */
		$result = $this->get_product_category_list(null,  'product_tag' );
		 $tags = array();
		 foreach((array)$result as $tag)
		 {
			 $tags[$tag->id] = $tag->category_name;
		 }
		return $tags;
	 }
	 public function get_variation_complete_name($variation_id)
	 {
		$error = false;
		$variation = wc_get_product($variation_id);
		//wcqpe_var_dump("inside ".$variation->get_type());
		if($variation == null || $variation == false)
			return "";
		if($variation->is_type('simple') || $variation->is_type('variable'))
			return $variation->get_title();
		
		$product_name = $variation->get_title()." - ";	
		if($product_name == " - ")
			return false;
		$attributes_counter = 0;
		foreach($variation->get_variation_attributes( ) as $attribute_name => $value)
		{
			
			if($attributes_counter > 0)
				$product_name .= ", ";
			$meta_key = urldecode( str_replace( 'attribute_', '', $attribute_name ) ); 
			//wcqpe_var_dump($value);
			$product_name .= " ".wc_attribute_label($meta_key).": ".$value;
			$attributes_counter++;
		}
		return $product_name;
	 }
	public function get_product_name($product_id, $default = false)
	{
		global $wcqpe_wpml_helper;
		$product_id = $wcqpe_wpml_helper->get_main_language_id($product_id, 'product');
		$readable_name  = $default;
		$product = wc_get_product($product_id);
		
		if($product->get_type() == 'variation')
		{
			$readable_name = $this->get_variation_complete_name($product_id);
			$readable_name = isset($readable_name) && $readable_name != "" && $readable_name != " " ? "#".$product_id." - ".$readable_name  : $default;
		}
		else
		{
			try{
			    //$product = new WC_Product($product_id);
			    $readable_name = isset($product) ? $product->get_formatted_name() : $default;
		    }catch (Exception $e){}
		}
		return $readable_name; //isset($product) ? $product->get_formatted_name() : $default;
	}
	public function get_product_category_name($category_id, $default = false)
	{
		global $wcqpe_wpml_helper;
		$category_id = $wcqpe_wpml_helper->get_main_language_id($category_id, 'product_cat');
		$category = get_term( $category_id, 'product_cat' );
		return isset($category) ? $category->name : $default;
	}
	public function get_product_id_by_category_id($cat_id)
	{
		/* return get_posts(array(
				'numberposts'   => -1,
				'category' => $cat_id,
				'post_type' => 'product',
				'fields'        => 'ids',
				)); */
		$args = array(
			'fields'        		=> 'ids',
			'post_type'             => 'product',
			'post_status'           => 'publish',
			//'ignore_sticky_posts'   => 1,
			'posts_per_page'        => -1,
			'meta_query'            => array(
				array(
					'key'           => '_visibility',
					'value'         => array('catalog', 'visible'),
					'compare'       => 'IN'
				)
			),
			'tax_query'             => array(
				array(
					'taxonomy'      => 'product_cat',
					'field' => 'term_id', //This is optional, as it defaults to 'term_id'
					'terms'         => $cat_id,
					'operator'      => 'IN' // Possible values are 'IN', 'NOT IN', 'AND'.
				)
			)
		);
		$products = get_posts($args);
		/* $to_return = array();
		foreach($products as $product_id)
		{
			$to_return[] = $product_id;
			
		} */
		return $products;
	}
	public function get_shipping_classes_select()
	{
		 $args = array(
				'taxonomy'         => 'product_shipping_class',
				'hide_empty'       => 0,
				'show_option_none' => __( 'No shipping class / Same as parent', 'woocommerce-quick-product-editor' ),
				'name'             => 'product_shipping_class',
				'id'               => 'product_shipping_class',
				'class'            => 'select short',
				'echo'			   => 'false'
			);
			$defaults = array(
			'show_option_all'   => '',
			'show_option_none'  => '',
			'orderby'           => 'id',
			'order'             => 'ASC',
			'show_count'        => 0,
			'hide_empty'        => 1,
			'child_of'          => 0,
			'exclude'           => '',
			'echo'              => 1,
			'selected'          => 0,
			'hierarchical'      => 0,
			'name'              => 'cat',
			'id'                => '',
			'class'             => 'postform',
			'depth'             => 0,
			'tab_index'         => 0,
			'taxonomy'          => 'category',
			'hide_if_empty'     => false,
			'option_none_value' => -1,
			'value_field'       => 'term_id',
			'required'          => false,
		);
		
		$r = wp_parse_args( $args, $defaults );

		if ( ! isset( $r['pad_counts'] ) && $r['show_count'] && $r['hierarchical'] ) {
			$r['pad_counts'] = true;
		}

		
		// Avoid clashes with the 'name' param of get_terms().
		$get_terms_args = $r;
		unset( $get_terms_args['name'] );
	
		/*return wp_dropdown_categories( $args ); */
		$shipping_classes = get_terms( 'product_shipping_class', $get_terms_args );
		$result = array(-1 => __( 'No shipping class / Same as parent', 'woocommerce-quick-product-editor' ));
		foreach((array)$shipping_classes as $shipping_class)
			$result[$shipping_class->term_id] = $shipping_class->name;
			
		return $result;
	}
}
?>