<?php 
class WCQPE_QuckEditor
{
	var $page = "product_page_woocommerce-quick-product-editor-main-page";
	
	public function __construct()
	{
		add_action('add_meta_boxes', array($this, 'add_meta_boxes'));
		
		add_action( 'current_screen', array(&$this, 'cl_set_global_options_pages') );
	}
	function cl_set_global_options_pages($current_screen) 
	{
	  if(!is_admin())
		  return;
	  global $wcqpe_wpml_helper;
	
	  if ($current_screen->id == 'product_page_woocommerce-quick-product-editor-main-page') 
	  {
		$wcqpe_wpml_helper->switch_to_default_language();
	  }
	}
	public function add_page($cap = 'manage_woocommerce')
	{
		
		$this->page = add_submenu_page( 'edit.php?post_type=product', __('Bulk product editor', 'woocommerce-quick-product-editor'), __('Bulk product editor', 'woocommerce-quick-product-editor'), $cap, 'woocommerce-quick-product-editor-main-page', array($this, 'render_page'));
		
		add_action('load-'.$this->page,  array($this,'page_actions'),9);
		add_action('admin_footer-'.$this->page,array($this,'footer_scripts'));
	}
	function page_actions()
	{
		do_action('add_meta_boxes_'.$this->page, null);
		do_action('add_meta_boxes', $this->page, null);
	}
	function footer_scripts(){
		?>
		<script> postboxes.add_postbox_toggles(pagenow);</script>
		<?php
	}
	public function render_page()
	{
		global $pagenow;
		
		add_screen_option('layout_columns', array('max' => 2, 'default' => 2) );
	   /*  if(isset($_POST) && isset($_POST['wcccuf_nonce_configuration_data']) && wp_verify_nonce($_POST['wcccuf_nonce_configuration_data'], 'wcccuf_save_data') && isset($_POST['wcqpe_code']))
			$wcqpe_code_model->save_code($_POST['wcqpe_code']); */
	
		wp_enqueue_script('postbox'); 
		wp_enqueue_media();
		wp_enqueue_script( 'jquery-ui-core' );
		wp_enqueue_script( 'jquery-ui-sortable' );
		wp_enqueue_script('select2', WCQPE_PLUGIN_PATH.'/js/vendor/select2/select2.full.min.js', array('jquery'));  
		//wp_enqueue_script('select2-multi-checkboxes', WCQPE_PLUGIN_PATH.'/js/vendor/select2-multi-checkboxes/select2.multi-checkboxes.js', array('jquery'));  
		wp_enqueue_script('datetime', WCQPE_PLUGIN_PATH.'/js/vendor/datetime/picker.js', array('jquery'));  
		wp_enqueue_script('datetime-date', WCQPE_PLUGIN_PATH.'/js/vendor/datetime/picker.date.js', array('jquery'));  
		wp_enqueue_script('datetime-time', WCQPE_PLUGIN_PATH.'/js/vendor/datetime/picker.time.js', array('jquery'));  
		wp_enqueue_script('wcqpe-datetime-manager', WCQPE_PLUGIN_PATH.'/js/admin-datetime.js', array('jquery'));  
		wp_enqueue_script('wcqpe-product-list', WCQPE_PLUGIN_PATH.'/js/admin-load-product-list.js', array('jquery')); 
		wp_enqueue_script('wcqpe-category-list', WCQPE_PLUGIN_PATH.'/js/admin-load-category-list.js', array('jquery')); 
		wp_enqueue_script('wcqpe-taxonomy-lists', WCQPE_PLUGIN_PATH.'/js/admin-load-taxonomy-lists.js', array('jquery')); 
		wp_register_script('wcqpe-load-values-from-product', WCQPE_PLUGIN_PATH.'/js/admin-load-values-from-product.js', array('jquery'));
		wp_enqueue_script('wcqpe-quick-editor-page', WCQPE_PLUGIN_PATH.'/js/admin-quick-editor-page.js', array('jquery'));
		
		wp_register_script('wcqpe-admin-load-image-from-gallery', WCQPE_PLUGIN_PATH.'/js/admin-load-image-from-gallery.js', array('jquery'));
		$js_options = array('placeholder_path' => esc_url( wc_placeholder_img_src()),
							 'loading_message' => __('Loading, please wait...','woocommerce-quick-product-editor'),
							 'no_product_selected_message' => __('Select a product!','woocommerce-quick-product-editor'),
							 'product_invalid_message' => __('The selected product is invalid!','woocommerce-quick-product-editor'),
							 'done_message' => __('Done!','woocommerce-quick-product-editor')
							);
		wp_localize_script( 'wcqpe-admin-load-image-from-gallery', 'wcqpe_options', $js_options );
		wp_localize_script( 'wcqpe-load-values-from-product', 'wcqpe_options', $js_options );
		wp_enqueue_script( 'wcqpe-admin-load-image-from-gallery' );
		wp_enqueue_script( 'wcqpe-load-values-from-product' );
			
		wp_enqueue_style('datetime-classic', WCQPE_PLUGIN_PATH.'/css/vendor/datetime/classic.css'); 	
		wp_enqueue_style('datetime-classic-date', WCQPE_PLUGIN_PATH.'/css/vendor/datetime/classic.date.css'); 	
		wp_enqueue_style('datetime-classic-time', WCQPE_PLUGIN_PATH.'/css/vendor/datetime/classic.time.css'); 	
		wp_enqueue_style('select2', WCQPE_PLUGIN_PATH.'/css/vendor/select2/select2.min.css'); 	
		wp_enqueue_style('admin-quick-editor-page', WCQPE_PLUGIN_PATH.'/css/admin-quick-editor-page.css'); 
		?>
		<div class="wrap">
			 <?php //screen_icon(); ?>
 
			<h2><?php esc_html_e('WooCommerce Bulk Product Editor','woocommerce-quick-product-editor'); ?></h2>
	
			<form id="post"  method="post">
				<?php wp_nonce_field( 'wcccuf_save_data', 'wcccuf_nonce_configuration_data' ); ?>
				<div id="poststuff">
					<div id="post-body" class="metabox-holder columns-<?php echo 1 == get_current_screen()->get_columns() ? '1' : '2'; ?>">
						<div id="post-body-content">
						</div>
						
						<div id="postbox-container-1" class="postbox-container">
							<?php do_meta_boxes('woocommerce-quick-product-editor','side',null); ?>
						</div>
						
						<div id="postbox-container-2" class="postbox-container">
							  <?php do_meta_boxes('woocommerce-quick-product-editor','normal',null); ?>
							  <?php do_meta_boxes('woocommerce-quick-product-editor','advanced',null); ?>
							  
						</div> 
					</div> <!-- #post-body -->
				</div> <!-- #poststuff -->
				
			</form>
		</div> <!-- .wrap -->
		<?php 
	}
	
	function add_meta_boxes()
	{
		$screen = get_current_screen();
		//wcqpe_var_dump($screen->base);
		
		if(!$screen || $screen->base != "product_page_woocommerce-quick-product-editor-main-page")
			return;
		
		add_meta_box( 'quick_editor', 
					__('Quick Editor','woocommerce-quick-product-editor'), 
					array($this, 'add_custom_code_fields_meta_box'), 
					'woocommerce-quick-product-editor', 
					'normal' 
			);
		
		add_meta_box('load_values_from_product', 
				__('Import values from product','woocommerce-quick-product-editor'), 
				array($this, 'load_values_from_product'), 
				'woocommerce-quick-product-editor',
				'side' 
			);
			
		add_meta_box('save_button', 
				__('Save','woocommerce-quick-product-editor'), 
				array($this, 'add_save_button_meta_box'), 
				'woocommerce-quick-product-editor',
				'side' 
			);
	}
	function add_custom_code_fields_meta_box()
	{
		global $wcqpe_product_model;
		
		$you_have_img = null;
		$upload_link = esc_url( get_upload_iframe_src( 'image' /* ,$post->ID */) );
		//$your_img_id = get_post_meta( $post->ID, '_your_img_id', true );
		//$your_img_src = wp_get_attachment_image_src( $your_img_id, 'full' );

		//WP_CONTENT_DIR
		
		?>
		<h1 class="step_title"><?php _e('1. Select the products to edit','woocommerce-quick-product-editor') ?></h1>			
		<div id="product-selection-container">
			<p id="wcqpe_product_selection_error_message"><?php _e('Select at least one product or category','woocommerce-quick-product-editor') ?></p>
			<div class="wcqpe_select_product_container">
				<label><?php _e('Select products','woocommerce-quick-product-editor');?></label>
				<select class="js-data-product-ajax" 
						name="product_id[]" 
						multiple="multiple" 
						id="product_id">
						<?php 
						/*  foreach( $coditional_item_data['product_id'] as $product_id)
							{
								echo '<option value="'.$product_id.'" selected="selected" >'.$wcqpe_product_model->get_product_name($product_id).'</option>';
							}  */
						?>
				</select>
			</div>
			<div class="wcqpe_select_product_container">
				<label><?php _e('Select categories','woocommerce-quick-product-editor');?><!--<span class="wcqpe_required_label"> *</span>--></label>
				<select class="js-data-category-ajax" 
						name="category_id[]" 
						multiple="multiple" 
						id="category_id">
						<?php 
						 /* foreach( $coditional_item_data['category_id'] as $category_id)
							{
								echo '<option value="'.$category_id.'" selected="selected" >'.$wcqpe_product_model->get_product_category_name($category_id).'</option>';
							}  */
						?>
							
				</select>
			</div>
			<div id="product_category_apply_container">
				<div class="one_third_container">
						<label><?php _e('In case the selected product is variable','woocommerce-quick-product-editor');?><span class="wcqpe_required_label"> *</span></label>
						<select name="variation_apply_policy"  required="required" class="full_width">
							<option value="variations_only"><?php _e('Apply settings to its variations only','woocommerce-quick-product-editor');?></option>
							<option value="master_product"><?php _e('Apply settings to master product only','woocommerce-quick-product-editor');?></option>
							<option value="master_and_variations"><?php _e('Apply settings to master and its variations','woocommerce-quick-product-editor');?></option>
						</select>
				</div>
				<div class="one_third_container"> <!-- half_container -->
						<label><?php _e('Apply to','woocommerce-quick-product-editor');?><span class="wcqpe_required_label"> *</span></label>
						<select name="product_apply_policy"  required="required" class="full_width">
							<option value="selected"><?php _e('Selected products and categories','woocommerce-quick-product-editor');?></option>
							<option value="except"><?php _e('Except the selected products and categories','woocommerce-quick-product-editor');?></option>
						</select>
				</div>
				<div class="one_third_container">
						<label><?php _e('Children categories','woocommerce-quick-product-editor');?><span class="wcqpe_required_label"> *</span></label>
						<select name="children_category_apply_policy"  required="required" class="full_width">
							<option value="selected_only"><?php _e('Consider selected categories only','woocommerce-quick-product-editor');?></option>
							<option value="selected_and_children"><?php _e('Consider selected categories and all its children','woocommerce-quick-product-editor');?></option>
						</select>
				</div>
			</div>
		</div>
		<h1 class="step_title_secondary"><?php _e('2. Configure products values','woocommerce-quick-product-editor') ?></h1>
		<p><?php _e('Items can be dragged & dropped. Sort as you wish to better edit products.','woocommerce-quick-product-editor') ?></p>
		<div class="wcqpe_sortable">
			<!-- Image container  -->
			<div id="image-selector-container">
				<h3 id="image_selector_title" ><?php _e('Product image','woocommerce-quick-product-editor') ?></h3>
				<select class="negative_top_offset manage_element_display_on_selection" name="wcqpe_data[image_id][apply_policy]" data-element="product-image-and-controllers-container">
					<option value="leave_unchanged"><?php _e('Leave unchanged','woocommerce-quick-product-editor') ?></option>
					<option value="set_new"><?php _e('Set new','woocommerce-quick-product-editor') ?></option>
				</select>
				
				<div id="product-image-and-controllers-container">
				<p><?php _e('If no image is selected, the current product image will be removed.','woocommerce-quick-product-editor') ?></p>
					<div id="img-container">
						<?php //if ( $you_have_img ) : ?>
							<img src="<?php echo esc_url( wc_placeholder_img_src()); ?>" alt="" id="wcqpe-product-image" style="" />
						<?php //endif; ?>
					</div>

					<!-- Your add & remove image links -->
					<div id="image-buttons-container">
						<a id="upload-custom-img" class="<?php if ( $you_have_img  ) { echo 'hidden'; } ?>" 
						   href="<?php echo $upload_link ?>">
							<?php _e('Set image','woocommerce-quick-product-editor') ?>
						</a>
						<a id="delete-custom-img" class=" <?php if ( ! $you_have_img  ) { echo 'hidden'; } ?>" 
						  href="#">
							<?php _e('Remove image','woocommerce-quick-product-editor') ?>
						</a>
					</div>
				</div>
				<!-- A hidden input to set and post the chosen image id -->
				<input id="product_image_id" name="wcqpe_data[image_id][value]" type="hidden" value="<?php //echo esc_attr( $your_img_id ); ?>" />
			</div>
			
			<div class="fields-container">
				<h3><?php _e('General','woocommerce-quick-product-editor') ?></h3>
				
				<div class="generic_inline_container">
					<label class="first_field_label"><?php _e('Regular price','woocommerce-quick-product-editor') ?></label>
					<p class="small_margin"><?php _e('Leave empty to leave the current regular price unchanged.','woocommerce-quick-product-editor') ?></p>
					<select class="negative_top_offset" name="wcqpe_data[regular_price][apply_policy]">
						<option value="set_new"><?php _e('Set new','woocommerce-quick-product-editor') ?></option>
						<option value="increase_by_val"><?php _e('Icrease by val','woocommerce-quick-product-editor') ?></option>
						<option value="decrease_by_val"><?php _e('Decrease by val','woocommerce-quick-product-editor') ?></option>
						<option value="increase_by_perc"><?php _e('Increase by %','woocommerce-quick-product-editor') ?></option>
						<option value="decrease_by_perc"><?php _e('Decease by %','woocommerce-quick-product-editor') ?></option>
					</select>
					<input type="number" name="wcqpe_data[regular_price][value]" value="" placeholder="<?php _e('Input a regular price','woocommerce-quick-product-editor') ?>" min="0" step="0.001"></input>
					
					<label class="field_label"><?php _e('Sale price','woocommerce-quick-product-editor') ?></label>
					<p class="small_margin"><?php _e('Leave empty to leave the current sale price unchanged.','woocommerce-quick-product-editor') ?></br>
					<?php _e('<strong>NOTE:</strong> to remove old sale price, set -1.','woocommerce-quick-product-editor') ?>
					</p>
					<select class="negative_top_offset" name="wcqpe_data[sale_price][apply_policy]">
						<option value="set_new"><?php _e('Set new','woocommerce-quick-product-editor') ?></option>
						<option value="increase_by_val"><?php _e('Icrease by val','woocommerce-quick-product-editor') ?></option>
						<option value="decrease_by_val"><?php _e('Decrease by val','woocommerce-quick-product-editor') ?></option>
						<option value="increase_by_perc"><?php _e('Increase by %','woocommerce-quick-product-editor') ?></option>
						<option value="decrease_by_perc"><?php _e('Decease by %','woocommerce-quick-product-editor') ?></option>
					</select>
					<input type="number" name="wcqpe_data[sale_price][value]" value="" placeholder="<?php _e('Input a sale price','woocommerce-quick-product-editor') ?>" min="-1" step="0.001"></input>
				</div>
				
				<div class="generic_inline_container">
					<label class="first_field_label"><?php _e('Sale price from date','woocommerce-quick-product-editor') ?></label>
					<p class="small_margin"><?php _e('Leave empty to delete the current date.','woocommerce-quick-product-editor') ?></p>
					<select class="wcqpe_sale_date_policy_selector negative_top_offset" name="wcqpe_data[date_on_sale_from][apply_policy]" data-target="wcqpe_sale_from_date">
						<option value="leave_unchanged"><?php _e('Leave unchanged','woocommerce-quick-product-editor') ?></option>
						<!-- <option value="delete_existing"><?php _e('Delete existing date','woocommerce-quick-product-editor') ?></option>-->
						<option value="set_new"><?php _e('Set new','woocommerce-quick-product-editor') ?></option>
					</select>
					<input type="text" id="wcqpe_sale_from_date" class="wcqpe_date wcqpe_sale_date" name="wcqpe_data[date_on_sale_from][value]" value="" placeholder="<?php _e('From... YYYY-MM-DD','woocommerce-quick-product-editor') ?>"></input>
					
					<label class="field_label"><?php _e('Sale price to date','woocommerce-quick-product-editor') ?></label>
					<p class="small_margin"><?php _e('Leave empty to delete the current date.','woocommerce-quick-product-editor') ?></p>
					<select class="wcqpe_sale_date_policy_selector negative_top_offset" name="wcqpe_data[date_on_sale_to][apply_policy]" data-target="wcqpe_sale_to_date">
						<option value="leave_unchanged"><?php _e('Leave unchanged','woocommerce-quick-product-editor') ?></option>
						<!-- <option value="delete_existing"><?php _e('Delete existing date','woocommerce-quick-product-editor') ?></option> -->
						<option value="set_new"><?php _e('Set new','woocommerce-quick-product-editor') ?></option>
					</select>
					<input type="text" id="wcqpe_sale_to_date" class="wcqpe_date wcqpe_sale_date" name="wcqpe_data[date_on_sale_to][value]" value="" placeholder="<?php _e('To... YYYY-MM-DD','woocommerce-quick-product-editor') ?>"></input>
				</div>
				
				<div class="generic_inline_container">
					<div class="inline_block_container">
						<label class="first_field_label"><?php _e('Virtual','woocommerce-quick-product-editor') ?></label>
						<p class="small_margin "><?php _e('Virtual products are intangible and are not shipped.','woocommerce-quick-product-editor') ?></p>
						<select class="negative_top_offset" name="wcqpe_data[virtual][value]">
							<option value="leave_unchanged"><?php _e('Leave unchanged','woocommerce-quick-product-editor') ?></option>
							<option value="true"><?php _e('Yes','woocommerce-quick-product-editor') ?></option>
							<option value="false"><?php _e('No','woocommerce-quick-product-editor') ?></option>
						</select>
					</div>
					<div class="inline_block_container">
						<label class="first_field_label"><?php _e('Status','woocommerce-quick-product-editor') ?></label>
						<p class="small_margin"><?php _e('In case of variation the Private, Pending review and Draft options will set the product as disabled.','woocommerce-quick-product-editor') ?></p>
						<select class="negative_top_offset" name="wcqpe_data[status][value]">
							<option value="leave_unchanged"><?php _e('Leave unchanged','woocommerce-quick-product-editor') ?></option>
							<option value="publish"><?php _e('Published','woocommerce-quick-product-editor') ?></option>
							<option value="private"><?php _e('Private','woocommerce-quick-product-editor') ?></option>
							<option value="pending"><?php _e('Pending review','woocommerce-quick-product-editor') ?></option>
							<option value="draft"><?php _e('Draft','woocommerce-quick-product-editor') ?></option>
						</select>
					</div>	
					<div class="inline_block_container">
						<label class="field_label"><?php _e('Catalog visibility ','woocommerce-quick-product-editor') ?></label>
						<p class="small_margin"><?php _e('Affects <strong>only simple and master</strong> products. This setting determines which shop pages products will be listed on.','woocommerce-quick-product-editor') ?></p>
						<select class="negative_top_offset" name="wcqpe_data[catalog_visibility][value]">
							<option value="leave_unchanged"><?php _e('Leave unchanged','woocommerce-quick-product-editor') ?></option>
							<option value="visible"><?php _e('Shop and search results','woocommerce-quick-product-editor') ?></option>
							<option value="catalog"><?php _e('Shop only','woocommerce-quick-product-editor') ?></option>
							<option value="search"><?php _e('Search results only','woocommerce-quick-product-editor') ?></option>
							<option value="hidden"><?php _e('Hidden','woocommerce-quick-product-editor') ?></option>
						</select>
					</div>		
					<div class="inline_block_container">
						<label class="field_label"><?php _e('Featured','woocommerce-quick-product-editor') ?></label>
						<p class="small_margin"><?php _e('Affects <strong>only simple and master</strong> products. This is a featured product','woocommerce-quick-product-editor') ?></p>
						<select class="negative_top_offset" name="wcqpe_data[featured][value]">
							<option value="leave_unchanged"><?php _e('Leave unchanged','woocommerce-quick-product-editor') ?></option>
							<option value="true"><?php _e('Yes','woocommerce-quick-product-editor') ?></option>
							<option value="false"><?php _e('No','woocommerce-quick-product-editor') ?></option>
						</select>
					</div>	
				</div>
			</div>
			<!-- Taxonomy -->
			<div class="fields-container">
				<h3><?php _e('Taxonomy','woocommerce-quick-product-editor') ?></h3>
				<label class="first_field_label"><?php _e('Categories','woocommerce-quick-product-editor') ?></label>
				<p class="small_margin small_width"><?php _e('Affects <strong>only simple and master</strong> products. To remove previous categories, select <i>Set new</i> and leave empty the selection.','woocommerce-quick-product-editor') ?></p>
				<select class="manage_element_display_on_selection" name="wcqpe_data[category_ids][apply_policy]" data-element="taxonomy_category_ids_container">
					<option value="leave_unchanged"><?php _e('Leave unchanged','woocommerce-quick-product-editor') ?></option>
					<option value="set_new"><?php _e('Set new','woocommerce-quick-product-editor') ?></option>
				</select>
				<div id="taxonomy_category_ids_container">
					<select class="" 
								name="wcqpe_data[category_ids][value][]" 
								multiple="multiple" 
								id="taxonomy_category_ids">
							<?php 
								$categories = $wcqpe_product_model->get_categories();
								foreach($categories as $cat_id => $cat_name)
									echo '<option value='.$cat_id.'>'.$cat_name.'</option>';
							?>
					</select>
				</div>	
				<label class="field_label"><?php _e('Tags','woocommerce-quick-product-editor') ?></label>
				<p class="small_margin small_width"><?php _e('Affects <strong>only simple and master</strong> products. To remove previous tags, select <i>Set new</i> and leave empty the selection.','woocommerce-quick-product-editor') ?></p>
				<select class="manage_element_display_on_selection" name="wcqpe_data[tag_ids][apply_policy]" data-element="taxonomy_tag_ids_container">
					<option value="leave_unchanged"><?php _e('Leave unchanged','woocommerce-quick-product-editor') ?></option>
					<option value="set_new"><?php _e('Set new','woocommerce-quick-product-editor') ?></option>
				</select>
				<div id="taxonomy_tag_ids_container">
					<select class="" 
								name="wcqpe_data[tag_ids][value][]" 
								multiple="multiple" 
								id="taxonomy_tag_ids">
								<?php 
								$tags = $wcqpe_product_model->get_tags();
								foreach($tags as $tag_id => $tag_name)
									echo '<option value='.$tag_id.'>'.$tag_name.'</option>';
							?>
					</select>
				</div>
			</div>
			<!-- Taxes -->
			<div class="fields-container">
				<h3><?php _e('Tax','woocommerce-quick-product-editor') ?></h3>
				<label class="first_field_label"><?php _e('Tax status','woocommerce-quick-product-editor') ?></label>
				<p class="small_margin"><?php _e('Applicable only to simple and variable products, not to variations.','woocommerce-quick-product-editor') ?></p>
				<select class="" name="wcqpe_data[tax_status][value]">
					<option value="leave_unchanged"><?php _e('Leave unchanged','woocommerce-quick-product-editor') ?></option>
					<option value="taxable"><?php _e('Taxable','woocommerce-quick-product-editor') ?></option>
					<option value="shipping"><?php _e('Shipping only','woocommerce-quick-product-editor') ?></option>
					<option value="none"><?php _e('None','woocommerce-quick-product-editor') ?></option>
				</select>
				
				<label class="field_label"><?php _e('Tax class','woocommerce-quick-product-editor') ?></label>
				<p></p>
				<select class="" name="wcqpe_data[tax_class][value]">
					<option value="leave_unchanged"><?php _e('Leave unchanged','woocommerce-quick-product-editor') ?></option>
					<option value="-1"><?php _e('Same as parent (applicable only to variations)','woocommerce-quick-product-editor') ?></option>
					<?php 
						foreach(wc_get_product_tax_class_options() as $tax_class_code => $tax_class_name)
						{
							echo '<option value='.$tax_class_code.'>'.$tax_class_name.'</option>';
						}
					?>
				</select>
			</div>
			
			<!-- Invetory  -->
			<div class="fields-container">
				<h3><?php _e('Inventory','woocommerce-quick-product-editor') ?></h3>
				
				<div class="generic_inline_container">
					<div class="block_container">
						<label class="first_field_label"><?php _e('SKU','woocommerce-quick-product-editor') ?></label>
						<p class="small_margin"><?php _e('Leave empty to leave the current SKU unchanged.','woocommerce-quick-product-editor') ?></p>
						<select class="negative_top_offset" name="wcqpe_data[sku][apply_policy]">
							<option value="set_new"><?php _e('Set new','woocommerce-quick-product-editor') ?></option>
						</select>
						<input type="text" name="wcqpe_data[sku][value]" value="" placeholder="<?php _e('Input a SKU','woocommerce-quick-product-editor') ?>" min="0"></input>
					</div>
					<div class="inline_block_container">
						<label class="field_label"><?php _e('Sold individually','woocommerce-quick-product-editor') ?></label>
						<p class="small_margin"><?php _e('Affects <strong>only simple and master</strong> products. Enable this to only allow one of this item to be bought in a single order.','woocommerce-quick-product-editor') ?></p>
						<select class="" name="wcqpe_data[sold_individually][value]">
							<option value="leave_unchanged"><?php _e('Leave unchanged','woocommerce-quick-product-editor') ?></option>
							<option value="false"><?php _e('No','woocommerce-quick-product-editor') ?></option>
							<option value="true"><?php _e('Yes','woocommerce-quick-product-editor') ?></option>
						</select>
					</div>
					<div class="inline_block_container">
						<label class="field_label"><?php _e('Manage stock','woocommerce-quick-product-editor') ?></label>
						<p class="small_margin"><?php _e( 'Enable stock management at product level.', 'woocommerce-quick-product-editor' ); ?></p>
						<select class="" id="manage_stock" name="wcqpe_data[manage_stock][value]">
							<option value="leave_unchanged"><?php _e('Leave unchanged','woocommerce-quick-product-editor') ?></option>
							<option value="false"><?php _e('No','woocommerce-quick-product-editor') ?></option>
							<option value="true"><?php _e('Yes','woocommerce-quick-product-editor') ?></option>
						</select>
					</div> 
				</div>
				
				<div class="generic_block_container">
					<div id="disabled_stock_controllers_container" > <!-- class="inline_block_container " -->
						<label class="first_field_label"><?php _e('Stock status','woocommerce-quick-product-editor') ?></label>
						<p class="small_margin"><?php _e( 'Controls whether or not the product is listed as "in stock" or "out of stock" on the frontend.', 'woocommerce-quick-product-editor' ); ?></p>				
						<select class="" name="wcqpe_data[stock_status][value]">
							<option value="leave_unchanged"><?php _e('Leave unchanged','woocommerce-quick-product-editor') ?></option>
							<?php 
							foreach(wc_get_product_stock_status_options() as $code => $name)
							{
								echo '<option value='.$code.'>'.$name.'</option>';
							}
						?>
						</select>
					</div>
					
					<div id="enabled_stock_controllers_container" class=" ">
						<label class="first_field_label"><?php _e('Stock quantity','woocommerce-quick-product-editor') ?></label>
						<p class="small_margin"><?php _e( 'Leave empty to leave the current stock quantity unchanged. If this is a variable product this value will be used to control stock for all variations, unless you define stock at variation level.', 'woocommerce-quick-product-editor' ); ?></p>
						<select class="negative_top_offset" name="wcqpe_data[stock_quantity][apply_policy]">
							<option value="set_new"><?php _e('Set new','woocommerce-quick-product-editor') ?></option>
							<option value="increase_by_val"><?php _e('Icrease by val','woocommerce-quick-product-editor') ?></option>
							<option value="decrease_by_val"><?php _e('Decrease by val','woocommerce-quick-product-editor') ?></option>
							<option value="increase_by_perc"><?php _e('Increase by %','woocommerce-quick-product-editor') ?></option>
							<option value="decrease_by_perc"><?php _e('Decease by %','woocommerce-quick-product-editor') ?></option>
						</select>
						<input type="text" name="wcqpe_data[stock_quantity][value]" value="" placeholder="<?php _e('Input a quantity','woocommerce-quick-product-editor') ?>" min="0"></input>
						
						<label class="field_label"><?php _e('Allow backorders?','woocommerce-quick-product-editor') ?></label>
						<p class="small_margin"><?php _e( 'If managing stock, this controls whether or not backorders are allowed. If enabled, stock quantity can go below 0.', 'woocommerce-quick-product-editor' ); ?></p>
						<select class="" name="wcqpe_data[backorders][value]">
							<option value="leave_unchanged"><?php _e('Leave unchanged','woocommerce-quick-product-editor') ?></option>
							<?php 
							foreach(wc_get_product_backorder_options() as $code => $name)
							{
								echo '<option value='.$code.'>'.$name.'</option>';
							}
						?>
						</select>
					</div>
				</div>
			</div>
			<!-- Shipping  -->
			<div class="fields-container">
				<h3><?php _e('Shipping','woocommerce-quick-product-editor') ?></h3>
				<div class="inline_block_container">
					<label class="field_label"><?php _e('Weight','woocommerce-quick-product-editor') ?></label>
					<p class="small_margin"><?php _e( 'Weight in decimal form. Leave empty to leave the current weight unchanged.', 'woocommerce-quick-product-editor' ); ?></p>
					<select class="negative_top_offset" name="wcqpe_data[weight][apply_policy]">
						<option value="set_new"><?php _e('Set new','woocommerce-quick-product-editor') ?></option>
						<option value="increase_by_val"><?php _e('Icrease by val','woocommerce-quick-product-editor') ?></option>
						<option value="decrease_by_val"><?php _e('Decrease by val','woocommerce-quick-product-editor') ?></option>
						<option value="increase_by_perc"><?php _e('Increase by %','woocommerce-quick-product-editor') ?></option>
						<option value="decrease_by_perc"><?php _e('Decease by %','woocommerce-quick-product-editor') ?></option>
					</select>
					<input type="text" name="wcqpe_data[weight][value]" value="" placeholder="<?php _e('Input a quantity','woocommerce-quick-product-editor') ?>" min="0" step="0.001"></input>
				</div>
				<div class="inline_block_container">
					<label class="field_label"><?php _e('Length','woocommerce-quick-product-editor') ?></label>
					<p class="small_margin"><?php _e( 'Length in decimal form. Leave empty to leave the current length unchanged.', 'woocommerce-quick-product-editor' ); ?></p>
					<select class="negative_top_offset" name="wcqpe_data[length][apply_policy]">
						<option value="set_new"><?php _e('Set new','woocommerce-quick-product-editor') ?></option>
						<option value="increase_by_val"><?php _e('Icrease by val','woocommerce-quick-product-editor') ?></option>
						<option value="decrease_by_val"><?php _e('Decrease by val','woocommerce-quick-product-editor') ?></option>
						<option value="increase_by_perc"><?php _e('Increase by %','woocommerce-quick-product-editor') ?></option>
						<option value="decrease_by_perc"><?php _e('Decease by %','woocommerce-quick-product-editor') ?></option>
					</select>
					<input type="text" name="wcqpe_data[length][value]" value="" placeholder="<?php _e('Input a quantity','woocommerce-quick-product-editor') ?>" min="0" step="0.001"></input>
				</div>
				<div class="inline_block_container">
					<label class="field_label"><?php _e('Width','woocommerce-quick-product-editor') ?></label>
					<p class="small_margin"><?php _e( 'Width in decimal form. Leave empty to leave the current width unchanged.', 'woocommerce-quick-product-editor' ); ?></p>
					<select class="negative_top_offset" name="wcqpe_data[width][apply_policy]">
						<option value="set_new"><?php _e('Set new','woocommerce-quick-product-editor') ?></option>
						<option value="increase_by_val"><?php _e('Icrease by val','woocommerce-quick-product-editor') ?></option>
						<option value="decrease_by_val"><?php _e('Decrease by val','woocommerce-quick-product-editor') ?></option>
						<option value="increase_by_perc"><?php _e('Increase by %','woocommerce-quick-product-editor') ?></option>
						<option value="decrease_by_perc"><?php _e('Decease by %','woocommerce-quick-product-editor') ?></option>
					</select>
					<input type="text" name="wcqpe_data[width][value]" value="" placeholder="<?php _e('Input a quantity','woocommerce-quick-product-editor') ?>" min="0" step="0.001"></input>
				</div>
				<div class="inline_block_container">
					<label class="field_label"><?php _e('Height','woocommerce-quick-product-editor') ?></label>
					<p class="small_margin"><?php _e( 'Height in decimal form. Leave empty to leave the current height unchanged.', 'woocommerce-quick-product-editor' ); ?></p>
					<select class="negative_top_offset" name="wcqpe_data[height][apply_policy]">
						<option value="set_new"><?php _e('Set new','woocommerce-quick-product-editor') ?></option>
						<option value="increase_by_val"><?php _e('Icrease by val','woocommerce-quick-product-editor') ?></option>
						<option value="decrease_by_val"><?php _e('Decrease by val','woocommerce-quick-product-editor') ?></option>
						<option value="increase_by_perc"><?php _e('Increase by %','woocommerce-quick-product-editor') ?></option>
						<option value="decrease_by_perc"><?php _e('Decease by %','woocommerce-quick-product-editor') ?></option>
					</select>
					<input type="text" name="wcqpe_data[height][value]" value="" placeholder="<?php _e('Input a quantity','woocommerce-quick-product-editor') ?>" min="0" step="0.001"></input>
				</div>
				<label class="field_label"><?php _e('Shipping class','woocommerce-quick-product-editor') ?></label>
					<p class="small_margin"><?php _e( 'Shipping classes are used by certain shipping methods to group similar products.', 'woocommerce-quick-product-editor' ); ?></p>
					<select class="" name="wcqpe_data[shipping_class_id][value]">
						<option value="leave_unchanged"><?php _e('Leave unchanged','woocommerce-quick-product-editor') ?></option>
						<?php 
						foreach($wcqpe_product_model->get_shipping_classes_select() as $code => $name)
						{
							echo '<option value='.$code.'>'.$name.'</option>';
						}
						?>
					</select>
			</div>
			
			<!-- Description --->
			<div class="fields-container-full-width">
			<h3><?php _e('Name, slug and description','woocommerce-quick-product-editor') ?></h3>
			<label class="first_field_label"><?php _e('Product name','woocommerce-quick-product-editor') ?></label>
			<p class="small_margin"><?php _e('Leave empty to leave the current product title unchanged. Affects <strong>only simple and master</strong> products. ','woocommerce-quick-product-editor') ?></p>
			<input type="text" name="wcqpe_data[name][value]" value="" placeholder="<?php _e('Product name','woocommerce-quick-product-editor') ?>" ></input>
			
			<label class="field_label"><?php _e('Slug','woocommerce-quick-product-editor') ?></label>
			<p class="small_margin"><?php _e('Leave empty to leave the current product slug unchanged. Affects <strong>only simple and master</strong> products. Note that slug is an unique key so in case you are assigning the same slug to different products, WooCommerce will automatically modify it.','woocommerce-quick-product-editor') ?></p>
			<input type="text" name="wcqpe_data[slug][value]" value="" placeholder="<?php _e('Slug','woocommerce-quick-product-editor') ?>" ></input>
			
			<label class="field_label"><?php _e('Description','woocommerce-quick-product-editor') ?></label>
			<p><?php _e('You can choose to set a new description or leave the existing one unchanged.','woocommerce-quick-product-editor') ?></p>
			<select class="negative_top_offset manage_element_display_on_selection" name="wcqpe_data[description][apply_policy]" data-element="wp-description-wrap">
				<option value="leave_unchanged"><?php _e('Leave unchanged','woocommerce-quick-product-editor') ?></option>
				<option value="set_new"><?php _e('Set new','woocommerce-quick-product-editor') ?></option>
			</select>
			<?php
				wp_editor( "", 'description', array(
				'wpautop'       => true,
				'media_buttons' => true,
				'textarea_name' => 'wcqpe_data[description][value]',
				'textarea_rows' => 10,
				'teeny'         => true
			) );
			?>
			<label class="field_label"><?php _e('Short description','woocommerce-quick-product-editor') ?></label>
			<p><?php _e('You can choose to set a new short description or leave the existing one unchanged.','woocommerce-quick-product-editor') ?></p>
			<select class="negative_top_offset manage_element_display_on_selection" name="wcqpe_data[short_description][apply_policy]" data-element="wp-short_description-wrap">
				<option value="leave_unchanged"><?php _e('Leave unchanged','woocommerce-quick-product-editor') ?></option>
				<option value="set_new"><?php _e('Set new','woocommerce-quick-product-editor') ?></option>
			</select>
			<?php
				wp_editor( "", 'short_description', array(
				'wpautop'       => true,
				'media_buttons' => true,
				'textarea_name' => 'wcqpe_data[short_description][value]',
				'textarea_rows' => 10,
				'teeny'         => true
			) );
			?>
			</div>
		</div>
		<?php
	}
	function load_values_from_product()
	{
		?>
		<div class="wcqpe_select_product_container">
			<label><?php _e('Select a product','woocommerce-quick-product-editor');?></label>
			<select class="js-data-product-ajax" 
					id="load_product_id">
			</select>
			
			<label class="field_label"><?php _e('Product name, slug and descriptions','woocommerce-quick-product-editor');?></label>
			<select name="load_name_description_policy" id="load_name_description_policy">
				<option value="not_load"><?php _e('Do not import','woocommerce-quick-product-editor');?></description>
				<option value="load"><?php _e('Import','woocommerce-quick-product-editor');?></description>
			</select>
		</div>
		<div id="wcqpe_load_product_values_status"></div>
		<!-- <p>
		<?php _e('<strong>NOTE:</strong> Product name and description values will be imported too. So before saving, make sure they have been modified (or removed in order to leave destination product name and descriptions unchanged)','woocommerce-quick-product-editor');?>
		</p> -->
		<button class="button button-primary" id="load_from_product_button"><?php _e('Import','woocommerce-quick-product-editor');?></button>
		<?php 
	}
	function add_save_button_meta_box()
	{
		?>
		<div class="" id="wcqpe_progress_info_container">
			<div id="wcqpe_progress_bar_container">
				<div class="" id="wcqpe_bar_background"></div>
				<div class="" id="wcqpe_bar"></div>
			</div>
			<div class="" id="wcqpe_progress_percent">0%</div>
			<div class="" id="wcqpe_progress_status"></div>
		</div>
		<?php
		submit_button( __( 'Save', 'woocommerce-quick-product-editor' ),
						'primary',
						'submit'
					);
	}
}
?>